/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.HasDevices;
import com.inscada.mono.communication.base.y.c_sj;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@AttributeOverride(name="id", column=@Column(name="conn_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class Connection<TDevice extends Device<?, ?>>
extends OwnedSpaceBaseModel
implements HasDevices<TDevice> {
    @Column(name="project_id", insertable=false, updatable=false)
    protected String projectId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    protected Project project;
    @NotNull
    @Min(value=0L)
    @Max(value=65535L)
    protected Integer port;
    @NotBlank
    @Size(max=50)
    protected String ip;
    @NotBlank
    @Size(max=100)
    protected String name;
    @Size(max=255)
    protected String dsc;
    @NotNull
    protected c_sj protocol;

    public Integer getPort() {
        Connection a;
        return a.port;
    }

    public c_sj getProtocol() {
        Connection a;
        return a.protocol;
    }

    public void setDsc(String string) {
        Object a = string;
        Connection a2 = this;
        a2.dsc = a;
    }

    public Connection() {
        Connection a;
    }

    public boolean equals(Object object) {
        Connection a = this;
        Object a2 = object;
        if (a == a2) {
            return (4 ^ 5) != 0;
        }
        if (!(a2 instanceof Connection)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 ^ 3) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return 3 >> 1;
        }
        return false;
    }

    public String getProjectId() {
        Connection a;
        return a.projectId;
    }

    public void setProjectId(String string) {
        Object a = string;
        Connection a2 = this;
        a2.projectId = a;
    }

    public int hashCode() {
        Connection a;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[2 ^ 3] = a.getProjectId();
        objectArray[1 ^ 3] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getDsc() {
        Connection a;
        return a.dsc;
    }

    public String getName() {
        Connection a;
        return a.name;
    }

    public void setPort(Integer n) {
        Object a = n;
        Connection a2 = this;
        a2.port = a;
    }

    public void setProject(Project project) {
        Connection a;
        Connection a2 = project;
        Connection connection = a = this;
        connection.project = a2;
        connection.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Project getProject() {
        Connection a;
        return a.project;
    }

    public void setIp(String string) {
        Object a = string;
        Connection a2 = this;
        a2.ip = a;
    }

    public String getIp() {
        Connection a;
        return a.ip;
    }

    public void setName(String string) {
        Object a = string;
        Connection a2 = this;
        a2.name = a;
    }

    public void setProtocol(c_sj c_sj2) {
        Connection a = c_sj2;
        Connection a2 = this;
        a2.protocol = a;
    }
}

