/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.cluster.sync;

import com.inscada.mono.cluster.model.ClusterNodeInfo;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_C;
import com.inscada.mono.secret.model.EncryptedSecrets;
import com.inscada.mono.shared.aspects.SpaceFilterAspect;
import jakarta.annotation.PostConstruct;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;

@Service
@ConditionalOnProperty(name={"ins.cluster.enabled"}, havingValue="true")
public class RedisReplicationManager
implements ClusterNodeListener {
    private final String f_kS;
    private static final Logger f_hu = LoggerFactory.getLogger(RedisReplicationManager.class);
    private final JedisPooled f_jS;
    private final Integer f_nS;
    private final c_C f_rs;

    /*
     * WARNING - void declaration
     */
    @Autowired
    public RedisReplicationManager(JedisPooled jedisPooled, c_C c_C2, @Value(value="${spring.data.redis.host:localhost}") String string, @Value(value="${spring.data.redis.port:6379}") Integer n) {
        void selfRedisHost;
        void clusterOperations;
        void jedis;
        RedisReplicationManager a;
        RedisReplicationManager redisReplicationManager = object;
        Object object = n;
        RedisReplicationManager redisReplicationManager2 = a = redisReplicationManager;
        RedisReplicationManager redisReplicationManager3 = a;
        redisReplicationManager3.f_jS = jedis;
        redisReplicationManager3.f_rs = clusterOperations;
        redisReplicationManager2.f_kS = selfRedisHost;
        redisReplicationManager2.f_nS = object;
    }

    @PostConstruct
    public void registerListener() {
        RedisReplicationManager a;
        a.f_rs.m_ca((ClusterNodeListener)a);
        f_hu.info(EncryptedSecrets.m_Bf((Object)"uhCdT_B}KdDlSdHcjlIl@hU-Uh@dTyB\u007fBi\u0007dS~BaA-F~\u0007l\u0007NKxTyB\u007fibChkdTyBcB\u007f\t"));
    }

    public void leader(long a3) {
        try {
            RedisReplicationManager a2;
            String[] stringArray = new String[--2];
            stringArray[3 ^ 3] = SpaceFilterAspect.m_OF((Object)"`6");
            stringArray[--1] = EncryptedSecrets.m_Bf((Object)"hCb");
            Object a3 = a2.f_jS.sendCommand((ProtocolCommand)Protocol.Command.REPLICAOF, stringArray);
            f_hu.info(SpaceFilterAspect.m_OF((Object)"-F\u0010]Y@\u0016J\u001c\u000e\u0010]YZ\u0011KYb<o=k+\u0000Y}\u001cZ\rG\u0017IY|\u001cJ\u0010]YZ\u0016\u000e\u0014O\nZ\u001c\\YC\u0016J\u001c\u0000Y|\u001c]\fB\r\u0014YU\u0004"), a3);
            return;
        }
        catch (Exception a3) {
            f_hu.error(EncryptedSecrets.m_Bf((Object)"KFdKhC-Sb\u0007~By\u0007_BiN~\u0007yH-JlTyB\u007f\u0007`HiB-Hc\u0007aBlChU-IbCh\t"), (Throwable)a3);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notLeader() {
        RedisReplicationManager redisReplicationManager = this;
        f_hu.info(SpaceFilterAspect.m_OF((Object)"-F\u0010]Y@\u0016J\u001c\u000e\u0010]YOYh6b5a.k+\u0000Yo\rZ\u001cC\tZ\u0010@\u001e\u000e\rAYH\u0010@\u001d\u000e\u0015K\u0018J\u001c\\YO\u0017JY]\rO\u000bZY|\u001cJ\u0010]Y\\\u001c^\u0015G\u001aO\rG\u0016@W"));
        try {
            Optional<ClusterNodeInfo> optional = redisReplicationManager.f_rs.m_ba().stream().filter(ClusterNodeInfo::getIsLeader).findFirst();
            if (optional.isPresent()) {
                ClusterNodeInfo clusterNodeInfo = optional.get();
                String a2 = clusterNodeInfo.getRedisHost();
                Integer n = clusterNodeInfo.getRedisPort();
                if (a2 != null && n != null) {
                    if (Objects.equals(redisReplicationManager.f_kS, a2) && Objects.equals(redisReplicationManager.f_nS, n)) {
                        f_hu.warn(EncryptedSecrets.m_Bf((Object)"cdTnH{B\u007fBi\u0007aBlChU*T-uhCdT-NcTyFcDh\u0007dT-SeN~\u0007cHiB*T-HzI-NcTyFcDh\t-tfN}WdIj\u0007\u007fB}KdDlSdHc\u0007nH`JlIi\u0007yH-W\u007fB{BcS-DdUnRaF\u007f\u0007\u007fB}KdDlSdHc\t"));
                        return;
                    }
                    Object[] objectArray = new Object[--3];
                    objectArray[3 ^ 3] = clusterNodeInfo.getNodeId();
                    objectArray[4 ^ 5] = a2;
                    objectArray[1 ^ 3] = n;
                    f_hu.info(SpaceFilterAspect.m_OF((Object)"h\u0016[\u0017JYB\u001cO\u001dK\u000b\u000e^U\u0004\tYY\u0010Z\u0011\u000e+K\u001dG\n\u000e\u0018ZYU\u0004\u0014\u0002SW\u000e*Z\u0018\\\rG\u0017IY\\\u001c^\u0015G\u001aO\rG\u0016@W"), objectArray);
                    String[] stringArray = new String[--2];
                    stringArray[3 ^ 3] = a2;
                    stringArray[5 >> 2] = String.valueOf(n);
                    Object a2 = redisReplicationManager.f_jS.sendCommand((ProtocolCommand)Protocol.Command.REPLICAOF, stringArray);
                    f_hu.info(EncryptedSecrets.m_Bf((Object)"^By\u0007_BiN~\u0007yH-UhWaNnFyB-A\u007fH`\u0007aBlChU#\u0007_B~RaS7\u0007vZ"), a2);
                    return;
                }
                f_hu.error(SpaceFilterAspect.m_OF((Object)"5K\u0018J\u001c\\Y@\u0016J\u001c\u000e^U\u0004\tYJ\u0016K\n\u000e\u0017A\r\u000e\u0011O\u000fKY|\u001cJ\u0010]YF\u0016]\r\u0001\tA\u000bZYG\u0017H\u0016\\\u0014O\rG\u0016@YO\u000fO\u0010B\u0018L\u0015KW\u000e:O\u0017@\u0016ZY]\rO\u000bZY\\\u001c^\u0015G\u001aO\rG\u0016@W"), (Object)clusterNodeInfo.getNodeId());
                return;
            }
            f_hu.warn(EncryptedSecrets.m_Bf((Object)"dbRaC-IbS-AdIi\u0007l\u0007aBlChU-IbCh\u0007dI-SeB-DaR~ShU-QdBz\u0007yH-UhWaNnFyB-uhCdT-A\u007fH`\t-pdKa\u0007\u007fByUt\u0007bI-Ih_y\u0007nKxTyB\u007f\u0007{NhP-DeFc@h\t"));
            return;
        }
        catch (Exception exception) {
            f_hu.error(SpaceFilterAspect.m_OF((Object)"?O\u0010B\u001cJYZ\u0016\u000e\nK\r\u000e+K\u001dG\n\u000e\rAY\\\u001c^\u0015G\u001aOYC\u0016J\u001c\u000e\u0016@YH\u0016B\u0015A\u000eK\u000b\u000e\u0017A\u001dKW"), (Throwable)exception);
            return;
        }
    }
}

