/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.animation.model.Animation;
import com.inscada.mono.animation.y.c_HJ;
import com.inscada.mono.animation.y.c_pL;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="animation_element")
@AttributeOverride(name="id", column=@Column(name="anim_element_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"animationId", "animation"})
public class AnimationElement
extends SpaceBaseModel {
    @NotNull
    private c_pL type;
    @NotBlank
    @Size(max=100)
    @Column(name="dom_id")
    private String domId;
    @Column(name="animation_id", insertable=false, updatable=false)
    private String animationId;
    @NotBlank
    private String expression;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="animation_id", updatable=false)
    private Animation animation;
    @NotNull
    @Column(name="expression_type")
    private c_HJ expressionType;
    @NotBlank
    private String props;
    @Size(max=255)
    private String dsc;
    @Size(max=255)
    private String name;

    public String getProps() {
        AnimationElement a;
        return a.props;
    }

    public void setDomId(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.domId = a;
    }

    public String getDsc() {
        AnimationElement a;
        return a.dsc;
    }

    public void setAnimation(Animation animation) {
        AnimationElement a;
        AnimationElement a2 = animation;
        AnimationElement animationElement = a = this;
        animationElement.animation = a2;
        animationElement.animationId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public AnimationElement() {
        AnimationElement a;
    }

    public c_HJ getExpressionType() {
        AnimationElement a;
        return a.expressionType;
    }

    public String getDomId() {
        AnimationElement a;
        return a.domId;
    }

    public String getName() {
        AnimationElement a;
        return a.name;
    }

    public String getAnimationId() {
        AnimationElement a;
        return a.animationId;
    }

    public void setName(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.name = a;
    }

    public Animation getAnimation() {
        AnimationElement a;
        return a.animation;
    }

    public void setProps(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.props = a;
    }

    public String getExpression() {
        AnimationElement a;
        return a.expression;
    }

    public boolean equals(Object object) {
        AnimationElement a = this;
        Object a2 = object;
        if (a == a2) {
            return (4 ^ 5) != 0;
        }
        if (!(a2 instanceof AnimationElement)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 ^ 3) != 0;
        }
        if (a.getAnimationId().equals(object2.getAnimationId()) && a.getName().equals(object2.getName())) {
            return (4 ^ 5) != 0;
        }
        return false;
    }

    public int hashCode() {
        AnimationElement a;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = super.hashCode();
        objectArray[3 & 5] = a.getAnimationId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setExpression(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.expression = a;
    }

    public void setExpressionType(c_HJ c_HJ2) {
        AnimationElement a = c_HJ2;
        AnimationElement a2 = this;
        a2.expressionType = a;
    }

    public c_pL getType() {
        AnimationElement a;
        return a.type;
    }

    public void setDsc(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.dsc = a;
    }

    public void setAnimationId(String string) {
        Object a = string;
        AnimationElement a2 = this;
        a2.animationId = a;
    }

    public void setType(c_pL c_pL2) {
        AnimationElement a = c_pL2;
        AnimationElement a2 = this;
        a2.type = a;
    }
}

