/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.d.c_Kk;
import com.inscada.mono.alarm.d.c_Wk;
import com.inscada.mono.alarm.d.c_el;
import com.inscada.mono.alarm.d.c_gK;
import com.inscada.mono.alarm.d.c_kK;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AlarmGroupSummary;
import com.inscada.mono.alarm.services.c_Rj;
import com.inscada.mono.alarm.services.c_jL;
import com.inscada.mono.alarm.services.c_ll;
import com.inscada.mono.alarm.services.c_pK;
import com.inscada.mono.alarm.y.c_dL;
import com.inscada.mono.auth.c_yK;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.manager.LeaderFencedManager;
import com.inscada.mono.cluster.services.c_C;
import com.inscada.mono.log.d.c_dA;
import com.inscada.mono.project.d.c_k;
import com.inscada.mono.report.services.c_jB;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.system.model.Stats;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
extends LeaderFencedManager
implements c_k {
    public static final short f_NY = 105;
    public static final short f_BY = 107;
    private final c_dA f_IX;
    public static final short f_gY = 104;
    public static final short f_gaa = 103;
    private final c_yK f_NX;
    private static final Logger f_bc = LoggerFactory.getLogger(AlarmManager.class);
    public static final short f_AX = 106;
    public static final short f_TY = 102;
    private final c_jL f_kaa;
    public static final short f_HY = 108;
    private final JedisPooled f_nZ;
    private final c_ll f_JZ;
    private final c_Rj f_xz;
    private static final String f_iaa = "activeAlarmGroups";
    public static final short f_Daa = 109;
    public static final short f_RZ = 101;
    private final Lock f_vX;

    protected void deactivateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.f_JZ.m_nGa((String)a2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader(long l) {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        String a = alarmManager2.f_pC.m_la();
        f_bc.info(c_jB.m_YG((Object)"E7e)i\u0016e5e<a)>{P3m($5k?a{, yr$3e($9a8k6a{p3a{H\u001eE\u001fA\t*{V>w/k)m5c{e8p2r>$:h:v6wu*u"), (Object)a);
        alarmManager2.f_vX.lock();
        try {
            HashSet hashSet = new HashSet(alarmManager.f_nZ.smembers(f_iaa));
            if (hashSet.isEmpty()) {
                f_bc.info(Stats.m_Tf((Object)"P\np\u0014|+p\bp\u0001t\u00141N]\u0003p\u0002t\u00141\u001dlO+F_\t1\u0007r\u0012x\u0010tFp\np\u0014|Fv\u0014~\u0013a\u00151\u0000~\u0013\u007f\u00021\u000f\u007fFC\u0003u\u000fbFe\t1\u0014t\u0015e\tc\u0003?"), (Object)a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 >> 1] = hashSet.size();
            objectArray[--2] = hashSet;
            f_bc.info(c_jB.m_YG((Object)"\u001ah:v6I:j:c>v{,\u0017a:`>v{\u007f&-a$\u001dk.j?$ y{e8p2r>$:h:v6$<v4q+$\u0012@($2j{V>`2w{p4$)a(p4v>>{\u007f&"), objectArray);
            ArrayList a2 = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[3 >> 2] = Stats.m_Tf((Object)"0X#F9P*P4\\9V4^3A");
            alarmManager.f_NX.m_UEa(() -> {
                void a;
                Object a2 = hashSet;
                AlarmManager a3 = this;
                a.addAll(a3.f_JZ.m_qIa((Set)a2));
            }, stringArray);
            f_bc.info(c_jB.m_YG((Object)"E7e)i\u0016e5e<a)$sH>e?a)$ yr>{E/p>i+p2j<$/k{v>w/k)a{\u007f&$:h:v6$<v4q+wu"), (Object)a, (Object)a2.size());
            a2.forEach(alarmGroup -> {
                void a;
                AlarmManager alarmManager;
                AlarmManager alarmManager2 = alarmManager = this;
                Object a2 = alarmManager2.f_pC.m_la();
                String[] stringArray = new String[5 >> 1];
                stringArray[2 & 5] = Stats.m_Tf((Object)"'R2X0P2T9P*P4\\");
                stringArray[3 >> 1] = c_jB.m_YG((Object)"@\u001eE\u0018P\u0012R\u001aP\u001e[\u001aH\u001aV\u0016");
                alarmManager2.f_NX.m_aga(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1((String)a2, (AlarmGroup)a), a.getSpace(), stringArray);
            });
            f_bc.info(Stats.m_Tf((Object)"P\np\u0014|+p\bp\u0001t\u00141N]\u0003p\u0002t\u00141\u001dlO+FW\u000f\u007f\u000fb\u000et\u00021\u0007}\u0007c\u000b1\u0014t\u0015e\tc\u0007e\u000f~\b1\u0016c\tr\u0003b\u0015?"), (Object)a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_bc.error(c_jB.m_YG((Object)"E7e)i\u0016e5e<a)$sH>e?a)$ yr>{A)v4v{`.v2j<$:h:v6$)a(p4v:p2k5$+v4g>w(>{\u007f&"), objectArray);
            return;
        }
        finally {
            alarmManager.f_vX.unlock();
        }
    }

    @TransactionalEventListener(value={c_Wk.class})
    public void handleAlarmChangeEvent(c_Wk c_Wk2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_pC.m_ma()) {
            AlarmManager a = a.m_kLa();
            f_bc.info(c_jB.m_YG((Object)"H\u001eE\u001fA\t>{L:j?h2j<$\u001ah:v6G3e5c>A-a5p{b4v{e7e)i{M\u001f>{\u007f&({C)k.t{M\u001f>{\u007f&"), (Object)a.getId(), (Object)a.getGroupId());
            c_pK c_pK2 = alarmManager.f_kaa.m_JHa(a.getGroupId());
            if (c_pK2 != null && c_pK2.m_qha()) {
                if (Boolean.TRUE.equals(a.getIsActive())) {
                    c_pK2.m_KHa((Alarm)a);
                    return;
                }
                c_pK2.m_sia((Alarm)a);
                return;
            }
        } else {
            f_bc.debug(Stats.m_Tf((Object)"(^(<*T'U#C\\1/v\b~\u0014x\bvFP\np\u0014|%y\u0007\u007f\u0001t#g\u0003\u007f\u00121\u0000~\u00141\u0007}\u0007c\u000b1/U\\1\u001dl"), (Object)a.m_kLa().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_dL getAlarmGroupStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(c_jB.m_YG((Object)"H\u001eE\u001fA\t>{C>p/m5c{e7e)i{c)k.t{w/e/q($=k)$ y{h4g:h7}u"), a);
            return a2.getAlarmGroupStatusInternal((String)a);
        }
        f_bc.debug(Stats.m_Tf((Object)"(^(<*T'U#C\\14t\u0017d\u0003b\u0012x\bvF}\u0003p\u0002t\u00141\u0000~\u00141\u0007}\u0007c\u000b1\u0001c\td\u00161\u0015e\u0007e\u0013bFw\tcFj\u001b?"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            return (c_dL)a2.f_pC.m_Fa(Short.valueOf((short)(0x7C & 0x6B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group status for " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$deactivateAlarmGroupInternal$4(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_vX.lock();
        try {
            c_pK c_pK2 = a2.f_kaa.m_JHa(a.getId());
            if (c_pK2 != null) {
                c_pK2.m_NGa();
                a2.f_kaa.m_RHa(a.getId(), c_pK2);
            }
            String[] stringArray = new String[--1];
            stringArray[3 ^ 3] = a.getId();
            a2.f_nZ.srem(f_iaa, stringArray);
            return;
        }
        finally {
            a2.f_vX.unlock();
        }
    }

    @TransactionalEventListener(value={c_gK.class})
    public void handleAlarmDeleteEvent(c_gK c_gK2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_pC.m_ma()) {
            AlarmManager a = a.m_hka();
            f_bc.info(c_jB.m_YG((Object)"H\u001eE\u001fA\t>{L:j?h2j<$\u001ah:v6@>h>p>A-a5p{b4v{e7e)i{M\u001f>{\u007f&({C)k.t{M\u001f>{\u007f&"), (Object)a.getId(), (Object)a.getGroupId());
            c_pK c_pK2 = alarmManager.f_kaa.m_JHa(a.getGroupId());
            if (c_pK2 != null && c_pK2.m_qha()) {
                c_pK2.m_sia((Alarm)a);
                return;
            }
        } else {
            f_bc.debug(Stats.m_Tf((Object)"(^(<*T'U#C\\1/v\b~\u0014x\bvFP\np\u0014|\"t\nt\u0012t#g\u0003\u007f\u00121\u0000~\u00141\u0007}\u0007c\u000b1/U\\1\u001dl"), (Object)a.m_hka().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String string, AlarmGroup alarmGroup) {
        void a;
        AlarmManager a2 = alarmGroup;
        AlarmManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[4 ^ 5] = a2.getName();
            objectArray[--2] = a2.getId();
            f_bc.info(c_jB.m_YG((Object)"E7e)i\u0016e5e<a)$sH>e?a)$ yr>{V>w/k)m5c{e7e)i{c)k.ta$ y{,\u0012@a$ yr"), objectArray);
            a3.activateAlarmGroupInternal((AlarmGroup)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[2 ^ 3] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_IX.m_AK(a2.getProject()).m_V("Alarm Group Restore (Leader " + (String)a + ")", Stats.m_Tf((Object)"CbF9/U\\1CbO1\u0000p\u000f}\u0003uFe\t1\u0014t\u0015e\tc\u0003?FR\u0007d\u0015t\\1Cb").formatted(objectArray));
            try {
                f_bc.warn(c_jB.m_YG((Object)"E7e)i\u0016e5e<a)$sH>e?a)$ yr>{E/p>i+p2j<$/k{`>e8p2r:p>$:h:v6$<v4q+$ y{e=p>v{v>w/k)e/m4j{b:m7q)au"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal((AlarmGroup)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 >> 2] = a;
                objectArray2[5 >> 2] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_bc.error(Stats.m_Tf((Object)"P\np\u0014|+p\bp\u0001t\u00141N]\u0003p\u0002t\u00141\u001dlO+FW\u0007x\nt\u00021\u0012~Fu\u0003p\u0005e\u000fg\u0007e\u00031\u0007}\u0007c\u000b1\u0001c\td\u00161\u001dlFp\u0000e\u0003cFc\u0003b\u0012~\u0014p\u0012x\t\u007fFw\u0007x\nd\u0014t\\1\u001dl"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_dL> getAlarmStatuses(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_pC.m_ma()) {
            f_bc.debug(c_jB.m_YG((Object)"\u0017A\u001a@\u001eVa$\u001ca/p2j<$:h:v6$(p:p.w>w{b4v{\u007f&$\u0012@($7k8e7h\">{\u007f&"), (Object)a.size(), (Object)a);
            return a2.getAlarmStatusesInternal((List)a);
        }
        f_bc.debug(Stats.m_Tf((Object)"_)_K]#P\"T4+FC\u0003`\u0013t\u0015e\u000f\u007f\u00011\nt\u0007u\u0003cFw\tcFp\np\u0014|Fb\u0012p\u0012d\u0015t\u00151\u0000~\u00141\u001dlFX\"b\\1\u001dl"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = new ArrayList(a);
            return (Map)a2.f_pC.m_Fa(Short.valueOf((short)(0x6F & 0x7B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$3(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_vX.lock();
        try {
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to start alarm group " + a.getName());
            }
            Runnable runnable = () -> a2.lambda$activateAlarmGroupInternal$2((AlarmGroup)a);
            a2.fenced("Activate alarm group " + a.getId(), runnable).run();
            return;
        }
        finally {
            a2.f_vX.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_dL getAlarmGroupStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_JZ.m_fla((String)a2, (String)a)) == null) {
            return c_dL.f_uy;
        }
        return a3.getAlarmGroupStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    public AlarmManager(c_Rj c_Rj2, c_ll c_ll2, c_jL c_jL2, c_dA c_dA2, JedisPooled jedisPooled, c_C c_C2, c_yK c_yK2) {
        AlarmManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        AlarmManager a8;
        AlarmManager alarmManager = alarmManager2;
        AlarmManager alarmManager2 = c_yK2;
        AlarmManager alarmManager3 = a8 = alarmManager;
        AlarmManager alarmManager4 = a8;
        AlarmManager alarmManager5 = a8;
        super((c_C)a7);
        AlarmManager alarmManager6 = a8;
        alarmManager6.f_vX = new ReentrantLock();
        alarmManager5.f_xz = a6;
        alarmManager5.f_JZ = a5;
        alarmManager4.f_kaa = a4;
        alarmManager4.f_IX = a3;
        alarmManager3.f_nZ = a2;
        alarmManager3.f_NX = a;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.deactivateAlarmGroup(alarmManager.f_JZ.m_mha((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    protected c_dL getAlarmStatusInternal(Alarm alarm) {
        void a;
        AlarmManager alarmManager = this;
        if (a == null) {
            return c_dL.f_uy;
        }
        AlarmManager a2 = alarmManager.f_kaa.m_JHa(a.getGroup().getId());
        if (a2 != null && a2.m_qha() && a2.m_Mia(a.getId())) {
            return c_dL.f_yz;
        }
        return c_dL.f_uy;
    }

    protected void activateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_JZ.m_VIa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(c_jB.m_YG((Object)"H\u001eE\u001fA\t>{@>e8p2r:p2j<$:h:v6$<v4q+$ y{h4g:h7}u"), a);
            a2.deactivateAlarmGroupInternal((String)a);
            return;
        }
        f_bc.debug(Stats.m_Tf((Object)"_)_K]#P\"T4+FC\u0003`\u0013t\u0015e\u000f\u007f\u00011\nt\u0007u\u0003cFe\t1\u0002t\u0007r\u0012x\u0010p\u0012tFp\np\u0014|Fv\u0014~\u0013aFj\u001b?"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x6E & 0x77)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm group " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_dL> getAlarmStatusesInternal(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    protected void activateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_NX.m_mEa(() -> a2.lambda$activateAlarmGroupInternal$3((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        AlarmManager alarmManager = this;
        try {
            Class[] classArray = new Class[--1];
            classArray[5 >> 3] = String.class;
            alarmManager.f_pC.m_Da((short)(0x67 & 0x7D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_jB.m_YG((Object)"e8p2r:p>E7e)i\u001cv4q+M5p>v5e7"), classArray));
            Class[] classArray2 = new Class[3 & 5];
            classArray2[2 & 5] = String.class;
            alarmManager.f_pC.m_Da((short)(0x76 & 0x6F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(Stats.m_Tf((Object)"\u0002t\u0007r\u0012x\u0010p\u0012t'}\u0007c\u000bV\u0014~\u0013a/\u007f\u0012t\u0014\u007f\u0007}"), classArray2));
            Class[] classArray3 = new Class[3 >> 1];
            classArray3[5 >> 3] = String.class;
            alarmManager.f_pC.m_Da((short)(0x7F & 0x67), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_jB.m_YG((Object)"c>p\u001ah:v6W/e/q(M5p>v5e7"), classArray3));
            Class[] classArray4 = new Class[5 >> 2];
            classArray4[2 & 5] = String.class;
            alarmManager.f_pC.m_Da((short)(0x6B & 0x7C), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(Stats.m_Tf((Object)"v\u0003e'}\u0007c\u000bV\u0014~\u0013a5e\u0007e\u0013b/\u007f\u0012t\u0014\u007f\u0007}"), classArray4));
            Class[] classArray5 = new Class[--1];
            classArray5[5 >> 3] = String.class;
            alarmManager.f_pC.m_Da((short)(0x6F & 0x79), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_jB.m_YG((Object)"<a/E7e)i\bp:p.w>w\u0019}\u000bv4n>g/M?M5p>v5e7"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            alarmManager.f_pC.m_Da((short)(0x6F & 0x7A), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(Stats.m_Tf((Object)"\u0001t\u0012P\np\u0014|!c\td\u0016B\u0012p\u0012d\u0015t\u0015S\u001fA\u0014~\ft\u0005e/u/\u007f\u0012t\u0014\u007f\u0007}"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            alarmManager.f_pC.m_Da((short)(0x6B & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_jB.m_YG((Object)"c>p\u001ah:v6W/e/q(a(M5p>v5e7"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            alarmManager.f_pC.m_Da((short)(0x6D & 0x7E), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(Stats.m_Tf((Object)"\u0007r\u0012x\u0010p\u0012t'}\u0007c\u000bV\u0014~\u0013a\u0015S\u001fA\u0014~\ft\u0005e/u/\u007f\u0012t\u0014\u007f\u0007}"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String.class;
            alarmManager.f_pC.m_Da((short)(0x6F & 0x7D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_jB.m_YG((Object)"`>e8p2r:p>E7e)i\u001cv4q+w\u0019}\u000bv4n>g/M?M5p>v5e7"), classArray9));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(Stats.m_Tf((Object)"W\u0007x\nt\u00021\u0012~Fc\u0003v\u000fb\u0012t\u00141'}\u0007c\u000b\\\u0007\u007f\u0007v\u0003cFC6RF|\u0003e\u000e~\u0002b"), a);
        }
    }

    @TransactionalEventListener(value={c_kK.class})
    public void handleAlarmGroupDeleteEvent(c_kK c_kK2) {
        AlarmManager a = c_kK2;
        AlarmManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.info(c_jB.m_YG((Object)"\u0017A\u001a@\u001eVa$\u0013e5`7m5c{E7e)i\u001cv4q+@>h>p>A-a5p{b4v{c)k.t{M\u001f>{\u007f&"), (Object)a.m_HJa().getId());
            a2.deactivateAlarmGroupInternal(a.m_HJa().getId());
            return;
        }
        f_bc.debug(Stats.m_Tf((Object)"_)_K]#P\"T4+FX\u0001\u007f\tc\u000f\u007f\u00011'}\u0007c\u000bV\u0014~\u0013a\"t\nt\u0012t#g\u0003\u007f\u00121\u0000~\u00141\u0001c\td\u00161/U\\1\u001dl"), (Object)a.m_HJa().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_dL> getAlarmStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(c_jB.m_YG((Object)"H\u001eE\u001fA\t>{C>p/m5c{e7h{e7e)i{w/e/q(a($=k)$+v4n>g/$ y{h4g:h7}u"), a);
            return a2.getAlarmStatusesByProjectIdInternal((String)a);
        }
        f_bc.debug(Stats.m_Tf((Object)"(^(<*T'U#C\\14t\u0017d\u0003b\u0012x\bvF}\u0003p\u0002t\u00141\u0000~\u00141\u0007}\n1\u0007}\u0007c\u000b1\u0015e\u0007e\u0013b\u0003bFw\tcFa\u0014~\ft\u0005eFj\u001b?"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_pC.m_Fa(Short.valueOf((short)(0x7B & 0x6D)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(c_jB.m_YG((Object)"\u0017A\u001a@\u001eVa$\u001ag/m-e/m5c{e7h{e7e)i{c)k.t($=k)$+v4n>g/$ y{h4g:h7}u"), a);
            a2.activateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(Stats.m_Tf((Object)"(^(<*T'U#C\\14t\u0017d\u0003b\u0012x\bvF}\u0003p\u0002t\u00141\u0012~Fp\u0005e\u000fg\u0007e\u00031\u0007}\n1\u0007}\u0007c\u000b1\u0001c\td\u0016bFw\tcFa\u0014~\ft\u0005eFj\u001b?"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x7C & 0x6F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_dL> getAlarmGroupStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_JZ.m_jHa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroupSummary::getId, alarmGroupSummary -> {
            AlarmManager a = alarmGroupSummary;
            AlarmManager a2 = this;
            return a2.getAlarmGroupStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.activateAlarmGroup(alarmManager.f_JZ.m_mha((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_dL getAlarmStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_xz.m_VHa((String)a2, (String)a)) == null) {
            return c_dL.f_uy;
        }
        return a3.getAlarmStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_el.class})
    public void handleAlarmGroupChangeEvent(c_el c_el2) {
        void a;
        AlarmManager alarmManager = this;
        if (alarmManager.f_pC.m_ma()) {
            f_bc.info(c_jB.m_YG((Object)"\u0017A\u001a@\u001eVa$\u0013e5`7m5c{E7e)i\u001cv4q+G3e5c>A-a5p{b4v{c)k.t{M\u001f>{\u007f&"), (Object)a.m_pLa().getId());
            alarmManager.f_vX.lock();
            try {
                Object a2 = a.m_pLa().getId();
                if (alarmManager.getAlarmGroupStatusInternal((String)a2) == c_dL.f_yz) {
                    AlarmManager alarmManager2 = alarmManager;
                    alarmManager2.deactivateAlarmGroupInternal((String)a2);
                    alarmManager2.activateAlarmGroupInternal((String)a2);
                }
                return;
            }
            finally {
                alarmManager.f_vX.unlock();
            }
        }
        f_bc.debug(Stats.m_Tf((Object)"_)_K]#P\"T4+FX\u0001\u007f\tc\u000f\u007f\u00011'}\u0007c\u000bV\u0014~\u0013a%y\u0007\u007f\u0001t#g\u0003\u007f\u00121\u0000~\u00141\u0001c\td\u00161/U\\1\u001dl"), (Object)a.m_pLa().getId());
    }

    public void notLeader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_pC.m_la();
        f_bc.info(Stats.m_Tf((Object)"'}\u0007c\u000b\\\u0007\u007f\u0007v\u0003c\\12y\u000fbF\u007f\tu\u00031Nj\u001b8Fx\u00151(^F])_!T412Y#1*T'U#CH15e\ta\u0016x\bvFp\n}F}\tr\u0007}Fp\np\u0014|Fx\bb\u0016t\u0005e\tc\u0015?H?"), a);
        alarmManager2.f_vX.lock();
        try {
            alarmManager.f_kaa.m_gia();
            f_bc.info(c_jB.m_YG((Object)"\u001ah:v6I:j:c>v{,\u0015k/$\u0017a:`>v{\u007f&-a$\u001ah7$7k8e7$:h:v6$2j(t>g/m4j{p:w0w{l:r>$9a>j{v>u.a(p>`{p4$(p4tu"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_bc.error(Stats.m_Tf((Object)"P\np\u0014|+p\bp\u0001t\u00141N_\teF]\u0003p\u0002t\u00141\u001dlO+FT\u0014c\tcFu\u0013c\u000f\u007f\u00011\u0016c\tr\u0003b\u00151\twFb\u0012~\u0016a\u000f\u007f\u00011\n~\u0005p\n1\u0007}\u0007c\u000b1\u000f\u007f\u0015a\u0003r\u0012~\u0014b\\1\u001dl"), objectArray);
            return;
        }
        finally {
            alarmManager.f_vX.unlock();
        }
    }

    protected c_dL getAlarmStatusInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        return alarmManager.getAlarmStatusInternal(alarmManager.f_xz.m_Xia((String)a2));
    }

    protected c_dL getAlarmGroupStatusInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_kaa.m_JHa((String)a)) != null && a.m_qha()) {
            return c_dL.f_yz;
        }
        return c_dL.f_uy;
    }

    protected Map<String, c_dL> getAlarmStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_xz.m_hga((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(BaseModel::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(c_jB.m_YG((Object)"H\u001eE\u001fA\t>{E8p2r:p2j<$:h:v6$<v4q+$ y{h4g:h7}u"), a);
            a2.activateAlarmGroupInternal((String)a);
            return;
        }
        f_bc.debug(Stats.m_Tf((Object)"_)_K]#P\"T4+FC\u0003`\u0013t\u0015e\u000f\u007f\u00011\nt\u0007u\u0003cFe\t1\u0007r\u0012x\u0010p\u0012tFp\np\u0014|Fv\u0014~\u0013aFj\u001b?"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x7D & 0x67)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm group " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$2(AlarmGroup alarmGroup) {
        AlarmManager a;
        AlarmManager a2 = alarmGroup;
        AlarmManager alarmManager = a = this;
        long l = alarmManager.f_pC.m_Ja();
        String string = alarmManager.f_pC.m_la();
        c_pK c_pK2 = alarmManager.f_kaa.m_ZHa((AlarmGroup)a2);
        c_pK2.m_sIa();
        long l2 = alarmManager.f_pC.m_Ja();
        if (!alarmManager.f_pC.m_ma() || l2 == -1L || l2 != l) {
            try {
                c_pK2.m_NGa();
                a.f_kaa.m_RHa(a2.getId(), c_pK2);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[--4];
                objectArray[3 & 4] = string;
                objectArray[--1] = a2.getId();
                objectArray[5 >> 1] = exception.getMessage();
                objectArray[--3] = exception;
                f_bc.warn(c_jB.m_YG((Object)"E7e)i\u0016e5e<a)$s\u007f&-a$\u001da5g>`{w/k+$=e2h>`{b4v{e7e)i{c)k.t{\u007f&$:b/a)$/a)i{g3e5c>>{\u007f&"), objectArray);
            }
            Object[] objectArray = new Object[--4];
            objectArray[3 & 4] = a2.getId();
            objectArray[5 >> 2] = string;
            objectArray[5 >> 1] = l;
            objectArray[--3] = l2;
            f_bc.info(Stats.m_Tf((Object)"B\rx\u0016a\u000f\u007f\u00011\u0007r\u0012x\u0010p\u0012x\t\u007fF~\u00001\u0007}\u0007c\u000b1\u0001c\td\u00161\u001dlF~\b1\b~\u0002tFj\u001b+F}\u0003p\u0002t\u0014b\u000ex\u00161\n~\u0015eF~\u00141\u0012t\u0014|Fr\u000ep\bv\u0003uF9\u0015r\u000et\u0002d\nt\u0002,\u001dlJ1\u0005d\u0014c\u0003\u007f\u0012,\u001dlO?"), objectArray);
            return;
        }
        if (c_pK2.m_qha()) {
            String[] stringArray = new String[--1];
            stringArray[3 & 4] = a2.getId();
            a.f_nZ.sadd(f_iaa, stringArray);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_dL> getAlarmGroupStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(c_jB.m_YG((Object)"H\u001eE\u001fA\t>{C>p/m5c{e7h{e7e)i{c)k.t{w/e/q(a($=k)$+v4n>g/$ y{h4g:h7}u"), a);
            return a2.getAlarmGroupStatusesByProjectIdInternal((String)a);
        }
        f_bc.debug(Stats.m_Tf((Object)"(^(<*T'U#C\\14t\u0017d\u0003b\u0012x\bvF}\u0003p\u0002t\u00141\u0000~\u00141\u0007}\n1\u0007}\u0007c\u000b1\u0001c\td\u00161\u0015e\u0007e\u0013b\u0003bFw\tcFa\u0014~\ft\u0005eFj\u001b?"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_pC.m_Fa(Short.valueOf((short)(0x7E & 0x6B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group statuses for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(c_jB.m_YG((Object)"\u0017A\u001a@\u001eVa$\u001fa:g/m-e/m5c{e7h{e7e)i{c)k.t($=k)$+v4n>g/$ y{h4g:h7}u"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(Stats.m_Tf((Object)"(^(<*T'U#C\\14t\u0017d\u0003b\u0012x\bvF}\u0003p\u0002t\u00141\u0012~Fu\u0003p\u0005e\u000fg\u0007e\u00031\u0007}\n1\u0007}\u0007c\u000b1\u0001c\td\u0016bFw\tcFa\u0014~\ft\u0005eFj\u001b?"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_pC.m_Fa(Short.valueOf((short)(0x6F & 0x7D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        a.registerRemoteCallsWithClusterNode();
        f_bc.info(Stats.m_Tf((Object)"P\np\u0014|+p\bp\u0001t\u00141\u000f\u007f\u000fe\u000fp\nx\u001ct\u00021\u0007\u007f\u00021\u0014t\u0001x\u0015e\u0003c\u0003uFp\u00151%}\u0013b\u0012t\u0014_\tu\u0003]\u000fb\u0012t\bt\u0014?"));
    }

    @TransactionalEventListener(value={c_Kk.class})
    public void handleAlarmAddEvent(c_Kk c_Kk2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_pC.m_ma()) {
            c_pK c_pK2;
            AlarmManager a = a.m_RJa();
            f_bc.info(c_jB.m_YG((Object)"\u0017A\u001a@\u001eVa$\u0013e5`7m5c{E7e)i\u001a`?A-a5p{b4v{e7e)i{M\u001f>{\u007f&({C)k.t{M\u001f>{\u007f&"), (Object)a.getId(), (Object)a.getGroupId());
            if (Boolean.TRUE.equals(a.getIsActive()) && (c_pK2 = alarmManager.f_kaa.m_JHa(a.getGroupId())) != null && c_pK2.m_qha()) {
                c_pK2.m_KHa((Alarm)a);
                return;
            }
        } else {
            f_bc.debug(Stats.m_Tf((Object)"_)_K]#P\"T4+FX\u0001\u007f\tc\u000f\u007f\u00011'}\u0007c\u000bP\u0002u#g\u0003\u007f\u00121\u0000~\u00141\u0007}\u0007c\u000b1/U\\1\u001dl"), (Object)a.m_RJa().getId());
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.info(c_jB.m_YG((Object)"H\u001eE\u001fA\t>{L:j?h2j<$\u000bv4n>g/@>e8p2r:p>A-a5p{b4v{t)k1a8p{M\u001f>{\u007f&"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_bc.debug(Stats.m_Tf((Object)"(^(<*T'U#C\\1/v\b~\u0014x\bvFA\u0014~\ft\u0005e\"t\u0007r\u0012x\u0010p\u0012t#g\u0003\u007f\u00121\u0000~\u00141\u0016c\t{\u0003r\u00121/U\\1\u001dl"), a);
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_JZ.m_VIa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_dL getAlarmStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_pC.m_ma()) {
            f_bc.debug(c_jB.m_YG((Object)"H\u001eE\u001fA\t>{C>p/m5c{e7e)i{w/e/q($=k)$ y{h4g:h7}u"), a);
            return a2.getAlarmStatusInternal((String)a);
        }
        f_bc.debug(Stats.m_Tf((Object)"(^(<*T'U#C\\14t\u0017d\u0003b\u0012x\bvF}\u0003p\u0002t\u00141\u0000~\u00141\u0007}\u0007c\u000b1\u0015e\u0007e\u0013bFw\tcFj\u001b?"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[5 >> 3] = a;
            return (c_dL)a2.f_pC.m_Fa(Short.valueOf((short)(0x77 & 0x6F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm status for " + (String)a, (Throwable)exception);
        }
    }

    protected void activateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.activateAlarmGroupInternal(alarmManager.f_JZ.m_nGa((String)a2));
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_NX.m_mEa(() -> a2.lambda$deactivateAlarmGroupInternal$4((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }
}

