/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.user.model.Role;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="permissions")
@AttributeOverride(name="id", column=@Column(name="permission_id", length=36, nullable=false, updatable=false))
public class Permission
extends SpaceBaseModel {
    @Column(name="is_global", nullable=false)
    private Boolean isGlobal = (3 ^ 3) != 0;
    @JsonIgnore
    @ManyToMany(mappedBy="permissions")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<Role> roles;
    @Column(nullable=false)
    private String name;

    public boolean equals(Object object) {
        Permission a = this;
        Object a2 = object;
        if (a == a2) {
            return (3 & 5) != 0;
        }
        if (!(a2 instanceof Permission)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 ^ 3) != 0;
        }
        return Objects.equals(a.name, object2.name);
    }

    @JsonIgnore
    public boolean isSpaceScoped() {
        Permission a;
        if (!a.isGlobal() && a.getSpace() != null) {
            return --1 != 0;
        }
        return false;
    }

    public Permission() {
        Permission a;
        Permission permission = a;
        a.roles = new HashSet();
    }

    public int hashCode() {
        Permission a;
        Object[] objectArray = new Object[--2];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[3 & 5] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getName() {
        Permission a;
        return a.name;
    }

    public Set<Role> getRoles() {
        Permission a;
        return a.roles;
    }

    @JsonIgnore
    public boolean isGlobal() {
        Permission a;
        return Boolean.TRUE.equals(a.isGlobal);
    }

    public Boolean getIsGlobal() {
        Permission a;
        return a.isGlobal;
    }

    public void setName(String string) {
        Object a = string;
        Permission a2 = this;
        a2.name = a;
    }

    public void setIsGlobal(Boolean bl) {
        Object a = bl;
        Permission a2 = this;
        a2.isGlobal = a;
    }

    public void setRoles(Set<Role> set) {
        Object a = set;
        Permission a2 = this;
        a2.roles = a;
    }
}

