/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.alarm.restcontrollers.FiredAlarmController;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.space.SpaceContext;
import com.inscada.mono.space.model.Space;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import java.util.Objects;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.SQLRestriction;

@MappedSuperclass
@FilterDef(name="spaceFilter", parameters={@ParamDef(name="spaceId", type=String.class)}, defaultCondition="space_id = :spaceId")
@Filter(name="spaceFilter")
public abstract class SpaceBaseModel
extends BaseModel {
    public static final String SPACE_COLUMN = "space_id";
    public static final String SPACE_FILTER_NAME = "spaceFilter";
    public static final String SPACE_PARAMETER_NAME = "spaceId";
    public static final String SPACE_DEFAULT_CONDITION = "space_id = :spaceId";
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="space_id", updatable=false)
    protected Space space;

    public SpaceBaseModel() {
        SpaceBaseModel a;
    }

    @PrePersist
    public void setActiveSpace() {
        SpaceBaseModel a;
        if (a.getSpace() == null) {
            a.setSpace(Objects.requireNonNull(SpaceContext.getActiveSpace(), FiredAlarmController.m_nja((Object)"\bd:w>4(|4a7p{v>4+f>g>z/")));
        }
    }

    @PreUpdate
    @PreRemove
    public void checkSpace() {
        SpaceBaseModel a;
        if (a.getSpace() == null || !a.getSpace().equals((Object)SpaceContext.getActiveSpace())) {
            throw new EntityNotFoundException(SpaceContext.m_le((Object)"\u0004;\"0,s3;\"s4#&0\""));
        }
    }

    public void setSpace(Space space) {
        SpaceBaseModel a = space;
        SpaceBaseModel a2 = this;
        a2.space = a;
    }

    public boolean equals(Object object) {
        SpaceBaseModel a = this;
        Object a2 = object;
        if (a == a2) {
            return (3 & 5) != 0;
        }
        if (!(a2 instanceof SpaceBaseModel)) {
            return false;
        }
        Object object2 = a2;
        return Objects.equals(a.getSpace(), object2.getSpace());
    }

    public Space getSpace() {
        SpaceBaseModel a;
        return a.space;
    }

    public int hashCode() {
        SpaceBaseModel a;
        Object[] objectArray = new Object[4 ^ 5];
        objectArray[2 & 5] = a.getSpace();
        return Objects.hash(objectArray);
    }
}

