/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.f4b6a3.uuid.UuidCreator;
import com.inscada.mono.cluster.r.c_kJ;
import com.inscada.mono.datasource.sql.restcontrollers.CustomSqlDatabaseController;
import jakarta.persistence.Column;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.util.Date;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@EntityListeners(value={AuditingEntityListener.class, c_kJ.class})
@FilterDef(name="softDeleteFilter", defaultCondition="deleted_dttm IS NULL")
@Filter(name="softDeleteFilter")
public abstract class BaseModel {
    @Id
    @Column(name="id", updatable=false, nullable=false, length=36)
    protected String id;
    public static final String SOFT_DELETE_FILTER_NAME = "softDeleteFilter";
    public static final String SOFT_DELETE_FILTER_DEFAULT_CONDITION = "deleted_dttm IS NULL";
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @CreatedBy
    @Column(name="insert_user", updatable=false)
    protected String createdBy;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @CreatedDate
    @Column(name="insert_dttm", updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date creationDate;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Column(name="deleted_dttm")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletedDate;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Version
    @Column(name="version")
    private Long version;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @LastModifiedBy
    @Column(name="version_user")
    protected String lastModifiedBy;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @LastModifiedDate
    @Column(name="version_dttm")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date lastModifiedDate;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Column(name="deleted_user")
    private String deletedBy;

    public void setDeletedDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.deletedDate = a;
    }

    public Date getDeletedDate() {
        BaseModel a;
        return a.deletedDate;
    }

    public void setVersion(Long l) {
        Object a = l;
        BaseModel a2 = this;
        a2.version = a;
    }

    public void setDeletedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.deletedBy = a;
    }

    public Date getCreationDate() {
        BaseModel a;
        return a.creationDate;
    }

    public void setLastModifiedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.lastModifiedBy = a;
    }

    @PreRemove
    private /* synthetic */ void preventHardDelete() {
        throw new UnsupportedOperationException(CustomSqlDatabaseController.m_gP((Object)"\u0002\u001c8\u0019j\u0019/\u0011/\t/]#\u000ej\u0013%\tj\u001c&\u0011%\n/\u0019d]\u001a\u0011/\u001c9\u0018j\b9\u0018j\t\"\u0018j\u000f/\r%\u000e#\t%\u000f3Z9].\u0018&\u0018>\u0018j\u0010/\t\"\u0012.],\u00128]9\u0012,\tj\u0019/\u0011/\t#\u0012$S"));
    }

    public String getDeletedBy() {
        BaseModel a;
        return a.deletedBy;
    }

    public String getCreatedBy() {
        BaseModel a;
        return a.createdBy;
    }

    public void setLastModifiedDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.lastModifiedDate = a;
    }

    public Long getVersion() {
        BaseModel a;
        return a.version;
    }

    @PrePersist
    protected void onCreate() {
        BaseModel a;
        if (a.id == null) {
            a.id = UuidCreator.getTimeOrdered().toString();
        }
    }

    public void setId(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.id = a;
    }

    public void setCreatedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.createdBy = a;
    }

    public String getId() {
        BaseModel a;
        return a.id;
    }

    public Date getLastModifiedDate() {
        BaseModel a;
        return a.lastModifiedDate;
    }

    protected BaseModel() {
        BaseModel a;
    }

    public String getLastModifiedBy() {
        BaseModel a;
        return a.lastModifiedBy;
    }

    public void setCreationDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.creationDate = a;
    }
}

