/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.auth.exceptions.AuthTokenException;
import com.inscada.mono.auth.exceptions.RunAsExecutionException;
import com.inscada.mono.broadcast.exceptions.BroadcastOperationException;
import com.inscada.mono.c_kK;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.exceptions.CommunicationException;
import com.inscada.mono.communication.base.exceptions.SetValueException;
import com.inscada.mono.impexp.exceptions.ImportExportException;
import com.inscada.mono.report.exceptions.ReportGenerationException;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.script.exceptions.ScriptException;
import com.inscada.mono.settings.exceptions.SettingsException;
import com.inscada.mono.shared.exceptions.AlreadyExistsException;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.InscadaException;
import com.inscada.mono.shared.exceptions.MismatchException;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.exceptions.ParsingException;
import com.inscada.mono.shared.exceptions.RelationExistsException;
import com.inscada.mono.shared.exceptions.ValidationDefinitionException;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.shared.f.c_BC;
import com.inscada.mono.sms.exceptions.SmsProviderException;
import com.inscada.mono.space.exceptions.SpaceOperationException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.OptimisticLockException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.StaleObjectStateException;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice(basePackages={"com.inscada.mono"})
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String UNKNOWN_ERROR = "Unknown Error";
    private static final String PARSING_ERROR = "Parsing Error";
    private final Environment environment;
    private static final String SMS_PROVIDER_ERROR = "SMS Provider Error";
    private static final String BROADCAST_OPERATION_ERROR = "Broadcast Operation Error";
    private static final String SECURITY_ERROR = "Security Error";
    private static final String NOT_FOUND_ERROR = "Not Found Error";
    private static final String REPORT_GENERATION_ERROR = "Report Generation Error";
    private static final String RUN_AS_ERROR = "Run-As Execution Error";
    private static final String INSCADA_ERROR = "Inscada Error";
    private static final String SET_VALUE_ERROR = "Set Value Error";
    private static final String DATABASE_ERROR = "Database Error";
    private static final String OPTIMISTIC_LOCK_ERROR = "Optimistic Lock Error";
    private static final String SCRIPT_ERROR = "Script Execution Error";
    private static final String VALIDATION_ERROR = "Validation Error";
    private static final String SPACE_OPERATION_ERROR = "Space Operation Error";
    private static final String VALIDATION_DEFINITION_ERROR = "Validation Definition Error";
    private static final String AUTH_TOKEN_ERROR = "Auth Token Error";
    private static final Logger log = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String MISMATCH_ERROR = "Mismatch Error";
    private static final String IMPORT_EXPORT_ERROR = "Import/Export Error";
    private static final String BROWSE_OPERATION_ERROR = "Browse Operation Error";
    private static final String COMMUNICATION_ERROR = "Communication Error";
    private static final String RELATION_EXISTS_ERROR = "Relation Exists Error";
    private static final String SETTINGS_ERROR = "Settings Error";
    private static final String ALREADY_EXISTS_ERROR = "Already Exists Error";
    private static final String NOT_ACTIVE_ERROR = "Not Active Error";
    private static final String CONSTRAINT_VIOLATION = "Constraint Violation";
    private static final String REPORT_SCHEDULING_ERROR = "Report Scheduling Error";
    private static final String FILE_STORAGE_ERROR = "File Storage Error";

    @ExceptionHandler(value={MismatchException.class})
    protected ResponseEntity<Object> handleMismatch(MismatchException mismatchException) {
        GeneralExceptionHandler a = mismatchException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, MISMATCH_ERROR);
    }

    @ExceptionHandler(value={OptimisticLockException.class, StaleObjectStateException.class})
    protected ResponseEntity<Object> handleOptimisticLock(Exception exception) {
        Object a = exception;
        GeneralExceptionHandler a2 = this;
        return a2.buildErrorResponse((Exception)a, c_BC.m_aE((Object)"\u0011J,QeP A*P!\u00022C6\u00020R!C1G!\u0002'[eC+M1J PeW6G7\fer)G$Q \u00027G#P Q-\u0002<M0PeF$V$\u0002$L!\u00021P<\u0002$E$K+\f"), (HttpStatusCode)HttpStatus.CONFLICT, OPTIMISTIC_LOCK_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException httpMessageNotReadableException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        generalExceptionHandler2 = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, VALIDATION_ERROR);
        log.error(c_BC.m_aE((Object)"\bG6Q$E \u0002+M1\u00027G$F$@)G\u007f\u0002>_"), (Object)generalExceptionHandler2, (Object)ex);
        return new ResponseEntity((Object)generalExceptionHandler2, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={BrowseOperationException.class})
    protected ResponseEntity<Object> handleBrowseOperationException(BrowseOperationException browseOperationException) {
        GeneralExceptionHandler a = browseOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROWSE_OPERATION_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ResponseEntity<Object> buildErrorResponse(Exception exception, String string, HttpStatusCode httpStatusCode, String string2) {
        void a;
        void a2;
        void a3;
        Object a4 = string;
        GeneralExceptionHandler a5 = this;
        a4 = a5.createExceptionDetails((HttpStatusCode)a3, (String)a4, (Exception)a2, (String)a, null);
        log.error(c_BC.m_aE((Object)"\fL1G7L$NeG7P*P\u007f\u0002>_"), a4, (Object)a2);
        return new ResponseEntity(a4, (HttpStatusCode)a3);
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    protected ResponseEntity<Object> handleSecurityExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.FORBIDDEN, SECURITY_ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException illegalArgumentException) {
        IllegalArgumentException a = illegalArgumentException;
        GeneralExceptionHandler a2 = this;
        IllegalArgumentException illegalArgumentException2 = a;
        return a2.buildErrorResponse((Exception)illegalArgumentException2, illegalArgumentException2.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    @ExceptionHandler(value={ValidationDefinitionException.class})
    protected ResponseEntity<Object> handleValidationDefinitionException(ValidationDefinitionException validationDefinitionException) {
        GeneralExceptionHandler a = validationDefinitionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, VALIDATION_DEFINITION_ERROR);
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return c_kK.m_FKa((Object)"U\u0006Q\u000f\n\u0012K\fK\bR\t");
        }
    }

    @ExceptionHandler(value={BroadcastOperationException.class})
    protected ResponseEntity<Object> handleBroadcastOperationException(BroadcastOperationException broadcastOperationException) {
        GeneralExceptionHandler a = broadcastOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROADCAST_OPERATION_ERROR);
    }

    @ExceptionHandler(value={RelationExistsException.class})
    protected ResponseEntity<Object> handleRelationExists(RelationExistsException relationExistsException) {
        GeneralExceptionHandler a = relationExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, RELATION_EXISTS_ERROR);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException missingServletRequestParameterException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = missingServletRequestParameterException;
        GeneralExceptionHandler ex = generalExceptionHandler;
        Object[] objectArray = new Object[1 ^ 3];
        objectArray[2 & 5] = generalExceptionHandler2.getParameterName();
        objectArray[3 >> 1] = generalExceptionHandler2.getParameterType();
        ExceptionDetails headers = ex.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, c_BC.m_aE((Object)"p S0K7G!\u00025C7C(G1G7\u0002b\u00076\u0005eM#\u00021[5Ge\u0005`Qb\u0002,QeO,Q6K+E").formatted(objectArray), (Exception)generalExceptionHandler2, VALIDATION_ERROR);
        log.error(c_kK.m_FKa((Object)"*L\u0014V\u000eK\u0000\u0005\u0017D\u0015D\n@\u0013@\u0015\u001fG^\u001a"), (Object)headers, (Object)generalExceptionHandler2);
        return new ResponseEntity((Object)headers, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException methodArgumentTypeMismatchException) {
        GeneralExceptionHandler a = methodArgumentTypeMismatchException;
        GeneralExceptionHandler a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = a.getName();
        objectArray[--1] = a.getValue();
        objectArray[1 ^ 3] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : c_kK.m_FKa((Object)"\u0012K\fK\bR\t");
        String string = c_BC.m_aE((Object)"\u0015C7C(G1G7\u0002b\u00076\u0005eU,V-\u00023C)W \u0002b\u00076\u0005eA*W)FeL*Ve@ \u0002&M+T P1G!\u00021MeV<R \u0002b\u00076\u0005").formatted(objectArray);
        return a2.buildErrorResponse((Exception)a, string, (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    @ExceptionHandler(value={ReportGenerationException.class})
    protected ResponseEntity<Object> handleReportGenerationException(ReportGenerationException reportGenerationException) {
        GeneralExceptionHandler a = reportGenerationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_GENERATION_ERROR);
    }

    @ExceptionHandler(value={CommunicationException.class})
    protected ResponseEntity<Object> handleCommunicationException(CommunicationException communicationException) {
        GeneralExceptionHandler a = communicationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, COMMUNICATION_ERROR);
    }

    @ExceptionHandler(value={ImportExportException.class})
    protected ResponseEntity<Object> handleImportExportException(ImportExportException importExportException) {
        GeneralExceptionHandler a = importExportException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, IMPORT_EXPORT_ERROR);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException dataIntegrityViolationException) {
        GeneralExceptionHandler a = dataIntegrityViolationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, ExceptionUtils.getRootCauseMessage((Throwable)generalExceptionHandler), (HttpStatusCode)HttpStatus.CONFLICT, DATABASE_ERROR);
    }

    @ExceptionHandler(value={InscadaException.class})
    protected ResponseEntity<Object> handleInscadaException(InscadaException inscadaException) {
        GeneralExceptionHandler a = inscadaException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={TransactionSystemException.class})
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException transactionSystemException) {
        void a;
        GeneralExceptionHandler generalExceptionHandler = this;
        Object a2 = a.getRootCause();
        if (a2 instanceof ConstraintViolationException) {
            a2 = (ConstraintViolationException)a2;
            return generalExceptionHandler.handleConstraintViolation((ConstraintViolationException)a2);
        }
        void v0 = a;
        return generalExceptionHandler.buildErrorResponse((Exception)v0, ExceptionUtils.getRootCauseMessage((Throwable)v0), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    @ExceptionHandler(value={SmsProviderException.class})
    protected ResponseEntity<Object> handleSmsProviderException(SmsProviderException smsProviderException) {
        GeneralExceptionHandler a = smsProviderException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SMS_PROVIDER_ERROR);
    }

    @ExceptionHandler(value={SpaceOperationException.class})
    protected ResponseEntity<Object> handleSpaceOperationException(SpaceOperationException spaceOperationException) {
        GeneralExceptionHandler a = spaceOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SPACE_OPERATION_ERROR);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException illegalStateException) {
        IllegalStateException a = illegalStateException;
        GeneralExceptionHandler a2 = this;
        IllegalStateException illegalStateException2 = a;
        return a2.buildErrorResponse((Exception)illegalStateException2, illegalStateException2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException methodArgumentNotValidException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        object = new HashMap();
        Map status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return c_kK.m_FKa((Object)"k\b\u0005\n@\u0014V\u0006B\u0002\u0005\u0006S\u0006L\u000bD\u0005I\u0002");
        }, Collectors.toList())));
        List a = ex.getBindingResult().getGlobalErrors().stream().map(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return c_kK.m_FKa((Object)"k\b\u0005\n@\u0014V\u0006B\u0002\u0005\u0006S\u0006L\u000bD\u0005I\u0002");
        }).collect(Collectors.toList());
        object.putAll(status);
        if (!a.isEmpty()) {
            object.put(c_BC.m_aE((Object)"\"N*@$N"), a);
        }
        object = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, headers.formatErrorMessages((Map)object), (Exception)ex, VALIDATION_ERROR, (Map)object);
        log.error(c_kK.m_FKa((Object)"s\u0006I\u000eA\u0006Q\u000eJ\t\u0005\u0002W\u0015J\u0015\u001fG^\u001a"), object, (Object)ex);
        return new ResponseEntity(object, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={FileStorageException.class})
    protected ResponseEntity<Object> handleFileStorage(FileStorageException fileStorageException) {
        GeneralExceptionHandler a = fileStorageException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, FILE_STORAGE_ERROR);
    }

    private /* synthetic */ boolean isSseRequest() {
        block5: {
            ServletRequestAttributes servletRequestAttributes;
            block4: {
                GeneralExceptionHandler generalExceptionHandler = this;
                try {
                    servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                    if (servletRequestAttributes != null) break block4;
                    return false;
                }
                catch (Exception exception) {
                    return 5 >> 3;
                }
            }
            HttpServletRequest httpServletRequest = servletRequestAttributes.getRequest();
            String string = httpServletRequest.getHeader(c_BC.m_aE((Object)"\u0004A&G5V"));
            String a = httpServletRequest.getHeader("Content-Type");
            if ((string == null || !string.contains(c_kK.m_FKa((Object)"\u0013@\u001fQH@\u0011@\tQJV\u0013W\u0002D\n"))) && (a == null || !a.contains(c_BC.m_aE((Object)"V Z1\r T L1\u000f6V7G$O")))) break block5;
            return true;
        }
        return false;
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleAllExceptions(Exception exception) {
        Exception a = exception;
        Object a2 = this;
        if (a2.isSseRequest() && (a2.isClientAbort((Throwable)a) || a instanceof HttpMessageNotReadableException || a instanceof HttpMessageNotWritableException)) {
            log.warn(c_kK.m_FKa((Object)"v4`GW\u0002T\u0012@\u0014QG@\u0015W\bWGV\u0012U\u0017W\u0002V\u0014@\u0003\u001fG^\u001a"), (Object)a.getMessage());
            return ResponseEntity.noContent().build();
        }
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, UNKNOWN_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleExceptionInternal(Exception exception, Object object, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void status;
        GeneralExceptionHandler generalExceptionHandler = exception2;
        Exception exception2 = exception;
        GeneralExceptionHandler ex = generalExceptionHandler;
        if (ex.isSseRequest() && (ex.isClientAbort((Throwable)exception2) || exception2 instanceof HttpMessageNotReadableException || exception2 instanceof HttpMessageNotWritableException)) {
            log.warn(c_BC.m_aE((Object)"q\u0016geK+V P+C)\u0002 P7M7\u00026W5R7G6Q F\u007f\u0002>_"), (Object)exception2.getMessage());
            return ResponseEntity.noContent().build();
        }
        ExceptionDetails body = ex.createExceptionDetails((HttpStatusCode)status, exception2.getMessage(), exception2, UNKNOWN_ERROR);
        log.error(c_kK.m_FKa((Object)"l\tQ\u0002W\tD\u000b\u0005\u0002W\u0015J\u0015\u001fG^\u001a"), (Object)body, (Object)exception2);
        return new ResponseEntity((Object)body, (HttpStatusCode)status);
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException influxDBMapperException) {
        GeneralExceptionHandler a = influxDBMapperException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> map) {
        Map<String, List<String>> a2 = map;
        GeneralExceptionHandler a3 = this;
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)c_BC.m_aE((Object)"i\u0002"), (Iterable)a.getValue())).collect(Collectors.joining(c_BC.m_aE((Object)"\u00029\u0002")));
    }

    @ExceptionHandler(value={NotFoundException.class, EntityNotFoundException.class})
    protected ResponseEntity<Object> handleEntityNotFound(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND, NOT_FOUND_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException constraintViolationException) {
        GeneralExceptionHandler a2 = constraintViolationException;
        GeneralExceptionHandler a3 = this;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails((HttpStatusCode)HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, CONSTRAINT_VIOLATION, map);
        log.error(c_kK.m_FKa((Object)"f\bK\u0014Q\u0015D\u000eK\u0013\u0005\u0011L\bI\u0006Q\u000eJ\t\u001fG^\u001a"), (Object)a2);
        return new ResponseEntity((Object)a2, (HttpStatusCode)HttpStatus.CONFLICT);
    }

    private /* synthetic */ boolean isClientAbort(Throwable throwable) {
        Throwable a = throwable;
        GeneralExceptionHandler a2 = this;
        Throwable throwable2 = a;
        while (throwable2 != null) {
            String string;
            if (a instanceof ClientAbortException) {
                return (3 & 5) != 0;
            }
            if (a instanceof IOException && (string = a.getMessage()) != null && ((string = string.toLowerCase(Locale.ROOT)).contains(c_kK.m_FKa((Object)"\u0005W\bN\u0002KGU\u000eU\u0002")) || string.contains(c_BC.m_aE((Object)"&M+L A1K*LeP Q V")) || string.contains(c_kK.m_FKa((Object)"\u0006G\bW\u0013@\u0003\u0005\u0005\\GQ\u000f@GV\bC\u0013R\u0006W\u0002")))) {
                return true;
            }
            throwable2 = a.getCause();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String sanitizeMessage(String string, Exception exception) {
        void a;
        Object a2 = exception;
        GeneralExceptionHandler a3 = this;
        if (a2 instanceof ScriptException) {
            return a;
        }
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof AlreadyExistsException) {
            return c_BC.m_aE((Object)"p Q*W7A \u0002$N7G$F<\u0002 Z,Q1Q");
        }
        if (a2 instanceof FileStorageException) {
            return c_kK.m_FKa((Object)"!L\u000b@GJ\u0017@\u0015D\u0013L\bKGC\u0006L\u000b@\u0003");
        }
        if (a2 instanceof MismatchException) {
            return c_BC.m_aE((Object)"p Q*W7A \u0002(K6O$V&J");
        }
        if (a2 instanceof NotActiveException) {
            return c_kK.m_FKa((Object)"w\u0002V\bP\u0015F\u0002\u0005\u000eVGK\bQGD\u0004Q\u000eS\u0002");
        }
        if (a2 instanceof NotFoundException) {
            return c_BC.m_aE((Object)"\u0017G6M0P&GeL*VeD*W+F");
        }
        if (a2 instanceof RelationExistsException) {
            return c_kK.m_FKa((Object)"5@\u000bD\u0013@\u0003\u0005\u0015@\u0014J\u0012W\u0004@G@\u001fL\u0014Q\u0014");
        }
        if (a2 instanceof OptimisticLockException || a2 instanceof StaleObjectStateException) {
            return c_BC.m_aE((Object)"\u0017G6M0P&GeU$QeW5F$V Fe@<\u0002$L*V-G7\u00020Q P");
        }
        if (a2 instanceof SmsProviderException) {
            return c_kK.m_FKa((Object)"v*vGV\u0002W\u0011L\u0004@GJ\u0017@\u0015D\u0013L\bKGC\u0006L\u000b@\u0003");
        }
        if (a2 instanceof SettingsException) {
            return c_BC.m_aE((Object)"\u0004R5N,A$V,M+\u00026G1V,L\"QeG7P*P");
        }
        if (a2 instanceof ParsingException) {
            return c_kK.m_FKa((Object)".K\u0011D\u000bL\u0003\u0005\u0003D\u0013DGC\bW\nD\u0013");
        }
        if (a2 instanceof ValidationDefinitionException) {
            return c_BC.m_aE((Object)"k+V P+C)\u00023C)K!C1K*LeA*L#K\"W7C1K*LeG7P*P");
        }
        if (a2 instanceof BrowseOperationException) {
            return c_kK.m_FKa((Object)"&KG@\u0015W\bWGJ\u0004F\u0012W\u0015@\u0003\u0005\u0003P\u0015L\tBGDGG\u0015J\u0010V\u0002\u0005\bU\u0002W\u0006Q\u000eJ\t");
        }
        if (a2 instanceof SetValueException) {
            return c_BC.m_aE((Object)"c+\u0002 P7M7\u0002*A&W7P FeU-K)GeQ V1K+EeCeT$N0G");
        }
        if (a2 instanceof CommunicationException) {
            return c_kK.m_FKa((Object)"$J\nH\u0012K\u000eF\u0006Q\u000eJ\t\u0005\u0004J\tC\u000eB\u0012W\u0006Q\u000eJ\t\u0005\u0002W\u0015J\u0015");
        }
        if (a2 instanceof RunAsExecutionException) {
            return c_BC.m_aE((Object)"c+\u0002,L1G7L$NeM5G7C1K*LeD$K)G!\u0002!W7K+EeG=G&W1K*L");
        }
        if (a2 instanceof SpaceOperationException) {
            return c_kK.m_FKa((Object)"4U\u0006F\u0002\u0005\bU\u0002W\u0006Q\u000eJ\t\u0005\u0001D\u000eI\u0002AGA\u0012@GQ\b\u0005\u0006\u0005\u0005P\u0014L\t@\u0014VGW\u0012I\u0002\u0005\u0011L\bI\u0006Q\u000eJ\t");
        }
        if (a2 instanceof ImportExportException) {
            return c_BC.m_aE((Object)"c+\u0002 P7M7\u0002*A&W7P FeF0P,L\"\u0002!C1CeK(R*P1\r Z5M7V");
        }
        if (a2 instanceof ReportGenerationException) {
            return c_kK.m_FKa((Object)"d\t\u0005\u0002W\u0015J\u0015\u0005\bF\u0004P\u0015W\u0002AGA\u0012W\u000eK\u0000\u0005\u0015@\u0017J\u0015QGB\u0002K\u0002W\u0006Q\u000eJ\t");
        }
        if (a2 instanceof ReportSchedulingException) {
            return c_BC.m_aE((Object)"\u0004LeG7P*PeM&A0P7G!\u0002!W7K+EeP R*P1\u00026A-G!W)K+E");
        }
        if (a2 instanceof BroadcastOperationException) {
            return c_kK.m_FKa((Object)"d\t\u0005\u0002W\u0015J\u0015\u0005\bF\u0004P\u0015W\u0002AGA\u0012W\u000eK\u0000\u0005\u0006\u0005\u0005W\bD\u0003F\u0006V\u0013\u0005\bU\u0002W\u0006Q\u000eJ\t");
        }
        if (a2 instanceof AuthTokenException) {
            return c_BC.m_aE((Object)"\u0004LeC0V-G+V,A$V,M+\u00021M.G+\u0002 P7M7\u0002*A&W7P F");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return c_kK.m_FKa((Object)"#D\u0013D\u0005D\u0014@GF\bK\u0014Q\u0015D\u000eK\u0013\u0005\u0011L\bI\u0006Q\u000eJ\t");
        }
        if (a2 instanceof TransactionSystemException) {
            return c_BC.m_aE((Object)"\u0001C1C'C6GeV7C+Q$A1K*LeG7P*P");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return c_kK.m_FKa((Object)"q\u000eH\u0002\u0005\u0014@\u0015L\u0002VGA\u0006Q\u0006G\u0006V\u0002\u0005\u0002W\u0015J\u0015");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return c_BC.m_aE((Object)"c&A Q6\u0002!G+K F");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return c_kK.m_FKa((Object)".K\u0011D\u000bL\u0003\u0005\u000eK\u0017P\u0013");
        }
        if (a2 instanceof ConstraintViolationException) {
            return c_BC.m_aE((Object)"t$N,F$V,M+\u0002&M+Q1P$K+VeT,M)C1K*L");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return c_kK.m_FKa((Object)"l\tS\u0006I\u000eAGW\u0002T\u0012@\u0014QGC\bW\nD\u0013");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return c_BC.m_aE((Object)"\bK6Q,L\"\u00027G4W,P FeR$P$O V P");
        }
        if (a2 instanceof IllegalStateException) {
            return c_kK.m_FKa((Object)".K\u0011D\u000bL\u0003\u0005\u0006U\u0017I\u000eF\u0006Q\u000eJ\t\u0005\u0014Q\u0006Q\u0002");
        }
        return c_BC.m_aE((Object)"\u0004LeW+G=R A1G!\u0002 P7M7\u0002*A&W7P F");
    }

    @ExceptionHandler(value={ReportSchedulingException.class})
    protected ResponseEntity<Object> handleReportSchedulingException(ReportSchedulingException reportSchedulingException) {
        GeneralExceptionHandler a = reportSchedulingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_SCHEDULING_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2) {
        Object a;
        void a2;
        void a3;
        void a4;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler a5 = generalExceptionHandler;
        return a5.createExceptionDetails((HttpStatusCode)a4, (String)a3, (Exception)a2, (String)a, null);
    }

    @ExceptionHandler(value={AuthTokenException.class})
    protected ResponseEntity<Object> handleAuthTokenException(AuthTokenException authTokenException) {
        GeneralExceptionHandler a = authTokenException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, AUTH_TOKEN_ERROR);
    }

    @ExceptionHandler(value={ScriptException.class})
    protected ResponseEntity<Object> handleScriptException(ScriptException scriptException) {
        GeneralExceptionHandler a = scriptException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SCRIPT_ERROR);
    }

    public GeneralExceptionHandler(Environment environment) {
        GeneralExceptionHandler a = environment;
        GeneralExceptionHandler a2 = this;
        a2.environment = a;
    }

    @ExceptionHandler(value={SetValueException.class})
    protected ResponseEntity<Object> handleSetValueException(SetValueException setValueException) {
        GeneralExceptionHandler a = setValueException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SET_VALUE_ERROR);
    }

    @ExceptionHandler(value={AlreadyExistsException.class})
    protected ResponseEntity<Object> handleAlreadyExists(AlreadyExistsException alreadyExistsException) {
        GeneralExceptionHandler a = alreadyExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, ALREADY_EXISTS_ERROR);
    }

    @ExceptionHandler(value={SettingsException.class})
    protected ResponseEntity<Object> handleSettingsException(SettingsException settingsException) {
        GeneralExceptionHandler a = settingsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SETTINGS_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2, Map<String, List<String>> map) {
        void a;
        void a2;
        Object a3;
        void a4;
        String a5;
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler generalExceptionHandler2 = a6 = generalExceptionHandler;
        a5 = generalExceptionHandler2.sanitizeMessage(a5, (Exception)a4);
        String string3 = generalExceptionHandler2.isDevelopment() ? a4.getClass().getName() : c_kK.m_FKa((Object)"\"]\u0004@\u0017Q\u000eJ\t");
        Object object2 = a6.isDevelopment() ? a3 : c_BC.m_aE((Object)"g7P*P");
        return new ExceptionDetails(a2.value(), a5, string3, (String)object2, (Map)a, (String)(a3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a4) : null), new Date(), a6.getCurrentPath());
    }

    private /* synthetic */ boolean isDevelopment() {
        String[] stringArray = this;
        String[] a = stringArray.environment.getActiveProfiles();
        if (a.length == 0) {
            return 3 >> 2;
        }
        return Arrays.asList(a).contains(c_kK.m_FKa((Object)"\u0003@\u0011"));
    }

    @ExceptionHandler(value={ParsingException.class})
    protected ResponseEntity<Object> handleParsingException(ParsingException parsingException) {
        GeneralExceptionHandler a = parsingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, PARSING_ERROR);
    }

    @ExceptionHandler(value={RunAsExecutionException.class})
    protected ResponseEntity<Object> handleRunAsExecution(RunAsExecutionException runAsExecutionException) {
        GeneralExceptionHandler a = runAsExecutionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, RUN_AS_ERROR);
    }

    @ExceptionHandler(value={NotActiveException.class})
    protected ResponseEntity<Object> handleNotActive(NotActiveException notActiveException) {
        GeneralExceptionHandler a = notActiveException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, NOT_ACTIVE_ERROR);
    }
}

