/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.repositories;

import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportSummary;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;

@EnableSpaceFilter
public interface ReportRepository
extends BaseJpaRepository<Report> {
    public List<Report> findByProjectId(String var1);

    @Query(value="SELECT new com.inscada.mono.report.model.ReportSummary(r.id, r.name, r.project.id, r.dsc, r.createdBy, r.creationDate, r.lastModifiedBy, r.lastModifiedDate) FROM Report r WHERE r.id = ?1")
    public Optional<ReportSummary> findSummaryById(String var1);

    public Optional<Report> findOneByProjectIdAndName(String var1, String var2);

    public List<Report> findByProjectIdAndNameIn(String var1, Set<String> var2);

    @Query(value="SELECT new com.inscada.mono.report.model.ReportSummary(r.id, r.name, r.project.id, r.dsc, r.createdBy, r.creationDate, r.lastModifiedBy, r.lastModifiedDate) FROM Report r WHERE r.project.id = ?1 AND r.name = ?2")
    public Optional<ReportSummary> findSummaryByProjectIdAndName(String var1, String var2);

    @Query(value="SELECT new com.inscada.mono.report.model.ReportSummary(r.id, r.name, r.project.id, r.dsc, r.createdBy, r.creationDate, r.lastModifiedBy, r.lastModifiedDate) FROM Report r WHERE r.project.id = ?1")
    public List<ReportSummary> findSummaryByProjectId(String var1);

    @DisableSpaceFilter
    @Query(value="SELECT r FROM Report r WHERE r.id IN ?1")
    public List<Report> findAllInAllSpaces(Set<String> var1);

    @Query(value="SELECT new com.inscada.mono.report.model.ReportSummary(r.id, r.name, r.project.id, r.dsc, r.createdBy, r.creationDate, r.lastModifiedBy, r.lastModifiedDate) FROM Report r")
    public List<ReportSummary> findSummary();
}

