/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportSubgroup;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="report_group")
@AttributeOverride(name="id", column=@Column(name="report_group_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"reportId", "report"})
public class ReportGroup
extends SpaceBaseModel {
    @NotBlank
    @Size(max=100)
    private String name;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="report_id")
    private Report report;
    @NotNull
    @Min(value=1L)
    @Column(name="group_order")
    private Short groupOrder;
    @JsonIgnore
    @OneToMany(mappedBy="reportGroup")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<ReportSubgroup> reportSubgroups;
    @Size(max=255)
    @Column
    private String dsc;
    @Column(name="report_id", updatable=false, insertable=false)
    private String reportId;

    public void setDsc(String string) {
        Object a = string;
        ReportGroup a2 = this;
        a2.dsc = a;
    }

    public void setGroupOrder(Short s) {
        Object a = s;
        ReportGroup a2 = this;
        a2.groupOrder = a;
    }

    public void setReport(Report report) {
        ReportGroup a;
        ReportGroup a2 = report;
        ReportGroup reportGroup = a = this;
        reportGroup.report = a2;
        reportGroup.reportId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Short getGroupOrder() {
        ReportGroup a;
        return a.groupOrder;
    }

    public ReportGroup() {
        ReportGroup a;
        ReportGroup reportGroup = a;
        reportGroup.reportSubgroups = new HashSet();
    }

    public int hashCode() {
        ReportGroup a;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = super.hashCode();
        objectArray[--1] = a.getName();
        objectArray[5 >> 1] = a.getReportId();
        return Objects.hash(objectArray);
    }

    public boolean equals(Object object) {
        ReportGroup a = this;
        Object a2 = object;
        if (a == a2) {
            return (3 & 5) != 0;
        }
        if (!(a2 instanceof ReportGroup)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 ^ 3) != 0;
        }
        if (a.getName().equals(object2.getName()) && a.getReportId().equals(object2.getReportId())) {
            return (4 ^ 5) != 0;
        }
        return false;
    }

    public String getName() {
        ReportGroup a;
        return a.name;
    }

    public String getReportId() {
        ReportGroup a;
        return a.reportId;
    }

    public void setReportId(String string) {
        Object a = string;
        ReportGroup a2 = this;
        a2.reportId = a;
    }

    public Set<ReportSubgroup> getReportSubgroups() {
        ReportGroup a;
        return a.reportSubgroups;
    }

    public void setName(String string) {
        Object a = string;
        ReportGroup a2 = this;
        a2.name = a;
    }

    public Report getReport() {
        ReportGroup a;
        return a.report;
    }

    public void setReportSubgroups(Set<ReportSubgroup> set) {
        Object a = set;
        ReportGroup a2 = this;
        a2.reportSubgroups = a;
    }

    public String getDsc() {
        ReportGroup a;
        return a.dsc;
    }
}

