/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.report.model.ReportGroup;
import com.inscada.mono.report.r.c_KB;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="report")
@AttributeOverride(name="id", column=@Column(name="report_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class Report
extends OwnedSpaceBaseModel {
    @JsonIgnore
    @OneToMany(mappedBy="report")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<ReportGroup> reportGroups;
    @Min(value=1L)
    @Max(value=31L)
    @Column(name="report_day")
    private Short reportDay;
    @NotNull
    @Column(name="print_flag")
    private Boolean printFlag;
    @Min(value=1L)
    @Max(value=31L)
    @Column(name="print_day")
    private Short printDay;
    @NotNull
    private c_KB period;
    @Min(value=1L)
    @Column(name="minutes")
    private Integer minutes;
    @Min(value=1L)
    @Max(value=31L)
    @Column(name="mail_day")
    private Short mailDay;
    @NotNull
    @Column(name="mail_flag")
    private Boolean mailFlag;
    @Size(max=50)
    private String no;
    @Column(name="mail_to")
    private String mailTo;
    @NotNull
    @Column(name="logo_flag")
    private Boolean logoFlag;
    @Size(max=255)
    private String dsc;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm:ss")
    @Temporal(value=TemporalType.TIME)
    @Column(name="print_time")
    private Date printTime;
    @NotBlank
    @Size(max=100)
    private String name;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm:ss")
    @Temporal(value=TemporalType.TIME)
    @Column(name="report_time")
    private Date reportTime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm:ss")
    @Temporal(value=TemporalType.TIME)
    @Column(name="mail_time")
    private Date mailTime;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    private String lang;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;

    public void setReportGroups(Set<ReportGroup> set) {
        Object a = set;
        Report a2 = this;
        a2.reportGroups = a;
    }

    public Date getReportTime() {
        Report a;
        return a.reportTime;
    }

    public void setPrintTime(Date date) {
        Object a = date;
        Report a2 = this;
        a2.printTime = a;
    }

    public Boolean getLogoFlag() {
        Report a;
        return a.logoFlag;
    }

    public Report() {
        Report a;
        Report report = a;
        report.reportGroups = new HashSet();
    }

    public String getDsc() {
        Report a;
        return a.dsc;
    }

    public boolean equals(Object object) {
        Report a = this;
        Object a2 = object;
        if (a == a2) {
            return 5 >> 2;
        }
        if (!(a2 instanceof Report)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return 3 >> 2;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return (2 ^ 3) != 0;
        }
        return false;
    }

    public Short getMailDay() {
        Report a;
        return a.mailDay;
    }

    public void setMinutes(Integer n) {
        Object a = n;
        Report a2 = this;
        a2.minutes = a;
    }

    public String getMailTo() {
        Report a;
        return a.mailTo;
    }

    public int hashCode() {
        Report a;
        Object[] objectArray = new Object[--3];
        objectArray[3 & 4] = super.hashCode();
        objectArray[--1] = a.getProjectId();
        objectArray[--2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setProject(Project project) {
        Report a;
        Report a2 = project;
        Report report = a = this;
        report.project = a2;
        report.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setMailFlag(Boolean bl) {
        Object a = bl;
        Report a2 = this;
        a2.mailFlag = a;
    }

    public Project getProject() {
        Report a;
        return a.project;
    }

    public String getProjectId() {
        Report a;
        return a.projectId;
    }

    public Date getMailTime() {
        Report a;
        return a.mailTime;
    }

    public void setNo(String string) {
        Object a = string;
        Report a2 = this;
        a2.no = a;
    }

    public void setPrintFlag(Boolean bl) {
        Object a = bl;
        Report a2 = this;
        a2.printFlag = a;
    }

    public c_KB getPeriod() {
        Report a;
        return a.period;
    }

    public String getName() {
        Report a;
        return a.name;
    }

    public void setReportTime(Date date) {
        Object a = date;
        Report a2 = this;
        a2.reportTime = a;
    }

    public void setPeriod(c_KB c_KB2) {
        Report a = c_KB2;
        Report a2 = this;
        a2.period = a;
    }

    public void setLogoFlag(Boolean bl) {
        Object a = bl;
        Report a2 = this;
        a2.logoFlag = a;
    }

    public void setName(String string) {
        Object a = string;
        Report a2 = this;
        a2.name = a;
    }

    public void setMailTime(Date date) {
        Object a = date;
        Report a2 = this;
        a2.mailTime = a;
    }

    public Date getPrintTime() {
        Report a;
        return a.printTime;
    }

    public Short getPrintDay() {
        Report a;
        return a.printDay;
    }

    public void setLang(String string) {
        Object a = string;
        Report a2 = this;
        a2.lang = a;
    }

    public void setMailTo(String string) {
        Object a = string;
        Report a2 = this;
        a2.mailTo = a;
    }

    public Short getReportDay() {
        Report a;
        return a.reportDay;
    }

    public void setMailDay(Short s) {
        Object a = s;
        Report a2 = this;
        a2.mailDay = a;
    }

    public Set<ReportGroup> getReportGroups() {
        Report a;
        return a.reportGroups;
    }

    public void setDsc(String string) {
        Object a = string;
        Report a2 = this;
        a2.dsc = a;
    }

    public Integer getMinutes() {
        Report a;
        return a.minutes;
    }

    public Boolean getMailFlag() {
        Report a;
        return a.mailFlag;
    }

    public String getLang() {
        Report a;
        return a.lang;
    }

    public void setReportDay(Short s) {
        Object a = s;
        Report a2 = this;
        a2.reportDay = a;
    }

    public String getNo() {
        Report a;
        return a.no;
    }

    public Boolean getPrintFlag() {
        Report a;
        return a.printFlag;
    }

    public void setPrintDay(Short s) {
        Object a = s;
        Report a2 = this;
        a2.printDay = a;
    }

    public void setProjectId(String string) {
        Object a = string;
        Report a2 = this;
        a2.projectId = a;
    }
}

