/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.project.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.shared.model.SpaceBaseModel;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="project")
@AttributeOverride(name="id", column=@Column(name="project_id", length=36, nullable=false, updatable=false))
public class Project
extends SpaceBaseModel {
    @Size(max=255)
    private String address;
    @Column(name="icon_file_id", updatable=false, insertable=false)
    private String iconFileId;
    @Size(max=255)
    private String dsc;
    private Double longitude;
    @NotBlank
    @Size(max=100)
    @Column(updatable=false)
    private String name;
    @NotNull
    @Column(name="active_flag")
    private Boolean isActive;
    @JsonIgnore
    @OneToOne
    @JoinColumn(name="icon_file_id")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private FileInfo iconFile;
    @Column(name="contract_day")
    private Integer contractDay;
    @Column(name="contract_hour")
    private String contractHour;
    private String properties;
    private Double latitude;

    public boolean equals(Object object) {
        Project a = this;
        Object a2 = object;
        if (a == a2) {
            return 3 >> 1;
        }
        if (!(a2 instanceof Project)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return 5 >> 3;
        }
        return a.getName().equals(object2.getName());
    }

    public Double getLatitude() {
        Project a;
        return a.latitude;
    }

    public int hashCode() {
        Project a;
        Object[] objectArray = new Object[1 ^ 3];
        objectArray[3 ^ 3] = super.hashCode();
        objectArray[--1] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getAddress() {
        Project a;
        return a.address;
    }

    public Integer getContractDay() {
        Project a;
        return a.contractDay;
    }

    public void setProperties(String string) {
        Object a = string;
        Project a2 = this;
        a2.properties = a;
    }

    public void setContractDay(Integer n) {
        Object a = n;
        Project a2 = this;
        a2.contractDay = a;
    }

    public Double getLongitude() {
        Project a;
        return a.longitude;
    }

    public String getDsc() {
        Project a;
        return a.dsc;
    }

    public Project() {
        Project a;
    }

    public String getContractHour() {
        Project a;
        return a.contractHour;
    }

    public void setIconFile(FileInfo fileInfo) {
        Project a;
        Project a2 = fileInfo;
        Project project = a = this;
        project.iconFile = a2;
        project.iconFileId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setContractHour(String string) {
        Object a = string;
        Project a2 = this;
        a2.contractHour = a;
    }

    public String getProperties() {
        Project a;
        return a.properties;
    }

    public String getName() {
        Project a;
        return a.name;
    }

    public void setIconFileId(String string) {
        Object a = string;
        Project a2 = this;
        a2.iconFileId = a;
    }

    public void setDsc(String string) {
        Object a = string;
        Project a2 = this;
        a2.dsc = a;
    }

    public void setLongitude(Double d) {
        Object a = d;
        Project a2 = this;
        a2.longitude = a;
    }

    public void setLatitude(Double d) {
        Object a = d;
        Project a2 = this;
        a2.latitude = a;
    }

    public void setIsActive(Boolean bl) {
        Object a = bl;
        Project a2 = this;
        a2.isActive = a;
    }

    public Boolean getIsActive() {
        Project a;
        return a.isActive;
    }

    public String getIconFileId() {
        Project a;
        return a.iconFileId;
    }

    public FileInfo getIconFile() {
        Project a;
        return a.iconFile;
    }

    public void setAddress(String string) {
        Object a = string;
        Project a2 = this;
        a2.address = a;
    }

    public void setName(String string) {
        Object a = string;
        Project a2 = this;
        a2.name = a;
    }
}

