/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.menu.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.user.model.Role;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="menus")
@Inheritance(strategy=InheritanceType.JOINED)
@AttributeOverride(name="id", column=@Column(name="menu_id", length=36, nullable=false, updatable=false))
@SQLRestriction(value="deleted_dttm IS NULL")
public class Menu
extends SpaceBaseModel {
    private String name;
    @JsonIgnore
    @ManyToMany(mappedBy="menus")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<Role> roles;
    @Column(name="is_global", nullable=false)
    private Boolean isGlobal = 3 >> 2;

    public Boolean getIsGlobal() {
        Menu a;
        return a.isGlobal;
    }

    public boolean equals(Object object) {
        Menu a = this;
        Object a2 = object;
        if (a == a2) {
            return 3 >> 1;
        }
        if (!(a2 instanceof Menu)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (2 & 5) != 0;
        }
        return Objects.equals(a.getName(), object2.getName());
    }

    public Menu() {
        Menu a;
        Menu menu = a;
        a.roles = new HashSet();
    }

    public Set<Role> getRoles() {
        Menu a;
        return a.roles;
    }

    public void setRoles(Set<Role> set) {
        Object a = set;
        Menu a2 = this;
        a2.roles = a;
    }

    public String getName() {
        Menu a;
        return a.name;
    }

    @JsonIgnore
    public boolean isSpaceScoped() {
        Menu a;
        if (!a.isGlobal() && a.getSpace() != null) {
            return (3 & 5) != 0;
        }
        return false;
    }

    @JsonIgnore
    public boolean isGlobal() {
        Menu a;
        return Boolean.TRUE.equals(a.isGlobal);
    }

    public void setIsGlobal(Boolean bl) {
        Object a = bl;
        Menu a2 = this;
        a2.isGlobal = a;
    }

    public void setName(String string) {
        Object a = string;
        Menu a2 = this;
        a2.name = a;
    }

    public int hashCode() {
        Menu a;
        Object[] objectArray = new Object[5 >> 1];
        objectArray[2 & 5] = super.hashCode();
        objectArray[--1] = a.getName();
        return Objects.hash(objectArray);
    }
}

