/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_SL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.manager.LeaderFencedManager;
import com.inscada.mono.cluster.services.c_c;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.r.c_TK;
import com.inscada.mono.communication.base.r.c_el;
import com.inscada.mono.communication.base.services.c_Fi;
import com.inscada.mono.communication.base.services.c_IH;
import com.inscada.mono.communication.base.services.c_Pi;
import com.inscada.mono.communication.base.services.x.c_Ue;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.r.c_db;
import com.inscada.mono.datatransfer.services.c_kC;
import com.inscada.mono.datatransfer.services.c_zC;
import com.inscada.mono.datatransfer.x.c_YA;
import com.inscada.mono.datatransfer.x.c_ad;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.r.c_VA;
import com.inscada.mono.log.x.c_wB;
import com.inscada.mono.mail.model.MailerWithSettings;
import com.inscada.mono.project.x.c_m;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
extends LeaderFencedManager
implements c_m {
    private final c_IH f_mG;
    public static final short f_MG = 404;
    public static final short f_rH = 402;
    private static final String f_Ji = "scheduledDataTransfers";
    public static final short f_JI = 405;
    private final Lock f_uh;
    private final c_SL f_sh;
    private static final Logger f_Hc = LoggerFactory.getLogger(DataTransferManager.class);
    public static final short f_sG = 407;
    private final c_Pi f_EI;
    private final Map<String, Job> f_pi;
    public static final short f_hH = 401;
    public static final short f_Kh = 403;
    private final c_Fi f_Cj;
    private final JedisPooled f_bI;
    private final c_zC f_gj;
    public static final short f_MH = 406;
    private final c_VA f_LH;
    private final c_wB f_Ej;

    @TransactionalEventListener(value={c_YA.class})
    public void handleRescheduleEvent(c_YA c_YA2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_vc.m_Aa()) {
            DataTransferManager a = a.m_Kq();
            f_Hc.info(c_Ue.m_nt((Object)"(p%q!g^\u0015,T\nQ\b\\\nRDg\u0001F\u0007]\u0001Q\u0011Y\u0001p\u0012P\nADS\u000bGDQ\u0005A\u0005\u0015\u0010G\u0005[\u0017S\u0001G^\u0015\u001fHD\u001d-q^\u0015\u001fHM"), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_db.f_WH) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_Hc.debug(MailerWithSettings.m_wK((Object)" \\ >\"V/W+AT3't\u0000|\u001cz\u0000tNA\u000b`\r{\u000bw\u001b\u007f\u000bV\u0018v\u0000gNu\u0001aNw\u000fg\u000f3\u001aa\u000f}\u001du\u000baT3\u0015n"), (Object)a.m_Kq().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_Cj.m_Dca(a.getProjectId(), (Map)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_db getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_gj.m_MN((String)a2, (String)a)) == null) {
            return c_db.f_KG;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_gj.m_VN((String)a, (String)a3).getId());
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_gj.m_xp((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_pi.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_Hc.info(c_Ue.m_nt((Object)"q\u0005A\u0005a\u0016T\nF\u0002P\u0016x\u0005[\u0005R\u0001GD\u001d*Z\u0010\u0015(P\u0005Q\u0001GDN\u0019\u001c^\u0015'T\nV\u0001Y\b\\\nRDY\u000bV\u0005YD_\u000bWDS\u000bGDQ\u0005A\u0005\u0015\u0010G\u0005[\u0017S\u0001GD| \u000fDN\u0019"), (Object)a3, (Object)a);
                dataTransferManager.f_LH.m_GO((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 ^ 3] = a3;
                objectArray[2 ^ 3] = a;
                objectArray[5 >> 1] = a22.getMessage();
                objectArray[--3] = a22;
                f_Hc.error(MailerWithSettings.m_wK((Object)"W\u000fg\u000fG\u001cr\u0000`\bv\u001c^\u000f}\u000ft\u000baN; |\u001a3\"v\u000fw\u000baNh\u0013:T3+a\u001c|\u001c3\rr\u0000p\u000b\u007f\u0002z\u0000tN\u007f\u0001p\u000f\u007fNy\u0001qNu\u0001aNw\u000fg\u000f3\u001aa\u000f}\u001du\u000baNZ*3\u0015nT3\u0015n"), objectArray);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_zC c_zC2, c_IH c_IH2, c_Fi c_Fi2, c_Pi c_Pi2, c_VA c_VA2, JedisPooled jedisPooled, c_wB c_wB2, c_c c_c2, c_SL c_SL2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_SL2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        super((c_c)a9);
        DataTransferManager dataTransferManager7 = a10;
        a10.f_uh = new ReentrantLock();
        dataTransferManager7.f_pi = new ConcurrentHashMap();
        dataTransferManager6.f_gj = a8;
        dataTransferManager6.f_mG = a7;
        dataTransferManager5.f_Cj = a6;
        dataTransferManager5.f_EI = a5;
        dataTransferManager4.f_LH = a4;
        dataTransferManager4.f_Ej = a3;
        dataTransferManager3.f_bI = a2;
        dataTransferManager3.f_sh = a;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_gj.m_VN((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_Ue.m_nt((Object)"y!t p6\u000fDf\u0007]\u0001Q\u0011Y\r[\u0003\u0015\u0000T\u0010TDA\u0016T\nF\u0002P\u0016\u0015\u001fHDY\u000bV\u0005Y\bLJ"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_Hc.debug(MailerWithSettings.m_wK((Object)"]!]C_+R*V<)NA\u000bb\u001bv\u001dg\u0007}\t3\u0002v\u000fw\u000baNg\u00013\u001dp\u0006v\nf\u0002vNw\u000fg\u000f3\u001aa\u000f}\u001du\u000baNh\u0013="), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[5 >> 3] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x69F5 & 0x179B)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return 3 >> 1;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_bI.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return --1 != 0;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_kC.f_ui[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0xF & 0x7B) != calendar.get(0x2F & 0x5B)) {
                    n2 = 5 >> 2;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(0x2F & 0x56) != calendar.get(0x77 & 0xE)) {
                    n2 = 5 >> 2;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(--2) != calendar.get(5 >> 1)) {
                    n2 = 3 >> 1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(3 >> 1) != calendar.get(3 >> 1) ? 3 >> 1 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[1 ^ 3];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_bI.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(c_Ue.m_nt((Object)"'@\u0016G\u0001[\u0010"))) {
            return false;
        }
        int a222 = switch (c_kC.f_ui[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x7E & 0x3D) * (0x63FF & 0x1FE8));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[5 >> 2] = a2.getName();
            objectArray[--2] = a2.getId();
            f_Hc.info(c_Ue.m_nt((Object)" T\u0010T0G\u0005[\u0017S\u0001G)T\nT\u0003P\u0016\u0015Ly\u0001T\u0000P\u0016\u0015\u001fHM\u000fDg\u0001F\u0010Z\u0016\\\nRDQ\u0005A\u0005\u0015\u0010G\u0005[\u0017S\u0001G^\u0015\u001fHD\u001d-q^\u0015\u001fHM"), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a2.getName();
            objectArray[4 ^ 5] = a2.getId();
            objectArray[--2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_Ej.m_ak(a2.getProject()).m_w("Data Transfer Restore (Leader " + (String)a + ")", MailerWithSettings.m_wK((Object)"K`N;'WT3K`G3\br\u0007\u007f\u000bwNg\u00013\u001cv\u001dg\u0001a\u000b=NP\u000ff\u001dvT3K`").formatted(objectArray));
            try {
                f_Hc.warn(c_Ue.m_nt((Object)" T\u0010T0G\u0005[\u0017S\u0001G)T\nT\u0003P\u0016\u0015Ly\u0001T\u0000P\u0016\u0015\u001fHM\u000fDt\u0010A\u0001X\u0014A\r[\u0003\u0015\u0010ZDV\u0005[\u0007P\b\u0015\u0000T\u0010TDA\u0016T\nF\u0002P\u0016\u0015\u001fHDT\u0002A\u0001GDG\u0001F\u0010Z\u0016T\u0010\\\u000b[DS\u0005\\\b@\u0016PJ"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 ^ 3] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_Hc.error(MailerWithSettings.m_wK((Object)"*r\u001ar:a\u000f}\u001du\u000ba#r\u0000r\tv\u001c3F_\u000br\nv\u001c3\u0015nG)NU\u000fz\u0002v\n3\u001a|Np\u000f}\rv\u00023\nr\u001arNg\u001cr\u0000`\bv\u001c3\u0015nNr\bg\u000baNa\u000b`\u001a|\u001cr\u001az\u0001}Nu\u000fz\u0002f\u001cvT3\u0015n"), objectArray2);
                return;
            }
        }
    }

    protected Map<String, c_db> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_Ue.m_nt((Object)"(p%q!g^\u0015'T\nV\u0001Y\b\\\nRDT\bYDQ\u0005A\u0005\u0015\u0010G\u0005[\u0017S\u0001G\u0017\u0015\u0002Z\u0016\u0015\u0014G\u000b_\u0001V\u0010\u0015\u001fHDY\u000bV\u0005Y\bLJ"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_Hc.debug(MailerWithSettings.m_wK((Object)" \\ >\"V/W+AT3<v\u001ff\u000b`\u001az\u0000tN\u007f\u000br\nv\u001c3\u001a|Np\u000f}\rv\u00023\u000f\u007f\u00023\nr\u001arNg\u001cr\u0000`\bv\u001c`Nu\u0001aNc\u001c|\u0004v\rgNh\u0013="), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x2BF7 & 0x559D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_mG.m_pba((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_Cj.m_Fca(object);
        a3 = dataTransferManager2.f_Cj.m_Fca((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_ad.class})
    public void handleCancelEvent(c_ad c_ad2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_vc.m_Aa()) {
            DataTransferManager a2 = a.m_XQ();
            f_Hc.info(c_Ue.m_nt((Object)"(p%q!g^\u0015,T\nQ\b\\\nRDv\u0005[\u0007P\bp\u0012P\nADS\u000bGDQ\u0005A\u0005\u0015\u0010G\u0005[\u0017S\u0001G^\u0015\u001fHD\u001d-q^\u0015\u001fHM"), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_Hc.debug(MailerWithSettings.m_wK((Object)" \\ >\"V/W+AT3't\u0000|\u001cz\u0000tNP\u000f}\rv\u0002V\u0018v\u0000gNu\u0001aNw\u000fg\u000f3\u001aa\u000f}\u001du\u000baT3\u0015n"), (Object)a.m_XQ().getId());
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_Ue.m_nt((Object)"y!t p6\u000fDv\u0005[\u0007P\bY\r[\u0003\u0015\u0000T\u0010TDA\u0016T\nF\u0002P\u0016\u0015\u001fHDY\u000bV\u0005Y\bLJ"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_Hc.debug(MailerWithSettings.m_wK((Object)"]!]C_+R*V<)NA\u000bb\u001bv\u001dg\u0007}\t3\u0002v\u000fw\u000baNg\u00013\rr\u0000p\u000b\u007fNw\u000fg\u000f3\u001aa\u000f}\u001du\u000baNh\u0013="), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x4DB2 & 0x33DF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_Ue.m_nt((Object)"(p%q!g^\u00157V\fP\u0000@\b\\\nRDT\bYDQ\u0005A\u0005\u0015\u0010G\u0005[\u0017S\u0001G\u0017\u0015\u0002Z\u0016\u0015\u0014G\u000b_\u0001V\u0010\u0015\u001fHDY\u000bV\u0005Y\bLJ"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_Hc.debug(MailerWithSettings.m_wK((Object)" \\ >\"V/W+AT3<v\u001ff\u000b`\u001az\u0000tN\u007f\u000br\nv\u001c3\u001a|N`\r{\u000bw\u001b\u007f\u000b3\u000f\u007f\u00023\nr\u001arNg\u001cr\u0000`\bv\u001c`Nu\u0001aNc\u001c|\u0004v\rgNh\u0013="), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x45DF & 0x3BB4)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_db> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(MailerWithSettings.m_wK((Object)"_+R*V<)NT\u000bg\u001az\u0000tNw\u000fg\u000f3\u001aa\u000f}\u001du\u000baN`\u001ar\u001af\u001dv\u001d3\b|\u001c3\u0015nNZ*`N\u007f\u0001p\u000f\u007f\u0002jT3\u0015n"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_Hc.debug(c_Ue.m_nt((Object)"*z*\u0018(p%q!g^\u00156P\u0015@\u0001F\u0010\\\nRDY\u0001T\u0000P\u0016\u0015\u0002Z\u0016\u0015\u0000T\u0010TDA\u0016T\nF\u0002P\u0016\u0015\u0017A\u0005A\u0011F\u0001FDS\u000bGDN\u0019\u0015-q\u0017\u000fDN\u0019"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[5 >> 3] = new ArrayList(a);
            return (Map)a2.f_vc.m_ja(Short.valueOf((short)(0x4BD6 & 0x35BF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(MailerWithSettings.m_wK((Object)"?"))), (Throwable)exception);
        }
    }

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_sh.m_gDa(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_vc.m_ca();
        f_Hc.info(c_Ue.m_nt((Object)" T\u0010T0G\u0005[\u0017S\u0001G)T\nT\u0003P\u0016\u000fDa\f\\\u0017\u0015\nZ\u0000PD\u001d\u001fHM\u0015\rFD{+\u0015(z*r!gDa,pDy!t p6\u001bDv\u0005[\u0007P\bY\r[\u0003\u0015\u0005Y\b\u0015\bZ\u0007T\b\u0015\u0000T\u0010TDA\u0016T\nF\u0002P\u0016\u0015\u000eZ\u0006FJ\u001bJ"), a);
        dataTransferManager2.f_uh.lock();
        try {
            new ArrayList(dataTransferManager.f_pi.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_pi.clear();
            f_Hc.info(MailerWithSettings.m_wK((Object)"*r\u001ar:a\u000f}\u001du\u000ba#r\u0000r\tv\u001c3F]\u0001gN_\u000br\nv\u001c3\u0015nG)NR\u0002\u007fN\u007f\u0001p\u000f\u007fNw\u000fg\u000f3\u001aa\u000f}\u001du\u000baNy\u0001q\u001d3\u0006r\u0018vNq\u000bv\u00003\u001cv\u001ff\u000b`\u001av\n3\u001a|Np\u000f}\rv\u00023\u000f}\n3\r\u007f\u000br\u001cv\n3\ba\u0001~N\u007f\u0001p\u000f\u007fNg\u001cr\rx\u0007}\t="), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Hc.error(c_Ue.m_nt((Object)"q\u0005A\u0005a\u0016T\nF\u0002P\u0016x\u0005[\u0005R\u0001GD\u001d*Z\u0010\u0015(P\u0005Q\u0001GDN\u0019\u001c^\u0015!G\u0016Z\u0016\u0015\u0000@\u0016\\\nRDE\u0016Z\u0007P\u0017FDZ\u0002\u0015\u0007T\nV\u0001Y\b\\\nRDY\u000bV\u0005YDQ\u0005A\u0005\u0015\u0010G\u0005[\u0017S\u0001GD_\u000bW\u0017\u000fDN\u0019"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_uh.unlock();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_el c_el2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_kC.f_KI[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    protected c_db getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_pi.containsKey(a)) {
            return c_db.f_WH;
        }
        return c_db.f_KG;
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = a.getSourceVariableId();
        objectArray[3 & 5] = a.getRangeType();
        objectArray[--2] = a.getCalcType();
        return c_Ue.m_nt((Object)"\u0000T\u0010TIA\u0016T\nF\u0002P\u0016\u000f\u0017A\u0005A\u0017\u000f\u0012T\u0016\\\u0005W\bP^\u0010\u0017\u000fAF^\u0010\u0017").formatted(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_TK c_TK2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0x2D & 0x5F, 5 >> 3);
        ((Calendar)object).set(0x5E & 0x2F, 3 >> 2);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_kC.f_ui[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x5F & 0x2C, 3 >> 2);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0x5B & 0x2F, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0xF & 0x7B, 0xFFFFFFFF & 0xFFFFFFFE);
                ((Calendar)object3).set(0x4D & 0x3E, 2 & 5);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0x7F & 0xB, 3 >> 2);
                ((Calendar)object4).set(0x1F & 0x6C, 3 & 4);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 3 >> 2);
                ((Calendar)object5).set(0x5F & 0x2C, 3 >> 2);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 3 ^ 3);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(5 >> 1, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(c_Ue.m_nt((Object)"1[\u0001M\u0014P\u0007A\u0001QDG\u0005[\u0003PDA\u001dE\u0001"));
    }

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.info(c_Ue.m_nt((Object)"y!t p6\u000fD}\u0005[\u0000Y\r[\u0003\u00154G\u000b_\u0001V\u0010q\u0001T\u0007A\rC\u0005A\u0001p\u0012P\nADS\u000bGDE\u0016Z\u000eP\u0007AD| \u000fDN\u0019"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_Hc.debug(MailerWithSettings.m_wK((Object)" \\ >\"V/W+AT3't\u0000|\u001cz\u0000tNC\u001c|\u0004v\rg*v\u000fp\u001az\u0018r\u001av+e\u000b}\u001a3\b|\u001c3\u001ea\u0001y\u000bp\u001a3'WT3\u0015n"), a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader(long l) {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        String a = dataTransferManager2.f_vc.m_ca();
        f_Hc.info(MailerWithSettings.m_wK((Object)"*r\u001ar:a\u000f}\u001du\u000ba#r\u0000r\tv\u001c)NG\u0006z\u001d3\u0000|\nvN;\u0015nG3\u0006r\u001d3\fv\r|\u0003vNg\u0006vN_+R*V<=NA\u000b`\u001a|\u001cz\u0000tN`\r{\u000bw\u001b\u007f\u000bwNw\u000fg\u000f3\u001aa\u000f}\u001du\u000ba\u001d=@="), (Object)a);
        dataTransferManager2.f_uh.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_bI.smembers(f_Ji));
            if (hashSet.isEmpty()) {
                f_Hc.info(c_Ue.m_nt((Object)" T\u0010T0G\u0005[\u0017S\u0001G)T\nT\u0003P\u0016\u0015Ly\u0001T\u0000P\u0016\u0015\u001fHM\u000fD{\u000b\u0015\u0017V\fP\u0000@\bP\u0000\u0015\u0000T\u0010TDA\u0016T\nF\u0002P\u0016FDS\u000b@\nQD\\\n\u00156P\u0000\\\u0017\u0015\u0010ZDG\u0001F\u0010Z\u0016PJ"), (Object)a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[3 >> 1] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_Hc.info(MailerWithSettings.m_wK((Object)"W\u000fg\u000fG\u001cr\u0000`\bv\u001c^\u000f}\u000ft\u000baN;\"v\u000fw\u000baNh\u0013:T3(|\u001b}\n3\u0015nN`\r{\u000bw\u001b\u007f\u000bwNw\u000fg\u000f3\u001aa\u000f}\u001du\u000baNZ*`Nz\u00003<v\nz\u001d3\u001a|Na\u000b`\u001a|\u001cvT3\u0015n"), objectArray);
            ArrayList a2 = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[3 >> 2] = c_Ue.m_nt((Object)"c-p3j t0t;a6t*f\"p6");
            dataTransferManager.f_sh.m_rDa(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_gj.m_Rq((Set)a2));
            }, stringArray);
            f_Hc.info(MailerWithSettings.m_wK((Object)"W\u000fg\u000fG\u001cr\u0000`\bv\u001c^\u000f}\u000ft\u000baN;\"v\u000fw\u000baNh\u0013:T3/g\u001av\u0003c\u001az\u0000tNg\u00013\u001cv\u001dg\u0001a\u000b3\u0015nNw\u000fg\u000f3\u001aa\u000f}\u001du\u000ba\u001d="), (Object)a, (Object)a2.size());
            a2.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_vc.m_ca();
                String[] stringArray = new String[--2];
                stringArray[3 & 4] = c_Ue.m_nt((Object)"f'}!q1y!j t0t;a6t*f\"p6");
                stringArray[--1] = MailerWithSettings.m_wK((Object)"-R P+_1W/G/L:A/]=U+A");
                dataTransferManager2.f_sh.m_qfa(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_Hc.info(c_Ue.m_nt((Object)"q\u0005A\u0005a\u0016T\nF\u0002P\u0016x\u0005[\u0005R\u0001GD\u001d(P\u0005Q\u0001GDN\u0019\u001c^\u0015\"\\\n\\\u0017]\u0001QDQ\u0005A\u0005\u0015\u0010G\u0005[\u0017S\u0001GDG\u0001F\u0010Z\u0016T\u0010\\\u000b[DE\u0016Z\u0007P\u0017FJ"), (Object)a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 & 5] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_Hc.error(MailerWithSettings.m_wK((Object)"W\u000fg\u000fG\u001cr\u0000`\bv\u001c^\u000f}\u000ft\u000baN;\"v\u000fw\u000baNh\u0013:T3+a\u001c|\u001c3\nf\u001cz\u0000tNw\u000fg\u000f3\u001aa\u000f}\u001du\u000baNa\u000b`\u001a|\u001cr\u001az\u0001}Nc\u001c|\rv\u001d`T3\u0015n"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_uh.unlock();
        }
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_uh.lock();
        try {
            Job job = (Job)a2.f_pi.get(a.getId());
            if (job != null) {
                a2.f_LH.m_GO(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_pi.remove(a.getId());
            String[] stringArray = new String[4 ^ 5];
            stringArray[3 & 4] = a.getId();
            dataTransferManager.f_bI.srem(f_Ji, stringArray);
            return;
        }
        finally {
            a2.f_uh.unlock();
        }
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = a.getSourceVariableId();
        objectArray[5 >> 2] = a.getRangeType();
        objectArray[5 >> 1] = a.getCalcType();
        return MailerWithSettings.m_wK((Object)"\nr\u001arCg\u001cr\u0000`\bv\u001c)\u0002r\u001dgCp\u000f\u007f\r>\u001az\u0003vTe\u000fa\u0007r\f\u007f\u000b)K`T6\u001d)K`").formatted(objectArray);
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_gj.m_Hq((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_bI.setex(a5, (long)n, String.valueOf(d));
            a4.f_bI.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(MailerWithSettings.m_wK((Object)"e\u000f\u007f\u001bv"), d);
                a6.put(a.getName(), a3);
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_db> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_Ue.m_nt((Object)"y!t p6\u000fDr\u0001A\u0010\\\nRDT\bYDQ\u0005A\u0005\u0015\u0010G\u0005[\u0017S\u0001GDF\u0010T\u0010@\u0017P\u0017\u0015\u0002Z\u0016\u0015\u0014G\u000b_\u0001V\u0010\u0015\u001fHDY\u000bV\u0005Y\bLJ"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_Hc.debug(MailerWithSettings.m_wK((Object)" \\ >\"V/W+AT3<v\u001ff\u000b`\u001az\u0000tN\u007f\u000br\nv\u001c3\b|\u001c3\u000f\u007f\u00023\nr\u001arNg\u001cr\u0000`\bv\u001c3\u001dg\u000fg\u001b`\u000b`Nu\u0001aNc\u001c|\u0004v\rgNh\u0013="), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_vc.m_ja(Short.valueOf((short)(0x7FB7 & 0x1DF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        a.registerRemoteCallsWithClusterNode();
        f_Hc.info(c_Ue.m_nt((Object)"q\u0005A\u0005a\u0016T\nF\u0002P\u0016x\u0005[\u0005R\u0001GD\\\n\\\u0010\\\u0005Y\rO\u0001QDT\nQDG\u0001R\rF\u0010P\u0016P\u0000\u0015\u0005FDv\b@\u0017A\u0001G*Z\u0000P(\\\u0017A\u0001[\u0001GJ"));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(MailerWithSettings.m_wK((Object)"e\u000f\u007f\u001bv"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_gj.m_Kn((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(c_Ue.m_nt((Object)"\u0012T\b@\u0001"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return --1 != 0;
        }
        return false;
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_sh.m_gDa(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_uh.lock();
        try {
            String string;
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 & 4] = a.getName();
            String string2 = string = MailerWithSettings.m_wK((Object)"K`NW\u000fg\u000f3:a\u000f}\u001du\u000ba").formatted(objectArray);
            string = a2.f_LH.m_oo(a.getProject(), string2, a2.fenced(string2, () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a)), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_pi.put(a.getId(), string);
            String[] stringArray = new String[3 >> 1];
            stringArray[2 & 5] = a.getId();
            dataTransferManager.f_bI.sadd(f_Ji, stringArray);
            return;
        }
        finally {
            a2.f_uh.unlock();
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[4 ^ 5];
            classArray[2 & 5] = String.class;
            dataTransferManager.f_vc.m_Ca((short)(0x1D9D & 0x63F3), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(MailerWithSettings.m_wK((Object)"\u001dp\u0006v\nf\u0002v*r\u001ar:a\u000f}\u001du\u000ba'}\u001av\u001c}\u000f\u007f"), classArray));
            Class[] classArray2 = new Class[5 >> 2];
            classArray2[3 & 4] = String.class;
            dataTransferManager.f_vc.m_Ca((short)(0x13FA & 0x6D97), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_Ue.m_nt((Object)"V\u0005[\u0007P\bq\u0005A\u0005a\u0016T\nF\u0002P\u0016|\nA\u0001G\nT\b"), classArray2));
            Class[] classArray3 = new Class[4 ^ 5];
            classArray3[2 & 5] = String.class;
            dataTransferManager.f_vc.m_Ca((short)(0x27F3 & 0x599F), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(MailerWithSettings.m_wK((Object)"t\u000bg*r\u001ar:a\u000f}\u001du\u000ba=g\u000fg\u001b`'}\u001av\u001c}\u000f\u007f"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[3 >> 2] = String.class;
            dataTransferManager.f_vc.m_Ca((short)(0x679E & 0x19F5), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_Ue.m_nt((Object)"F\u0007]\u0001Q\u0011Y\u0001q\u0005A\u0005a\u0016T\nF\u0002P\u0016F&L4G\u000b_\u0001V\u0010|\u0000|\nA\u0001G\nT\b"), classArray4));
            Class[] classArray5 = new Class[4 ^ 5];
            classArray5[5 >> 3] = String.class;
            dataTransferManager.f_vc.m_Ca((short)(0x3FDD & 0x41B7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(MailerWithSettings.m_wK((Object)"\rr\u0000p\u000b\u007f*r\u001ar:a\u000f}\u001du\u000ba\u001dQ\u0017C\u001c|\u0004v\rg'w'}\u001av\u001c}\u000f\u007f"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_vc.m_Ca((short)(0x65DF & 0x1BB6), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_Ue.m_nt((Object)"R\u0001A T\u0010T0G\u0005[\u0017S\u0001G7A\u0005A\u0011F\u0001F&L-Q\u0017|\nA\u0001G\nT\b"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_vc.m_Ca((short)(0x65BF & 0x1BD7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(MailerWithSettings.m_wK((Object)"\tv\u001aW\u000fg\u000fG\u001cr\u0000`\bv\u001c@\u001ar\u001af\u001dv\u001dQ\u0017C\u001c|\u0004v\rg'w'}\u001av\u001c}\u000f\u007f"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_Ue.m_nt((Object)"s\u0005\\\bP\u0000\u0015\u0010ZDG\u0001R\rF\u0010P\u0016\u0015 T\u0010T0G\u0005[\u0017S\u0001G)T\nT\u0003P\u0016\u00156e'\u0015\tP\u0010]\u000bQ\u0017"), a);
        }
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_gj.m_QQ((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_mG.m_pba((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_Cj.m_Fca((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    protected Map<String, c_db> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_gj.m_GR((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_TK c_TK2) {
        DataTransferManager a = c_TK2;
        DataTransferManager a2 = this;
        switch (c_kC.f_ui[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_db getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(MailerWithSettings.m_wK((Object)"\"V/W+AT3)v\u001ag\u0007}\t3\nr\u001arNg\u001cr\u0000`\bv\u001c3\u001dg\u000fg\u001b`Nu\u0001aNZ*)Nh\u00133\u0002|\rr\u0002\u007f\u0017="), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_Hc.debug(c_Ue.m_nt((Object)"{+{Iy!t p6\u000fDg\u0001D\u0011P\u0017A\r[\u0003\u0015\bP\u0005Q\u0001GDS\u000bGDQ\u0005A\u0005\u0015\u0010G\u0005[\u0017S\u0001GDF\u0010T\u0010@\u0017\u0015\u0002Z\u0016\u0015-q^\u0015\u001fHJ"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a;
            return (c_db)a2.f_vc.m_ja(Short.valueOf((short)(0x31B3 & 0x4FDF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_el[] c_elArray = (c_el[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_el[]::new);
        a4 = a7.f_EI.m_lca(stringArray, (Date)a5, (Date)((Object)a4), c_elArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_bI.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return 3 >> 2;
        }
        return true;
    }
}

