/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="data_transfer")
@AttributeOverride(name="id", column=@Column(name="data_transfer_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class DataTransfer
extends OwnedSpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @Size(max=255)
    private String dsc;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    @NotNull
    @Min(value=1000L)
    private Integer period;
    @JsonIgnore
    @OneToMany(mappedBy="dataTransfer")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<DataTransferDetail> dataTransferDetails;
    @NotBlank
    @Size(max=100)
    private String name;

    public int hashCode() {
        DataTransfer a;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = super.hashCode();
        objectArray[3 >> 1] = a.getProjectId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setProjectId(String string) {
        Object a = string;
        DataTransfer a2 = this;
        a2.projectId = a;
    }

    public Integer getPeriod() {
        DataTransfer a;
        return a.period;
    }

    public Set<DataTransferDetail> getDataTransferDetails() {
        DataTransfer a;
        return a.dataTransferDetails;
    }

    public void setPeriod(Integer n) {
        Object a = n;
        DataTransfer a2 = this;
        a2.period = a;
    }

    public Project getProject() {
        DataTransfer a;
        return a.project;
    }

    public void addDetail(DataTransferDetail dataTransferDetail) {
        DataTransfer a;
        DataTransfer a2 = dataTransferDetail;
        DataTransfer dataTransfer = a = this;
        a2.setDataTransfer(dataTransfer);
        dataTransfer.dataTransferDetails.add(a2);
    }

    public void setDataTransferDetails(Set<DataTransferDetail> set) {
        Object a = set;
        DataTransfer a2 = this;
        a2.dataTransferDetails = a;
    }

    public void setProject(Project project) {
        DataTransfer a;
        DataTransfer a2 = project;
        DataTransfer dataTransfer = a = this;
        dataTransfer.project = a2;
        dataTransfer.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public String getDsc() {
        DataTransfer a;
        return a.dsc;
    }

    public DataTransfer() {
        DataTransfer a;
        DataTransfer dataTransfer = a;
        dataTransfer.dataTransferDetails = new HashSet();
    }

    public void setDsc(String string) {
        Object a = string;
        DataTransfer a2 = this;
        a2.dsc = a;
    }

    public boolean equals(Object object) {
        DataTransfer a = this;
        Object a2 = object;
        if (a == a2) {
            return (4 ^ 5) != 0;
        }
        if (!(a2 instanceof DataTransfer)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 & 4) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return --1 != 0;
        }
        return false;
    }

    public String getProjectId() {
        DataTransfer a;
        return a.projectId;
    }

    public void setName(String string) {
        Object a = string;
        DataTransfer a2 = this;
        a2.name = a;
    }

    private static /* synthetic */ boolean lambda$removeDetail$0(String string, DataTransferDetail dataTransferDetail) {
        String a = dataTransferDetail;
        String a2 = string;
        return a.getId().equals(a2);
    }

    public String getName() {
        DataTransfer a;
        return a.name;
    }

    public void removeDetail(String string) {
        Object a = string;
        DataTransfer a2 = this;
        a2.dataTransferDetails.removeIf(arg_0 -> DataTransfer.lambda$removeDetail$0((String)a, arg_0));
    }
}

