/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.opcua.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.opcua.model.OpcUaDevice;
import com.inscada.mono.communication.protocols.opcua.r.c_gf;
import com.inscada.mono.communication.protocols.opcua.r.c_hf;
import com.inscada.mono.communication.protocols.opcua.r.c_pE;
import com.inscada.mono.shared.p.c_Yc;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="opc_ua_connection")
public class OpcUaConnection
extends Connection<OpcUaDevice> {
    @NotNull
    @Column(name="is_anonymous_authentication")
    private Boolean isAnonymousAuthentication;
    @Column(name="password")
    @Convert(converter=c_Yc.class)
    private String password;
    @NotNull
    @Column(name="is_username_password_authentication")
    private Boolean isUsernamePasswordAuthentication;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<OpcUaDevice> devices;
    @Column(name="is_https_enabled")
    private Boolean isHttpsEnabled;
    @Min(value=100L)
    @Column(name="timeout")
    private Integer timeoutInMs;
    @Column(name="server_name")
    private String serverName;
    @NotNull
    @Column(name="security_policy")
    private c_hf securityPolicy;
    @Min(value=0L)
    @Max(value=65535L)
    @Column(name="https_port")
    private Integer httpsPort;
    @NotNull
    @Column(name="security_mode")
    private c_gf securityMode;
    @Column(name="username")
    private String username;
    @Column(name="encoding_type")
    private c_pE encodingType;

    public Boolean getIsUsernamePasswordAuthentication() {
        OpcUaConnection a;
        return a.isUsernamePasswordAuthentication;
    }

    public void setTimeoutInMs(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.timeoutInMs = a;
    }

    public Integer getHttpsPort() {
        OpcUaConnection a;
        return a.httpsPort;
    }

    public String getPassword() {
        OpcUaConnection a;
        return a.password;
    }

    public void setEncodingType(c_pE c_pE2) {
        OpcUaConnection a = c_pE2;
        OpcUaConnection a2 = this;
        a2.encodingType = a;
    }

    public void setHttpsPort(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.httpsPort = a;
    }

    public Set<OpcUaDevice> getDevices() {
        OpcUaConnection a;
        return a.devices;
    }

    public OpcUaConnection() {
        OpcUaConnection a;
        OpcUaConnection opcUaConnection = a;
        opcUaConnection.devices = new HashSet();
    }

    public void setSecurityMode(c_gf c_gf2) {
        OpcUaConnection a = c_gf2;
        OpcUaConnection a2 = this;
        a2.securityMode = a;
    }

    public c_pE getEncodingType() {
        OpcUaConnection a;
        return a.encodingType;
    }

    public void setDevices(Set<OpcUaDevice> set) {
        Object a = set;
        OpcUaConnection a2 = this;
        a2.devices = a;
    }

    public c_gf getSecurityMode() {
        OpcUaConnection a;
        return a.securityMode;
    }

    public void setServerName(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.serverName = a;
    }

    public void setIsUsernamePasswordAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isUsernamePasswordAuthentication = a;
    }

    public Integer getTimeoutInMs() {
        OpcUaConnection a;
        return a.timeoutInMs;
    }

    public c_hf getSecurityPolicy() {
        OpcUaConnection a;
        return a.securityPolicy;
    }

    public void setIsAnonymousAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isAnonymousAuthentication = a;
    }

    public void setIsHttpsEnabled(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isHttpsEnabled = a;
    }

    public Boolean getIsAnonymousAuthentication() {
        OpcUaConnection a;
        return a.isAnonymousAuthentication;
    }

    public void setUsername(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.username = a;
    }

    public String getServerName() {
        OpcUaConnection a;
        return a.serverName;
    }

    public String getUsername() {
        OpcUaConnection a;
        return a.username;
    }

    public Boolean getIsHttpsEnabled() {
        OpcUaConnection a;
        return a.isHttpsEnabled;
    }

    public void setSecurityPolicy(c_hf c_hf2) {
        OpcUaConnection a = c_hf2;
        OpcUaConnection a2 = this;
        a2.securityPolicy = a;
    }

    public void setPassword(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.password = a;
    }
}

