/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.mqtt.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.mqtt.model.MqttDevice;
import com.inscada.mono.shared.p.c_Yc;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="mqtt_connection")
public class MqttConnection
extends Connection<MqttDevice> {
    @Column(name="clean_session")
    private Boolean cleanSession;
    @Column(name="use_ssl")
    private Boolean useSsl;
    @Size(max=50)
    private String username;
    @Positive
    @Column(name="pool_size")
    private Integer poolSize;
    @Positive
    @Column(name="initial_delay")
    private Integer initialDelayInMs;
    @PositiveOrZero
    @Column(name="max_delay")
    private Integer maxDelayInMs;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<MqttDevice> devices;
    @Size(max=50)
    @Convert(converter=c_Yc.class)
    private String password;
    @Size(max=23)
    private String identifier;
    @Max(value=65535000L)
    @PositiveOrZero
    @Column(name="keep_alive")
    private Integer keepAliveInMs;

    public Integer getKeepAliveInMs() {
        MqttConnection a;
        return a.keepAliveInMs;
    }

    public void setDevices(Set<MqttDevice> set) {
        Object a = set;
        MqttConnection a2 = this;
        a2.devices = a;
    }

    public String getUsername() {
        MqttConnection a;
        return a.username;
    }

    public Integer getPoolSize() {
        MqttConnection a;
        return a.poolSize;
    }

    public Integer getInitialDelayInMs() {
        MqttConnection a;
        return a.initialDelayInMs;
    }

    public String getIdentifier() {
        MqttConnection a;
        return a.identifier;
    }

    public void setMaxDelayInMs(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.maxDelayInMs = a;
    }

    public Boolean getUseSsl() {
        MqttConnection a;
        return a.useSsl;
    }

    public void setPassword(String string) {
        Object a = string;
        MqttConnection a2 = this;
        a2.password = a;
    }

    public void setUseSsl(Boolean bl) {
        Object a = bl;
        MqttConnection a2 = this;
        a2.useSsl = a;
    }

    public void setInitialDelayInMs(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.initialDelayInMs = a;
    }

    public String getPassword() {
        MqttConnection a;
        return a.password;
    }

    public MqttConnection() {
        MqttConnection a;
        MqttConnection mqttConnection = a;
        mqttConnection.devices = new HashSet();
    }

    public void setIdentifier(String string) {
        Object a = string;
        MqttConnection a2 = this;
        a2.identifier = a;
    }

    public void setUsername(String string) {
        Object a = string;
        MqttConnection a2 = this;
        a2.username = a;
    }

    public void setCleanSession(Boolean bl) {
        Object a = bl;
        MqttConnection a2 = this;
        a2.cleanSession = a;
    }

    public Boolean getCleanSession() {
        MqttConnection a;
        return a.cleanSession;
    }

    public Set<MqttDevice> getDevices() {
        MqttConnection a;
        return a.devices;
    }

    public void setKeepAliveInMs(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.keepAliveInMs = a;
    }

    public Integer getMaxDelayInMs() {
        MqttConnection a;
        return a.maxDelayInMs;
    }

    public void setPoolSize(Integer n) {
        Object a = n;
        MqttConnection a2 = this;
        a2.poolSize = a;
    }
}

