/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_SL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.manager.LeaderFencedManager;
import com.inscada.mono.cluster.services.c_c;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.r.c_lk;
import com.inscada.mono.communication.base.services.c_EG;
import com.inscada.mono.communication.base.services.c_PL;
import com.inscada.mono.communication.base.services.c_j;
import com.inscada.mono.communication.base.services.c_ze;
import com.inscada.mono.communication.base.x.c_VL;
import com.inscada.mono.communication.base.x.c_lL;
import com.inscada.mono.license.x.c_Oc;
import com.inscada.mono.log.x.c_wB;
import com.inscada.mono.mail.x.c_qd;
import com.inscada.mono.project.x.c_m;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
extends LeaderFencedManager
implements c_m {
    public static final short f_HS = 201;
    private final c_wB f_TS;
    public static final short f_sT = 208;
    public static final short f_zS = 202;
    private final c_SL f_DS;
    public static final short f_wT = 210;
    public static final short f_Et = 207;
    private static final Logger f_Hc = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short f_st = 204;
    public static final short f_CU = 203;
    private static final String f_SR = "activeConnections";
    private final c_PL f_mT;
    public static final short f_BS = 205;
    private final JedisPooled f_yu;
    private final Lock f_lt;
    private final c_Oc f_Ju;
    public static final short f_Gs = 209;
    public static final short f_Qu = 206;
    private final c_EG<C, V> f_Nt;

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_DS.m_gDa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_lt.lock();
            try {
                c_ze c_ze2 = a2.f_Nt.m_UAa(a.getId());
                if (c_ze2 != null) {
                    c_ze2.m_HV();
                    a2.f_Nt.m_aca(a.getId(), c_ze2);
                }
                String[] stringArray = new String[3 >> 1];
                stringArray[3 ^ 3] = a.getId();
                a2.f_yu.srem(f_SR, stringArray);
                return;
            }
            finally {
                a2.f_lt.unlock();
            }
        }, a);
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[2 ^ 3];
            classArray[3 >> 2] = String.class;
            connectionManager.f_vc.m_Ca((short)(0x6DCF & 0x12F9), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ExceptionDetails.m_kD((Object)"d(v.c\u001fx2y9t(~3y\u0015y(r.y={"), classArray));
            Class[] classArray2 = new Class[2 ^ 3];
            classArray2[3 ^ 3] = String.class;
            connectionManager.f_vc.m_Ca((short)(0x4ADE & 0x35EB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_qd.m_DK((Object)";j'n\u000bq&p-}<w'p\u0001p<{:p)r"), classArray2));
            Class[] classArray3 = new Class[--1];
            classArray3[5 >> 3] = String.class;
            connectionManager.f_vc.m_Ca((short)(0x18EF & 0x67DB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ExceptionDetails.m_kD((Object)"p9c\u001fx2y9t(~3y\u000fc=c)d\u0015y(r.y={"), classArray3));
            Class[] classArray4 = new Class[3 & 5];
            classArray4[3 ^ 3] = SetValueRequest.class;
            connectionManager.f_vc.m_Ca((short)(0x28CD & 0x57FE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_qd.m_DK((Object)";{<H)l!\u007f*r-H)r={\u0001p<{:p)r"), classArray4));
            Class[] classArray5 = new Class[2 ^ 3];
            classArray5[3 ^ 3] = Collection.class;
            connectionManager.f_vc.m_Ca((short)(0x36DF & 0x49ED), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ExceptionDetails.m_kD((Object)"d9c\nv.~=u0r\nv0b9d\u0015y(r.y={"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_vc.m_Ca((short)(0x28DE & 0x57EF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_qd.m_DK((Object)"m<\u007f:j\u000bq&p-}<w'p;\\1N:q\"{+j\u0001z\u0001p<{:p)r"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_vc.m_Ca((short)(0x53CF & 0x2CFF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ExceptionDetails.m_kD((Object)"/c3g\u001fx2y9t(~3y/U%G.x6r?c\u0015s\u0015y(r.y={"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_vc.m_Ca((short)(0xCF1 & 0x73DE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_qd.m_DK((Object)"/{<]'p&{+j!q&M<\u007f<k;{;\\1N:q\"{+j\u0001z\u0001p<{:p)r"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_vc.m_Ca((short)(0x31D5 & 0x4EFB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ExceptionDetails.m_kD((Object)";r(T3y2r?c5x2D(v(b/r/U%^8d\u0015y(r.y={"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_vc.m_Ca((short)(0x2AF6 & 0x55DB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_qd.m_DK((Object)"*l'i;{\u000bq&p-}<w'p\u0001p<{:p)r"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(ExceptionDetails.m_kD((Object)"\u001av5{9s|c37.r;~/c9e|T3y2r?c5x2Z=y=p9e|E\fT|z9c4x8d"), a);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_mT.m_iAa((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[--1] = a2.getName();
            objectArray[--2] = a2.getId();
            f_Hc.info(c_qd.m_DK((Object)"\u000bq&p-}<w'p\u0005\u007f&\u007f/{:>`R-\u007f,{:>3ca$hL-m<q:w&yh}'p&{+j!q&$he5>`W\f$he57"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[3 >> 1] = a2.getId();
            objectArray[--2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_TS.m_ak(a2.getProject()).m_w("Connection Restore (Leader " + (String)a + ")", ExceptionDetails.m_kD((Object)"yd|?\u0015Sf7ydu7:v5{9s|c37.r/c3e99|T=b/rf7yd").formatted(objectArray));
            try {
                f_Hc.warn(c_qd.m_DK((Object)"\u000bq&p-}<w'p\u0005\u007f&\u007f/{:>`R-\u007f,{:>3ca$h_<j-s8j!p/><qhm<q8>+q&p-}<w'phe5>)x<{:>:{;j'l)j!q&>.\u007f!r=l-0"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 & 4] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_Hc.error(ExceptionDetails.m_kD((Object)"T3y2r?c5x2Z=y=p9e|?\u0010r=s9e|l!>f7\u001av5{9s|c37/c3g|t3y2r?c5x27'j|v:c9e|e9d(x.v(~3y|q=~0b.rf7'j"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_qd.m_DK((Object)"R\r_\f[\u001a$hM<\u007f:j!p/>+q&p-}<w'phe5>$q+\u007f$r10"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_Hc.debug(ExceptionDetails.m_kD((Object)"Y\u0013Yq[\u0019V\u0018R\u000e-|E9f)r/c5y;70r=s9e|c37/c=e(7?x2y9t(~3y|l!9"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[2 & 5] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x2DF9 & 0x52CF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_Nt.m_UAa((String)a)) != null) {
                void a3;
                a.m_uv((List)a3);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_vc.m_ca();
        String[] stringArray = new String[--4];
        stringArray[3 >> 2] = ExceptionDetails.m_kD((Object)"\u000fC\u001dE\bH\u001fX\u0012Y\u0019T\b^\u0013Y");
        stringArray[2 ^ 3] = c_qd.m_DK((Object)"M\u001cQ\u0018A\u000bQ\u0006P\r]\u001cW\u0007P");
        stringArray[--2] = ExceptionDetails.m_kD((Object)"\n^\u0019@\u0003T\u0013Y\u0012R\u001fC\u0015X\u0012H\u0015C\u0019Z");
        stringArray[--3] = c_qd.m_DK((Object)"H\u0001[\u001fA\u001e_\u001aW\t\\\u0004[");
        connectionManager2.f_DS.m_qfa(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    protected Map<String, c_lk> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_ze c_ze2 = a2.f_Nt.m_UAa(a.getConnectionId());
        if (c_ze2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_ze2.m_cv(a);
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_qd.m_DK((Object)"\u0004[\tZ\rLr>\u001bj)l<w&yh\u007f$rh}'p&{+j!q&mhx'lhn:q\"{+jhe5>$q+\u007f$r10"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_Hc.debug(ExceptionDetails.m_kD((Object)"\u0012X\u0012:\u0010R\u001dS\u0019Ef7\u000er-b9d(~2p|{9v8r.7(x|d(v.c|v0{|t3y2r?c5x2d|q3e|g.x6r?c|l!9"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x61EF & 0x1EDE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader(long l) {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        String a = connectionManager2.f_vc.m_ca();
        f_Hc.info(c_qd.m_DK((Object)"\u000bq&p-}<w'p\u0005\u007f&\u007f/{:$hJ w;>&q,{h63ca> \u007f;>*{+q%{hj {hR\r_\f[\u001a0hL-m<q:w&yh\u007f+j!h->+q&p-}<w'p;0f0"), (Object)a);
        connectionManager2.f_lt.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_yu.smembers(f_SR));
            if (hashSet.isEmpty()) {
                f_Hc.info(ExceptionDetails.m_kD((Object)"T3y2r?c5x2Z=y=p9e|?\u0010r=s9e|l!>f7\u0012x|v?c5a97?x2y9t(~3y/7:x)y875y|E9s5d|c37.r/c3e99"), (Object)a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[--1] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_Hc.info(c_qd.m_DK((Object)"]'p&{+j!q&S)p)y-lh6\u0004{)z-lhe57r>\u000eq=p,>3ch\u007f+j!h->+q&p-}<w'phW\fmhw&>\u001a{,w;><qhl-m<q:{r>3c"), objectArray);
            Object a2 = new ArrayList();
            String[] stringArray = new String[2 ^ 3];
            stringArray[5 >> 3] = ExceptionDetails.m_kD((Object)"\n^\u0019@\u0003T\u0013Y\u0012R\u001fC\u0015X\u0012H\u0015C\u0019Z");
            connectionManager.f_DS.m_rDa(() -> connectionManager.lambda$leader$0((Collection)a2, hashSet), stringArray);
            f_Hc.info(c_qd.m_DK((Object)"\u000bq&p-}<w'p\u0005\u007f&\u007f/{:>`R-\u007f,{:>3ca$h_<j-s8j!p/><qhl-m<q:{he5>+q&p-}<w'p;0"), (Object)a, (Object)a2.size());
            Object object = a2 = a2.iterator();
            while (object.hasNext()) {
                Connection connection = (Connection)a2.next();
                object = a2;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_Hc.info(ExceptionDetails.m_kD((Object)"T3y2r?c5x2Z=y=p9e|?\u0010r=s9e|l!>f7\u001a~2~/\u007f9s|t3y2r?c5x27.r/c3e=c5x27,e3t9d/9"), (Object)a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[--2] = exception;
            f_Hc.error(c_qd.m_DK((Object)"\u000bq&p-}<w'p\u0005\u007f&\u007f/{:>`R-\u007f,{:>3ca$h[:l'lhz=l!p/>+q&p-}<w'phl-m<q:\u007f<w'phn:q+{;mr>3c"), objectArray);
            return;
        }
        finally {
            connectionManager.f_lt.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_mT.m_zaa((String)a, (String)a3).getId());
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Nt.m_UAa((String)a)) instanceof c_j) {
            return ((c_j)a).m_Fa();
        }
        throw new BrowseOperationException(ExceptionDetails.m_kD((Object)"\u001ee3`/r|x,r.v(~3y|y3c|d)g,x.c9s"));
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.info(ExceptionDetails.m_kD((Object)"\u0010R\u001dS\u0019Ef7\u0014v2s0~2p|G.x6r?c\u0018r=t(~*v(r\u0019a9y(7:x.7,e3}9t(7\u0015Sf7'j"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_Hc.debug(c_qd.m_DK((Object)"\u0006Q\u00063\u0004[\tZ\rLr>\u0001y&q:w&yhN:q\"{+j\f{)}<w>\u007f<{\rh-p<>.q:>8l't-}<>\u0001Zr>3c"), a);
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_lL.class})
    public void handleDeleteEvent(c_lL c_lL2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_vc.m_Aa()) {
            ConnectionManager a2 = a.m_Gfa();
            f_Hc.info(ExceptionDetails.m_kD((Object)"\u0010R\u001dS\u0019Ef7\u0014v2s0~2p|S9{9c9R*r2c|q3e|t3y2r?c5x2-|l!7t^\u0018-|l!>"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_Hc.debug(c_qd.m_DK((Object)"P\u0007PeR\r_\f[\u001a$hW/p'l!p/>\f{${<{\rh-p<>.q:>+q&p-}<w'pr>3c"), (Object)a.m_Gfa().getId());
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_mT.m_mCa((String)a2));
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_mT.m_FAa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_mT.m_mCa((String)a);
        return connectionManager2.f_DS.m_Sea(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_qd.m_DK((Object)"\u0004[\tZ\rLr>\u0018{:x'l%w&yh|:q?m->'n-l)j!q&>.q:>+q&p-}<w'phe5>$q+\u007f$r10"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_Hc.debug(ExceptionDetails.m_kD((Object)"\u0012X\u0012:\u0010R\u001dS\u0019Ef7\u000er-b9d(~2p|{9v8r.7(x|g9e:x.z|u.x+d973g9e=c5x27:x.7?x2y9t(~3y|l!9"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[2 & 5] = a;
            return a2.f_vc.m_ja(Short.valueOf((short)(0x18F6 & 0x67DB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_mT.m_DAa(a.getId());
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_vc.m_ca();
        f_Hc.info(ExceptionDetails.m_kD((Object)"T3y2r?c5x2Z=y=p9ef7\b\u007f5d|y3s97tl!>|~/7\u0012X|[\u0013Y\u001bR\u000e7\b_\u00197\u0010R\u001dS\u0019Er7\u000fc3g,~2p|v0{|{3t={|t3y2r?c3e/9r9"), a);
        connectionManager2.f_lt.lock();
        try {
            connectionManager.f_Nt.m_Fba();
            f_Hc.info(c_qd.m_DK((Object)"\u000bq&p-}<w'p\u0005\u007f&\u007f/{:>`P'jhR-\u007f,{:>3ca$h_$rhr'})rh}'p&{+j'l;> \u007f>{h|-{&>:{9k-m<{,><qhm<q8>)p,>+r-\u007f:{,>.l'shr'})rhj:\u007f+u!p/0"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_Hc.error(ExceptionDetails.m_kD((Object)"\u001fx2y9t(~3y\u0011v2v;r.7tY3c|[9v8r.7'ju-|R.e3e|s)e5y;7,e3t9d/73q|d(x,g5y;70x?v07?x2y9t(x.df7'j"), objectArray);
            return;
        }
        finally {
            connectionManager.f_lt.unlock();
        }
    }

    private /* synthetic */ void lambda$startConnectionInternal$3(Connection connection) {
        ConnectionManager a;
        ConnectionManager a2 = connection;
        ConnectionManager connectionManager = a = this;
        long l = connectionManager.f_vc.m_Ia();
        String string = connectionManager.f_vc.m_ca();
        connectionManager.stopConnectionInternal((Connection)a2);
        if (!Boolean.TRUE.equals(a2.getProject().getIsActive())) {
            throw new NotActiveException("Project should be active to start connection " + a2.getName());
        }
        ConnectionManager connectionManager2 = a;
        connectionManager2.f_Ju.m_LK();
        c_ze c_ze2 = connectionManager2.f_Nt.m_eBa((Connection)a2);
        c_ze2.m_Tv();
        long l2 = connectionManager2.f_vc.m_Ia();
        if (!connectionManager2.f_vc.m_Aa() || l2 == -1L || l2 != l) {
            try {
                c_ze2.m_HV();
                a.f_Nt.m_aca(a2.getId(), c_ze2);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[--4];
                objectArray[3 & 4] = string;
                objectArray[4 ^ 5] = a2.getId();
                objectArray[--2] = exception.getMessage();
                objectArray[--3] = exception;
                f_Hc.warn(ExceptionDetails.m_kD((Object)"\u001fx2y9t(~3y\u0011v2v;r.7tl!>f7\u001ar2t9s|d(x,7:v5{9s|q3e|t3y2r?c5x27'j|v:c9e|c9e17?\u007f=y;rf7'j"), objectArray);
            }
            Object[] objectArray = new Object[--4];
            objectArray[3 >> 2] = a2.getId();
            objectArray[--1] = string;
            objectArray[5 >> 1] = l;
            objectArray[--3] = l2;
            f_Hc.info(c_qd.m_DK((Object)"\u001bu!n8w&yh\u007f+j!h)j!q&>'xh}'p&{+j!q&>3chq&>&q,{he5$hr-\u007f,{:m w8>$q;jhq:><{:sh} \u007f&y-zh6;} {,k${,#3cd>+k:l-p<#3ca0"), objectArray);
            return;
        }
        String[] stringArray = new String[--1];
        stringArray[3 >> 2] = a2.getId();
        a.f_yu.sadd(f_SR, stringArray);
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, c_qd.m_DK((Object)"\u001b{<H)r={\u001a{9k-m<>+\u007f&p'jh|->&k$r"));
        Objects.requireNonNull(a.getConnectionId(), ExceptionDetails.m_kD((Object)"\u001fx2y9t(~3y\u0015s|~27\u000fr(A={)r\u000er-b9d(7?v2y3c|u972b0{"));
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_qd.m_DK((Object)"\u0004[\tZ\rLr>\u001b{<j!p/>>\u007f:w)|${hh)r={hx'lh}'p&{+j!q&>3chr'})r$gr>3c"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_Hc.debug(ExceptionDetails.m_kD((Object)"Y\u0013Yq[\u0019V\u0018R\u000e-|E9f)r/c5y;70r=s9e|c37/r(7*v.~=u0r|a={)r|q3e|t3y2r?c5x27'jf7'j"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x4DED & 0x32DE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    protected Map<String, c_lk> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_mT.m_RBa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    protected c_lk getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Nt.m_UAa((String)a)) != null && a.m_Mv()) {
            return c_lk.f_gu;
        }
        return c_lk.f_ES;
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_mT.m_FAa((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_PL c_PL2, c_Oc c_Oc2, c_wB c_wB2, c_EG<C, V> c_EG2, JedisPooled jedisPooled, c_c c_c2, c_SL c_SL2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_SL2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        super((c_c)a7);
        ConnectionManager connectionManager6 = a8;
        connectionManager6.f_lt = new ReentrantLock();
        connectionManager5.f_mT = a6;
        connectionManager5.f_Ju = a5;
        connectionManager4.f_TS = a4;
        connectionManager4.f_Nt = a3;
        connectionManager3.f_yu = a2;
        connectionManager3.f_DS = a;
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, c_qd.m_DK((Object)"\u001b{<H)r={\u001a{9k-m<>+\u007f&p'jh|->&k$r")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), ExceptionDetails.m_kD((Object)"\u001fx2y9t(~3y\u0015s|~27\u000fr(A={)r\u000er-b9d(7?v2y3c|u972b0{")));
        if (a3.f_vc.m_Aa()) {
            f_Hc.debug(c_qd.m_DK((Object)"R\r_\f[\u001a$hM-j<w&yhe5>>\u007f:w)|${hh)r={;>$q+\u007f$r10"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_Hc.debug(ExceptionDetails.m_kD((Object)"\u0012X\u0012:\u0010R\u001dS\u0019Ef7\u000er-b9d(~2p|{9v8r.7(x|d9c|l!7*v.~=u0r|a={)r/9"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = new ArrayList(a22);
            a3.f_vc.m_ja(Short.valueOf((short)(0xDFF & 0x72CD)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(c_qd.m_DK((Object)"X)w${,><qhL\u0018]hm-jhh)l!\u007f*r->>\u007f$k-m"), (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_qd.m_DK((Object)"\u0004[\tZ\rLr>\u001bj'n8w&yh\u007f$rh}'p&{+j!q&mhx'lhn:q\"{+jhe5>$q+\u007f$r10"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_Hc.debug(ExceptionDetails.m_kD((Object)"Y\u0013Yq[\u0019V\u0018R\u000e-|E9f)r/c5y;70r=s9e|c37/c3g|v0{|t3y2r?c5x2d|q3e|g.x6r?c|l!9"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[2 & 5] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x65CF & 0x1AFF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_lk> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_qd.m_DK((Object)"R\r_\f[\u001a$hY-j<w&yh}'p&{+j!q&>;j)j=m-mhx'lhe5>\u0001Z;>$q+\u007f$r10"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_Hc.debug(ExceptionDetails.m_kD((Object)"Y\u0013Yq[\u0019V\u0018R\u000e-|E9f)r/c5y;70r=s9e|q3e|t3y2r?c5x27/c=c)d9d|q3e|l!7\u0015S/9"), (Object)a.length);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_vc.m_ja(Short.valueOf((short)(0x2EF1 & 0x51DF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_DS.m_gDa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_lt.lock();
            try {
                Runnable runnable = () -> a2.lambda$startConnectionInternal$3((Connection)a);
                a2.fenced("Start connection " + a.getId(), runnable).run();
                return;
            }
            finally {
                a2.f_lt.unlock();
            }
        }, a);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        a.registerRemoteCallsWithClusterNode();
        f_Hc.info(c_qd.m_DK((Object)"\u000bq&p-}<w'p\u0005\u007f&\u007f/{:>!p!j!\u007f$w2{,>)p,>:{/w;j-l-zh\u007f;>\u000br=m<{:P'z-R!m<{&{:0"));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_lk getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_qd.m_DK((Object)"R\r_\f[\u001a$hY-j<w&yh}'p&{+j!q&>;j)j=mhx'lhe5>$q+\u007f$r10"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_Hc.debug(ExceptionDetails.m_kD((Object)"Y\u0013Yq[\u0019V\u0018R\u000e-|E9f)r/c5y;70r=s9e|q3e|t3y2r?c5x27/c=c)d|q3e|l!9"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            return (c_lk)a2.f_vc.m_ja(Short.valueOf((short)(0x55CF & 0x2AFB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_VL.class})
    public void handleRestartEvent(c_VL c_VL2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_vc.m_Aa()) {
            ConnectionManager a2 = a.m_sda();
            f_Hc.info(ExceptionDetails.m_kD((Object)"[\u0019V\u0018R\u000e-|_=y8{5y;7\u000er/c=e(R*r2c|q3e|t3y2r?c5x2-|l!7t^\u0018-|l!>"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_lt.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_lk.f_gu) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_lt.unlock();
            }
        }
        f_Hc.debug(c_qd.m_DK((Object)"\u0006Q\u00063\u0004[\tZ\rLr>\u0001y&q:w&yhL-m<\u007f:j\rh-p<>.q:>+q&p-}<w'pr>3c"), (Object)a.m_sda().getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_mT.m_zaa((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_qd.m_DK((Object)"R\r_\f[\u001a$hM<q8n!p/>+q&p-}<w'phe5>$q+\u007f$r10"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_Hc.debug(ExceptionDetails.m_kD((Object)"\u0012X\u0012:\u0010R\u001dS\u0019Ef7\u000er-b9d(~2p|{9v8r.7(x|d(x,7?x2y9t(~3y|l!9"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x71EE & 0xEDB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_lk getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_mT.m_vBa((String)a2, (String)a)) == null) {
            return c_lk.f_ES;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$leader$0(Collection collection, Set set) {
        void a;
        Object a2 = set;
        ConnectionManager a3 = this;
        a.addAll(a3.f_mT.m_nBa((Set)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_lk> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(c_qd.m_DK((Object)"R\r_\f[\u001a$hY-j<w&yh\u007f$rh}'p&{+j!q&>;j)j=m-mhx'lhn:q\"{+jhe5>$q+\u007f$r10"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_Hc.debug(ExceptionDetails.m_kD((Object)"Y\u0013Yq[\u0019V\u0018R\u000e-|E9f)r/c5y;70r=s9e|q3e|v0{|t3y2r?c5x27/c=c)d9d|q3e|g.x6r?c|l!9"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            return (Map)a2.f_vc.m_ja(Short.valueOf((short)(0x7AD3 & 0x5FC)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }
}

