/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.cluster.sync;

import com.inscada.mono.cluster.model.ClusterNodeInfo;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_c;
import com.inscada.mono.space.x.c_va;
import com.inscada.mono.system.model.SystemRequest;
import jakarta.annotation.PostConstruct;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;

@Service
@ConditionalOnProperty(name={"ins.cluster.enabled"}, havingValue="true")
public class RedisReplicationManager
implements ClusterNodeListener {
    private final c_c f_cS;
    private final Integer f_Yt;
    private final String f_nR;
    private final JedisPooled f_ls;
    private static final Logger f_DU = LoggerFactory.getLogger(RedisReplicationManager.class);

    @PostConstruct
    public void registerListener() {
        RedisReplicationManager a;
        a.f_cS.m_Ga((ClusterNodeListener)a);
        f_DU.info(c_va.m_jD((Object)"\bK>G)|?^6G9O.G5@\u0017O4O=K(\u000e(K=G)Z?\\?JzG.]?B<\u000e;]zOzm6[)Z?\\\u0014A>K\u0016G)Z?@?\\t"));
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public RedisReplicationManager(JedisPooled jedisPooled, c_c c_c2, @Value(value="${spring.data.redis.host:localhost}") String string, @Value(value="${spring.data.redis.port:6379}") Integer n) {
        void selfRedisHost;
        void clusterOperations;
        void jedis;
        RedisReplicationManager a;
        RedisReplicationManager redisReplicationManager = object;
        Object object = n;
        RedisReplicationManager redisReplicationManager2 = a = redisReplicationManager;
        RedisReplicationManager redisReplicationManager3 = a;
        redisReplicationManager3.f_ls = jedis;
        redisReplicationManager3.f_cS = clusterOperations;
        redisReplicationManager2.f_nR = selfRedisHost;
        redisReplicationManager2.f_Yt = object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notLeader() {
        RedisReplicationManager redisReplicationManager = this;
        f_DU.info(SystemRequest.m_RF((Object)"g\u0011Z\n\u0013\u0017\\\u001dVYZ\n\u0013\u0018\u0013?|5\u007f6d<aW\u00138G\rV\u0014C\rZ\u0017TYG\u0016\u0013\u001fZ\u0017WY_\u001cR\u001dV\u000b\u0013\u0018]\u001d\u0013\nG\u0018A\r\u0013+V\u001dZ\n\u0013\u000bV\t_\u0010P\u0018G\u0010\\\u0017\u001d"));
        try {
            Optional<ClusterNodeInfo> optional = redisReplicationManager.f_cS.m_Ea().stream().filter(ClusterNodeInfo::getIsLeader).findFirst();
            if (optional.isPresent()) {
                ClusterNodeInfo clusterNodeInfo = optional.get();
                String a2 = clusterNodeInfo.getRedisHost();
                Integer n = clusterNodeInfo.getRedisPort();
                if (a2 != null && n != null) {
                    if (Objects.equals(redisReplicationManager.f_nR, a2) && Objects.equals(redisReplicationManager.f_Yt, n)) {
                        f_DU.warn(c_va.m_jD((Object)"\u001eG)M5X?\\?JzB?O>K(\t)\u000e\bK>G)\u000e3@)Z;@9KzG)\u000e.F3]z@5J?\t)\u000e5Y4\u000e3@)Z;@9Kt\u000e\tE3^*G4Iz\\?^6G9O.G5@zM5C7O4JzZ5\u000e*\\?X?@.\u000e9G(M/B;\\z\\?^6G9O.G5@t"));
                        return;
                    }
                    Object[] objectArray = new Object[--3];
                    objectArray[2 & 5] = clusterNodeInfo.getNodeId();
                    objectArray[5 >> 2] = a2;
                    objectArray[5 >> 1] = n;
                    f_DU.info(SystemRequest.m_RF((Object)"?\\\f]\u001d\u0013\u0015V\u0018W\u001cAY\u0014\u0002N^\u0013\u000eZ\r[Ya\u001cW\u0010@YR\r\u0013\u0002NCH\u0004\u001dY`\rR\u000bG\u0010]\u001e\u0013\u000bV\t_\u0010P\u0018G\u0010\\\u0017\u001d"), objectArray);
                    String[] stringArray = new String[--2];
                    stringArray[3 >> 2] = a2;
                    stringArray[--1] = String.valueOf(n);
                    Object a2 = redisReplicationManager.f_ls.sendCommand((ProtocolCommand)Protocol.Command.REPLICAOF, stringArray);
                    f_DU.info(c_va.m_jD((Object)"}?Zz|?J3]zZ5\u000e(K*B3M;Z?\u000e<\\5CzB?O>K(\u0000z|?]/B.\u0014zU'"), a2);
                    return;
                }
                f_DU.error(SystemRequest.m_RF((Object)"\u007f\u001cR\u001dV\u000b\u0013\u0017\\\u001dVY\u0014\u0002N^\u0013\u001d\\\u001c@Y]\u0016GY[\u0018E\u001c\u0013+V\u001dZ\n\u0013\u0011\\\nGVC\u0016A\r\u0013\u0010]\u001f\\\u000b^\u0018G\u0010\\\u0017\u0013\u0018E\u0018Z\u0015R\u001b_\u001c\u001dYp\u0018]\u0017\\\r\u0013\nG\u0018A\r\u0013\u000bV\t_\u0010P\u0018G\u0010\\\u0017\u001d"), (Object)clusterNodeInfo.getNodeId());
                return;
            }
            f_DU.warn(c_va.m_jD((Object)"\u0019A/B>\u000e4A.\u000e<G4JzOzB?O>K(\u000e4A>KzG4\u000e.F?\u000e9B/].K(\u000e,G?YzZ5\u000e(K*B3M;Z?\u000e\bK>G)\u000e<\\5Ct\u000e\rG6Bz\\?Z(WzA4\u000e4K\"ZzM6[)Z?\\zX3K-\u000e9F;@=Kt"));
            return;
        }
        catch (Exception exception) {
            f_DU.error(SystemRequest.m_RF((Object)"u\u0018Z\u0015V\u001d\u0013\r\\Y@\u001cGYa\u001cW\u0010@YG\u0016\u0013\u000bV\t_\u0010P\u0018\u0013\u0014\\\u001dVY\\\u0017\u0013\u001f\\\u0015_\u0016D\u001cAY]\u0016W\u001c\u001d"), (Throwable)exception);
            return;
        }
    }

    public void leader(long a3) {
        try {
            RedisReplicationManager a2;
            String[] stringArray = new String[1 ^ 3];
            stringArray[2 & 5] = SystemRequest.m_RF((Object)"7|");
            stringArray[3 & 5] = c_va.m_jD((Object)"\u0015`\u001f");
            Object a3 = a2.f_ls.sendCommand((ProtocolCommand)Protocol.Command.REPLICAOF, stringArray);
            f_DU.info(SystemRequest.m_RF((Object)"g\u0011Z\n\u0013\u0017\\\u001dVYZ\n\u0013\r[\u001c\u00135v8w<aW\u0013*V\rG\u0010]\u001e\u0013+V\u001dZ\n\u0013\r\\Y^\u0018@\rV\u000b\u0013\u0014\\\u001dVW\u0013+V\nF\u0015GC\u0013\u0002N"), a3);
            return;
        }
        catch (Exception a3) {
            f_DU.error(c_va.m_jD((Object)"h;G6K>\u000e.Az]?Zz|?J3]zZ5\u000e7O)Z?\\zC5J?\u000e5@zB?O>K(\u000e4A>Kt"), (Throwable)a3);
            return;
        }
    }
}

