/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AlarmGroupSummary;
import com.inscada.mono.alarm.r.c_HJ;
import com.inscada.mono.alarm.services.c_hJ;
import com.inscada.mono.alarm.services.c_tL;
import com.inscada.mono.alarm.services.c_xl;
import com.inscada.mono.alarm.services.c_yL;
import com.inscada.mono.alarm.x.c_Jj;
import com.inscada.mono.alarm.x.c_Ml;
import com.inscada.mono.alarm.x.c_lK;
import com.inscada.mono.alarm.x.c_uj;
import com.inscada.mono.alarm.x.c_yj;
import com.inscada.mono.auth.c_SL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.manager.LeaderFencedManager;
import com.inscada.mono.cluster.services.c_c;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueDto;
import com.inscada.mono.datasource.sql.model.metadata.ProcedureMetadata;
import com.inscada.mono.log.x.c_wB;
import com.inscada.mono.project.x.c_m;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
extends LeaderFencedManager
implements c_m {
    private static final Logger f_Hc = LoggerFactory.getLogger(AlarmManager.class);
    public static final short f_TY = 104;
    private final JedisPooled f_eZ;
    public static final short f_HX = 105;
    public static final short f_wY = 109;
    private final c_yL f_lY;
    public static final short f_QX = 107;
    private final c_wB f_GZ;
    private final c_SL f_kY;
    public static final short f_gX = 106;
    private final c_xl f_fX;
    private final c_tL f_yX;
    public static final short f_cy = 103;
    public static final short f_Pz = 101;
    private final Lock f_iX;
    public static final short f_Iz = 108;
    public static final short f_Mz = 102;
    private static final String f_SY = "activeAlarmGroups";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader(long l) {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        String a = alarmManager2.f_vc.m_ca();
        f_Hc.info(ProcedureMetadata.m_Vr((Object)"4E\u0014[\u0018d\u0014G\u0014N\u0010[O\t!A\u001cZUG\u001aM\u0010\t]R\b\u0000UA\u0014ZUK\u0010J\u001aD\u0010\t\u0001A\u0010\t9l4m0{[\t'L\u0006]\u001a[\u001cG\u0012\t\u0014J\u0001@\u0003LUH\u0019H\u0007D\u0006\u0007[\u0007"), (Object)a);
        alarmManager2.f_iX.lock();
        try {
            HashSet hashSet = new HashSet(alarmManager.f_eZ.smembers(f_SY));
            if (hashSet.isEmpty()) {
                f_Hc.info(LoggedVariableValueDto.m_cda((Object)"\b\\(B$}(^(W,Bi\u0018\u0005U(T,BiK4\u0019s\u0010\u0007_iQ*D F,\u0010(\\(B$\u0010.B&E9CiV&E'TiY'\u0010\u001bU-Y:\u0010=_iB,C=_;Ug"), (Object)a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[2 ^ 3] = hashSet.size();
            objectArray[--2] = hashSet;
            f_Hc.info(ProcedureMetadata.m_Vr((Object)"h\u0019H\u0007D8H\u001bH\u0012L\u0007\t]e\u0010H\u0011L\u0007\t\u000eT\\\u0013Uo\u001a\\\u001bMUR\b\t\u0014J\u0001@\u0003LUH\u0019H\u0007DUN\u0007F\u0000YU`1ZU@\u001b\t'L\u0011@\u0006\t\u0001FU[\u0010Z\u0001F\u0007LO\t\u000eT"), objectArray);
            ArrayList a2 = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[3 ^ 3] = LoggedVariableValueDto.m_cda((Object)"f\u0000u\u001eo\b|\bb\u0004o\u000eb\u0006e\u0019");
            alarmManager.f_kY.m_rDa(() -> {
                void a;
                Object a2 = hashSet;
                AlarmManager a3 = this;
                a.addAll(a3.f_lY.m_wga((Set)a2));
            }, stringArray);
            f_Hc.info(ProcedureMetadata.m_Vr((Object)"4E\u0014[\u0018d\u0014G\u0014N\u0010[U\u00019L\u0014M\u0010[UR\b\u0000O\t4]\u0001L\u0018Y\u0001@\u001bNU]\u001a\t\u0007L\u0006]\u001a[\u0010\t\u000eTUH\u0019H\u0007DUN\u0007F\u0000Y\u0006\u0007"), (Object)a, (Object)a2.size());
            a2.forEach(alarmGroup -> {
                void a;
                AlarmManager alarmManager;
                AlarmManager alarmManager2 = alarmManager = this;
                Object a2 = alarmManager2.f_vc.m_ca();
                String[] stringArray = new String[1 ^ 3];
                stringArray[3 ^ 3] = LoggedVariableValueDto.m_cda((Object)"q\nd\u0000f\bd\fo\b|\bb\u0004");
                stringArray[--1] = ProcedureMetadata.m_Vr((Object)"1l4j!`#h!l*h9h'd");
                alarmManager2.f_kY.m_qfa(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1((String)a2, (AlarmGroup)a), a.getSpace(), stringArray);
            });
            f_Hc.info(LoggedVariableValueDto.m_cda((Object)"\b\\(B$}(^(W,Bi\u0018\u0005U(T,BiK4\u0019s\u0010\u000fY'Y:X,TiQ%Q;]iB,C=_;Q=Y&^i@;_*U:Cg"), (Object)a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Hc.error(ProcedureMetadata.m_Vr((Object)"4E\u0014[\u0018d\u0014G\u0014N\u0010[U\u00019L\u0014M\u0010[UR\b\u0000O\t0[\u0007F\u0007\t\u0011\\\u0007@\u001bNUH\u0019H\u0007DU[\u0010Z\u0001F\u0007H\u0001@\u001aGUY\u0007F\u0016L\u0006ZO\t\u000eT"), objectArray);
            return;
        }
        finally {
            alarmManager.f_iX.unlock();
        }
    }

    protected c_HJ getAlarmStatusInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        return alarmManager.getAlarmStatusInternal(alarmManager.f_fX.m_YGa((String)a2));
    }

    protected Map<String, c_HJ> getAlarmStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_fX.m_tHa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(BaseModel::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(ProcedureMetadata.m_Vr((Object)"e0h1l'\u0013Uh\u0016]\u001c_\u0014]\u001cG\u0012\t\u0014E\u0019\t\u0014E\u0014[\u0018\t\u0012[\u001a\\\u0005ZUO\u001a[UY\u0007F\u001fL\u0016]UR\b\t\u0019F\u0016H\u0019E\f\u0007"), a);
            a2.activateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"~\u0006~d|\fq\ru\u001b\nib,A<U:D ^.\u0010%U(T,BiD&\u0010(S=Y?Q=UiQ%\\iQ%Q;]iW;_<@:\u0010/_;\u00109B&Z,S=\u00102Mg"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x6D & 0x7E)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_HJ> getAlarmStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(ProcedureMetadata.m_Vr((Object)"9l4m0{O\t2L\u0001]\u001cG\u0012\t\u0014E\u0019\t\u0014E\u0014[\u0018\t\u0006]\u0014]\u0000Z\u0010ZUO\u001a[UY\u0007F\u001fL\u0016]UR\b\t\u0019F\u0016H\u0019E\f\u0007"), a);
            return a2.getAlarmStatusesByProjectIdInternal((String)a);
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"~\u0006~d|\fq\ru\u001b\nib,A<U:D ^.\u0010%U(T,BiV&BiQ%\\iQ%Q;]iC=Q=E:U:\u0010/_;\u00109B&Z,S=\u00102Mg"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_vc.m_ja(Short.valueOf((short)(0x6D & 0x7B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_HJ> getAlarmGroupStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_lY.m_Hka((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroupSummary::getId, alarmGroupSummary -> {
            AlarmManager a = alarmGroupSummary;
            AlarmManager a2 = this;
            return a2.getAlarmGroupStatusInternal(a.getId());
        }));
    }

    @TransactionalEventListener(value={c_Ml.class})
    public void handleAlarmChangeEvent(c_Ml c_Ml2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_vc.m_Aa()) {
            AlarmManager a = a.m_IKa();
            f_Hc.info(ProcedureMetadata.m_Vr((Object)"9l4m0{O\t=H\u001bM\u0019@\u001bNUh\u0019H\u0007D6A\u0014G\u0012L0_\u0010G\u0001\t\u0013F\u0007\t\u0014E\u0014[\u0018\t<mO\t\u000eTY\t2[\u001a\\\u0005\t<mO\t\u000eT"), (Object)a.getId(), (Object)a.getGroupId());
            c_hJ c_hJ2 = alarmManager.f_yX.m_ZGa(a.getGroupId());
            if (c_hJ2 != null && c_hJ2.m_XGa()) {
                if (Boolean.TRUE.equals(a.getIsActive())) {
                    c_hJ2.m_SHa((Alarm)a);
                    return;
                }
                c_hJ2.m_Aha((Alarm)a);
                return;
            }
        } else {
            f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"~\u0006~d|\fq\ru\u001b\niy.^&B ^.\u0010\b\\(B$s!Q'W,u?U'DiV&BiQ%Q;]iy\r\niK4"), (Object)a.m_IKa().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    public AlarmManager(c_xl c_xl2, c_yL c_yL2, c_tL c_tL2, c_wB c_wB2, JedisPooled jedisPooled, c_c c_c2, c_SL c_SL2) {
        AlarmManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        AlarmManager a8;
        AlarmManager alarmManager = alarmManager2;
        AlarmManager alarmManager2 = c_SL2;
        AlarmManager alarmManager3 = a8 = alarmManager;
        AlarmManager alarmManager4 = a8;
        AlarmManager alarmManager5 = a8;
        super((c_c)a7);
        AlarmManager alarmManager6 = a8;
        alarmManager6.f_iX = new ReentrantLock();
        alarmManager5.f_fX = a6;
        alarmManager5.f_lY = a5;
        alarmManager4.f_yX = a4;
        alarmManager4.f_GZ = a3;
        alarmManager3.f_eZ = a2;
        alarmManager3.f_kY = a;
    }

    protected void deactivateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.f_lY.m_fIa((String)a2));
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(ProcedureMetadata.m_Vr((Object)"9l4m0{O\t1L\u0014J\u0001@\u0003H\u0001@\u001bNUH\u0019H\u0007DUN\u0007F\u0000YUR\b\t\u0019F\u0016H\u0019E\f\u0007"), a);
            a2.deactivateAlarmGroupInternal((String)a);
            return;
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"\u0007\u007f\u0007\u001d\u0005u\bt\fbs\u0010\u001bU8E,C=Y'Wi\\,Q-U;\u0010=_iT,Q*D F(D,\u0010(\\(B$\u0010.B&E9\u00102Mg"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x76 & 0x6F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm group " + (String)a, (Throwable)exception);
        }
    }

    public void notLeader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_vc.m_ca();
        f_Hc.info(LoggedVariableValueDto.m_cda((Object)"q%Q;]\u0004Q'Q.U;\nid!Y:\u0010'_-Ui\u00182M`\u0010 Ci~\u0006\u0010\u0005\u007f\u0007w\fbid\u0001ui|\fq\ru\u001b\u001eic=_9@ ^.\u0010(\\%\u0010%_*Q%\u0010(\\(B$\u0010 ^:@,S=_;Cg\u001eg"), a);
        alarmManager2.f_iX.lock();
        try {
            alarmManager.f_yX.m_jIa();
            f_Hc.info(ProcedureMetadata.m_Vr((Object)"h\u0019H\u0007D8H\u001bH\u0012L\u0007\t]g\u001a]Ue\u0010H\u0011L\u0007\t\u000eT\\\u0013Uh\u0019EUE\u001aJ\u0014EUH\u0019H\u0007DU@\u001bZ\u0005L\u0016]\u001cF\u001b\t\u0001H\u0006B\u0006\t\u001dH\u0003LUK\u0010L\u001b\t\u0007L\u0004\\\u0010Z\u0001L\u0011\t\u0001FUZ\u0001F\u0005\u0007"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[3 & 5] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Hc.error(LoggedVariableValueDto.m_cda((Object)"\b\\(B$}(^(W,Bi\u0018\u0007_=\u0010\u0005U(T,BiK4\u0019s\u0010\fB;_;\u0010-E;Y'Wi@;_*U:Ci_/\u0010:D&@9Y'Wi\\&S(\\iQ%Q;]iY'C9U*D&B:\niK4"), objectArray);
            return;
        }
        finally {
            alarmManager.f_iX.unlock();
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.info(ProcedureMetadata.m_Vr((Object)"9l4m0{O\t=H\u001bM\u0019@\u001bNUy\u0007F\u001fL\u0016]1L\u0014J\u0001@\u0003H\u0001L0_\u0010G\u0001\t\u0013F\u0007\t\u0005[\u001aC\u0010J\u0001\t<mO\t\u000eT"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"~\u0006~d|\fq\ru\u001b\niy.^&B ^.\u0010\u0019B&Z,S=t,Q*D F(D,u?U'DiV&Bi@;_#U*Diy\r\niK4"), a);
    }

    protected void activateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.activateAlarmGroupInternal(alarmManager.f_lY.m_fIa((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    protected c_HJ getAlarmStatusInternal(Alarm alarm) {
        void a;
        AlarmManager alarmManager = this;
        if (a == null) {
            return c_HJ.f_oZ;
        }
        AlarmManager a2 = alarmManager.f_yX.m_ZGa(a.getGroup().getId());
        if (a2 != null && a2.m_XGa() && a2.m_Nia(a.getId())) {
            return c_HJ.f_lZ;
        }
        return c_HJ.f_oZ;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_HJ> getAlarmStatuses(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(ProcedureMetadata.m_Vr((Object)"e0h1l'\u0013Un\u0010]\u0001@\u001bNUH\u0019H\u0007DUZ\u0001H\u0001\\\u0006L\u0006\t\u0013F\u0007\t\u000eTU`1ZUE\u001aJ\u0014E\u0019PO\t\u000eT"), (Object)a.size(), (Object)a);
            return a2.getAlarmStatusesInternal((List)a);
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"\u0007\u007f\u0007\u001d\u0005u\bt\fbs\u0010\u001bU8E,C=Y'Wi\\,Q-U;\u0010/_;\u0010(\\(B$\u0010:D(D<C,CiV&BiK4\u0010\u0000t:\niK4"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = new ArrayList(a);
            return (Map)a2.f_vc.m_ja(Short.valueOf((short)(0x6F & 0x7B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(ProcedureMetadata.m_Vr((Object)"9l4m0{O\t4J\u0001@\u0003H\u0001@\u001bNUH\u0019H\u0007DUN\u0007F\u0000YUR\b\t\u0019F\u0016H\u0019E\f\u0007"), a);
            a2.activateAlarmGroupInternal((String)a);
            return;
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"\u0007\u007f\u0007\u001d\u0005u\bt\fbs\u0010\u001bU8E,C=Y'Wi\\,Q-U;\u0010=_iQ*D F(D,\u0010(\\(B$\u0010.B&E9\u00102Mg"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x67 & 0x7D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm group " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_HJ> getAlarmGroupStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(ProcedureMetadata.m_Vr((Object)"9l4m0{O\t2L\u0001]\u001cG\u0012\t\u0014E\u0019\t\u0014E\u0014[\u0018\t\u0012[\u001a\\\u0005\t\u0006]\u0014]\u0000Z\u0010ZUO\u001a[UY\u0007F\u001fL\u0016]UR\b\t\u0019F\u0016H\u0019E\f\u0007"), a);
            return a2.getAlarmGroupStatusesByProjectIdInternal((String)a);
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"~\u0006~d|\fq\ru\u001b\nib,A<U:D ^.\u0010%U(T,BiV&BiQ%\\iQ%Q;]iW;_<@iC=Q=E:U:\u0010/_;\u00109B&Z,S=\u00102Mg"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_vc.m_ja(Short.valueOf((short)(0x6A & 0x7F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_kY.m_gDa(() -> a2.lambda$deactivateAlarmGroupInternal$4((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    protected Map<String, c_HJ> getAlarmStatusesInternal(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$2(AlarmGroup alarmGroup) {
        AlarmManager a;
        AlarmManager a2 = alarmGroup;
        AlarmManager alarmManager = a = this;
        long l = alarmManager.f_vc.m_Ia();
        String string = alarmManager.f_vc.m_ca();
        c_hJ c_hJ2 = alarmManager.f_yX.m_hHa((AlarmGroup)a2);
        c_hJ2.m_wia();
        long l2 = alarmManager.f_vc.m_Ia();
        if (!alarmManager.f_vc.m_Aa() || l2 == -1L || l2 != l) {
            try {
                c_hJ2.m_GHa();
                a.f_yX.m_kia(a2.getId(), c_hJ2);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[--4];
                objectArray[3 ^ 3] = string;
                objectArray[2 ^ 3] = a2.getId();
                objectArray[1 ^ 3] = exception.getMessage();
                objectArray[--3] = exception;
                f_Hc.warn(ProcedureMetadata.m_Vr((Object)"4E\u0014[\u0018d\u0014G\u0014N\u0010[U\u0001\u000eT\\\u0013Uo\u0010G\u0016L\u0011\t\u0006]\u001aYUO\u0014@\u0019L\u0011\t\u0013F\u0007\t\u0014E\u0014[\u0018\t\u0012[\u001a\\\u0005\t\u000eTUH\u0013]\u0010[U]\u0010[\u0018\t\u0016A\u0014G\u0012LO\t\u000eT"), objectArray);
            }
            Object[] objectArray = new Object[--4];
            objectArray[5 >> 3] = a2.getId();
            objectArray[5 >> 2] = string;
            objectArray[--2] = l;
            objectArray[--3] = l2;
            f_Hc.info(LoggedVariableValueDto.m_cda((Object)"\u001a[ @9Y'WiQ*D F(D _'\u0010&ViQ%Q;]iW;_<@iK4\u0010&^i^&T,\u00102Ms\u0010%U(T,B:X @i\\&C=\u0010&BiD,B$\u0010*X(^.U-\u0010aC*X,T<\\,TtK4\u001ciS<B;U'DtK4\u0019g"), objectArray);
            return;
        }
        if (c_hJ2.m_XGa()) {
            String[] stringArray = new String[3 & 5];
            stringArray[3 ^ 3] = a2.getId();
            a.f_eZ.sadd(f_SY, stringArray);
        }
    }

    @TransactionalEventListener(value={c_Jj.class})
    public void handleAlarmGroupDeleteEvent(c_Jj c_Jj2) {
        AlarmManager a = c_Jj2;
        AlarmManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.info(ProcedureMetadata.m_Vr((Object)"e0h1l'\u0013Ua\u0014G\u0011E\u001cG\u0012\t4E\u0014[\u0018n\u0007F\u0000Y1L\u0019L\u0001L0_\u0010G\u0001\t\u0013F\u0007\t\u0012[\u001a\\\u0005\t<mO\t\u000eT"), (Object)a.m_vja().getId());
            a2.deactivateAlarmGroupInternal(a.m_vja().getId());
            return;
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"\u0007\u007f\u0007\u001d\u0005u\bt\fbs\u0010\u0000W'_;Y'Wiq%Q;]\u000eB&E9t,\\,D,u?U'DiV&BiW;_<@iy\r\niK4"), (Object)a.m_vja().getId());
    }

    @TransactionalEventListener(value={c_yj.class})
    public void handleAlarmDeleteEvent(c_yj c_yj2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_vc.m_Aa()) {
            AlarmManager a = a.m_DKa();
            f_Hc.info(ProcedureMetadata.m_Vr((Object)"9l4m0{O\t=H\u001bM\u0019@\u001bNUh\u0019H\u0007D1L\u0019L\u0001L0_\u0010G\u0001\t\u0013F\u0007\t\u0014E\u0014[\u0018\t<mO\t\u000eTY\t2[\u001a\\\u0005\t<mO\t\u000eT"), (Object)a.getId(), (Object)a.getGroupId());
            c_hJ c_hJ2 = alarmManager.f_yX.m_ZGa(a.getGroupId());
            if (c_hJ2 != null && c_hJ2.m_XGa()) {
                c_hJ2.m_Aha((Alarm)a);
                return;
            }
        } else {
            f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"~\u0006~d|\fq\ru\u001b\niy.^&B ^.\u0010\b\\(B$t,\\,D,u?U'DiV&BiQ%Q;]iy\r\niK4"), (Object)a.m_DKa().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_HJ getAlarmStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(ProcedureMetadata.m_Vr((Object)"9l4m0{O\t2L\u0001]\u001cG\u0012\t\u0014E\u0014[\u0018\t\u0006]\u0014]\u0000ZUO\u001a[UR\b\t\u0019F\u0016H\u0019E\f\u0007"), a);
            return a2.getAlarmStatusInternal((String)a);
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"~\u0006~d|\fq\ru\u001b\nib,A<U:D ^.\u0010%U(T,BiV&BiQ%Q;]iC=Q=E:\u0010/_;\u00102Mg"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 ^ 3] = a;
            return (c_HJ)a2.f_vc.m_ja(Short.valueOf((short)(0x67 & 0x7F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm status for " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        AlarmManager alarmManager = this;
        try {
            Class[] classArray = new Class[3 & 5];
            classArray[3 & 4] = String.class;
            alarmManager.f_vc.m_Ca((short)(0x75 & 0x6F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ProcedureMetadata.m_Vr((Object)"\u0014J\u0001@\u0003H\u0001L4E\u0014[\u0018n\u0007F\u0000Y<G\u0001L\u0007G\u0014E"), classArray));
            Class[] classArray2 = new Class[5 >> 2];
            classArray2[5 >> 3] = String.class;
            alarmManager.f_vc.m_Ca((short)(0x67 & 0x7E), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LoggedVariableValueDto.m_cda((Object)"T,Q*D F(D,q%Q;]\u000eB&E9y'D,B'Q%"), classArray2));
            Class[] classArray3 = new Class[5 >> 2];
            classArray3[5 >> 3] = String.class;
            alarmManager.f_vc.m_Ca((short)(0x77 & 0x6F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ProcedureMetadata.m_Vr((Object)"\u0012L\u0001h\u0019H\u0007D&]\u0014]\u0000Z<G\u0001L\u0007G\u0014E"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[2 & 5] = String.class;
            alarmManager.f_vc.m_Ca((short)(0x6E & 0x79), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LoggedVariableValueDto.m_cda((Object)".U=q%Q;]\u000eB&E9c=Q=E:y'D,B'Q%"), classArray4));
            Class[] classArray5 = new Class[3 & 5];
            classArray5[3 & 4] = String.class;
            alarmManager.f_vc.m_Ca((short)(0x6B & 0x7D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ProcedureMetadata.m_Vr((Object)"N\u0010]4E\u0014[\u0018z\u0001H\u0001\\\u0006L\u0006k\fy\u0007F\u001fL\u0016]<M<G\u0001L\u0007G\u0014E"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            alarmManager.f_vc.m_Ca((short)(0x6F & 0x7A), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LoggedVariableValueDto.m_cda((Object)"W,D\b\\(B$w;_<@\u001aD(D<C,C\u000bI\u0019B&Z,S=y-y'D,B'Q%"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            alarmManager.f_vc.m_Ca((short)(0x7B & 0x6F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ProcedureMetadata.m_Vr((Object)"\u0012L\u0001h\u0019H\u0007D&]\u0014]\u0000Z\u0010Z<G\u0001L\u0007G\u0014E"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            alarmManager.f_vc.m_Ca((short)(0x7F & 0x6C), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LoggedVariableValueDto.m_cda((Object)"Q*D F(D,q%Q;]\u000eB&E9C\u000bI\u0019B&Z,S=y-y'D,B'Q%"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String.class;
            alarmManager.f_vc.m_Ca((short)(0x7D & 0x6F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ProcedureMetadata.m_Vr((Object)"\u0011L\u0014J\u0001@\u0003H\u0001L4E\u0014[\u0018n\u0007F\u0000Y\u0006k\fy\u0007F\u001fL\u0016]<M<G\u0001L\u0007G\u0014E"), classArray9));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(LoggedVariableValueDto.m_cda((Object)"\u000fQ \\,TiD&\u0010;U.Y:D,Biq%Q;]\u0004Q'Q.U;\u0010\u001b`\n\u0010$U=X&T:"), a);
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(ProcedureMetadata.m_Vr((Object)"e0h1l'\u0013Um\u0010H\u0016]\u001c_\u0014]\u001cG\u0012\t\u0014E\u0019\t\u0014E\u0014[\u0018\t\u0012[\u001a\\\u0005ZUO\u001a[UY\u0007F\u001fL\u0016]UR\b\t\u0019F\u0016H\u0019E\f\u0007"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"~\u0006~d|\fq\ru\u001b\nib,A<U:D ^.\u0010%U(T,BiD&\u0010-U(S=Y?Q=UiQ%\\iQ%Q;]iW;_<@:\u0010/_;\u00109B&Z,S=\u00102Mg"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = a;
            a2.f_vc.m_ja(Short.valueOf((short)(0x6F & 0x7D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_lY.m_Uha((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    protected void activateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_kY.m_gDa(() -> a2.lambda$activateAlarmGroupInternal$3((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.deactivateAlarmGroup(alarmManager.f_lY.m_Gia((String)a, (String)a3).getId());
    }

    protected c_HJ getAlarmGroupStatusInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_yX.m_ZGa((String)a)) != null && a.m_XGa()) {
            return c_HJ.f_lZ;
        }
        return c_HJ.f_oZ;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.activateAlarmGroup(alarmManager.f_lY.m_Gia((String)a, (String)a3).getId());
    }

    protected void activateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_lY.m_Uha((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_HJ getAlarmGroupStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_vc.m_Aa()) {
            f_Hc.debug(ProcedureMetadata.m_Vr((Object)"9l4m0{O\t2L\u0001]\u001cG\u0012\t\u0014E\u0014[\u0018\t\u0012[\u001a\\\u0005\t\u0006]\u0014]\u0000ZUO\u001a[UR\b\t\u0019F\u0016H\u0019E\f\u0007"), a);
            return a2.getAlarmGroupStatusInternal((String)a);
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"~\u0006~d|\fq\ru\u001b\nib,A<U:D ^.\u0010%U(T,BiV&BiQ%Q;]iW;_<@iC=Q=E:\u0010/_;\u00102Mg"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            return (c_HJ)a2.f_vc.m_ja(Short.valueOf((short)(0x7F & 0x68)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group status for " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_lK.class})
    public void handleAlarmAddEvent(c_lK c_lK2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_vc.m_Aa()) {
            c_hJ c_hJ2;
            AlarmManager a = a.m_Xka();
            f_Hc.info(ProcedureMetadata.m_Vr((Object)"e0h1l'\u0013Ua\u0014G\u0011E\u001cG\u0012\t4E\u0014[\u0018h\u0011M0_\u0010G\u0001\t\u0013F\u0007\t\u0014E\u0014[\u0018\t<mO\t\u000eTY\t2[\u001a\\\u0005\t<mO\t\u000eT"), (Object)a.getId(), (Object)a.getGroupId());
            if (Boolean.TRUE.equals(a.getIsActive()) && (c_hJ2 = alarmManager.f_yX.m_ZGa(a.getGroupId())) != null && c_hJ2.m_XGa()) {
                c_hJ2.m_SHa((Alarm)a);
                return;
            }
        } else {
            f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"\u0007\u007f\u0007\u001d\u0005u\bt\fbs\u0010\u0000W'_;Y'Wiq%Q;]\bT-u?U'DiV&BiQ%Q;]iy\r\niK4"), (Object)a.m_Xka().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_HJ getAlarmGroupStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_lY.m_xHa((String)a2, (String)a)) == null) {
            return c_HJ.f_oZ;
        }
        return a3.getAlarmGroupStatus(a2.getId());
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        a.registerRemoteCallsWithClusterNode();
        f_Hc.info(LoggedVariableValueDto.m_cda((Object)"\b\\(B$}(^(W,BiY'Y=Y(\\ J,TiQ'TiB,W C=U;U-\u0010(Cis%E:D,B\u0007_-U\u0005Y:D,^,Bg"));
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_uj.class})
    public void handleAlarmGroupChangeEvent(c_uj c_uj2) {
        void a;
        AlarmManager alarmManager = this;
        if (alarmManager.f_vc.m_Aa()) {
            f_Hc.info(ProcedureMetadata.m_Vr((Object)"e0h1l'\u0013Ua\u0014G\u0011E\u001cG\u0012\t4E\u0014[\u0018n\u0007F\u0000Y6A\u0014G\u0012L0_\u0010G\u0001\t\u0013F\u0007\t\u0012[\u001a\\\u0005\t<mO\t\u000eT"), (Object)a.m_CKa().getId());
            alarmManager.f_iX.lock();
            try {
                Object a2 = a.m_CKa().getId();
                if (alarmManager.getAlarmGroupStatusInternal((String)a2) == c_HJ.f_lZ) {
                    AlarmManager alarmManager2 = alarmManager;
                    alarmManager2.deactivateAlarmGroupInternal((String)a2);
                    alarmManager2.activateAlarmGroupInternal((String)a2);
                }
                return;
            }
            finally {
                alarmManager.f_iX.unlock();
            }
        }
        f_Hc.debug(LoggedVariableValueDto.m_cda((Object)"\u0007\u007f\u0007\u001d\u0005u\bt\fbs\u0010\u0000W'_;Y'Wiq%Q;]\u000eB&E9s!Q'W,u?U'DiV&BiW;_<@iy\r\niK4"), (Object)a.m_CKa().getId());
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$3(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_iX.lock();
        try {
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to start alarm group " + a.getName());
            }
            Runnable runnable = () -> a2.lambda$activateAlarmGroupInternal$2((AlarmGroup)a);
            a2.fenced("Activate alarm group " + a.getId(), runnable).run();
            return;
        }
        finally {
            a2.f_iX.unlock();
        }
    }

    private /* synthetic */ void lambda$deactivateAlarmGroupInternal$4(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_iX.lock();
        try {
            c_hJ c_hJ2 = a2.f_yX.m_ZGa(a.getId());
            if (c_hJ2 != null) {
                c_hJ2.m_GHa();
                a2.f_yX.m_kia(a.getId(), c_hJ2);
            }
            String[] stringArray = new String[3 >> 1];
            stringArray[2 & 5] = a.getId();
            a2.f_eZ.srem(f_SY, stringArray);
            return;
        }
        finally {
            a2.f_iX.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String string, AlarmGroup alarmGroup) {
        void a;
        AlarmManager a2 = alarmGroup;
        AlarmManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[--1] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_Hc.info(ProcedureMetadata.m_Vr((Object)"4E\u0014[\u0018d\u0014G\u0014N\u0010[U\u00019L\u0014M\u0010[UR\b\u0000O\t'L\u0006]\u001a[\u001cG\u0012\t\u0014E\u0014[\u0018\t\u0012[\u001a\\\u0005\u0013UR\b\t]`1\u0013UR\b\u0000"), objectArray);
            a3.activateAlarmGroupInternal((AlarmGroup)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[5 >> 2] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_GZ.m_ak(a2.getProject()).m_w("Alarm Group Restore (Leader " + (String)a + ")", LoggedVariableValueDto.m_cda((Object)"\u0015:\u0010ay\r\ni\u0015:\u0019iV(Y%U-\u0010=_iB,C=_;Ug\u0010\nQ<C,\ni\u0015:").formatted(objectArray));
            try {
                f_Hc.warn(ProcedureMetadata.m_Vr((Object)"4E\u0014[\u0018d\u0014G\u0014N\u0010[U\u00019L\u0014M\u0010[UR\b\u0000O\t4]\u0001L\u0018Y\u0001@\u001bNU]\u001a\t\u0011L\u0014J\u0001@\u0003H\u0001LUH\u0019H\u0007DUN\u0007F\u0000YUR\b\t\u0014O\u0001L\u0007\t\u0007L\u0006]\u001a[\u0014]\u001cF\u001b\t\u0013H\u001cE\u0000[\u0010\u0007"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal((AlarmGroup)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[5 >> 3] = a;
                objectArray2[4 ^ 5] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_Hc.error(LoggedVariableValueDto.m_cda((Object)"\b\\(B$}(^(W,Bi\u0018\u0005U(T,BiK4\u0019s\u0010\u000fQ \\,TiD&\u0010-U(S=Y?Q=UiQ%Q;]iW;_<@iK4\u0010(V=U;\u0010;U:D&B(D _'\u0010/Q \\<B,\niK4"), objectArray2);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_HJ getAlarmStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_fX.m_CGa((String)a2, (String)a)) == null) {
            return c_HJ.f_oZ;
        }
        return a3.getAlarmStatus(a2.getId());
    }
}

