/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.r.c_ol;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableView;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="digital_alarm")
@CheckAtLeastOneNotNull(fieldNames={"variableAId", "variableA"})
public class DigitalAlarm
extends Alarm {
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="variable_B_id", insertable=false, updatable=false)
    private VariableView variableB;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="variable_A_id", insertable=false, updatable=false)
    private VariableView variableA;
    @Min(value=0L)
    @Max(value=63L)
    @Column(name="variable_A_bit_offset")
    private Integer variableABitOffset;
    @Column(name="variable_B_id")
    private String variableBId;
    @Column(name="variable_A_id")
    private String variableAId;
    @Column(name="variable_A_inverted")
    private Boolean variableAInverted;
    @Column(name="variable_B_inverted")
    private Boolean variableBInverted;
    @Min(value=0L)
    @Max(value=63L)
    @Column(name="variable_B_bit_offset")
    private Integer variableBBitOffset;
    @Column(name="and_calc")
    private Boolean andCalc;

    public Boolean getVariableAInverted() {
        DigitalAlarm a;
        return a.variableAInverted;
    }

    public Boolean getAndCalc() {
        DigitalAlarm a;
        return a.andCalc;
    }

    @JsonSetter
    public void setVariableA(VariableView variableView) {
        DigitalAlarm a = variableView;
        DigitalAlarm a2 = this;
        a2.variableA = a;
        if (a2.variableA != null) {
            a2.variableAId = a.getId();
            return;
        }
        a2.variableAId = null;
    }

    public void setVariableB(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.variableBId = a.getId();
            variable2.variableB = VariableView.from(a);
            return;
        }
        a2.variableBId = null;
        a2.variableB = null;
    }

    public void setVariableBBitOffset(Integer n) {
        Object a = n;
        DigitalAlarm a2 = this;
        a2.variableBBitOffset = a;
    }

    public Integer getVariableBBitOffset() {
        DigitalAlarm a;
        return a.variableBBitOffset;
    }

    public VariableView getVariableA() {
        DigitalAlarm a;
        return a.variableA;
    }

    public String getVariableAId() {
        DigitalAlarm a;
        return a.variableAId;
    }

    public String getVariableBId() {
        DigitalAlarm a;
        return a.variableBId;
    }

    public Boolean getVariableBInverted() {
        DigitalAlarm a;
        return a.variableBInverted;
    }

    public void setVariableAInverted(Boolean bl) {
        Object a = bl;
        DigitalAlarm a2 = this;
        a2.variableAInverted = a;
    }

    public c_ol getType() {
        return c_ol.f_yZ;
    }

    public VariableView getVariableB() {
        DigitalAlarm a;
        return a.variableB;
    }

    public void setVariableBInverted(Boolean bl) {
        Object a = bl;
        DigitalAlarm a2 = this;
        a2.variableBInverted = a;
    }

    public DigitalAlarm() {
        DigitalAlarm a;
    }

    public void setVariableAId(String string) {
        Object a = string;
        DigitalAlarm a2 = this;
        a2.variableAId = a;
    }

    public void setVariableABitOffset(Integer n) {
        Object a = n;
        DigitalAlarm a2 = this;
        a2.variableABitOffset = a;
    }

    public void setVariableA(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.variableAId = a.getId();
            variable2.variableA = VariableView.from(a);
            return;
        }
        a2.variableAId = null;
        a2.variableA = null;
    }

    @JsonSetter
    public void setVariableB(VariableView variableView) {
        DigitalAlarm a = variableView;
        DigitalAlarm a2 = this;
        a2.variableB = a;
        if (a2.variableB != null) {
            a2.variableBId = a.getId();
            return;
        }
        a2.variableBId = null;
    }

    public void setVariableBId(String string) {
        Object a = string;
        DigitalAlarm a2 = this;
        a2.variableBId = a;
    }

    public Integer getVariableABitOffset() {
        DigitalAlarm a;
        return a.variableABitOffset;
    }

    public void setAndCalc(Boolean bl) {
        Object a = bl;
        DigitalAlarm a2 = this;
        a2.andCalc = a;
    }
}

