/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.tracking.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableView;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="map_variable")
@AttributeOverride(name="id", column=@Column(name="map_variable_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull.List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"variableId", "variable"})})
public class MapVariable
extends SpaceBaseModel {
    @Column(name="var_order")
    private Integer varOrder;
    @Column(name="variable_id")
    private String variableId;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="variable_id", insertable=false, updatable=false)
    private VariableView variable;

    public void setVarOrder(Integer n) {
        Object a = n;
        MapVariable a2 = this;
        a2.varOrder = a;
    }

    public void setProjectId(String string) {
        Object a = string;
        MapVariable a2 = this;
        a2.projectId = a;
    }

    public void setProject(Project project) {
        MapVariable a;
        MapVariable a2 = project;
        MapVariable mapVariable = a = this;
        mapVariable.project = a2;
        mapVariable.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Integer getVarOrder() {
        MapVariable a;
        return a.varOrder;
    }

    public String getVariableId() {
        MapVariable a;
        return a.variableId;
    }

    public void setVariableId(String string) {
        Object a = string;
        MapVariable a2 = this;
        a2.variableId = a;
    }

    @JsonSetter
    public void setVariable(VariableView variableView) {
        MapVariable a = variableView;
        MapVariable a2 = this;
        a2.variable = a;
        if (a2.variable != null) {
            a2.variableId = a.getId();
            return;
        }
        a2.variableId = null;
    }

    public void setVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.variableId = a.getId();
            variable2.variable = VariableView.from(a);
            return;
        }
        a2.variableId = null;
        a2.variable = null;
    }

    public MapVariable() {
        MapVariable a;
    }

    public int hashCode() {
        MapVariable a;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = super.hashCode();
        objectArray[--1] = a.getProjectId();
        objectArray[1 ^ 3] = a.getVariableId();
        return Objects.hash(objectArray);
    }

    public String getProjectId() {
        MapVariable a;
        return a.projectId;
    }

    public boolean equals(Object object) {
        MapVariable a = this;
        Object a2 = object;
        if (a == a2) {
            return (4 ^ 5) != 0;
        }
        if (!(a2 instanceof MapVariable)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 & 4) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getVariableId().equals(object2.getVariableId())) {
            return 3 >> 1;
        }
        return false;
    }

    public Project getProject() {
        MapVariable a;
        return a.project;
    }

    public VariableView getVariable() {
        MapVariable a;
        return a.variable;
    }
}

