/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.impexp.model.ImportResult;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.space.SpaceContext;
import com.inscada.mono.space.model.Space;
import com.inscada.mono.user.restcontrollers.RoleController;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import java.util.Objects;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.SQLRestriction;

@MappedSuperclass
@FilterDef(name="spaceFilter", parameters={@ParamDef(name="spaceId", type=String.class)}, defaultCondition="space_id = :spaceId")
@Filter(name="spaceFilter")
public abstract class SpaceBaseModel
extends BaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="space_id", updatable=false)
    protected Space space;
    public static final String SPACE_PARAMETER_NAME = "spaceId";
    public static final String SPACE_DEFAULT_CONDITION = "space_id = :spaceId";
    public static final String SPACE_FILTER_NAME = "spaceFilter";
    public static final String SPACE_COLUMN = "space_id";

    public void setSpace(Space space) {
        SpaceBaseModel a = space;
        SpaceBaseModel a2 = this;
        a2.space = a;
    }

    @PrePersist
    public void setActiveSpace() {
        SpaceBaseModel a;
        if (a.getSpace() == null) {
            a.setSpace(Objects.requireNonNull(SpaceContext.getActiveSpace(), RoleController.m_AA((Object)"0\u0001\u0002\u0012\u0006Q\u0010\u0019\f\u0004\u000f\u0015C\u0013\u0006Q\u0013\u0003\u0006\u0002\u0006\u001f\u0017")));
        }
    }

    public SpaceBaseModel() {
        SpaceBaseModel a;
    }

    @PreUpdate
    @PreRemove
    public void checkSpace() {
        SpaceBaseModel a;
        if (a.getSpace() == null || !a.getSpace().equals((Object)SpaceContext.getActiveSpace())) {
            throw new EntityNotFoundException(ImportResult.m_pN((Object)"N<h7fty<ht~$l7h"));
        }
    }

    public boolean equals(Object object) {
        SpaceBaseModel a = this;
        Object a2 = object;
        if (a == a2) {
            return (2 ^ 3) != 0;
        }
        if (!(a2 instanceof SpaceBaseModel)) {
            return false;
        }
        Object object2 = a2;
        return Objects.equals(a.getSpace(), object2.getSpace());
    }

    public int hashCode() {
        SpaceBaseModel a;
        Object[] objectArray = new Object[--1];
        objectArray[3 & 4] = a.getSpace();
        return Objects.hash(objectArray);
    }

    public Space getSpace() {
        SpaceBaseModel a;
        return a.space;
    }
}

