/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.f4b6a3.uuid.UuidCreator;
import com.inscada.mono.cluster.r.c_wk;
import com.inscada.mono.communication.base.model.FrameSummary;
import jakarta.persistence.Column;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.util.Date;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@EntityListeners(value={AuditingEntityListener.class, c_wk.class})
@FilterDef(name="softDeleteFilter", defaultCondition="deleted_dttm IS NULL")
@Filter(name="softDeleteFilter")
public abstract class BaseModel {
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @LastModifiedDate
    @Column(name="version_dttm")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date lastModifiedDate;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Version
    @Column(name="version")
    private Long version;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Column(name="deleted_dttm")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletedDate;
    public static final String SOFT_DELETE_FILTER_NAME = "softDeleteFilter";
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Column(name="deleted_user")
    private String deletedBy;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @CreatedDate
    @Column(name="insert_dttm", updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date creationDate;
    @Id
    @Column(name="id", updatable=false, nullable=false, length=36)
    protected String id;
    public static final String SOFT_DELETE_FILTER_DEFAULT_CONDITION = "deleted_dttm IS NULL";
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @LastModifiedBy
    @Column(name="version_user")
    protected String lastModifiedBy;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @CreatedBy
    @Column(name="insert_user", updatable=false)
    protected String createdBy;

    public String getCreatedBy() {
        BaseModel a;
        return a.createdBy;
    }

    @PrePersist
    protected void onCreate() {
        BaseModel a;
        if (a.id == null) {
            a.id = UuidCreator.getTimeOrdered().toString();
        }
    }

    public Date getLastModifiedDate() {
        BaseModel a;
        return a.lastModifiedDate;
    }

    public String getDeletedBy() {
        BaseModel a;
        return a.deletedBy;
    }

    public Long getVersion() {
        BaseModel a;
        return a.version;
    }

    public Date getCreationDate() {
        BaseModel a;
        return a.creationDate;
    }

    protected BaseModel() {
        BaseModel a;
    }

    @PreRemove
    private /* synthetic */ void preventHardDelete() {
        throw new UnsupportedOperationException(FrameSummary.m_PV((Object)"-g\u0017bEb\u0000j\u0000r\u0000&\fuEh\nrEg\tj\nq\u0000bK&5j\u0000g\u0016cEs\u0016cEr\rcEt\u0000v\nu\fr\nt\u001c!\u0016&\u0001c\tc\u0011cEk\u0000r\ri\u0001&\u0003i\u0017&\u0016i\u0003rEb\u0000j\u0000r\fi\u000b("));
    }

    public String getId() {
        BaseModel a;
        return a.id;
    }

    public void setVersion(Long l) {
        Object a = l;
        BaseModel a2 = this;
        a2.version = a;
    }

    public void setDeletedDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.deletedDate = a;
    }

    public void setLastModifiedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.lastModifiedBy = a;
    }

    public void setCreatedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.createdBy = a;
    }

    public void setId(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.id = a;
    }

    public void setCreationDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.creationDate = a;
    }

    public Date getDeletedDate() {
        BaseModel a;
        return a.deletedDate;
    }

    public String getLastModifiedBy() {
        BaseModel a;
        return a.lastModifiedBy;
    }

    public void setLastModifiedDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.lastModifiedDate = a;
    }

    public void setDeletedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.deletedBy = a;
    }
}

