/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.auth.exceptions.AuthTokenException;
import com.inscada.mono.auth.exceptions.RunAsExecutionException;
import com.inscada.mono.broadcast.exceptions.BroadcastOperationException;
import com.inscada.mono.chat.restcontrollers.ChatController;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.exceptions.CommunicationException;
import com.inscada.mono.communication.base.exceptions.SetValueException;
import com.inscada.mono.impexp.exceptions.ImportExportException;
import com.inscada.mono.mail.model.MailerWithSettings;
import com.inscada.mono.report.exceptions.ReportGenerationException;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.script.exceptions.ScriptException;
import com.inscada.mono.settings.exceptions.SettingsException;
import com.inscada.mono.shared.exceptions.AlreadyExistsException;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.InscadaException;
import com.inscada.mono.shared.exceptions.MismatchException;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.exceptions.ParsingException;
import com.inscada.mono.shared.exceptions.RelationExistsException;
import com.inscada.mono.shared.exceptions.ValidationDefinitionException;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.sms.exceptions.SmsProviderException;
import com.inscada.mono.space.exceptions.SpaceOperationException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.OptimisticLockException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.StaleObjectStateException;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice(basePackages={"com.inscada.mono"})
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String UNKNOWN_ERROR = "Unknown Error";
    private static final String DATABASE_ERROR = "Database Error";
    private static final String INSCADA_ERROR = "Inscada Error";
    private static final String ALREADY_EXISTS_ERROR = "Already Exists Error";
    private static final Logger log = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String COMMUNICATION_ERROR = "Communication Error";
    private static final String RELATION_EXISTS_ERROR = "Relation Exists Error";
    private static final String SECURITY_ERROR = "Security Error";
    private static final String OPTIMISTIC_LOCK_ERROR = "Optimistic Lock Error";
    private static final String SET_VALUE_ERROR = "Set Value Error";
    private static final String REPORT_GENERATION_ERROR = "Report Generation Error";
    private static final String SETTINGS_ERROR = "Settings Error";
    private final Environment environment;
    private static final String MISMATCH_ERROR = "Mismatch Error";
    private static final String NOT_ACTIVE_ERROR = "Not Active Error";
    private static final String REPORT_SCHEDULING_ERROR = "Report Scheduling Error";
    private static final String SMS_PROVIDER_ERROR = "SMS Provider Error";
    private static final String AUTH_TOKEN_ERROR = "Auth Token Error";
    private static final String BROADCAST_OPERATION_ERROR = "Broadcast Operation Error";
    private static final String VALIDATION_DEFINITION_ERROR = "Validation Definition Error";
    private static final String VALIDATION_ERROR = "Validation Error";
    private static final String IMPORT_EXPORT_ERROR = "Import/Export Error";
    private static final String NOT_FOUND_ERROR = "Not Found Error";
    private static final String RUN_AS_ERROR = "Run-As Execution Error";
    private static final String BROWSE_OPERATION_ERROR = "Browse Operation Error";
    private static final String CONSTRAINT_VIOLATION = "Constraint Violation";
    private static final String PARSING_ERROR = "Parsing Error";
    private static final String SPACE_OPERATION_ERROR = "Space Operation Error";
    private static final String FILE_STORAGE_ERROR = "File Storage Error";
    private static final String SCRIPT_ERROR = "Script Execution Error";

    @ExceptionHandler(value={SetValueException.class})
    protected ResponseEntity<Object> handleSetValueException(SetValueException setValueException) {
        GeneralExceptionHandler a = setValueException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SET_VALUE_ERROR);
    }

    @ExceptionHandler(value={OptimisticLockException.class, StaleObjectStateException.class})
    protected ResponseEntity<Object> handleOptimisticLock(Exception exception) {
        Object a = exception;
        GeneralExceptionHandler a2 = this;
        return a2.buildErrorResponse((Exception)a, ChatController.m_uea((Object)";\u0002\u0006\u0019O\u0018\n\t\u0000\u0018\u000bJ\u0018\u000b\u001cJ\u001a\u001a\u000b\u000b\u001b\u000f\u000bJ\r\u0013O\u000b\u0001\u0005\u001b\u0002\n\u0018O\u001f\u001c\u000f\u001dDO:\u0003\u000f\u000e\u0019\nJ\u001d\u000f\t\u0018\n\u0019\u0007J\u0016\u0005\u001a\u0018O\u000e\u000e\u001e\u000eJ\u000e\u0004\u000bJ\u001b\u0018\u0016J\u000e\r\u000e\u0003\u0001D"), (HttpStatusCode)HttpStatus.CONFLICT, OPTIMISTIC_LOCK_ERROR);
    }

    public GeneralExceptionHandler(Environment environment) {
        GeneralExceptionHandler a = environment;
        GeneralExceptionHandler a2 = this;
        a2.environment = a;
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleExceptionInternal(Exception exception, Object object, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void status;
        GeneralExceptionHandler generalExceptionHandler = exception2;
        Exception exception2 = exception;
        GeneralExceptionHandler ex = generalExceptionHandler;
        if (ex.isSseRequest() && (ex.isClientAbort((Throwable)exception2) || exception2 instanceof HttpMessageNotReadableException || exception2 instanceof HttpMessageNotWritableException)) {
            log.warn(ChatController.m_uea((Object)"9</O\u0003\u0001\u001e\n\u0018\u0001\u000b\u0003J\n\u0018\u001d\u0005\u001dJ\u001c\u001f\u001f\u001a\u001d\u000f\u001c\u0019\n\u000eUJ\u0014\u0017"), (Object)exception2.getMessage());
            return ResponseEntity.noContent().build();
        }
        ExceptionDetails body = ex.createExceptionDetails((HttpStatusCode)status, exception2.getMessage(), exception2, UNKNOWN_ERROR);
        log.error(MailerWithSettings.m_ml((Object)"!B\u001cI\u001aB\t@HI\u001a^\u0007^R\f\u0013Q"), (Object)body, (Object)exception2);
        return new ResponseEntity((Object)body, (HttpStatusCode)status);
    }

    private /* synthetic */ boolean isClientAbort(Throwable throwable) {
        Throwable a = throwable;
        GeneralExceptionHandler a2 = this;
        Throwable throwable2 = a;
        while (throwable2 != null) {
            String string;
            if (a instanceof ClientAbortException) {
                return --1 != 0;
            }
            if (a instanceof IOException && (string = a.getMessage()) != null && ((string = string.toLowerCase(Locale.ROOT)).contains(MailerWithSettings.m_ml((Object)"N\u001aC\u0003I\u0006\f\u0018E\u0018I")) || string.contains(ChatController.m_uea((Object)"\f\u0005\u0001\u0004\n\t\u001b\u0003\u0000\u0004O\u0018\n\u0019\n\u001e")) || string.contains(MailerWithSettings.m_ml((Object)"M\nC\u001aX\rHHN\u0011\f\u001cD\r\f\u001bC\u000eX\u001fM\u001aI")))) {
                return true;
            }
            throwable2 = a.getCause();
        }
        return false;
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException dataIntegrityViolationException) {
        GeneralExceptionHandler a = dataIntegrityViolationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, ExceptionUtils.getRootCauseMessage((Throwable)generalExceptionHandler), (HttpStatusCode)HttpStatus.CONFLICT, DATABASE_ERROR);
    }

    @ExceptionHandler(value={ReportSchedulingException.class})
    protected ResponseEntity<Object> handleReportSchedulingException(ReportSchedulingException reportSchedulingException) {
        GeneralExceptionHandler a = reportSchedulingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_SCHEDULING_ERROR);
    }

    @ExceptionHandler(value={FileStorageException.class})
    protected ResponseEntity<Object> handleFileStorage(FileStorageException fileStorageException) {
        GeneralExceptionHandler a = fileStorageException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, FILE_STORAGE_ERROR);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleAllExceptions(Exception exception) {
        Exception a = exception;
        Object a2 = this;
        if (a2.isSseRequest() && (a2.isClientAbort((Throwable)a) || a instanceof HttpMessageNotReadableException || a instanceof HttpMessageNotWritableException)) {
            log.warn(MailerWithSettings.m_ml((Object)";\u007f-\f\u001aI\u0019Y\r_\u001c\f\r^\u001aC\u001a\f\u001bY\u0018\\\u001aI\u001b_\rHR\f\u0013Q"), (Object)a.getMessage());
            return ResponseEntity.noContent().build();
        }
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, UNKNOWN_ERROR);
    }

    @ExceptionHandler(value={AuthTokenException.class})
    protected ResponseEntity<Object> handleAuthTokenException(AuthTokenException authTokenException) {
        GeneralExceptionHandler a = authTokenException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, AUTH_TOKEN_ERROR);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException illegalStateException) {
        IllegalStateException a = illegalStateException;
        GeneralExceptionHandler a2 = this;
        IllegalStateException illegalStateException2 = a;
        return a2.buildErrorResponse((Exception)illegalStateException2, illegalStateException2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    @ExceptionHandler(value={ValidationDefinitionException.class})
    protected ResponseEntity<Object> handleValidationDefinitionException(ValidationDefinitionException validationDefinitionException) {
        GeneralExceptionHandler a = validationDefinitionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, VALIDATION_DEFINITION_ERROR);
    }

    @ExceptionHandler(value={ReportGenerationException.class})
    protected ResponseEntity<Object> handleReportGenerationException(ReportGenerationException reportGenerationException) {
        GeneralExceptionHandler a = reportGenerationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_GENERATION_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String sanitizeMessage(String string, Exception exception) {
        void a;
        Object a2 = exception;
        GeneralExceptionHandler a3 = this;
        if (a2 instanceof ScriptException) {
            return a;
        }
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof AlreadyExistsException) {
            return ChatController.m_uea((Object)"8\n\u0019\u0000\u001f\u001d\t\nJ\u000e\u0006\u001d\u000f\u000e\u000e\u0016J\n\u0012\u0006\u0019\u001b\u0019");
        }
        if (a2 instanceof FileStorageException) {
            return MailerWithSettings.m_ml((Object)"j\u0001@\r\f\u0007\\\r^\tX\u0001C\u0006\f\u000eM\u0001@\rH");
        }
        if (a2 instanceof MismatchException) {
            return ChatController.m_uea((Object)"8\n\u0019\u0000\u001f\u001d\t\nJ\u0002\u0003\u001c\u0007\u000e\u001e\f\u0002");
        }
        if (a2 instanceof NotActiveException) {
            return MailerWithSettings.m_ml((Object)":I\u001bC\u001d^\u000bIHE\u001b\f\u0006C\u001c\f\tO\u001cE\u001eI");
        }
        if (a2 instanceof NotFoundException) {
            return ChatController.m_uea((Object)"=\u000f\u001c\u0005\u001a\u0018\f\u000fO\u0004\u0000\u001eO\f\u0000\u001f\u0001\u000e");
        }
        if (a2 instanceof RelationExistsException) {
            return MailerWithSettings.m_ml((Object)"~\r@\tX\rHH^\r_\u0007Y\u001aO\r\f\rT\u0001_\u001c_");
        }
        if (a2 instanceof OptimisticLockException || a2 instanceof StaleObjectStateException) {
            return ChatController.m_uea((Object)"=\u000f\u001c\u0005\u001a\u0018\f\u000fO\u001d\u000e\u0019O\u001f\u001f\u000e\u000e\u001e\n\u000eO\b\u0016J\u000e\u0004\u0000\u001e\u0007\u000f\u001dJ\u001a\u0019\n\u0018");
        }
        if (a2 instanceof SmsProviderException) {
            return MailerWithSettings.m_ml((Object)";a;\f\u001bI\u001aZ\u0001O\r\f\u0007\\\r^\tX\u0001C\u0006\f\u000eM\u0001@\rH");
        }
        if (a2 instanceof SettingsException) {
            return ChatController.m_uea((Object)".\u001a\u001f\u0006\u0006\t\u000e\u001e\u0006\u0005\u0001J\u001c\u000f\u001b\u001e\u0006\u0004\b\u0019O\u000f\u001d\u0018\u0000\u0018");
        }
        if (a2 instanceof ParsingException) {
            return MailerWithSettings.m_ml((Object)"e\u0006Z\t@\u0001HHH\tX\t\f\u000eC\u001aA\tX");
        }
        if (a2 instanceof ValidationDefinitionException) {
            return ChatController.m_uea((Object)"#\u0001\u001e\n\u0018\u0001\u000b\u0003J\u0019\u000b\u0003\u0003\u000b\u000b\u001b\u0003\u0000\u0004O\t\u0000\u0004\t\u0003\b\u001f\u001d\u000b\u001b\u0003\u0000\u0004O\u000f\u001d\u0018\u0000\u0018");
        }
        if (a2 instanceof BrowseOperationException) {
            return MailerWithSettings.m_ml((Object)"m\u0006\f\r^\u001aC\u001a\f\u0007O\u000bY\u001a^\rHHH\u001d^\u0001B\u000f\f\t\f\n^\u0007[\u001bIHC\u0018I\u001aM\u001cE\u0007B");
        }
        if (a2 instanceof SetValueException) {
            return ChatController.m_uea((Object)"+\u0001J\n\u0018\u001d\u0005\u001dJ\u0000\t\f\u001f\u001d\u0018\n\u000eO\u001d\u0007\u0003\u0003\u000fO\u0019\n\u001e\u001b\u0003\u0001\rO\u000bO\u001c\u000e\u0006\u001a\u000f");
        }
        if (a2 instanceof CommunicationException) {
            return MailerWithSettings.m_ml((Object)"o\u0007A\u0005Y\u0006E\u000bM\u001cE\u0007BHO\u0007B\u000eE\u000fY\u001aM\u001cE\u0007BHI\u001a^\u0007^");
        }
        if (a2 instanceof RunAsExecutionException) {
            return ChatController.m_uea((Object)"+\u0001J\u0006\u0004\u001b\u000f\u001d\u0004\u000e\u0006O\u0005\u001f\u000f\u001d\u000b\u001b\u0003\u0000\u0004O\f\u000e\u0003\u0003\u000f\u000bJ\u000b\u001f\u001d\u0003\u0001\rO\u000f\u0017\u000f\f\u001f\u001b\u0003\u0000\u0004");
        }
        if (a2 instanceof SpaceOperationException) {
            return MailerWithSettings.m_ml((Object)"\u007f\u0018M\u000bIHC\u0018I\u001aM\u001cE\u0007BHJ\tE\u0004I\f\f\fY\r\f\u001cCHMHN\u001d_\u0001B\r_\u001b\f\u001aY\u0004IHZ\u0001C\u0004M\u001cE\u0007B");
        }
        if (a2 instanceof ImportExportException) {
            return ChatController.m_uea((Object)"+\u0001J\n\u0018\u001d\u0005\u001dJ\u0000\t\f\u001f\u001d\u0018\n\u000eO\u000e\u001a\u0018\u0006\u0004\bJ\u000b\u000b\u001b\u000bO\u0003\u0002\u001a\u0000\u0018\u001bE\n\u0012\u001f\u0005\u001d\u001e");
        }
        if (a2 instanceof ReportGenerationException) {
            return MailerWithSettings.m_ml((Object)")BHI\u001a^\u0007^HC\u000bO\u001d^\u001aI\f\f\fY\u001aE\u0006KH^\r\\\u0007^\u001c\f\u000fI\u0006I\u001aM\u001cE\u0007B");
        }
        if (a2 instanceof ReportSchedulingException) {
            return ChatController.m_uea((Object)".\u0004O\u000f\u001d\u0018\u0000\u0018O\u0005\f\t\u001a\u0018\u001d\u000f\u000bJ\u000b\u001f\u001d\u0003\u0001\rO\u0018\n\u001a\u0000\u0018\u001bJ\u001c\t\u0007\u000f\u000b\u001f\u0003\u0003\u0001\r");
        }
        if (a2 instanceof BroadcastOperationException) {
            return MailerWithSettings.m_ml((Object)")BHI\u001a^\u0007^HC\u000bO\u001d^\u001aI\f\f\fY\u001aE\u0006KHMHN\u001aC\tH\u000bM\u001bXHC\u0018I\u001aM\u001cE\u0007B");
        }
        if (a2 instanceof AuthTokenException) {
            return ChatController.m_uea((Object)".\u0004O\u000b\u001a\u001e\u0007\u000f\u0001\u001e\u0006\t\u000e\u001e\u0006\u0005\u0001J\u001b\u0005\u0004\u000f\u0001J\n\u0018\u001d\u0005\u001dJ\u0000\t\f\u001f\u001d\u0018\n\u000e");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return MailerWithSettings.m_ml((Object)"h\tX\tN\t_\r\f\u000bC\u0006_\u001c^\tE\u0006XHZ\u0001C\u0004M\u001cE\u0007B");
        }
        if (a2 instanceof TransactionSystemException) {
            return ChatController.m_uea((Object)"+\u000b\u001b\u000b\r\u000b\u001c\u000fO\u001e\u001d\u000b\u0001\u0019\u000e\t\u001b\u0003\u0000\u0004O\u000f\u001d\u0018\u0000\u0018");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return MailerWithSettings.m_ml((Object)"<E\u0005IH_\r^\u0001I\u001b\f\fM\u001cM\nM\u001bIHI\u001a^\u0007^");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return ChatController.m_uea((Object)"+\f\t\n\u0019\u001cJ\u000b\u000f\u0001\u0003\n\u000e");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return MailerWithSettings.m_ml((Object)"e\u0006Z\t@\u0001HHE\u0006\\\u001dX");
        }
        if (a2 instanceof ConstraintViolationException) {
            return ChatController.m_uea((Object)"<\u000e\u0006\u0006\u000e\u000e\u001e\u0006\u0005\u0001J\f\u0005\u0001\u0019\u001b\u0018\u000e\u0003\u0001\u001eO\u001c\u0006\u0005\u0003\u000b\u001b\u0003\u0000\u0004");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return MailerWithSettings.m_ml((Object)"!B\u001eM\u0004E\f\f\u001aI\u0019Y\r_\u001c\f\u000eC\u001aA\tX");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return ChatController.m_uea((Object)"\"\u0003\u001c\u0019\u0006\u0004\bJ\u001d\u000f\u001e\u001f\u0006\u0018\n\u000eO\u001a\u000e\u0018\u000e\u0007\n\u001e\n\u0018");
        }
        if (a2 instanceof IllegalStateException) {
            return MailerWithSettings.m_ml((Object)"e\u0006Z\t@\u0001HHM\u0018\\\u0004E\u000bM\u001cE\u0007BH_\u001cM\u001cI");
        }
        return ChatController.m_uea((Object)".\u0004O\u001f\u0001\u000f\u0017\u001a\n\t\u001b\u000f\u000bJ\n\u0018\u001d\u0005\u001dJ\u0000\t\f\u001f\u001d\u0018\n\u000e");
    }

    @ExceptionHandler(value={ImportExportException.class})
    protected ResponseEntity<Object> handleImportExportException(ImportExportException importExportException) {
        GeneralExceptionHandler a = importExportException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, IMPORT_EXPORT_ERROR);
    }

    @ExceptionHandler(value={SmsProviderException.class})
    protected ResponseEntity<Object> handleSmsProviderException(SmsProviderException smsProviderException) {
        GeneralExceptionHandler a = smsProviderException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SMS_PROVIDER_ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException illegalArgumentException) {
        IllegalArgumentException a = illegalArgumentException;
        GeneralExceptionHandler a2 = this;
        IllegalArgumentException illegalArgumentException2 = a;
        return a2.buildErrorResponse((Exception)illegalArgumentException2, illegalArgumentException2.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    @ExceptionHandler(value={AlreadyExistsException.class})
    protected ResponseEntity<Object> handleAlreadyExists(AlreadyExistsException alreadyExistsException) {
        GeneralExceptionHandler a = alreadyExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, ALREADY_EXISTS_ERROR);
    }

    private /* synthetic */ boolean isDevelopment() {
        String[] stringArray = this;
        String[] a = stringArray.environment.getActiveProfiles();
        if (a.length == 0) {
            return (3 & 4) != 0;
        }
        return Arrays.asList(a).contains(MailerWithSettings.m_ml((Object)"H\rZ"));
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> map) {
        Map<String, List<String>> a2 = map;
        GeneralExceptionHandler a3 = this;
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)ChatController.m_uea((Object)"CJ"), (Iterable)a.getValue())).collect(Collectors.joining(ChatController.m_uea((Object)"J\u0013J")));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException methodArgumentNotValidException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        object = new HashMap();
        Map status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return MailerWithSettings.m_ml((Object)"&CHA\r_\u001bM\u000fIHM\u001eM\u0001@\tN\u0004I");
        }, Collectors.toList())));
        List a = ex.getBindingResult().getGlobalErrors().stream().map(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return MailerWithSettings.m_ml((Object)"&CHA\r_\u001bM\u000fIHM\u001eM\u0001@\tN\u0004I");
        }).collect(Collectors.toList());
        object.putAll(status);
        if (!a.isEmpty()) {
            object.put(ChatController.m_uea((Object)"\b\u0006\u0000\b\u000e\u0006"), a);
        }
        object = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, headers.formatErrorMessages((Map)object), (Exception)ex, VALIDATION_ERROR, (Map)object);
        log.error(MailerWithSettings.m_ml((Object)">M\u0004E\fM\u001cE\u0007BHI\u001a^\u0007^R\f\u0013Q"), object, (Object)ex);
        return new ResponseEntity(object, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException httpMessageNotReadableException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        generalExceptionHandler2 = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, VALIDATION_ERROR);
        log.error(ChatController.m_uea((Object)"\"\u000f\u001c\u0019\u000e\r\nJ\u0001\u0005\u001bJ\u001d\u000f\u000e\u000e\u000e\b\u0003\u000fUJ\u0014\u0017"), (Object)generalExceptionHandler2, (Object)ex);
        return new ResponseEntity((Object)generalExceptionHandler2, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException influxDBMapperException) {
        GeneralExceptionHandler a = influxDBMapperException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    @ExceptionHandler(value={BroadcastOperationException.class})
    protected ResponseEntity<Object> handleBroadcastOperationException(BroadcastOperationException broadcastOperationException) {
        GeneralExceptionHandler a = broadcastOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROADCAST_OPERATION_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException constraintViolationException) {
        GeneralExceptionHandler a2 = constraintViolationException;
        GeneralExceptionHandler a3 = this;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails((HttpStatusCode)HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, CONSTRAINT_VIOLATION, map);
        log.error(MailerWithSettings.m_ml((Object)"+C\u0006_\u001c^\tE\u0006XHZ\u0001C\u0004M\u001cE\u0007BR\f\u0013Q"), (Object)a2);
        return new ResponseEntity((Object)a2, (HttpStatusCode)HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={RunAsExecutionException.class})
    protected ResponseEntity<Object> handleRunAsExecution(RunAsExecutionException runAsExecutionException) {
        GeneralExceptionHandler a = runAsExecutionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, RUN_AS_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2, Map<String, List<String>> map) {
        void a;
        void a2;
        Object a3;
        void a4;
        String a5;
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler generalExceptionHandler2 = a6 = generalExceptionHandler;
        a5 = generalExceptionHandler2.sanitizeMessage(a5, (Exception)a4);
        String string3 = generalExceptionHandler2.isDevelopment() ? a4.getClass().getName() : MailerWithSettings.m_ml((Object)"i\u0010O\r\\\u001cE\u0007B");
        Object object2 = a6.isDevelopment() ? a3 : ChatController.m_uea((Object)"/\u001d\u0018\u0000\u0018");
        return new ExceptionDetails(a2.value(), a5, string3, (String)object2, (Map)a, (String)(a3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a4) : null), new Date(), a6.getCurrentPath());
    }

    @ExceptionHandler(value={ScriptException.class})
    protected ResponseEntity<Object> handleScriptException(ScriptException scriptException) {
        GeneralExceptionHandler a = scriptException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SCRIPT_ERROR);
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return MailerWithSettings.m_ml((Object)"\u0018M\u001cDGY\u0006G\u0006C\u001fB");
        }
    }

    @ExceptionHandler(value={CommunicationException.class})
    protected ResponseEntity<Object> handleCommunicationException(CommunicationException communicationException) {
        GeneralExceptionHandler a = communicationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, COMMUNICATION_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException methodArgumentTypeMismatchException) {
        GeneralExceptionHandler a = methodArgumentTypeMismatchException;
        GeneralExceptionHandler a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = a.getName();
        objectArray[3 >> 1] = a.getValue();
        objectArray[1 ^ 3] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : MailerWithSettings.m_ml((Object)"Y\u0006G\u0006C\u001fB");
        String string = ChatController.m_uea((Object)"?\u000b\u001d\u000b\u0002\u000f\u001b\u000f\u001dJHO\u001cMO\u001d\u0006\u001e\u0007J\u0019\u000b\u0003\u001f\nJHO\u001cMO\t\u0000\u001f\u0003\u000eO\u0004\u0000\u001eO\b\nJ\f\u0005\u0001\u001c\n\u0018\u001b\u000f\u000bJ\u001b\u0005O\u001e\u0016\u001a\nJHO\u001cM").formatted(objectArray);
        return a2.buildErrorResponse((Exception)a, string, (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    @ExceptionHandler(value={RelationExistsException.class})
    protected ResponseEntity<Object> handleRelationExists(RelationExistsException relationExistsException) {
        GeneralExceptionHandler a = relationExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, RELATION_EXISTS_ERROR);
    }

    @ExceptionHandler(value={NotActiveException.class})
    protected ResponseEntity<Object> handleNotActive(NotActiveException notActiveException) {
        GeneralExceptionHandler a = notActiveException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, NOT_ACTIVE_ERROR);
    }

    @ExceptionHandler(value={BrowseOperationException.class})
    protected ResponseEntity<Object> handleBrowseOperationException(BrowseOperationException browseOperationException) {
        GeneralExceptionHandler a = browseOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROWSE_OPERATION_ERROR);
    }

    @ExceptionHandler(value={MismatchException.class})
    protected ResponseEntity<Object> handleMismatch(MismatchException mismatchException) {
        GeneralExceptionHandler a = mismatchException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, MISMATCH_ERROR);
    }

    @ExceptionHandler(value={SpaceOperationException.class})
    protected ResponseEntity<Object> handleSpaceOperationException(SpaceOperationException spaceOperationException) {
        GeneralExceptionHandler a = spaceOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SPACE_OPERATION_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2) {
        Object a;
        void a2;
        void a3;
        void a4;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler a5 = generalExceptionHandler;
        return a5.createExceptionDetails((HttpStatusCode)a4, (String)a3, (Exception)a2, (String)a, null);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException missingServletRequestParameterException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = missingServletRequestParameterException;
        GeneralExceptionHandler ex = generalExceptionHandler;
        Object[] objectArray = new Object[1 ^ 3];
        objectArray[3 ^ 3] = generalExceptionHandler2.getParameterName();
        objectArray[2 ^ 3] = generalExceptionHandler2.getParameterType();
        ExceptionDetails headers = ex.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, ChatController.m_uea((Object)"8\n\u001b\u001a\u0003\u001d\u000f\u000bJ\u001f\u000b\u001d\u000b\u0002\u000f\u001b\u000f\u001dJHO\u001cMO\u0005\tJ\u001b\u0013\u001f\u000fOMJ\u0019HJ\u0006\u0019O\u0007\u0006\u0019\u001c\u0003\u0001\r").formatted(objectArray), (Exception)generalExceptionHandler2, VALIDATION_ERROR);
        log.error(MailerWithSettings.m_ml((Object)"a\u0001_\u001bE\u0006KH\\\t^\tA\rX\r^R\f\u0013Q"), (Object)headers, (Object)generalExceptionHandler2);
        return new ResponseEntity((Object)headers, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    protected ResponseEntity<Object> handleSecurityExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.FORBIDDEN, SECURITY_ERROR);
    }

    @ExceptionHandler(value={InscadaException.class})
    protected ResponseEntity<Object> handleInscadaException(InscadaException inscadaException) {
        GeneralExceptionHandler a = inscadaException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    private /* synthetic */ boolean isSseRequest() {
        block5: {
            ServletRequestAttributes servletRequestAttributes;
            block4: {
                GeneralExceptionHandler generalExceptionHandler = this;
                try {
                    servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                    if (servletRequestAttributes != null) break block4;
                    return false;
                }
                catch (Exception exception) {
                    return 5 >> 3;
                }
            }
            HttpServletRequest httpServletRequest = servletRequestAttributes.getRequest();
            String string = httpServletRequest.getHeader(ChatController.m_uea((Object)".\t\f\u000f\u001f\u001e"));
            String a = httpServletRequest.getHeader("Content-Type");
            if ((string == null || !string.contains(MailerWithSettings.m_ml((Object)"X\rT\u001c\u0003\rZ\rB\u001c\u0001\u001bX\u001aI\tA"))) && (a == null || !a.contains(ChatController.m_uea((Object)"\u001e\n\u0012\u001bE\n\u001c\n\u0004\u001bG\u001c\u001e\u001d\u000f\u000e\u0007")))) break block5;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={TransactionSystemException.class})
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException transactionSystemException) {
        void a;
        GeneralExceptionHandler generalExceptionHandler = this;
        Object a2 = a.getRootCause();
        if (a2 instanceof ConstraintViolationException) {
            a2 = (ConstraintViolationException)a2;
            return generalExceptionHandler.handleConstraintViolation((ConstraintViolationException)a2);
        }
        void v0 = a;
        return generalExceptionHandler.buildErrorResponse((Exception)v0, ExceptionUtils.getRootCauseMessage((Throwable)v0), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ResponseEntity<Object> buildErrorResponse(Exception exception, String string, HttpStatusCode httpStatusCode, String string2) {
        void a;
        void a2;
        void a3;
        Object a4 = string;
        GeneralExceptionHandler a5 = this;
        a4 = a5.createExceptionDetails((HttpStatusCode)a3, (String)a4, (Exception)a2, (String)a, null);
        log.error(ChatController.m_uea((Object)"&\u0004\u001b\u000f\u001d\u0004\u000e\u0006O\u000f\u001d\u0018\u0000\u0018UJ\u0014\u0017"), a4, (Object)a2);
        return new ResponseEntity(a4, (HttpStatusCode)a3);
    }

    @ExceptionHandler(value={NotFoundException.class, EntityNotFoundException.class})
    protected ResponseEntity<Object> handleEntityNotFound(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND, NOT_FOUND_ERROR);
    }

    @ExceptionHandler(value={ParsingException.class})
    protected ResponseEntity<Object> handleParsingException(ParsingException parsingException) {
        GeneralExceptionHandler a = parsingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, PARSING_ERROR);
    }

    @ExceptionHandler(value={SettingsException.class})
    protected ResponseEntity<Object> handleSettingsException(SettingsException settingsException) {
        GeneralExceptionHandler a = settingsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SETTINGS_ERROR);
    }
}

