/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.services;

import com.inscada.mono.auth.c_mj;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.manager.LeaderFencedManager;
import com.inscada.mono.cluster.services.c_H;
import com.inscada.mono.impexp.model.ExtractedItem;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.r.c_Gd;
import com.inscada.mono.log.e.c_eC;
import com.inscada.mono.project.e.c_I;
import com.inscada.mono.project.e.c_wB;
import com.inscada.mono.script.e.c_Wb;
import com.inscada.mono.script.e.c_lC;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.script.r.c_Fc;
import com.inscada.mono.script.r.c_Pd;
import com.inscada.mono.script.services.c_ZB;
import com.inscada.mono.script.services.c_tC;
import com.inscada.mono.script.services.c_wC;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ScriptManager
extends LeaderFencedManager
implements c_I {
    private final c_Gd f_cc;
    private final c_tC f_eC;
    public static final short f_Wb = 304;
    public static final short f_mB = 303;
    private final c_wC f_Qc;
    public static final short f_cB = 301;
    private static final Logger f_td = LoggerFactory.getLogger(ScriptManager.class);
    private final JedisPooled f_Hd;
    public static final short f_Mb = 307;
    private final Lock f_QB;
    public static final short f_SA = 306;
    private final c_eC f_GB;
    private final Map<String, Job> f_XA;
    public static final short f_Cd = 305;
    private static final String f_oB = "scheduled_scripts";
    private final c_mj f_bC;
    public static final short f_Nc = 302;

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(c_wB.m_sj((Object)"{+v*r<\rNd\r_\u000bS\u001b[\u0007Y\t\u0017\u001dT\u001c^\u001eCNL\u0013\u0017\u0002X\rV\u0002[\u0017\u0019"), a);
            a2.scheduleScriptInternal((String)a);
            return;
        }
        f_td.debug(ExtractedItem.m_qM((Object)"_J_(]@PATW+%C``ptvel\u007fb1itdu`c%ej1vrmtadit%bfclaq1~l+"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[5 >> 3] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x5AF & 0x7B7D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule script " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_Fc getScriptStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_eC.m_eg((String)a2, (String)a)) == null) {
            return c_Fc.f_aA;
        }
        return a3.getScriptStatus(a2.getId());
    }

    private /* synthetic */ void lambda$cancelScriptInternal$9(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_QB.lock();
        try {
            Job job = (Job)a2.f_XA.get(a.getId());
            if (job != null) {
                a2.f_cc.m_qn(job);
            }
            ScriptManager scriptManager = a2;
            scriptManager.f_XA.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[3 & 4] = a.getId();
            scriptManager.f_Hd.srem(f_oB, stringArray);
            return;
        }
        finally {
            a2.f_QB.unlock();
        }
    }

    protected void scheduleScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_bC.m_gEa(() -> a2.lambda$scheduleScriptInternal$4((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(ExtractedItem.m_qM((Object)"ITDU@C?1Fpkr`}ixkv%bfclaq1~l%}jrd}ih+"), a);
            a2.cancelScriptInternal((String)a);
            return;
        }
        f_td.debug(c_wB.m_sj((Object)" x \u001a\"r/s+eT\u0017<R\u001fB\u000bD\u001a^\u0000PN[\u000bV\nR\u001c\u0017\u001aXNT\u000fY\rR\u0002\u0017\u001dT\u001c^\u001eCNL\u0013\u0019"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[2 & 5] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x41EF & 0x3F3E)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel script " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Job createDailyScriptJob(RepeatableScript repeatableScript) {
        String string;
        void a;
        ScriptManager scriptManager = this;
        Object a2 = a.getTime();
        a2 = LocalTime.of(((Date)a2).getHours(), ((Date)a2).getMinutes(), ((Date)a2).getSeconds());
        ScriptManager scriptManager2 = scriptManager;
        String string2 = string = scriptManager2.generateJobName((RepeatableScript)a);
        return scriptManager2.f_cc.m_ym(a.getProject(), string2, scriptManager.fenced(string2, () -> scriptManager.lambda$createDailyScriptJob$8((RepeatableScript)a)), (LocalTime)a2);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.cancelScript(scriptManager.f_eC.m_SE((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    public ScriptManager(c_tC c_tC2, c_Gd c_Gd2, c_wC c_wC2, c_eC c_eC2, JedisPooled jedisPooled, c_H c_H2, c_mj c_mj2) {
        ScriptManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ScriptManager a8;
        ScriptManager scriptManager = scriptManager2;
        ScriptManager scriptManager2 = c_mj2;
        ScriptManager scriptManager3 = a8 = scriptManager;
        ScriptManager scriptManager4 = a8;
        ScriptManager scriptManager5 = a8;
        super((c_H)a7);
        ScriptManager scriptManager6 = a8;
        a8.f_QB = new ReentrantLock();
        scriptManager6.f_XA = new ConcurrentHashMap();
        scriptManager5.f_eC = a6;
        scriptManager5.f_cc = a5;
        scriptManager4.f_Qc = a4;
        scriptManager4.f_GB = a3;
        scriptManager3.f_Hd = a2;
        scriptManager3.f_bC = a;
    }

    @TransactionalEventListener(value={c_Wb.class})
    public void handleRescheduleEvent(c_Wb c_Wb2) {
        ScriptManager scriptManager = this;
        if (scriptManager.f_XC.m_da()) {
            ScriptManager a = a.m_tg();
            f_td.info(ExtractedItem.m_qM((Object)"]@PATW+%Yd\u007fa}l\u007fb1Wtvrmtadit@g`\u007fq1c~w1vrwxue?1~l%9LU?1~l,"), (Object)a.getName(), (Object)a.getId());
            if (scriptManager.getScriptStatusInternal(a.getId()) == c_Fc.f_kA) {
                scriptManager.scheduleScriptInternal(a.getId());
                return;
            }
        } else {
            f_td.debug(c_wB.m_sj((Object)"y!yC{+v*r<\rN~\tY\u0001E\u0007Y\t\u0017<R\u001dT\u0006R\nB\u0002R+A\u000bY\u001a\u0017\bX\u001c\u0017\u001dT\u001c^\u001eCT\u0017\u0015J"), (Object)a.m_tg().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_lC.class})
    public void handleCancelEvent(c_lC c_lC2) {
        void a;
        ScriptManager scriptManager = this;
        if (scriptManager.f_XC.m_da()) {
            ScriptManager a2 = a.m_hG();
            f_td.info(ExtractedItem.m_qM((Object)"]@PATW+%Yd\u007fa}l\u007fb1Fpkr`}@g`\u007fq1c~w1vrwxue?1~l%9LU?1~l,"), (Object)a2.getName(), (Object)a2.getId());
            scriptManager.cancelScriptInternal((RepeatableScript)a2);
            return;
        }
        f_td.debug(c_wB.m_sj((Object)"y!yC{+v*r<\rN~\tY\u0001E\u0007Y\t\u0017-V\u0000T\u000b[+A\u000bY\u001a\u0017\bX\u001c\u0017\u001dT\u001c^\u001eCT\u0017\u0015J"), (Object)a.m_hG().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_Fc> getScriptStatuses(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(c_wB.m_sj((Object)"{+v*r<\rNp\u000bC\u001a^\u0000PNV\u0002[ND\rE\u0007G\u001a\u0017\u001dC\u000fC\u001bD\u000bDNQ\u0001ENG\u001cX\u0004R\rCNL\u0013\u0017\u0002X\rV\u0002[\u0017\u0019"), a);
            return a2.getScriptStatusesByProjectIdInternal((String)a);
        }
        f_td.debug(ExtractedItem.m_qM((Object)"K^K<ITDU@C?1Wttd`bqxkv%}`patw1c~w1d}i1vrwxue%bqpqdvtv1c~w1ucj{`rq1~l+"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_XC.m_Fa(Short.valueOf((short)(0x1DFB & 0x6337)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a22 = (Job)scriptManager.f_XA.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_td.info(ExtractedItem.m_qM((Object)"VrwxueHpkpbtw1-_je%]`patw1~l,+%Rd\u007ffti}l\u007fb1i~fpi1o~g1c~w1vrwxue%XA+%jx"), (Object)a3, (Object)a);
                scriptManager.f_cc.m_qn((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 >> 2] = a3;
                objectArray[--1] = a;
                objectArray[5 >> 1] = a22.getMessage();
                objectArray[--3] = a22;
                f_td.error(c_wB.m_sj((Object)"=T\u001c^\u001eC#V\u0000V\tR\u001c\u0017Fy\u0001CN{\u000bV\nR\u001c\u0017\u0015JG\rNr\u001cE\u0001ENT\u000fY\rR\u0002[\u0007Y\t\u0017\u0002X\rV\u0002\u0017\u0004X\f\u0017\bX\u001c\u0017\u001dT\u001c^\u001eCN~*\u0017\u0015JT\u0017\u0015J"), objectArray);
            }
        }
    }

    private /* synthetic */ void lambda$createPeriodicScriptJob$7(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_Qc.m_jh((Script)a);
    }

    protected Map<String, c_Fc> getScriptStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getScriptStatusInternal(arg_0)));
    }

    protected void cancelScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_bC.m_gEa(() -> a2.lambda$cancelScriptInternal$9((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    protected void cancelScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.cancelScriptInternal(scriptManager.f_eC.m_UF((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$createOnceScriptJob$6(RepeatableScript repeatableScript) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a2 = Script.newBuilder((RepeatableScript)a).build();
        scriptManager.f_Qc.m_jh((Script)a2);
        scriptManager.cancelScript(a.getId());
    }

    private /* synthetic */ void lambda$createDailyScriptJob$8(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_Qc.m_jh((Script)a);
    }

    private /* synthetic */ Job createOnceScriptJob(RepeatableScript repeatableScript) {
        String string;
        ScriptManager a;
        ScriptManager a2 = repeatableScript;
        ScriptManager scriptManager = a = this;
        String string2 = string = scriptManager.generateJobName((RepeatableScript)a2);
        return scriptManager.f_cc.m_Cm(a2.getProject(), string2, a.fenced(string2, () -> a.lambda$createOnceScriptJob$6((RepeatableScript)a2)), Duration.ofMillis(a2.getDelay().intValue()), 5 >> 3);
    }

    public void notLeader() {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        Object a = scriptManager2.f_XC.m_La();
        f_td.info(c_wB.m_sj((Object)"=T\u001c^\u001eC#V\u0000V\tR\u001c\rNc\u0006^\u001d\u0017\u0000X\nRN\u001f\u0015JG\u0017\u0007DNy!\u0017\"x p+eNc&rN{+v*r<\u0019Nt\u000fY\rR\u0002[\u0007Y\t\u0017\u000f[\u0002\u0017\u0002X\rV\u0002\u0017\u001dT\u001c^\u001eCN]\u0001U\u001d\u0019@\u0019"), a);
        scriptManager2.f_QB.lock();
        try {
            new ArrayList(scriptManager.f_XA.keySet()).forEach(arg_0 -> scriptManager.lambda$notLeader$2((String)a, arg_0));
            scriptManager.f_XA.clear();
            f_td.info(ExtractedItem.m_qM((Object)"VrwxueHpkpbtw1-_je%]`patw1~l,+%Pi}%}jrd}%bfclaq1o~gb%ydg`1gt`\u007f%c``ptve`u%ej1fpkr`}%pku%ritdc`u%ww~h1i~fpi1qcdrnxkv+"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_td.error(c_wB.m_sj((Object)"d\rE\u0007G\u001az\u000fY\u000fP\u000bEN\u001f X\u001a\u0017\"R\u000fS\u000bENL\u0013\u001eT\u0017+E\u001cX\u001c\u0017\nB\u001c^\u0000PNG\u001cX\rR\u001dDNX\b\u0017\rV\u0000T\u000b[\u0002^\u0000PN[\u0001T\u000f[ND\rE\u0007G\u001a\u0017\u0004X\fDT\u0017\u0015J"), objectArray);
            return;
        }
        finally {
            scriptManager.f_QB.unlock();
        }
    }

    protected Map<String, c_Fc> getScriptStatusesByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_eC.m_Li((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(RepeatableScriptSummary::getId, repeatableScriptSummary -> {
            ScriptManager a = repeatableScriptSummary;
            ScriptManager a2 = this;
            return a2.getScriptStatusInternal(a.getId());
        }));
    }

    private /* synthetic */ Job createPeriodicScriptJob(RepeatableScript repeatableScript) {
        String string;
        ScriptManager a;
        ScriptManager a2 = repeatableScript;
        ScriptManager scriptManager = a = this;
        String string2 = string = scriptManager.generateJobName((RepeatableScript)a2);
        return scriptManager.f_cc.m_qO(a2.getProject(), string2, a.fenced(string2, () -> a.lambda$createPeriodicScriptJob$7((RepeatableScript)a2)), Duration.ofMillis(a2.getPeriod().intValue()), a2.getOffset());
    }

    protected c_Fc getScriptStatusInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_XA.containsKey(a)) {
            return c_Fc.f_kA;
        }
        return c_Fc.f_aA;
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(ExtractedItem.m_qM((Object)"]@PATW+%Rd\u007ffti}l\u007fb1d}i1vrwxuev1c~w1ucj{`rq1~l%}jrd}ih+"), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(c_wB.m_sj((Object)"y!yC{+v*r<\rNe\u000bF\u001bR\u001dC\u0007Y\t\u0017\u0002R\u000fS\u000bENC\u0001\u0017\rV\u0000T\u000b[NV\u0002[ND\rE\u0007G\u001aDNQ\u0001ENG\u001cX\u0004R\rCNL\u0013\u0019"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x7171 & 0xFBF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel scripts for project " + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleScriptsByProjectIdInternal(String string) {
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_eC.m_gf((String)a2)) == null || a2.isEmpty()) {
            return;
        }
        a2.stream().filter(a -> {
            if (a.getType() != c_Pd.f_GC) {
                return (3 & 5) != 0;
            }
            return false;
        }).forEach(arg_0 -> a3.scheduleScriptInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.scheduleScript(scriptManager.f_eC.m_SE((String)a, (String)a3).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader(long l) {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        String a = scriptManager2.f_XC.m_La();
        f_td.info(ExtractedItem.m_qM((Object)"VrwxueHpkpbtw+%Emxv1k~at%9~l,1mpv1gtf~ht%emt%]@PATW?%C`bq~wxkv%bfy`up}`u%bfclaqb+?+"), (Object)a);
        scriptManager2.f_QB.lock();
        try {
            HashSet hashSet = new HashSet(scriptManager.f_Hd.smembers(f_oB));
            if (hashSet.isEmpty()) {
                f_td.info(c_wB.m_sj((Object)"=T\u001c^\u001eC#V\u0000V\tR\u001c\u0017F{\u000bV\nR\u001c\u0017\u0015JG\rNy\u0001\u0017\u001dT\u0006R\nB\u0002R\n\u0017\u001dT\u001c^\u001eC\u001d\u0017\bX\u001bY\n\u0017\u0007YNe\u000bS\u0007DNC\u0001\u0017\u001cR\u001dC\u0001E\u000b\u0019"), (Object)a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[2 ^ 3] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_td.info(ExtractedItem.m_qM((Object)"Bfclaq\\d\u007fdv`c%9Itdu`c%jx8?1C~p\u007fa1~l%bfy`up}`u%bfclaq1LUv1l\u007f%C`ulb%ej1wtvejc`+%jx"), objectArray);
            ArrayList a2 = new ArrayList();
            String[] stringArray = new String[5 >> 2];
            stringArray[5 >> 3] = c_wB.m_sj((Object)"a'r9h=t<~>c");
            scriptManager.f_bC.m_Sea(() -> {
                void a;
                Object a2 = hashSet;
                ScriptManager a3 = this;
                a.addAll(a3.f_eC.m_aG((Set)a2));
            }, stringArray);
            f_td.info(ExtractedItem.m_qM((Object)"Bfclaq\\d\u007fdv`c%9Itdu`c%jx8?1Deqthaqxkv%ej1wtvejc`1~l%bfclaqb+"), (Object)a, (Object)a2.size());
            a2.forEach(repeatableScript -> {
                void a;
                ScriptManager scriptManager;
                ScriptManager scriptManager2 = scriptManager = this;
                Object a2 = scriptManager2.f_XC.m_La();
                String[] stringArray = new String[--2];
                stringArray[3 ^ 3] = c_wB.m_sj((Object)"d-\u007f+s;{+h=t<~>c");
                stringArray[5 >> 2] = ExtractedItem.m_qM((Object)"FPKR@]ZBFCLAQ");
                scriptManager2.f_bC.m_XFa(() -> scriptManager.lambda$restoreSingleScriptOnLeader$1((String)a2, (RepeatableScript)a), a.getSpace(), stringArray);
            });
            f_td.info(c_wB.m_sj((Object)"d\rE\u0007G\u001az\u000fY\u000fP\u000bEN\u001f\"R\u000fS\u000bENL\u0013\u001eT\u0017(^\u0000^\u001d_\u000bSND\rE\u0007G\u001a\u0017\u001cR\u001dC\u0001E\u000fC\u0007X\u0000\u0017\u001eE\u0001T\u000bD\u001d\u0019"), (Object)a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_td.error(ExtractedItem.m_qM((Object)"Bfclaq\\d\u007fdv`c%9Itdu`c%jx8?1@cw~w1adwxkv%bfclaq1wtvejcdel~k1ucjr`bv+%jx"), objectArray);
            return;
        }
        finally {
            scriptManager.f_QB.unlock();
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ScriptManager a;
        a.registerRemoteCallsWithClusterNode();
        f_td.info(c_wB.m_sj((Object)"=T\u001c^\u001eC#V\u0000V\tR\u001c\u0017\u0007Y\u0007C\u0007V\u0002^\u0014R\n\u0017\u000fY\n\u0017\u001cR\t^\u001dC\u000bE\u000bSNV\u001d\u0017-[\u001bD\u001aR\u001cy\u0001S\u000b{\u0007D\u001aR\u0000R\u001c\u0019"));
    }

    protected void scheduleScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.scheduleScriptInternal(scriptManager.f_eC.m_UF((String)a2));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(c_wB.m_sj((Object)"\"r/s+eT\u0017=T\u0006R\nB\u0002^\u0000PNV\u0002[ND\rE\u0007G\u001aDNQ\u0001ENG\u001cX\u0004R\rCNL\u0013\u0017\u0002X\rV\u0002[\u0017\u0019"), a);
            a2.scheduleScriptsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(ExtractedItem.m_qM((Object)"K^K<ITDU@C?1Wttd`bqxkv%}`patw1q~%bfy`up}`1d}i1vrwxuev1c~w1ucj{`rq1~l+"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x2BFE & 0x5531)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule scripts for project " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ScriptManager scriptManager = this;
        try {
            Class[] classArray = new Class[4 ^ 5];
            classArray[3 ^ 3] = String.class;
            scriptManager.f_XC.m_Ja((short)(0x2D7F & 0x53AD), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ExtractedItem.m_qM((Object)"bfy`up}`BfclaqXke`ckpi"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[5 >> 3] = String.class;
            scriptManager.f_XC.m_Ja((short)(0x172E & 0x69FF), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_wB.m_sj((Object)"\rV\u0000T\u000b[=T\u001c^\u001eC'Y\u001aR\u001cY\u000f["), classArray2));
            Class[] classArray3 = new Class[--1];
            classArray3[5 >> 3] = String.class;
            scriptManager.f_XC.m_Ja((short)(0x6BBF & 0x156F), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ExtractedItem.m_qM((Object)"btqBfclaqBqpqdvXke`ckpi"), classArray3));
            Class[] classArray4 = new Class[3 & 5];
            classArray4[3 >> 2] = String.class;
            scriptManager.f_XC.m_Ja((short)(0x47B0 & 0x397F), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_wB.m_sj((Object)"\u001dT\u0006R\nB\u0002R=T\u001c^\u001eC\u001du\u0017g\u001cX\u0004R\rC'S'Y\u001aR\u001cY\u000f["), classArray4));
            Class[] classArray5 = new Class[2 ^ 3];
            classArray5[2 & 5] = String.class;
            scriptManager.f_XC.m_Ja((short)(0x2B3F & 0x55F1), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ExtractedItem.m_qM((Object)"rd\u007fftiBfclaqbGhUcj{`rqXaXke`ckpi"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            scriptManager.f_XC.m_Ja((short)(0x293B & 0x57F6), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_wB.m_sj((Object)"\tR\u001ad\rE\u0007G\u001ad\u001aV\u001aB\u001dR\u001du\u0017~\nD'Y\u001aR\u001cY\u000f["), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            scriptManager.f_XC.m_Ja((short)(0x517F & 0x2FB3), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ExtractedItem.m_qM((Object)"v`eVrwxueVedepb`bGhUcj{`rqXaXke`ckpi"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_wB.m_sj((Object)"(V\u0007[\u000bSNC\u0001\u0017\u001cR\t^\u001dC\u000bENd\rE\u0007G\u001az\u000fY\u000fP\u000bENe>tNZ\u000bC\u0006X\nD"), a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_Fc getScriptStatus(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(ExtractedItem.m_qM((Object)"ITDU@C?1Btqel\u007fb1vrwxue%bqpqdv1c~w1~l%}jrd}ih+"), a);
            return a2.getScriptStatusInternal((String)a);
        }
        f_td.debug(c_wB.m_sj((Object)"y!yC{+v*r<\rNe\u000bF\u001bR\u001dC\u0007Y\t\u0017\u0002R\u000fS\u000bENQ\u0001END\rE\u0007G\u001a\u0017\u001dC\u000fC\u001bDNQ\u0001ENL\u0013\u0019"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 >> 2] = a;
            return (c_Fc)a2.f_XC.m_Fa(Short.valueOf((short)(0x45AF & 0x3B7F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script status for " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_Fc> getScriptStatuses(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_XC.m_da()) {
            f_td.debug(ExtractedItem.m_qM((Object)"]@PATW+%V`eqxkv%bfclaq1vedepb`b%wjc%jx1LUv1i~fpi}|+%jx"), (Object)a.size(), (Object)a);
            return a2.getScriptStatusesByIdsInternal((List)a);
        }
        f_td.debug(c_wB.m_sj((Object)" x \u001a\"r/s+eT\u0017<R\u001fB\u000bD\u001a^\u0000PN[\u000bV\nR\u001c\u0017\bX\u001c\u0017\u001dT\u001c^\u001eCND\u001aV\u001aB\u001dR\u001d\u0017\bX\u001c\u0017\u0015JN~*DT\u0017\u0015J"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = new ArrayList(a);
            return (Map)a2.f_XC.m_Fa(Short.valueOf((short)(0x537 & 0x7BFA)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(ExtractedItem.m_qM((Object)")"))), (Throwable)exception);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.info(ExtractedItem.m_qM((Object)"]@PATW+%Yd\u007fa}l\u007fb1Ucj{`rqU`pfelgde`Tstke%wjc%aw~otfe%XA+%jx"), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(c_wB.m_sj((Object)" x \u001a\"r/s+eT\u0017'P\u0000X\u001c^\u0000PNg\u001cX\u0004R\rC*R\u000fT\u001a^\u0018V\u001aR+A\u000bY\u001a\u0017\bX\u001c\u0017\u001eE\u0001]\u000bT\u001a\u0017'sT\u0017\u0015J"), a);
    }

    protected void cancelScriptsByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_eC.m_gf((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelScriptInternal(arg_0));
    }

    private /* synthetic */ String generateJobName(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        Object[] objectArray = new Object[5 >> 1];
        objectArray[3 & 4] = a.getType().m_yG();
        objectArray[--1] = a.getName();
        return c_wB.m_sj((Object)"KDNd\rE\u0007G\u001a\u0017C\u0017KD").formatted(objectArray);
    }

    private /* synthetic */ void lambda$scheduleScriptInternal$4(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_QB.lock();
        try {
            Job job;
            ScriptManager scriptManager;
            block14: {
                a2.cancelScriptInternal((RepeatableScript)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to schedule script " + a.getName());
                }
                switch (c_ZB.f_qC[a.getType().ordinal()]) {
                    case 1: {
                        ScriptManager scriptManager2 = a2;
                        while (false) {
                        }
                        scriptManager = scriptManager2;
                        job = scriptManager2.createDailyScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 2: {
                        ScriptManager scriptManager3 = a2;
                        scriptManager = scriptManager3;
                        job = scriptManager3.createPeriodicScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 3: {
                        job = a2.createOnceScriptJob((RepeatableScript)a);
                        break;
                    }
                    case 4: {
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown schedule type of " + String.valueOf(a.getType()));
                    }
                }
                scriptManager = a2;
            }
            scriptManager.f_XA.put(a.getId(), job);
            String[] stringArray = new String[--1];
            stringArray[2 & 5] = a.getId();
            a2.f_Hd.sadd(f_oB, stringArray);
            return;
        }
        finally {
            a2.f_QB.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleScriptOnLeader$1(String string, RepeatableScript repeatableScript) {
        void a;
        ScriptManager a2 = repeatableScript;
        ScriptManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[3 & 5] = a2.getName();
            objectArray[--2] = a2.getId();
            f_td.info(ExtractedItem.m_qM((Object)"Bfclaq\\d\u007fdv`c%9Itdu`c%jx8?1Wtvejcl\u007fb1vrwxue?1~l%9LU?1~l,"), objectArray);
            a3.scheduleScriptInternal((RepeatableScript)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a2.getName();
            objectArray[3 >> 1] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_GB.m_Tk(a2.getProject()).m_T("Script Restore (Leader " + (String)a + ")", c_wB.m_sj((Object)"KDN\u001f'sT\u0017KDG\u0017\bV\u0007[\u000bSNC\u0001\u0017\u001cR\u001dC\u0001E\u000b\u0019Nt\u000fB\u001dRT\u0017KD").formatted(objectArray));
            try {
                f_td.warn(ExtractedItem.m_qM((Object)"Bfclaq\\d\u007fdv`c%9Itdu`c%jx8?1Deqthaqxkv%ej1fpkr`}%bfclaq1~l%pce`c%c`bq~wpqxj\u007f%wdxidwt+"), (Object)a, (Object)a2.getId());
                a3.cancelScriptInternal((RepeatableScript)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[3 >> 1] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_td.error(c_wB.m_sj((Object)"d\rE\u0007G\u001az\u000fY\u000fP\u000bEN\u001f\"R\u000fS\u000bENL\u0013\u001eT\u0017(V\u0007[\u000bSNC\u0001\u0017\rV\u0000T\u000b[ND\rE\u0007G\u001a\u0017\u0015JNV\bC\u000bENE\u000bD\u001aX\u001cV\u001a^\u0001YNQ\u000f^\u0002B\u001cRT\u0017\u0015J"), objectArray2);
                return;
            }
        }
    }
}

