/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.services;

import com.inscada.mono.alarm.model.FiredAlarmList;
import com.inscada.mono.auth.c_mj;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.manager.LeaderFencedManager;
import com.inscada.mono.cluster.services.c_H;
import com.inscada.mono.job.model.DailyJob;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.MonthlyJob;
import com.inscada.mono.job.r.c_Gd;
import com.inscada.mono.log.e.c_eC;
import com.inscada.mono.project.e.c_I;
import com.inscada.mono.report.e.c_LC;
import com.inscada.mono.report.e.c_gb;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportSummary;
import com.inscada.mono.report.r.c_Tb;
import com.inscada.mono.report.r.c_mC;
import com.inscada.mono.report.services.c_MB;
import com.inscada.mono.report.services.c_yC;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.repositories.BaseInfluxRepository;
import jakarta.annotation.PostConstruct;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ReportManager
extends LeaderFencedManager
implements c_I {
    public static final short f_Uf = 506;
    private final c_yC f_DE;
    private static final String f_sE = "scheduledReports";
    public static final short f_re = 504;
    public static final short f_nD = 501;
    private final JedisPooled f_lF;
    public static final short f_wE = 503;
    public static final short f_ID = 502;
    private final Map<String, List<Job>> f_JF;
    private static final Logger f_td = LoggerFactory.getLogger(ReportManager.class);
    private final Lock f_Rf;
    private final c_Gd f_Wf;
    private final c_eC f_Ve;
    public static final short f_Sf = 507;
    private final c_mj f_Ee;
    public static final short f_oE = 505;
    private final c_MB f_hf;

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(BaseInfluxRepository.m_oK((Object)"b6o7k!\u0014S}\u0010F\u0016J\u0006B\u001a@\u0014\u000e\u0001K\u0003A\u0001ZSU\u000e\u000e\u001fA\u0010O\u001fB\n\u0000"), a);
            a2.scheduleReportInternal((String)a);
            return;
        }
        f_td.debug(FiredAlarmList.m_ala((Object)"|`|\u0002~jskw}\b\u000f`JCZW\\FF\\H\u0012CWNVJ@\u000fF@\u0012\\QGWKGCW\u000f@JB@@[\u0012TO\u0001"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x4FF7 & 0x31FD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule report " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_Tb getReportStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ReportManager a3 = this;
        if ((a2 = a3.f_hf.m_lG((String)a2, (String)a)) == null) {
            return c_Tb.f_gF;
        }
        return a3.getReportStatus(a2.getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<String, c_Tb> getReportStatuses(List<String> list) {
        List<String> a = list;
        ReportManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_XC.m_da()) {
            f_td.debug(FiredAlarmList.m_ala((Object)"~jskw}\b\u000fuJF[[AU\u000f@JB@@[\u0012\\FNFZAJA\u000fT@@\u000fIR\u0012fv\\\u0012C]LSC^V\b\u000fIR"), (Object)a.size(), (Object)a);
            return a2.getReportStatusesByIdsInternal((List)a);
        }
        f_td.debug(BaseInfluxRepository.m_oK((Object)"=a=\u0003?k2j6|I\u000e!K\u0002[\u0016]\u0007G\u001dISB\u0016O\u0017K\u0001\u000e\u0015A\u0001\u000e\u0001K\u0003A\u0001ZS]\u0007O\u0007[\u0000K\u0000\u000e\u0015A\u0001\u000e\bSSg7]I\u000e\bS"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[2 & 5] = new ArrayList(a);
            return (Map)a2.f_XC.m_Fa(Short.valueOf((short)(0x31FE & 0x4FFB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get report statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(FiredAlarmList.m_ala((Object)"\u0003"))), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader(long l) {
        ReportManager reportManager;
        ReportManager reportManager2 = reportManager = this;
        String a = reportManager2.f_XC.m_La();
        f_td.info(FiredAlarmList.m_ala((Object)"}W_]]FbSASHW]\b\u000ffG[\\\u0012A]KW\u000f\u001aTO\u0006\u0012GS\\\u0012MWL]BW\u000fFGW\u000f~jskw}\u001c\u000f`JA[]][AU\u000fALZJVZ^JV\u000f@JB@@[A\u0001\u001c\u0001"), (Object)a);
        reportManager2.f_Rf.lock();
        try {
            HashSet hashSet = new HashSet(reportManager.f_lF.smembers(f_sE));
            if (hashSet.isEmpty()) {
                f_td.info(BaseInfluxRepository.m_oK((Object)"!K\u0003A\u0001Z>O\u001dO\u0014K\u0001\u000e[b\u0016O\u0017K\u0001\u000e\bSZ\u0014S`\u001c\u000e\u0000M\u001bK\u0017[\u001fK\u0017\u000e\u0001K\u0003A\u0001Z\u0000\u000e\u0015A\u0006@\u0017\u000e\u001a@S|\u0016J\u001a]SZ\u001c\u000e\u0001K\u0000Z\u001c\\\u0016\u0000"), (Object)a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[2 ^ 3] = hashSet.size();
            objectArray[--2] = hashSet;
            f_td.info(FiredAlarmList.m_ala((Object)"`JB@@[\u007fN\\NUJ@\u000f\u001acWNVJ@\u000fIR\u001b\u0015\u0012i]Z\\K\u0012TO\u000fALZJVZ^JV\u000f@JB@@[\u0012fv\\\u0012F\\\u000f`JVFA\u000fF@\u0012]W\\F@@J\b\u000fIR"), objectArray);
            ArrayList a2 = new ArrayList();
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 ^ 3] = BaseInfluxRepository.m_oK((Object)"%g6y,|6~<|'q:z6c");
            reportManager.f_Ee.m_Sea(() -> {
                void a;
                Object a2 = hashSet;
                ReportManager a3 = this;
                a.addAll(a3.f_hf.m_fh((Set)a2));
            }, stringArray);
            f_td.info(FiredAlarmList.m_ala((Object)"`JB@@[\u007fN\\NUJ@\u000f\u001acWNVJ@\u000fIR\u001b\u0015\u0012nF[WBB[[AU\u000fF@\u0012]W\\F@@J\u0012TO\u000f@JB@@[A\u0001"), (Object)a, (Object)a2.size());
            a2.forEach(report -> {
                void a;
                ReportManager reportManager;
                ReportManager reportManager2 = reportManager = this;
                Object a2 = reportManager2.f_XC.m_La();
                String[] stringArray = new String[--2];
                stringArray[2 & 5] = BaseInfluxRepository.m_oK((Object)"}0f6j&b6q!k#a!z");
                stringArray[--1] = FiredAlarmList.m_ala((Object)"lsaqj~p`jb``{");
                reportManager2.f_Ee.m_XFa(() -> reportManager.lambda$restoreSingleReportOnLeader$1((String)a2, (Report)a), a.getSpace(), stringArray);
            });
            f_td.info(BaseInfluxRepository.m_oK((Object)"|\u0016^\u001c\\\u0007c\u0012@\u0012I\u0016\\S\u0006?K\u0012J\u0016\\SU\u000e\u0007I\u000e5G\u001dG\u0000F\u0016JS\\\u0016^\u001c\\\u0007\u000e\u0001K\u0000Z\u001c\\\u0012Z\u001aA\u001d\u000e\u0003\\\u001cM\u0016]\u0000\u0000"), (Object)a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_td.error(FiredAlarmList.m_ala((Object)"`JB@@[\u007fN\\NUJ@\u000f\u001acWNVJ@\u000fIR\u001b\u0015\u0012j@]]]\u0012KG][AU\u000f@JB@@[\u0012]W\\F@@NFF]A\u0012_@@QJA\\\b\u000fIR"), objectArray);
            return;
        }
        finally {
            reportManager.f_Rf.unlock();
        }
    }

    protected Map<String, c_Tb> getReportStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        ReportManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getReportStatusInternal(arg_0)));
    }

    protected void scheduleReportInternal(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        a2.f_Ee.m_gEa(() -> a2.lambda$scheduleReportInternal$4((Report)a), (OwnedSpaceBaseModel)a);
    }

    @TransactionalEventListener(value={c_LC.class})
    public void handleRescheduleEvent(c_LC c_LC2) {
        ReportManager reportManager = this;
        if (reportManager.f_XC.m_da()) {
            ReportManager a = a.m_fk();
            f_td.info(BaseInfluxRepository.m_oK((Object)"?k2j6|I\u000e;O\u001dJ\u001fG\u001dIS|\u0016]\u0010F\u0016J\u0006B\u0016k\u0005K\u001dZSH\u001c\\S\\\u0016^\u001c\\\u0007\u0014SU\u000e\u000e[g7\u0014SU\u000e\u0007"), (Object)a.getName(), (Object)a.getId());
            if (reportManager.getReportStatusInternal(a.getId()) == c_Tb.f_ud) {
                reportManager.scheduleReportInternal(a.getId());
                return;
            }
        } else {
            f_td.debug(FiredAlarmList.m_ala((Object)"a}a\u001fcwnvj`\u0015\u0012fUA]][AU\u000f`JALZJVZ^JwYWAF\u000fT@@\u000f@JB@@[\b\u000fIR"), (Object)a.m_fk().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleReportOnLeader$1(String string, Report report) {
        void a;
        ReportManager a2 = report;
        ReportManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 >> 1] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_td.info(FiredAlarmList.m_ala((Object)"`JB@@[\u007fN\\NUJ@\u000f\u001acWNVJ@\u000fIR\u001b\u0015\u0012}W\\F@@F\\H\u0012]W_]]F\u0015\u0012TO\u000f\u001afv\u0015\u0012TO\u0006"), objectArray);
            a3.scheduleReportInternal((Report)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a2.getName();
            objectArray[2 ^ 3] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_Ve.m_Tk(a2.getProject()).m_T("Report Restore (Leader " + (String)a + ")", BaseInfluxRepository.m_oK((Object)"V]S\u0006:jI\u000eV]Z\u000e\u0015O\u001aB\u0016JSZ\u001c\u000e\u0001K\u0000Z\u001c\\\u0016\u0000Sm\u0012[\u0000KI\u000eV]").formatted(objectArray));
            try {
                f_td.warn(FiredAlarmList.m_ala((Object)"`JB@@[\u007fN\\NUJ@\u000f\u001acWNVJ@\u000fIR\u001b\u0015\u0012nF[WBB[[AU\u000fF@\u0012LSAQJ^\u000f@JB@@[\u0012TO\u000fSIFJ@\u000f@JA[]]S[[@\\\u000fTN[CG]W\u0001"), (Object)a, (Object)a2.getId());
                a3.cancelReportInternal((Report)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 & 4] = a;
                objectArray2[5 >> 2] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_td.error(BaseInfluxRepository.m_oK((Object)"|\u0016^\u001c\\\u0007c\u0012@\u0012I\u0016\\S\u0006?K\u0012J\u0016\\SU\u000e\u0007I\u000e5O\u001aB\u0016JSZ\u001c\u000e\u0010O\u001dM\u0016BS\\\u0016^\u001c\\\u0007\u000e\bSSO\u0015Z\u0016\\S\\\u0016]\u0007A\u0001O\u0007G\u001c@SH\u0012G\u001f[\u0001KI\u000e\bS"), objectArray2);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleMonthlyMailReportJob$6(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)a2).set(--5, a.getReportDay().shortValue());
        ((Calendar)object2).set(0x6F & 0x1B, a.getReportTime().getHours());
        ((Calendar)object2).set(0x3E & 0x4D, a.getReportTime().getMinutes());
        ((Calendar)object).set(0xF & 0x7D, a.getReportTime().getSeconds());
        calendar.set(0x1F & 0x6E, 3 & 4);
        a2 = ((Calendar)object).getTime();
        calendar.add(--2, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_DE.m_QL(a.getId(), date, (Date)a2, --1 != 0, a.getLang());
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyMailReportJob(Report report) {
        String string;
        ReportManager a = report;
        ReportManager a2 = this;
        String string2 = string = "Report Mail - " + a.getName();
        return a2.f_Wf.m_fo(a.getProject(), string2, a2.fenced(string2, () -> a2.lambda$scheduleMonthlyMailReportJob$6((Report)a)), (int)a.getMailDay().shortValue(), LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    /*
     * WARNING - void declaration
     */
    public ReportManager(c_MB c_MB2, c_Gd c_Gd2, c_yC c_yC2, c_eC c_eC2, JedisPooled jedisPooled, c_H c_H2, c_mj c_mj2) {
        ReportManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ReportManager a8;
        ReportManager reportManager = reportManager2;
        ReportManager reportManager2 = c_mj2;
        ReportManager reportManager3 = a8 = reportManager;
        ReportManager reportManager4 = a8;
        ReportManager reportManager5 = a8;
        super((c_H)a7);
        ReportManager reportManager6 = a8;
        a8.f_Rf = new ReentrantLock();
        reportManager6.f_JF = new ConcurrentHashMap();
        reportManager5.f_hf = a6;
        reportManager5.f_Wf = a5;
        reportManager4.f_DE = a4;
        reportManager4.f_Ve = a3;
        reportManager3.f_lF = a2;
        reportManager3.f_Ee = a;
    }

    protected void cancelReportInternal(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        a2.f_Ee.m_gEa(() -> a2.lambda$cancelReportInternal$9((Report)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_gb.class})
    public void handleCancelEvent(c_gb c_gb2) {
        void a;
        ReportManager reportManager = this;
        if (reportManager.f_XC.m_da()) {
            ReportManager a2 = a.m_el();
            f_td.info(BaseInfluxRepository.m_oK((Object)"?k2j6|I\u000e;O\u001dJ\u001fG\u001dISm\u0012@\u0010K\u001fk\u0005K\u001dZSH\u001c\\S\\\u0016^\u001c\\\u0007\u0014SU\u000e\u000e[g7\u0014SU\u000e\u0007"), (Object)a2.getName(), (Object)a2.getId());
            reportManager.cancelReportInternal((Report)a2);
            return;
        }
        f_td.debug(FiredAlarmList.m_ala((Object)"a}a\u001fcwnvj`\u0015\u0012fUA]][AU\u000fqN\\LWCwYWAF\u000fT@@\u000f@JB@@[\b\u000fIR"), (Object)a.m_el().getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(String string, String string2) {
        void a;
        ReportManager a2;
        Object a3 = string2;
        ReportManager reportManager = a2 = this;
        reportManager.cancelReport(reportManager.f_hf.m_Th((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(BaseInfluxRepository.m_oK((Object)"b6o7k!\u0014Sm\u0012@\u0010K\u001fB\u001a@\u0014\u000e\u0001K\u0003A\u0001ZSU\u000e\u000e\u001fA\u0010O\u001fB\n\u0000"), a);
            a2.cancelReportInternal((String)a);
            return;
        }
        f_td.debug(FiredAlarmList.m_ala((Object)"|`|\u0002~jskw}\b\u000f`JCZW\\FF\\H\u0012CWNVJ@\u000fF@\u0012LSAQJ^\u000f@JB@@[\u0012TO\u0001"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x6BF7 & 0x15FE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel report " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleMonthlyPrintReportJob$5(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)a2).set(--5, a.getReportDay().shortValue());
        ((Calendar)object2).set(0x3B & 0x4F, a.getReportTime().getHours());
        ((Calendar)object2).set(0x3E & 0x4D, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x2F & 0x5D, a.getReportTime().getSeconds());
        calendar.set(0x5F & 0x2E, 2 & 5);
        a2 = ((Calendar)object).getTime();
        calendar.add(1 ^ 3, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_DE.m_Gh(a.getId(), date, (Date)a2, 5 >> 2, a.getLang());
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ReportManager a;
        a.registerRemoteCallsWithClusterNode();
        f_td.info(BaseInfluxRepository.m_oK((Object)"!K\u0003A\u0001Z>O\u001dO\u0014K\u0001\u000e\u001a@\u001aZ\u001aO\u001fG\tK\u0017\u000e\u0012@\u0017\u000e\u0001K\u0014G\u0000Z\u0016\\\u0016JSO\u0000\u000e0B\u0006]\u0007K\u0001`\u001cJ\u0016b\u001a]\u0007K\u001dK\u0001\u0000"));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReports(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(BaseInfluxRepository.m_oK((Object)"?k2j6|I\u000e M\u001bK\u0017[\u001fG\u001dISO\u001fBS\\\u0016^\u001c\\\u0007]SH\u001c\\S^\u0001A\u0019K\u0010ZSU\u000e\u000e\u001fA\u0010O\u001fB\n\u0000"), a);
            a2.scheduleReportsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(FiredAlarmList.m_ala((Object)"a}a\u001fcwnvj`\u0015\u0012}W^GJA[[AU\u000f^JSKW]\u0012[]\u000fALZJVZ^J\u0012N^C\u0012]W_]]F\\\u0012I]]\u0012_@@XJQ[\u0012TO\u0001"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[2 & 5] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x6FF9 & 0x11FE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule reports for project " + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleReportInternal(String string) {
        ReportManager a;
        Object a2 = string;
        ReportManager reportManager = a = this;
        reportManager.scheduleReportInternal(reportManager.f_hf.m_II((String)a2));
    }

    protected c_Tb getReportStatusInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_JF.containsKey(a)) {
            return c_Tb.f_ud;
        }
        return c_Tb.f_gF;
    }

    private /* synthetic */ DailyJob scheduleDailyMailReportJob(Report report) {
        String string;
        ReportManager a = report;
        ReportManager a2 = this;
        String string2 = string = "Report Mail - " + a.getName();
        return a2.f_Wf.m_ym(a.getProject(), string2, a2.fenced(string2, () -> a2.lambda$scheduleDailyMailReportJob$8((Report)a)), LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<String, c_Tb> getReportStatuses(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(BaseInfluxRepository.m_oK((Object)"b6o7k!\u0014Si\u0016Z\u0007G\u001dISO\u001fBS\\\u0016^\u001c\\\u0007\u000e\u0000Z\u0012Z\u0006]\u0016]SH\u001c\\S^\u0001A\u0019K\u0010ZSU\u000e\u000e\u001fA\u0010O\u001fB\n\u0000"), a);
            return a2.getReportStatusesByProjectIdInternal((String)a);
        }
        f_td.debug(FiredAlarmList.m_ala((Object)"a}a\u001fcwnvj`\u0015\u0012}W^GJA[[AU\u000f^JSKW]\u0012I]]\u0012N^C\u0012]W_]]F\u000fA[S[G\\W\\\u0012I]]\u0012_@@XJQ[\u0012TO\u0001"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_XC.m_Fa(Short.valueOf((short)(0x23FF & 0x5DFB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReports(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(BaseInfluxRepository.m_oK((Object)"?k2j6|I\u000e0O\u001dM\u0016B\u001fG\u001dISO\u001fBS\\\u0016^\u001c\\\u0007]SH\u001c\\S^\u0001A\u0019K\u0010ZSU\u000e\u000e\u001fA\u0010O\u001fB\n\u0000"), a);
            a2.cancelReportsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(FiredAlarmList.m_ala((Object)"a}a\u001fcwnvj`\u0015\u0012}W^GJA[[AU\u000f^JSKW]\u0012[]\u000fQN\\LWC\u0012N^C\u0012]W_]]F\\\u0012I]]\u0012_@@XJQ[\u0012TO\u0001"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x7FD & 0x79FB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel reports for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleDailyMailReportJob$8(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)object2).set(0x1B & 0x6F, a.getReportTime().getHours());
        ((Calendar)object2).set(0x3F & 0x4C, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x3F & 0x4D, a.getReportTime().getSeconds());
        calendar.set(0x3E & 0x4F, 3 ^ 3);
        a2 = ((Calendar)object).getTime();
        calendar.add(--5, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_DE.m_QL(a.getId(), date, (Date)a2, (4 ^ 5) != 0, a.getLang());
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyPrintReportJob(Report report) {
        String string;
        ReportManager a = report;
        ReportManager a2 = this;
        String string2 = string = "Report Print - " + a.getName();
        return a2.f_Wf.m_fo(a.getProject(), string2, a2.fenced(string2, () -> a2.lambda$scheduleMonthlyPrintReportJob$5((Report)a)), (int)a.getPrintDay().shortValue(), LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    protected Map<String, c_Tb> getReportStatusesByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_hf.m_UI((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ReportSummary::getId, reportSummary -> {
            ReportManager a = reportSummary;
            ReportManager a2 = this;
            return a2.getReportStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$cancelReportInternal$9(Report report) {
        ReportManager reportManager = this;
        reportManager.f_Rf.lock();
        try {
            void a;
            Object a2 = (List)reportManager.f_JF.get(a.getId());
            if (a2 != null) {
                Object object = a2 = a2.iterator();
                while (object.hasNext()) {
                    Job job = (Job)a2.next();
                    object = a2;
                    reportManager.f_Wf.m_qn(job);
                }
            }
            ReportManager reportManager2 = reportManager;
            reportManager2.f_JF.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[2 & 5] = a.getId();
            reportManager2.f_lF.srem(f_sE, stringArray);
            return;
        }
        finally {
            reportManager.f_Rf.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(String string, String string2) {
        void a;
        ReportManager a2;
        Object a3 = string2;
        ReportManager reportManager = a2 = this;
        reportManager.scheduleReport(reportManager.f_hf.m_Th((String)a, (String)a3).getId());
    }

    protected void scheduleReportsByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_hf.m_Ph((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleReportInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        ReportManager reportManager = this;
        List a22 = (List)reportManager.f_JF.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_td.info(FiredAlarmList.m_ala((Object)"}W_]]FbSASHW]\u0012\u0007|@F\u000f~JSKW]\u0012TO\u0006\b\u000fqN\\LWC^F\\H\u0012C]LSC\u0012E]M\u0012I]]\u0012]W_]]F\u000f{k\b\u000fIR"), (Object)a3, (Object)a);
                a22.forEach(arg_0 -> ((c_Gd)reportManager.f_Wf).m_qn(arg_0));
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 ^ 3] = a3;
                objectArray[--1] = a;
                objectArray[--2] = a22.getMessage();
                objectArray[--3] = a22;
                f_td.error(BaseInfluxRepository.m_oK((Object)"!K\u0003A\u0001Z>O\u001dO\u0014K\u0001\u000e[`\u001cZSb\u0016O\u0017K\u0001\u000e\bSZ\u0014Sk\u0001\\\u001c\\SM\u0012@\u0010K\u001fB\u001a@\u0014\u000e\u001fA\u0010O\u001f\u000e\u0019A\u0011\u000e\u0015A\u0001\u000e\u0001K\u0003A\u0001ZSg7\u000e\bSI\u000e\bS"), objectArray);
            }
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ReportManager reportManager = this;
        try {
            Class[] classArray = new Class[3 & 5];
            classArray[5 >> 3] = String.class;
            reportManager.f_XC.m_Ja((short)(0x6BF7 & 0x15FD), (Object)reportManager, ReportManager.class.getDeclaredMethod(FiredAlarmList.m_ala((Object)"ALZJVZ^J`JB@@[{AFJ@ASC"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[3 ^ 3] = String.class;
            reportManager.f_XC.m_Ja((short)(0x65FF & 0x1BF6), (Object)reportManager, ReportManager.class.getDeclaredMethod(BaseInfluxRepository.m_oK((Object)"\u0010O\u001dM\u0016B!K\u0003A\u0001Z:@\u0007K\u0001@\u0012B"), classArray2));
            Class[] classArray3 = new Class[4 ^ 5];
            classArray3[3 & 4] = String.class;
            reportManager.f_XC.m_Ja((short)(0x21FF & 0x5FF7), (Object)reportManager, ReportManager.class.getDeclaredMethod(FiredAlarmList.m_ala((Object)"HW[`JB@@[a[S[G\\{AFJ@ASC"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[3 & 4] = String.class;
            reportManager.f_XC.m_Ja((short)(0x69FA & 0x17FD), (Object)reportManager, ReportManager.class.getDeclaredMethod(BaseInfluxRepository.m_oK((Object)"\u0000M\u001bK\u0017[\u001fK!K\u0003A\u0001Z\u0000l\n~\u0001A\u0019K\u0010Z:J:@\u0007K\u0001@\u0012B"), classArray4));
            Class[] classArray5 = new Class[2 ^ 3];
            classArray5[3 & 4] = String.class;
            reportManager.f_XC.m_Ja((short)(0x19FB & 0x67FD), (Object)reportManager, ReportManager.class.getDeclaredMethod(FiredAlarmList.m_ala((Object)"QN\\LWC`JB@@[AmK\u007f@@XJQ[{K{AFJ@ASC"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            reportManager.f_XC.m_Ja((short)(0x1BFF & 0x65FA), (Object)reportManager, ReportManager.class.getDeclaredMethod(BaseInfluxRepository.m_oK((Object)"\u0014K\u0007|\u0016^\u001c\\\u0007}\u0007O\u0007[\u0000K\u0000l\ng\u0017]:@\u0007K\u0001@\u0012B"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            reportManager.f_XC.m_Ja((short)(0x35FF & 0x4BFB), (Object)reportManager, ReportManager.class.getDeclaredMethod(FiredAlarmList.m_ala((Object)"UJF}W_]]F|FNFZAJAmK\u007f@@XJQ[{K{AFJ@ASC"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(BaseInfluxRepository.m_oK((Object)"5O\u001aB\u0016JSZ\u001c\u000e\u0001K\u0014G\u0000Z\u0016\\S|\u0016^\u001c\\\u0007c\u0012@\u0012I\u0016\\S|#mSC\u0016Z\u001bA\u0017]"), a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_Tb getReportStatus(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(FiredAlarmList.m_ala((Object)"cwnvj`\u0015\u0012hW[FF\\H\u0012]W_]]F\u000fA[S[G\\\u0012I]]\u0012fv\u0015\u0012TO\u000f^@QN^CK\u0001"), a);
            return a2.getReportStatusInternal((String)a);
        }
        f_td.debug(BaseInfluxRepository.m_oK((Object)"`<`^b6o7k!\u0014S|\u0016_\u0006K\u0000Z\u001a@\u0014\u000e\u001fK\u0012J\u0016\\SH\u001c\\S\\\u0016^\u001c\\\u0007\u000e\u0000Z\u0012Z\u0006]SH\u001c\\Sg7\u0014SU\u000e\u0000"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            return (c_Tb)a2.f_XC.m_Fa(Short.valueOf((short)(0x73FF & 0xDF7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get report transfer status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleDailyPrintReportJob$7(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)object2).set(0x2F & 0x5B, a.getReportTime().getHours());
        ((Calendar)object2).set(0x3C & 0x4F, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x6F & 0x1D, a.getReportTime().getSeconds());
        calendar.set(0x6E & 0x1F, 5 >> 3);
        a2 = ((Calendar)object).getTime();
        calendar.add(--5, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_DE.m_Gh(a.getId(), date, (Date)a2, (2 ^ 3) != 0, a.getLang());
    }

    protected void cancelReportsByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_hf.m_Ph((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelReportInternal(arg_0));
    }

    public void notLeader() {
        ReportManager reportManager;
        ReportManager reportManager2 = reportManager = this;
        Object a = reportManager2.f_XC.m_La();
        f_td.info(BaseInfluxRepository.m_oK((Object)"!K\u0003A\u0001Z>O\u001dO\u0014K\u0001\u0014Sz\u001bG\u0000\u000e\u001dA\u0017KS\u0006\bSZ\u000e\u001a]S`<\u000e?a=i6|Sz;kSb6o7k!\u0000Sm\u0012@\u0010K\u001fB\u001a@\u0014\u000e\u0012B\u001f\u000e\u001fA\u0010O\u001f\u000e\u0001K\u0003A\u0001ZSD\u001cL\u0000\u0000]\u0000"), a);
        reportManager2.f_Rf.lock();
        try {
            new ArrayList(reportManager.f_JF.keySet()).forEach(arg_0 -> reportManager.lambda$notLeader$2((String)a, arg_0));
            reportManager.f_JF.clear();
            f_td.info(FiredAlarmList.m_ala((Object)"}W_]]FbSASHW]\u0012\u0007|@F\u000f~JSKW]\u0012TO\u0006\b\u000fsC^\u000f^@QN^\u000f@JB@@[\u0012E]MA\u000fZNDJ\u0012MWJ\\\u000f@JCZW\\FJV\u000fF@\u0012LSAQJ^\u000fSAV\u000fQCWN@JV\u000fT]]B\u0012C]LSC\u0012[@NQD[AU\u0001"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_td.error(BaseInfluxRepository.m_oK((Object)"|\u0016^\u001c\\\u0007c\u0012@\u0012I\u0016\\S\u0006=A\u0007\u000e?K\u0012J\u0016\\SU\u000e\u0007I\u000e6\\\u0001A\u0001\u000e\u0017[\u0001G\u001dIS^\u0001A\u0010K\u0000]SA\u0015\u000e\u0010O\u001dM\u0016B\u001fG\u001dISB\u001cM\u0012BS\\\u0016^\u001c\\\u0007\u000e\u0019A\u0011]I\u000e\bS"), objectArray);
            return;
        }
        finally {
            reportManager.f_Rf.unlock();
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.info(BaseInfluxRepository.m_oK((Object)"?k2j6|I\u000e;O\u001dJ\u001fG\u001dIS~\u0001A\u0019K\u0010Z7K\u0012M\u0007G\u0005O\u0007K6X\u0016@\u0007\u000e\u0015A\u0001\u000e\u0003\\\u001cD\u0016M\u0007\u000e:jI\u000e\bS"), a);
            a2.cancelReportsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(FiredAlarmList.m_ala((Object)"|`|\u0002~jskw}\b\u000f{H\\@@F\\H\u0012\u007f@@XJQ[vJSLFFDNFJwYWAF\u000fT@@\u000fB]]EWLF\u000f{k\b\u000fIR"), a);
    }

    private /* synthetic */ DailyJob scheduleDailyPrintReportJob(Report report) {
        String string;
        ReportManager a = report;
        ReportManager a2 = this;
        String string2 = string = "Report Print - " + a.getName();
        return a2.f_Wf.m_ym(a.getProject(), string2, a2.fenced(string2, () -> a2.lambda$scheduleDailyPrintReportJob$7((Report)a)), LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    protected void cancelReportInternal(String string) {
        ReportManager a;
        Object a2 = string;
        ReportManager reportManager = a = this;
        reportManager.cancelReportInternal(reportManager.f_hf.m_II((String)a2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$scheduleReportInternal$4(Report var1_2) {
        a = var1_2;
        a = this;
        a.f_Rf.lock();
        try {
            block11: {
                block12: {
                    block10: {
                        a.cancelReportInternal((Report)a);
                        if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                            throw new NotActiveException("Project should be active to schedule report " + a.getName());
                        }
                        var2_3 = new ArrayList<MonthlyJob>();
                        try {
                            if (!Boolean.TRUE.equals(a.getPrintFlag())) break block10;
                            var3_4 = a.getPeriod() == c_mC.f_Eg ? a.scheduleMonthlyPrintReportJob((Report)a) : a.scheduleDailyPrintReportJob((Report)a);
                        }
                        catch (Exception var3_5) {
                            v0 = var4_6 = var2_3.iterator();
                            while (v0.hasNext()) {
                                var5_7 = (Job)var4_6.next();
                                v0 = var4_6;
                                a.f_Wf.m_qn(var5_7);
                            }
                            throw new ReportSchedulingException(BaseInfluxRepository.m_oK((Object)"h\u0012G\u001fK\u0017\u000e\u0007AS]\u0010F\u0016J\u0006B\u0016\u000e\u0001K\u0003A\u0001Z"), (Throwable)var3_5);
                        }
                        var2_3.add(var3_4);
                    }
                    if (!Boolean.TRUE.equals(a.getMailFlag())) break block11;
                    if (a.getPeriod() != c_mC.f_Eg) break block12;
                    v1 = a.scheduleMonthlyMailReportJob((Report)a);
                    ** GOTO lbl30
                }
                v1 = a.scheduleDailyMailReportJob((Report)a);
lbl30:
                // 2 sources

                var3_4 = v1;
                var2_3.add(var3_4);
            }
            v2 = a;
            v2.f_JF.put(a.getId(), var2_3);
            v3 = new String[3 >> 1];
            v3[3 ^ 3] = a.getId();
            v2.f_lF.sadd("scheduledReports", v3);
            return;
        }
        finally {
            a.f_Rf.unlock();
        }
    }
}

