/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.project.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.shared.model.SpaceBaseModel;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="project")
@AttributeOverride(name="id", column=@Column(name="project_id", length=36, nullable=false, updatable=false))
public class Project
extends SpaceBaseModel {
    @Column(name="contract_day")
    private Integer contractDay;
    @NotNull
    @Column(name="active_flag")
    private Boolean isActive;
    private Double longitude;
    private String properties;
    @JsonIgnore
    @OneToOne
    @JoinColumn(name="icon_file_id")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private FileInfo iconFile;
    @Column(name="contract_hour")
    private String contractHour;
    @NotBlank
    @Size(max=100)
    @Column(updatable=false)
    private String name;
    @Size(max=255)
    private String dsc;
    @Column(name="icon_file_id", updatable=false, insertable=false)
    private String iconFileId;
    @Size(max=255)
    private String address;
    private Double latitude;

    public void setProperties(String string) {
        Object a = string;
        Project a2 = this;
        a2.properties = a;
    }

    public void setName(String string) {
        Object a = string;
        Project a2 = this;
        a2.name = a;
    }

    public Double getLongitude() {
        Project a;
        return a.longitude;
    }

    public void setAddress(String string) {
        Object a = string;
        Project a2 = this;
        a2.address = a;
    }

    public Integer getContractDay() {
        Project a;
        return a.contractDay;
    }

    public void setLatitude(Double d) {
        Object a = d;
        Project a2 = this;
        a2.latitude = a;
    }

    public String getName() {
        Project a;
        return a.name;
    }

    public String getIconFileId() {
        Project a;
        return a.iconFileId;
    }

    public void setIsActive(Boolean bl) {
        Object a = bl;
        Project a2 = this;
        a2.isActive = a;
    }

    public void setContractHour(String string) {
        Object a = string;
        Project a2 = this;
        a2.contractHour = a;
    }

    public Double getLatitude() {
        Project a;
        return a.latitude;
    }

    public void setIconFile(FileInfo fileInfo) {
        Project a;
        Project a2 = fileInfo;
        Project project = a = this;
        project.iconFile = a2;
        project.iconFileId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setDsc(String string) {
        Object a = string;
        Project a2 = this;
        a2.dsc = a;
    }

    public FileInfo getIconFile() {
        Project a;
        return a.iconFile;
    }

    public Project() {
        Project a;
    }

    public int hashCode() {
        Project a;
        Object[] objectArray = new Object[1 ^ 3];
        objectArray[2 & 5] = super.hashCode();
        objectArray[--1] = a.getName();
        return Objects.hash(objectArray);
    }

    public String getProperties() {
        Project a;
        return a.properties;
    }

    public Boolean getIsActive() {
        Project a;
        return a.isActive;
    }

    public boolean equals(Object object) {
        Project a = this;
        Object a2 = object;
        if (a == a2) {
            return (4 ^ 5) != 0;
        }
        if (!(a2 instanceof Project)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (2 & 5) != 0;
        }
        return a.getName().equals(object2.getName());
    }

    public void setLongitude(Double d) {
        Object a = d;
        Project a2 = this;
        a2.longitude = a;
    }

    public void setContractDay(Integer n) {
        Object a = n;
        Project a2 = this;
        a2.contractDay = a;
    }

    public void setIconFileId(String string) {
        Object a = string;
        Project a2 = this;
        a2.iconFileId = a;
    }

    public String getContractHour() {
        Project a;
        return a.contractHour;
    }

    public String getDsc() {
        Project a;
        return a.dsc;
    }

    public String getAddress() {
        Project a;
        return a.address;
    }
}

