/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.menu.repositories;

import com.inscada.mono.menu.model.CustomMenu;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

@EnableSpaceFilter
public interface CustomMenuRepository
extends BaseJpaRepository<CustomMenu> {
    @Query(value="SELECT DISTINCT m FROM CustomMenu m LEFT JOIN FETCH m.children c LEFT JOIN FETCH c.children gc LEFT JOIN FETCH gc.children WHERE m.name = :name")
    public Optional<CustomMenu> findOneByName(@Param(value="name") String var1);

    @Query(value="SELECT DISTINCT m FROM CustomMenu m LEFT JOIN FETCH m.children c LEFT JOIN FETCH c.children gc LEFT JOIN FETCH gc.children WHERE m.parent.id = :customMenuId AND m.id = :secondCustomMenuId")
    public Optional<CustomMenu> findOneByParentIdAndId(@Param(value="customMenuId") String var1, @Param(value="secondCustomMenuId") String var2);

    @Query(value="SELECT DISTINCT m FROM CustomMenu m LEFT JOIN FETCH m.children c LEFT JOIN FETCH c.children gc LEFT JOIN FETCH gc.children WHERE m.parentId IS NULL ORDER BY m.menuOrder ASC")
    public List<CustomMenu> findByParentIdIsNullOrderByMenuOrderAsc();

    @Query(value="SELECT DISTINCT m FROM CustomMenu m LEFT JOIN FETCH m.children c LEFT JOIN FETCH c.children gc LEFT JOIN FETCH gc.children WHERE m.id = :id")
    public Optional<CustomMenu> findByIdWithChildren(@Param(value="id") String var1);

    @Query(value="SELECT DISTINCT m FROM CustomMenu m LEFT JOIN FETCH m.children c LEFT JOIN FETCH c.children gc LEFT JOIN FETCH gc.children WHERE m.id IN :customMenuIds OR m.name IN :names")
    public List<CustomMenu> findByIdInOrNameIn(@Param(value="customMenuIds") Set<String> var1, @Param(value="names") Set<String> var2);

    @Query(value="SELECT DISTINCT m FROM CustomMenu m LEFT JOIN FETCH m.children c LEFT JOIN FETCH c.children gc LEFT JOIN FETCH gc.children WHERE m.id = :thirdLevelCustomMenuId AND m.parent.id = :secondLevelCustomMenuId AND m.parent.parent.id = :customMenuId")
    public Optional<CustomMenu> findOneByParentIdsAndId(@Param(value="customMenuId") String var1, @Param(value="secondLevelCustomMenuId") String var2, @Param(value="thirdLevelCustomMenuId") String var3);
}

