/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.language.repositories;

import com.inscada.mono.language.model.Language;
import com.inscada.mono.language.model.LanguageFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

@EnableSpaceFilter
public interface LanguageRepository
extends BaseJpaRepository<Language> {
    public Page<Language> findLanguagesByKey(String var1, @Param(value="pageable") Pageable var2);

    public Language findOneByLangAndKey(String var1, String var2);

    public Page<Language> findAll(@Param(value="pageable") Pageable var1);

    public Page<Language> findLanguagesByKeyIgnoreCase(String var1, @Param(value="pageable") Pageable var2);

    public List<Language> findByLangAndKeyIn(String var1, String[] var2);

    public List<Language> findAllByKey(String var1);

    @Query(value="select lang from (select l.lang, min(l.insert_dttm) as min_dttm from inscada.language l where l.space_id = ?#{authentication.activeSpace.id} and l.deleted_dttm is null group by l.lang) t order by min_dttm", nativeQuery=true)
    public List<String> findDistinctLangs();

    public List<Language> findAllByLang(String var1);

    @Query(value="select ll from Language ll where (ll.lang = ?#{#langFilter.lang} or ?#{#langFilter.lang} is null or ?#{#langFilter.lang} = '') and (?#{#langFilter.key} = '' or upper(ll.key) like %?#{#langFilter.key}% ) and (?#{#langFilter.value} = '' or upper(ll.value) like %?#{#langFilter.value}% ) and (?#{#langFilter.dsc} = '' or upper(ll.dsc) like %?#{#langFilter.dsc}%) ")
    public Page<Language> findLanguagesByFilter(@Param(value="langFilter") LanguageFilter var1, @Param(value="pageable") Pageable var2);
}

