/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.filesystem.e;

import com.inscada.mono.animation.model.RunAnimScriptDto;
import com.inscada.mono.auth.services.otp.r.e.c_ZJ;
import com.inscada.mono.filesystem.model.FileDownloadResult;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.filesystem.repositories.FileInfoRepository;
import com.inscada.mono.shared.d.c_Fb;
import com.inscada.mono.shared.d.c_Uc;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.ModelUpdater;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.space.SpaceContext;
import com.inscada.mono.space.model.Space;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class c_Xb {
    public static final String f_Bj = "general-uploads";
    public static final String f_NI = "logo";
    public static final String f_Pi = "jasper-templates";
    private final FileInfoRepository f_aj;
    private final ModelUpdater f_ai;
    public static final String f_JI = "symbols";
    public static final String f_cG = "animations";
    public static final String f_wh = "project-icons";
    private final String f_dG;
    private static final Logger f_zI = LoggerFactory.getLogger(c_Xb.class);
    public static final String f_HH = "scl-files";
    public static final String f_Ti = "login-images";
    public static final String f_vG = "faceplates";

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public Optional<FileInfo> m_Xn(String string) {
        Object a = string;
        c_Xb a2 = this;
        return a2.f_aj.findByRelativePath((String)a);
    }

    /*
     * WARNING - void declaration
     */
    public FileDownloadResult m_fm(String string) {
        Path path;
        block7: {
            FileInfo fileInfo;
            Object a;
            void a2;
            c_Xb c_Xb2 = this;
            if (!StringUtils.hasText((String)a2)) {
                throw new NotFoundException(c_ZJ.m_Zfa((Object)".J@I\u000fB\tK@G\u0001F\u000bB\u0012J\u0015K\u0004\u0005\tH\u0001B\u0005\u0005\u0006L\f@\u000eD\r@@U\u0012J\u0016L\u0004@\u0004"));
            }
            Path path2 = Path.of(c_Xb2.f_dG, new String[3 >> 2]);
            path = path2.resolve(f_Ti).resolve((String)a2).normalize();
            if (!path.startsWith((Path)(a = path2.resolve(f_Ti).normalize()))) {
                throw new FileStorageException(RunAnimScriptDto.m_fha((Object)"\u0007\t8\u0006\"\u000e*G\"\b)\u000e G'\n/\u0000+G>\u0006:\u000f"));
            }
            a = new UrlResource(path.toUri());
            if (!a.exists() || !a.isReadable()) break block7;
            FileInfo fileInfo2 = fileInfo = new FileInfo();
            fileInfo2.setFileName((String)a2);
            fileInfo2.setFileType(Files.probeContentType(path));
            if (fileInfo2.getFileType() == null) {
                fileInfo.setFileType(c_ZJ.m_Zfa((Object)"D\u0010U\fL\u0003D\u0014L\u000fKOJ\u0003Q\u0005QMV\u0014W\u0005D\r"));
            }
            return new FileDownloadResult((Resource)a, fileInfo);
        }
        try {
            f_zI.error(RunAnimScriptDto.m_fha((Object)"\u0002\b)\u000e G'\n/\u0000+G(\u000e\"\u0002n\t!\u0013n\u0001!\u0012 \u0003n\b G*\u000e=\ftG5\u001a"), (Object)path);
            throw new NotFoundException(c_ZJ.m_Zfa((Object)"i\u000fB\tK@L\rD\u0007@@C\tI\u0005\u0005\u000eJ\u0014\u0005\u0006J\u0015K\u0004"));
        }
        catch (MalformedURLException a) {
            throw new NotFoundException(RunAnimScriptDto.m_fha((Object)"+!\u0000'\tn\u000e#\u0006)\u0002n\u0001'\u000b+G \b:G(\b;\t*Gf\n/\u000b(\b<\n+\u0003n2\u001c+gI"));
        }
        catch (IOException a) {
            f_zI.error(c_ZJ.m_Zfa((Object)"`\u0012W\u000fW@D\u0003F\u0005V\u0013L\u000eB@I\u000fB\tK@L\rD\u0007@@C\tI\u0005\u001f@^\u001d"), (Object)path, (Object)a);
            throw new NotFoundException(RunAnimScriptDto.m_fha((Object)"\u0002\b)\u000e G'\n/\u0000+G(\u000e\"\u0002n\t!\u0013n\u0001!\u0012 \u0003"));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_YN(String string) {
        Object a = string;
        c_Xb a2 = this;
        return a2.f_aj.findById(a).orElse(null);
    }

    private static /* synthetic */ NotFoundException m_zo(String a) {
        return new NotFoundException("File info not found with relative path: " + a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('VIEW_FILE') and hasAuthority('CREATE_FILE')")
    public FileInfo m_KM(String string) {
        FileInfo a;
        c_Xb c_Xb2 = this;
        Objects.requireNonNull(a, RunAnimScriptDto.m_fha((Object)"\u0001\u0015'\u0000'\t/\u000bn\u0001'\u000b+G\u0007#n\u0004/\t \b:G,\u0002n\t;\u000b\"I"));
        a = c_Xb2.m_cN((String)a);
        long l = System.currentTimeMillis();
        String string2 = a.getFileName();
        Object a22 = "";
        String string3 = string2;
        int n = string3.lastIndexOf(0x6E & 0x3F);
        if (n > 0) {
            String string4 = string2;
            string3 = string4.substring(3 >> 2, n);
            a22 = string4.substring(n);
        }
        if ((string2 = StringUtils.cleanPath((String)(string3 + "_clone_" + l + (String)a22))).contains(c_ZJ.m_Zfa((Object)"\u000bN"))) {
            throw new FileStorageException(RunAnimScriptDto.m_fha((Object)" +\t+\u0015/\u0013+\u0003n\u0001'\u000b+\t/\n+G-\b \u0013/\u000e \u0014n\u000e \u0011/\u000b'\u0003n\u0017/\u0013&G=\u0002?\u0012+\t-\u0002n@`IiI"));
        }
        a22 = Objects.requireNonNull(SpaceContext.getActiveSpace(), c_ZJ.m_Zfa((Object)"!F\u0014L\u0016@@V\u0010D\u0003@@L\u0013\u0005\u0012@\u0011P\tW\u0005A@Q\u000f\u0005\u0003I\u000fK\u0005\u0005\u0001\u0005\u0006L\f@N"));
        String[] stringArray = new String[--1];
        stringArray[3 >> 2] = a22.getName();
        a22 = Path.of(c_Xb2.f_dG, stringArray).toAbsolutePath().normalize();
        Path path = a22.resolve(string3 = StringUtils.hasText((String)a.getTargetSubdirectory()) ? a.getTargetSubdirectory() : f_Bj).normalize();
        Path path2 = path.resolve(string2).normalize();
        if (!path2.startsWith(path)) {
            throw new FileStorageException("Generated filename results in path traversal: " + string2);
        }
        String string5 = a22.relativize(path2).toString().replace(RunAnimScriptDto.m_fha((Object)";"), c_ZJ.m_Zfa((Object)"O"));
        if (c_Xb2.f_aj.existsByRelativePath(string5)) {
            throw new FileStorageException("A file already exists at generated path: " + string5);
        }
        a22 = a22.resolve(a.getRelativePath()).normalize();
        try {
            Files.createDirectories(path, new FileAttribute[3 ^ 3]);
            CopyOption[] copyOptionArray = new CopyOption[3 & 5];
            copyOptionArray[3 ^ 3] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy((Path)a22, path2, copyOptionArray);
            f_zI.info(RunAnimScriptDto.m_fha((Object)"!'\u000b+G-\u000b!\t+\u0003n\u0001<\b#Gi\u001c3@n\u0013!Gi\u001c3@"), a22, (Object)path2);
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not clone file: " + a.getFileName(), (Throwable)a22);
        }
        a22 = a.getName() + "_clone_" + l;
        Path path3 = path = new FileInfo();
        path3.setName((String)a22);
        path3.setDsc("Clone of " + a.getName());
        Path path4 = path;
        FileInfo fileInfo = a;
        Path path5 = path;
        path5.setFileName(string2);
        path5.setRelativePath(string5);
        path.setFileSize(fileInfo.getFileSize());
        path4.setFileType(fileInfo.getFileType());
        path4.setTargetSubdirectory(string3);
        return (FileInfo)c_Xb2.f_aj.save((Object)path);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_vN(String string) {
        Object a = string;
        c_Xb a2 = this;
        return (FileInfo)a2.m_Xn((String)a).orElseThrow(() -> c_Xb.m_zo((String)a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public Optional<FileInfo> m_tn(String string) {
        Object a = string;
        c_Xb a2 = this;
        return a2.f_aj.findById(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileDownloadResult m_FN(String string) {
        Path path;
        block3: {
            c_Xb a;
            Object a2 = string;
            c_Xb c_Xb2 = a = this;
            a2 = c_Xb2.m_vN((String)a2);
            String[] stringArray = new String[--1];
            stringArray[3 & 4] = a2.getSpace().getName();
            path = Path.of(c_Xb2.f_dG, stringArray).resolve(a2.getRelativePath()).normalize();
            try {
                UrlResource urlResource = new UrlResource(path.toUri());
                if (!urlResource.exists() || !urlResource.isReadable()) break block3;
                return new FileDownloadResult((Resource)urlResource, (FileInfo)a2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new NotFoundException(c_ZJ.m_Zfa((Object)"&L\f@@K\u000fQ@C\u000fP\u000eA@\r\rD\fC\u000fW\r@\u0004\u00055w,\fN"));
            }
        }
        f_zI.error(c_ZJ.m_Zfa((Object)"c\tI\u0005\u0005\r@\u0014D\u0004D\u0014D@@\u0018L\u0013Q\u0013\u0005\u0006J\u0012\u0005G^\u001d\u0002@G\u0015Q@C\tI\u0005\u0005\tV@H\tV\u0013L\u000eB@J\u000e\u0005\u0004L\u0013NN"), (Object)path);
        throw new NotFoundException(RunAnimScriptDto.m_fha((Object)"\b\u000e\"\u0002n\t!\u0013n\u0001!\u0012 \u0003"));
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public FileInfo m_Um(FileInfo fileInfo) {
        FileInfo fileInfo2;
        c_Xb a = fileInfo;
        c_Xb a2 = this;
        Object object = a.getId() != null ? a2.m_YN(a.getId()) : (fileInfo2 = StringUtils.hasText((String)a.getName()) ? a2.m_jN(a.getName()) : null);
        if (fileInfo2 != null) {
            a2.f_ai.copyForUpdate((Object)a, (SpaceBaseModel)fileInfo2, new String[3 & 4]);
            return fileInfo2;
        }
        return (FileInfo)a2.f_aj.save((Object)a);
    }

    /*
     * WARNING - void declaration
     */
    public c_Xb(FileInfoRepository fileInfoRepository, ModelUpdater modelUpdater, @Value(value="${ins.files.path}") String string) {
        void modelUpdater2;
        void fileInfoRepository2;
        c_Xb a;
        c_Xb c_Xb2 = object;
        Object object = string;
        c_Xb c_Xb3 = a = c_Xb2;
        a.f_aj = fileInfoRepository2;
        c_Xb3.f_ai = modelUpdater2;
        c_Xb3.f_dG = object;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_FILE') and hasAuthority('UPDATE_LOGIN_SETTINGS')")
    public void m_no(String string) {
        void a;
        c_Xb c_Xb2 = this;
        if (!StringUtils.hasText((String)a)) {
            f_zI.warn(c_ZJ.m_Zfa((Object)"A\u0005I\u0005Q\u0005i\u000fB\tK)H\u0001B\u0005\u0005\u0003D\fI\u0005A@R\tQ\b\u0005\u0005H\u0010Q\u0019\u0005\u000fW@K\u0015I\f\u0005\u0006L\f@\u000eD\r@N"));
            return;
        }
        try {
            Object a2 = StringUtils.cleanPath((String)a);
            if (a2.contains(RunAnimScriptDto.m_fha((Object)"`I"))) {
                throw new FileStorageException(c_ZJ.m_Zfa((Object)"&L\f@\u000eD\r@@F\u000fK\u0014D\tK\u0013\u0005\tK\u0016D\fL\u0004\u0005\u0010D\u0014M@V\u0005T\u0015@\u000eF\u0005\u0005G\u000bN\u0002N"));
            }
            Path path = Path.of(c_Xb2.f_dG, new String[2 & 5]).toAbsolutePath().normalize().resolve(f_Ti).normalize();
            Path path2 = path.resolve((String)a2).normalize();
            if (!path2.startsWith(path)) {
                f_zI.warn(RunAnimScriptDto.m_fha((Object)"7/\u0013&G:\u0015/\u0011+\u0015=\u0006\"G/\u0013:\u0002#\u0017:G(\b<G\"\b)\u000e G'\n/\u0000+G*\u0002\"\u0002:\u000e!\ttG5\u001a"), a2);
                throw new FileStorageException(c_ZJ.m_Zfa((Object)"l\u000eS\u0001I\tA@I\u000fB\tK@L\rD\u0007@@U\u0001Q\b\u0005\u0006J\u0012\u0005\u0004@\f@\u0014L\u000fKN"));
            }
            Files.deleteIfExists(path2);
            f_zI.info(RunAnimScriptDto.m_fha((Object)"+!\u0000'\tn\u000e#\u0006)\u0002n@5\u001aiG*\u0002\"\u0002:\u0002*G(\u0015!\nn\u0001'\u000b+\u00147\u0014:\u0002#Gf\u000e(G'\u0013n\u00026\u000e=\u0013+\u0003gI"), a2);
            return;
        }
        catch (IOException a2) {
            f_zI.error(c_ZJ.m_Zfa((Object)"`\u0012W\u000fW@J\u0003F\u0015W\u0012@\u0004\u0005\u0017M\tI\u0005\u0005\u0004@\f@\u0014L\u000eB@I\u000fB\tK@L\rD\u0007@@C\tI\u0005\u001f@^\u001d"), (Object)a, (Object)a2);
            return;
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_cN(String string) {
        Object a = string;
        c_Xb a2 = this;
        return (FileInfo)a2.m_tn((String)a).orElseThrow(() -> c_Xb.m_ao((String)a));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DELETE_FILE')")
    @Transactional
    public void m_wn(String string) {
        Path path;
        FileInfo fileInfo;
        void a;
        Object object;
        block5: {
            object = this;
            fileInfo = object.m_tn((String)a).orElse(null);
            if (fileInfo == null) {
                return;
            }
            String[] stringArray = new String[4 ^ 5];
            stringArray[3 & 4] = fileInfo.getSpace().getName();
            Path path2 = Path.of(object.f_dG, stringArray);
            path = path2.resolve(fileInfo.getRelativePath()).normalize();
            if (!Files.exists(path, new LinkOption[3 ^ 3])) break block5;
            Object a2 = fileInfo.getFileName();
            String string2 = LocalDateTime.now().format(DateTimeFormatter.ofPattern(c_ZJ.m_Zfa((Object)"\u0019\\\u0019\\-h\u0004A?m(H\rV\u0013")));
            Object object2 = a2;
            String string3 = "";
            int n = ((String)object2).lastIndexOf(0x3E & 0x6F);
            if (n > 0) {
                Object object3 = a2;
                object2 = ((String)object3).substring(3 & 4, n);
                string3 = ((String)object3).substring(n);
            }
            a2 = (String)object2 + "_deleted_" + string2 + string3;
            Path path3 = path;
            a2 = path3.getParent().resolve((String)a2);
            Files.move(path3, (Path)a2, new CopyOption[3 & 4]);
            f_zI.info(RunAnimScriptDto.m_fha((Object)"!'\u000b+G<\u0002 \u0006#\u0002*G(\u0015!\nn@5\u001aiG:\bn@5\u001aiG(\b<G*\u0002\"\u0002:\u0002"), (Object)path, a2);
        }
        try {
            f_zI.warn(c_ZJ.m_Zfa((Object)"u\b\\\u0013L\u0003D\f\u0005\u0006L\f@@K\u000fQ@C\u000fP\u000eA@C\u000fW@A\u0005I\u0005Q\u0005\u001f@^\u001d"), (Object)path);
        }
        catch (IOException iOException) {
            f_zI.error(RunAnimScriptDto.m_fha((Object)"\r\b;\u000b*G \b:G<\u0002 \u0006#\u0002n\u0001'\u000b+G(\b<G*\u0002\"\u0002:\u0002tG5\u001a"), (Object)fileInfo.getFileName(), (Object)iOException);
        }
        object.f_aj.delete((Object)fileInfo);
        f_zI.info(c_ZJ.m_Zfa((Object)"c\tI\u0005\u0005\u0004@\f@\u0014@\u0004\u0005\u0006J\u0012\u0005)aZ\u0005\u001bXL\u0005/W\tB\tK\u0001I@k\u0001H\u0005\u001f@^\u001d"), (Object)a, (Object)fileInfo.getFileName());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public void m_KN(ZipFile zipFile, FileInfo fileInfo) {
        void a3222;
        InputStream a22;
        c_Xb c_Xb2 = this;
        ZipEntry zipEntry = ((ZipFile)((Object)a22)).getEntry(a3222.getFileName());
        if (zipEntry == null) return;
        Objects.requireNonNull(a3222, RunAnimScriptDto.m_fha((Object)"!'\u000b+. \u0001!G!\u0005$\u0002-\u0013n\u0004/\t \b:G,\u0002n\t;\u000b\"I"));
        Object a = zipEntry.getName();
        if (((String)a).trim().isEmpty()) {
            throw new FileStorageException(c_ZJ.m_Zfa((Object)":L\u0010\u0005\u0005K\u0014W\u0019\u0005\u000eD\r@@F\u0001K\u000eJ\u0014\u0005\u0002@@@\rU\u0014\\N"));
        }
        if (((String)a).contains(RunAnimScriptDto.m_fha((Object)"`I")) || ((String)a).startsWith(c_ZJ.m_Zfa((Object)"O")) || ((String)a).startsWith(RunAnimScriptDto.m_fha((Object)";")) || ((String)a).contains(c_ZJ.m_Zfa((Object)"\u001fO")) || ((String)a).contains(RunAnimScriptDto.m_fha((Object)"t;"))) {
            f_zI.warn(c_ZJ.m_Zfa((Object)":L\u0010\u0005\u0013I\tU@D\u0014Q\u0005H\u0010Q@A\u0005Q\u0005F\u0014@\u0004\u0005\tK@@\u000eQ\u0012\\@K\u0001H\u0005\u001f@\u0002\u001bXG"), a);
            throw new FileStorageException(RunAnimScriptDto.m_fha((Object)"\u0014\u000e>G+\t:\u00157G-\b \u0013/\u000e \u0014n\u000e \u0011/\u000b'\u0003n\u0017/\u0013&G=\u0002?\u0012+\t-\u0002n\u0013&\u0006:G-\b;\u000b*G\"\u0002/\u0003n\u0013!G*\u000e<\u0002-\u0013!\u00157G:\u0015/\u0011+\u0015=\u0006\"I"));
        }
        Object object = ((String)a).replace((char)(0x7F & 0x5C), (char)(0x6F & 0x3F));
        if (((String)object).contains(c_ZJ.m_Zfa((Object)"N\u000bO")) || ((String)object).contains(RunAnimScriptDto.m_fha((Object)"H`I")) || ((String)object).equals(c_ZJ.m_Zfa((Object)"\u000bN"))) {
            f_zI.warn(RunAnimScriptDto.m_fha((Object)"\u0014\u000e>G=\u000b'\u0017n\u0006:\u0013+\n>\u0013n\u0003+\u0013+\u0004:\u0002*G'\tn\t!\u0015#\u0006\"\u000e4\u0002*G+\t:\u00157G \u0006#\u0002tGi\u001c3@"), object);
            throw new FileStorageException(c_ZJ.m_Zfa((Object)":L\u0010\u0005\u0005K\u0014W\u0019\u0005\u0003J\u000eQ\u0001L\u000eV@A\tW\u0005F\u0014J\u0012\\@Q\u0012D\u0016@\u0012V\u0001I@V\u0005T\u0015@\u000eF\u0005VN"));
        }
        Object object2 = object;
        int n = ((String)object2).lastIndexOf(0x6F & 0x3F);
        if (n >= 0) {
            object2 = ((String)object).substring(n + (5 >> 2));
        }
        if (((String)object2).isEmpty() || ((String)object2).equals(RunAnimScriptDto.m_fha((Object)"I")) || ((String)object2).equals(c_ZJ.m_Zfa((Object)"\u000bN"))) {
            throw new FileStorageException("Invalid filename extracted from zip entry: " + (String)a);
        }
        if (((String)(object2 = StringUtils.cleanPath((String)object2))).contains(RunAnimScriptDto.m_fha((Object)"`I"))) {
            throw new FileStorageException(c_ZJ.m_Zfa((Object)"c\tI\u0005K\u0001H\u0005\u0005\u0003J\u000eQ\u0001L\u000eV@L\u000eS\u0001I\tA@U\u0001Q\b\u0005\u0013@\u0011P\u0005K\u0003@@\u0002N\u000bG\u0005\u0001C\u0014@\u0012\u0005\u0003I\u0005D\u000eL\u000eBN"));
        }
        String string = a = StringUtils.hasText((String)a3222.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a3222.getTargetSubdirectory()) : f_Bj;
        if (((String)a).contains(RunAnimScriptDto.m_fha((Object)"`I"))) {
            throw new FileStorageException(c_ZJ.m_Zfa((Object)"q\u0001W\u0007@\u0014\u0005\u0013P\u0002A\tW\u0005F\u0014J\u0012\\@F\u000fK\u0014D\tK\u0013\u0005\tK\u0016D\fL\u0004\u0005\u0010D\u0014M@V\u0005T\u0015@\u000eF\u0005\u0005G\u000bN\u0002N"));
        }
        Space a3222 = Objects.requireNonNull(SpaceContext.getActiveSpace(), RunAnimScriptDto.m_fha((Object)"\u000f\u0004:\u000e8\u0002n\u0014>\u0006-\u0002n\u000e=G<\u0002?\u0012'\u0015+\u0003n\u0013!G;\u0017\"\b/\u0003n\u0006n\u0001'\u000b+I"));
        String[] stringArray = new String[4 ^ 5];
        stringArray[2 & 5] = a3222.getName();
        object = Path.of(c_Xb2.f_dG, stringArray).toAbsolutePath().normalize();
        Path path = object.resolve((String)a).normalize();
        if (!path.startsWith((Path)object)) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[5 >> 2] = object;
            objectArray[--2] = a3222.getName();
            f_zI.warn(c_ZJ.m_Zfa((Object)"u\u0001Q\b\u0005\u0014W\u0001S\u0005W\u0013D\f\u0005\u0001Q\u0014@\rU\u0014\u000b@p\u0010I\u000fD\u0004\u0005\u0014J@A\u0005W\tS\u0005A@A\tW\u0005F\u0014J\u0012\\@\u0002\u001bXG\u0005\u0012@\u0013J\fS\u0005V@J\u0015Q\u0013L\u0004@@V\u0010D\u0003@@W\u000fJ\u0014\u0005G^\u001d\u0002@C\u000fW@V\u0010D\u0003@@\u0002\u001bXG"), objectArray);
            throw new FileStorageException(RunAnimScriptDto.m_fha((Object)". \u0011/\u000b'\u0003n\u0003+\u0015'\u0011+\u0003n\u0017/\u0013&G=\u0017+\u0004'\u0001'\u0002*In&:\u0013+\n>\u0013n\u0013!G/\u0004-\u0002=\u0014n\b;\u0013=\u000e*\u0002n\u0003+\u0014'\u0000 \u0006:\u0002*G*\u000e<\u0002-\u0013!\u00157I"));
        }
        a = path.resolve((String)object2).normalize();
        if (!a.startsWith(path)) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = object2;
            objectArray[5 >> 2] = path;
            objectArray[1 ^ 3] = a3222.getName();
            f_zI.warn(c_ZJ.m_Zfa((Object)"u\u0001Q\b\u0005\u0014W\u0001S\u0005W\u0013D\f\u0005\u0001Q\u0014@\rU\u0014\u0005\u0016L\u0001\u0005\u0006L\f@\u000eD\r@N\u0005&L\f@\u000eD\r@@\u0002\u001bXG\u0005\tK@A\tW\u0005F\u0014J\u0012\\@\u0002\u001bXG\u0005\u0012@\u0013J\fS\u0005V@J\u0015Q\u0013L\u0004@@C\u000fW@V\u0010D\u0003@@\u0002\u001bXG"), objectArray);
            throw new FileStorageException("Invalid file name results in path traversal: " + (String)object2);
        }
        if (!a.startsWith((Path)object)) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[2 ^ 3] = object;
            objectArray[1 ^ 3] = a3222.getName();
            f_zI.warn(RunAnimScriptDto.m_fha((Object)"\b\u000e \u0006\"G=\u0002-\u0012<\u000e:\u001en\u0004&\u0002-\fn\u0001/\u000e\"\u0002*In3/\u0015)\u0002:G(\u000e\"\u0002n\u0017/\u0013&Gi\u001c3@n\u000e=G!\u0012:\u0014'\u0003+G=\u0017/\u0004+G<\b!\u0013n@5\u001aiG(\b<G=\u0017/\u0004+Gi\u001c3@"), objectArray);
            throw new FileStorageException(c_ZJ.m_Zfa((Object)"4D\u0012B\u0005Q@C\tI\u0005\u0005\u0010D\u0014M@W\u0005V\u000fI\u0016@\u0013\u0005\u000fP\u0014V\tA\u0005\u0005\u0004@\u0013L\u0007K\u0001Q\u0005A@V\u0010D\u0003@@A\tW\u0005F\u0014J\u0012\\N"));
        }
        String a3222 = object.relativize((Path)a).toString().replace(RunAnimScriptDto.m_fha((Object)";"), c_ZJ.m_Zfa((Object)"O"));
        if (c_Xb2.f_aj.existsByRelativePath(a3222)) {
            f_zI.info("A file already exists at path: " + a3222);
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            a22 = ((ZipFile)((Object)a22)).getInputStream(zipEntry);
            try {
                CopyOption[] copyOptionArray = new CopyOption[1];
                copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                Files.copy(a22, (Path)a, copyOptionArray);
                f_zI.info(RunAnimScriptDto.m_fha((Object)"\b\u000e\"\u0002n@5\u001aiG=\u0012-\u0004+\u0014=\u0001;\u000b\"\u001en\u0010<\u000e:\u0013+\tn\u0013!G(\u000e\"\u0002=\u001e=\u0013+\nn\u0006:Gi\u001c3@"), object2, a);
                if (a22 == null) return;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a22 != null) {
                    try {
                        a22.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a3222) {
                        throwable.addSuppressed(a3222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
            a22.close();
            return;
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not store file " + (String)object2 + ". Please try again!", (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_jN(String string) {
        Object a = string;
        c_Xb a2 = this;
        return a2.f_aj.findOneByName((String)a);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_LOGIN_SETTINGS')")
    public String m_An(MultipartFile multipartFile) {
        void a22;
        c_Xb c_Xb2 = this;
        void v0 = a22;
        Objects.requireNonNull(v0, RunAnimScriptDto.m_fha((Object)"*;\u000b:\u000e>\u0006<\u0013\b\u000e\"\u0002n\u0004/\t \b:G,\u0002n\t;\u000b\"I"));
        if (v0.isEmpty()) {
            throw new FileStorageException(c_ZJ.m_Zfa((Object)"#D\u000eK\u000fQ@V\u0014J\u0012@@D\u000e\u0005\u0005H\u0010Q\u0019\u0005\u0006L\f@N"));
        }
        Object a = StringUtils.cleanPath((String)Objects.requireNonNull(a22.getOriginalFilename(), RunAnimScriptDto.m_fha((Object)"*;\u000b:\u000e>\u0006<\u0013\b\u000e\"\u0002n\b<\u000e)\u000e \u0006\"G(\u000e\"\u0002 \u0006#\u0002n\u0004/\t \b:G,\u0002n\t;\u000b\"I")));
        if (a.contains(c_ZJ.m_Zfa((Object)"\u000bN"))) {
            throw new FileStorageException(RunAnimScriptDto.m_fha((Object)"!'\u000b+\t/\n+G-\b \u0013/\u000e \u0014n\u000e \u0011/\u000b'\u0003n\u0017/\u0013&G=\u0002?\u0012+\t-\u0002n@`IiI"));
        }
        Path path = Path.of(c_Xb2.f_dG, new String[5 >> 3]).toAbsolutePath().normalize().resolve(f_Ti).normalize();
        Path path2 = path.resolve((String)a).normalize();
        if (!path2.startsWith(path)) {
            throw new FileStorageException(c_ZJ.m_Zfa((Object)"l\u000eS\u0001I\tA@I\u000fB\tK@L\rD\u0007@@U\u0001Q\b"));
        }
        try {
            Files.createDirectories(path, new FileAttribute[3 & 4]);
            CopyOption[] copyOptionArray = new CopyOption[3 >> 1];
            copyOptionArray[3 & 4] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy(a22.getInputStream(), path2, copyOptionArray);
            f_zI.info(RunAnimScriptDto.m_fha((Object)"+!\u0000'\tn\u000e#\u0006)\u0002n@5\u001aiG=\u0012-\u0004+\u0014=\u0001;\u000b\"\u001en\u0010<\u000e:\u0013+\tn\u0013!G(\u000e\"\u0002=\u001e=\u0013+\nn\u0006:Gi\u001c3@"), a, (Object)path2);
            return a;
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not store login image " + (String)a + ". Please try again!", (Throwable)a22);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_FILE')")
    public FileInfo m_lN(String string, MultipartFile multipartFile, FileInfo fileInfo) {
        Path path;
        String string2;
        String string3;
        void a;
        int n;
        Object object;
        c_Xb a2;
        void a3;
        c_Xb c_Xb2;
        block12: {
            int n2;
            void v2;
            void a222;
            c_Xb2 = this;
            Objects.requireNonNull(a3, RunAnimScriptDto.m_fha((Object)"\u001b\u0017*\u0006:\u0002*G#\u0002:\u0006*\u0006:\u0006nO\b\u000e\"\u0002\u0007\t(\bgG!\u0005$\u0002-\u0013n\u0004/\t \b:G,\u0002n\t;\u000b\"I"));
            a2 = c_Xb2.m_cN((String)a222);
            String[] stringArray = new String[4 ^ 5];
            stringArray[3 ^ 3] = a2.getSpace().getName();
            object = Path.of(c_Xb2.f_dG, stringArray).toAbsolutePath().normalize();
            Path path2 = object.resolve(a2.getRelativePath()).normalize();
            int n3 = n = a != null && !a.isEmpty() ? 4 ^ 5 : 0;
            if (n != 0) {
                string3 = StringUtils.cleanPath((String)Objects.requireNonNull(a.getOriginalFilename(), c_ZJ.m_Zfa((Object)"h\u0015I\u0014L\u0010D\u0012Q&L\f@@J\u0012L\u0007L\u000eD\f\u0005\u0006L\f@\u000eD\r@@F\u0001K\u000eJ\u0014\u0005\u0002@@K\u0015I\f\u0005\u0017M\u0005K@W\u0005U\fD\u0003L\u000eB@F\u000fK\u0014@\u000eQN")));
                v2 = a3;
            } else {
                string3 = a2.getFileName();
                v2 = a3;
            }
            String string4 = StringUtils.hasText((String)v2.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a3.getTargetSubdirectory()) : (string2 = StringUtils.hasText((String)a2.getTargetSubdirectory()) ? a2.getTargetSubdirectory() : f_Bj);
            if (string3.contains(RunAnimScriptDto.m_fha((Object)"`I")) || string2.contains(c_ZJ.m_Zfa((Object)"\u000bN"))) {
                throw new FileStorageException(RunAnimScriptDto.m_fha((Object)". \u0011/\u000b'\u0003n\u0017/\u0013&G=\u0017+\u0004'\u0001'\u0002*G'\tn\u0012>\u0003/\u0013+G<\u0002?\u0012+\u0014:I"));
            }
            Path path3 = object.resolve(string2).normalize();
            if (!path3.startsWith((Path)object)) {
                f_zI.warn(c_ZJ.m_Zfa((Object)"0D\u0014M@Q\u0012D\u0016@\u0012V\u0001I@D\u0014Q\u0005H\u0010QN\u0005.@\u0017\u0005\u0014D\u0012B\u0005Q@V\u0015G\u0004L\u0012@\u0003Q\u000fW\u0019\u0005G^\u001d\u0002@W\u0005V\u000fI\u0016@\u0013\u0005\u000fP\u0014V\tA\u0005\u0005\u0013U\u0001F\u0005\u0005\u0012J\u000fQ@\u0002\u001bXG"), (Object)string2, object);
                throw new FileStorageException(RunAnimScriptDto.m_fha((Object)". \u0011/\u000b'\u0003n\u0003'\u0015+\u0004:\b<\u001en\u0017/\u0013&G=\u0017+\u0004'\u0001'\u0002*I"));
            }
            path = path3.resolve(string3).normalize();
            if (!path.startsWith(path3)) {
                f_zI.warn(c_ZJ.m_Zfa((Object)"0D\u0014M@Q\u0012D\u0016@\u0012V\u0001I@D\u0014Q\u0005H\u0010Q@S\tD@K\u0005R@C\tI\u0005K\u0001H\u0005\u000b@c\tI\u0005K\u0001H\u0005\u0005G^\u001d\u0002@L\u000e\u0005\u0004L\u0012@\u0003Q\u000fW\u0019\u0005G^\u001d\u0002@W\u0005V\u000fI\u0016@\u0013\u0005\u000fP\u0014V\tA\u0005"), (Object)string3, (Object)path3);
                throw new FileStorageException(RunAnimScriptDto.m_fha((Object)". \u0011/\u000b'\u0003n\u0001'\u000b+\t/\n+G=\u0017+\u0004'\u0001'\u0002*I"));
            }
            int n4 = n2 = !((String)(object = object.relativize(path).toString().replace(c_ZJ.m_Zfa((Object)"<"), RunAnimScriptDto.m_fha((Object)"H")))).equals(a2.getRelativePath()) ? --1 : 0;
            if (n2 != 0 && c_Xb2.f_aj.existsByRelativePathAndIdNot((String)object, (String)a222)) {
                throw new FileStorageException(c_ZJ.m_Zfa((Object)"d@C\tI\u0005\u0005\u0017L\u0014M@Q\bL\u0013\u0005\u000eD\r@@D\fW\u0005D\u0004\\@@\u0018L\u0013Q\u0013\u0005\u0001Q@Q\b@@Q\u0001W\u0007@\u0014\u0005\fJ\u0003D\u0014L\u000fKN"));
            }
            try {
                if (n != 0) {
                    if (Files.exists(path2, new LinkOption[3 >> 2])) {
                        Files.deleteIfExists(path2);
                        f_zI.info(RunAnimScriptDto.m_fha((Object)"\u0001\u000b*G(\u000e\"\u0002n\u0004!\t:\u0002 \u0013n\u0003+\u000b+\u0013+\u0003n\u0001<\b#G(\u000e\"\u0002=\u001e=\u0013+\ntG5\u001a"), (Object)path2);
                    }
                    Files.createDirectories(path3, new FileAttribute[2 & 5]);
                    CopyOption[] copyOptionArray = new CopyOption[--1];
                    copyOptionArray[2 & 5] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy(a.getInputStream(), path, copyOptionArray);
                    f_zI.info(c_ZJ.m_Zfa((Object)"k\u0005R@C\tI\u0005\u0005\u0003J\u000eQ\u0005K\u0014\u0005\u0006J\u0012\u0005G^\u001d\u0002@V\u0015F\u0003@\u0013V\u0006P\fI\u0019\u0005\u0017W\tQ\u0014@\u000e\u0005\u0014J@C\tI\u0005V\u0019V\u0014@\r\u0005\u0001Q@\u0002\u001bXG"), (Object)string3, (Object)path);
                    break block12;
                }
                if (n2 == 0) break block12;
                if (Files.exists(path2, new LinkOption[3 >> 2])) {
                    Files.createDirectories(path3, new FileAttribute[0]);
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(path2, path, copyOptionArray);
                    f_zI.info(RunAnimScriptDto.m_fha((Object)"\b\u000e\"\u0002n\n!\u0011+\u0003n\u0001<\b#G5\u001an\u0013!G5\u001a"), (Object)path2, (Object)path);
                    break block12;
                }
                f_zI.warn(c_ZJ.m_Zfa((Object)"j\fA@C\tI\u0005\u0005\u000eJ\u0014\u0005\u0006J\u0015K\u0004\u0005\u0001Q@^\u001d\u0005\u0006J\u0012\u0005\rJ\u0016@@J\u0010@\u0012D\u0014L\u000fKL\u0005\u0002P\u0014\u0005\r@\u0014D\u0004D\u0014D@@\u0018L\u0013Q\u0005AN"), (Object)path2);
                throw new NotFoundException(RunAnimScriptDto.m_fha((Object)"\b\u000e\"\u0002n\t!\u0013n\u0001!\u0012 \u0003n\u0001!\u0015n\u0012>\u0003/\u0013+G!\u0017+\u0015/\u0013'\b I"));
            }
            catch (IOException a222) {
                f_zI.error(c_ZJ.m_Zfa((Object)"#J\u0015I\u0004\u0005\u000eJ\u0014\u0005\u0015U\u0004D\u0014@@C\tI\u0005\u0005G^\u001d\u0002@A\u0015@@Q\u000f\u0005)j%]\u0003@\u0010Q\tJ\u000e"), (Object)a2.getFileName(), (Object)a222);
                throw new FileStorageException(RunAnimScriptDto.m_fha((Object)"\r\b;\u000b*G \b:G;\u0017*\u0006:\u0002n\u0013&\u0002n\u0001'\u000b+In7\"\u0002/\u0014+G:\u00157G/\u0000/\u000e I"));
            }
        }
        c_Xb c_Xb3 = a2;
        c_Xb c_Xb4 = a2;
        c_Xb4.setName(a3.getName());
        c_Xb4.setDsc(a3.getDsc());
        c_Xb3.setFileName(string3);
        c_Xb3.setTargetSubdirectory(string2);
        a2.setRelativePath((String)object);
        if (n != 0) {
            c_Xb c_Xb5 = a2;
            c_Xb5.setFileSize(Long.valueOf(a.getSize()));
            c_Xb5.setFileType(StringUtils.hasText((String)a.getContentType()) ? a.getContentType() : c_ZJ.m_Zfa((Object)"D\u0010U\fL\u0003D\u0014L\u000fKOJ\u0003Q\u0005QMV\u0014W\u0005D\r"));
            a2.setChecksum(c_Fb.m_se((Path)path));
        }
        return (FileInfo)c_Xb2.f_aj.save((Object)a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public void m_Go(Collection<FileInfo> collection) {
        Iterator a;
        c_Xb c_Xb2 = this;
        Object object = a.stream().map(BaseModel::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Object object2 = a.stream().map(FileInfo::getName).filter(c_Uc::m_tF).collect(Collectors.toSet());
        object = c_Xb2.f_aj.findByIdInOrNameIn(object, object2);
        object2 = object.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(FileInfo::getName, Function.identity()));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        a = a.iterator();
        while (a.hasNext()) {
            FileInfo fileInfo;
            c_Xb a2 = (FileInfo)a.next();
            Object object3 = a2.getId() != null ? (FileInfo)object2.get(a2.getId()) : (fileInfo = c_Uc.m_tF((String)a2.getName()) ? (FileInfo)object.get(a2.getName()) : null);
            if (fileInfo != null) {
                c_Xb2.f_ai.copyForUpdate((Object)a2, (SpaceBaseModel)fileInfo, new String[5 >> 3]);
                arrayList.add(fileInfo);
                continue;
            }
            arrayList.add(a2);
        }
        c_Xb2.f_aj.bulkSave(arrayList);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public List<FileInfo> m_Pm() {
        c_Xb a;
        return a.f_aj.findAll();
    }

    private static /* synthetic */ NotFoundException m_ao(String a) {
        return new NotFoundException("File info not found with id: " + a);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE')")
    public FileInfo m_Om(MultipartFile multipartFile, FileInfo fileInfo) {
        String string;
        c_Xb c_Xb2;
        String string2;
        void a22;
        c_Xb a = fileInfo;
        c_Xb a3 = this;
        void v0 = a22;
        Objects.requireNonNull(a, RunAnimScriptDto.m_fha((Object)"!'\u000b+. \u0001!G!\u0005$\u0002-\u0013n\u0004/\t \b:G,\u0002n\t;\u000b\"I"));
        Objects.requireNonNull(v0, c_ZJ.m_Zfa((Object)"-P\fQ\tU\u0001W\u0014c\tI\u0005\u0005\u0003D\u000eK\u000fQ@G\u0005\u0005\u000eP\fIN"));
        if (v0.isEmpty()) {
            throw new FileStorageException(RunAnimScriptDto.m_fha((Object)"$/\t \b:G=\u0013!\u0015+G/\tn\u0002#\u0017:\u001en\u0001'\u000b+I"));
        }
        String string3 = StringUtils.cleanPath((String)Objects.requireNonNull(a22.getOriginalFilename(), c_ZJ.m_Zfa((Object)"-P\fQ\tU\u0001W\u0014c\tI\u0005\u0005\u000fW\tB\tK\u0001I@C\tI\u0005K\u0001H\u0005\u0005\u0003D\u000eK\u000fQ@G\u0005\u0005\u000eP\fIN")));
        String string4 = string2 = StringUtils.hasText((String)a.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a.getTargetSubdirectory()) : f_Bj;
        if (string3.contains(RunAnimScriptDto.m_fha((Object)"`I")) || string2.contains(c_ZJ.m_Zfa((Object)"\u000bN"))) {
            throw new FileStorageException(RunAnimScriptDto.m_fha((Object)"\u0007\t8\u0006\"\u000e*G(\u000e\"\u0002n\u0017/\u0013&G=\u0017+\u0004'\u0001'\u0002*I"));
        }
        Space space = Objects.requireNonNull(SpaceContext.getActiveSpace(), c_ZJ.m_Zfa((Object)"d\u0003Q\tS\u0005\u0005\u0013U\u0001F\u0005\u0005\tV@W\u0005T\u0015L\u0012@\u0004\u0005\u0014J@P\u0010I\u000fD\u0004\u0005\u0001\u0005\u0006L\f@N"));
        String[] stringArray = new String[3 >> 1];
        stringArray[3 >> 2] = space.getName();
        Path path = Path.of(a3.f_dG, stringArray).toAbsolutePath().normalize();
        Path path2 = path.resolve(string2).normalize();
        if (!path2.startsWith(path)) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = string2;
            objectArray[--1] = path;
            objectArray[--2] = space.getName();
            f_zI.warn(RunAnimScriptDto.m_fha((Object)"\u001e\u0006:\u000fn\u0013<\u00068\u0002<\u0014/\u000bn\u0006:\u0013+\n>\u0013`G\u001b\u0017\"\b/\u0003n\u0013!G*\u0002<\u000e8\u0002*G*\u000e<\u0002-\u0013!\u00157Gi\u001c3@n\u0015+\u0014!\u000b8\u0002=G!\u0012:\u0014'\u0003+G=\u0017/\u0004+G<\b!\u0013n@5\u001aiG(\b<G=\u0017/\u0004+Gi\u001c3@"), objectArray);
            throw new FileStorageException(c_ZJ.m_Zfa((Object)")K\u0016D\fL\u0004\u0005\u0004L\u0012@\u0003Q\u000fW\u0019\u0005\u0010D\u0014M@V\u0010@\u0003L\u0006L\u0005AN"));
        }
        Path path3 = path2.resolve(string3).normalize();
        if (!path3.startsWith(path2)) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = string3;
            objectArray[2 ^ 3] = path2;
            objectArray[1 ^ 3] = space.getName();
            f_zI.warn(RunAnimScriptDto.m_fha((Object)"\u001e\u0006:\u000fn\u0013<\u00068\u0002<\u0014/\u000bn\u0006:\u0013+\n>\u0013n\u0011'\u0006n\u0001'\u000b+\t/\n+In!'\u000b+\t/\n+Gi\u001c3@n\u000e G*\u000e<\u0002-\u0013!\u00157Gi\u001c3@n\u0015+\u0014!\u000b8\u0002=G!\u0012:\u0014'\u0003+G(\b<G=\u0017/\u0004+Gi\u001c3@"), objectArray);
            throw new FileStorageException(c_ZJ.m_Zfa((Object)")K\u0016D\fL\u0004\u0005\u0006L\f@\u000eD\r@@V\u0010@\u0003L\u0006L\u0005AN"));
        }
        String string5 = path.relativize(path3).toString().replace(RunAnimScriptDto.m_fha((Object)";"), c_ZJ.m_Zfa((Object)"O"));
        if (a3.f_aj.existsByRelativePath(string5)) {
            throw new FileStorageException(RunAnimScriptDto.m_fha((Object)"\u000fG(\u000e\"\u0002n\u0010'\u0013&G:\u000f'\u0014n\t/\n+G/\u000b<\u0002/\u00037G+\u001f'\u0014:\u0014n\u000e G:\u000f+G:\u0006<\u0000+\u0013n\u000b!\u0004/\u0013'\b I"));
        }
        try {
            Files.createDirectories(path2, new FileAttribute[3 >> 2]);
            CopyOption[] copyOptionArray = new CopyOption[3 >> 1];
            copyOptionArray[3 >> 2] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy(a22.getInputStream(), path3, copyOptionArray);
            f_zI.info(c_ZJ.m_Zfa((Object)"c\tI\u0005\u0005G^\u001d\u0002@V\u0015F\u0003@\u0013V\u0006P\fI\u0019\u0005\u0017W\tQ\u0014@\u000e\u0005\u0014J@C\tI\u0005V\u0019V\u0014@\r\u0005\u0001Q@\u0002\u001bXG"), (Object)string3, (Object)path3);
            c_Xb c_Xb3 = a;
            a.setFileName(string3);
            c_Xb3.setRelativePath(string5);
            c_Xb3.setFileSize(Long.valueOf(a22.getSize()));
            c_Xb2 = a;
            string = StringUtils.hasText((String)a22.getContentType()) ? a22.getContentType() : RunAnimScriptDto.m_fha((Object)"/\u0017>\u000b'\u0004/\u0013'\b H!\u0004:\u0002:J=\u0013<\u0002/\n");
        }
        catch (IOException a22) {
            f_zI.error(c_ZJ.m_Zfa((Object)"f\u000fP\fA@K\u000fQ@V\u0014J\u0012@@C\tI\u0005\u0005G^\u001d\u0002@A\u0015@@Q\u000f\u0005)j%]\u0003@\u0010Q\tJ\u000e"), (Object)string3, (Object)a22);
            throw new FileStorageException(RunAnimScriptDto.m_fha((Object)"\r\b;\u000b*G \b:G=\u0013!\u0015+G:\u000f+G;\u0017\"\b/\u0003+\u0003n\u0001'\u000b+In7\"\u0002/\u0014+G:\u00157G/\u0000/\u000e I"));
        }
        {
            c_Xb2.setFileType(string);
            c_Xb c_Xb4 = a;
            c_Xb4.setTargetSubdirectory(string2);
            c_Xb4.setChecksum(c_Fb.m_se((Path)path3));
            return (FileInfo)a3.f_aj.save((Object)a);
        }
    }
}

