/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.faceplate.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.faceplate.model.FaceplateElement;
import com.inscada.mono.faceplate.model.FaceplatePlaceholder;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="faceplate")
@AttributeOverride(name="id", column=@Column(name="faceplate_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"svgFileId", "svgFile"}), @CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})})
public class Faceplate
extends SpaceBaseModel {
    @JsonIgnore
    @OneToOne(optional=false)
    @JoinColumn(name="svg_file_id")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private FileInfo svgFile;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @OneToMany(mappedBy="faceplate")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<FaceplatePlaceholder> faceplatePlaceholders;
    @Size(max=255)
    private String dsc;
    @NotBlank
    @Size(max=100)
    private String name;
    @OneToMany(mappedBy="faceplate")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<FaceplateElement> faceplateElements;
    @Column(name="svg_file_id", updatable=false, insertable=false)
    private String svgFileId;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    @Size(max=25)
    private String color;

    public void addPlaceholder(FaceplatePlaceholder faceplatePlaceholder) {
        Faceplate a;
        Faceplate a2 = faceplatePlaceholder;
        Faceplate faceplate = a = this;
        a2.setFaceplate(faceplate);
        faceplate.faceplatePlaceholders.add(a2);
    }

    public void setSvgFile(FileInfo fileInfo) {
        Faceplate a;
        Faceplate a2 = fileInfo;
        Faceplate faceplate = a = this;
        faceplate.svgFile = a2;
        faceplate.svgFileId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setFaceplateElements(Set<FaceplateElement> set) {
        Object a = set;
        Faceplate a2 = this;
        a2.faceplateElements = a;
    }

    public void setFaceplatePlaceholders(Set<FaceplatePlaceholder> set) {
        Object a = set;
        Faceplate a2 = this;
        a2.faceplatePlaceholders = a;
    }

    public void setColor(String string) {
        Object a = string;
        Faceplate a2 = this;
        a2.color = a;
    }

    public String getSvgFileId() {
        Faceplate a;
        return a.svgFileId;
    }

    public void setName(String string) {
        Object a = string;
        Faceplate a2 = this;
        a2.name = a;
    }

    private static /* synthetic */ boolean lambda$removeElement$0(String string, FaceplateElement faceplateElement) {
        String a = faceplateElement;
        String a2 = string;
        return a.getId().equals(a2);
    }

    public void setProjectId(String string) {
        Object a = string;
        Faceplate a2 = this;
        a2.projectId = a;
    }

    public void setProject(Project project) {
        Faceplate a;
        Faceplate a2 = project;
        Faceplate faceplate = a = this;
        faceplate.project = a2;
        faceplate.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Set<FaceplateElement> getFaceplateElements() {
        Faceplate a;
        return a.faceplateElements;
    }

    public void addElement(FaceplateElement faceplateElement) {
        Faceplate a;
        Faceplate a2 = faceplateElement;
        Faceplate faceplate = a = this;
        a2.setFaceplate(faceplate);
        faceplate.faceplateElements.add(a2);
    }

    public boolean equals(Object object) {
        Faceplate a = this;
        Object a2 = object;
        if (a == a2) {
            return 3 >> 1;
        }
        if (!(a2 instanceof Faceplate)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (2 & 5) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return (2 ^ 3) != 0;
        }
        return false;
    }

    public int hashCode() {
        Faceplate a;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[3 & 5] = a.getProjectId();
        objectArray[--2] = a.getName();
        return Objects.hash(objectArray);
    }

    public FileInfo getSvgFile() {
        Faceplate a;
        return a.svgFile;
    }

    public void setDsc(String string) {
        Object a = string;
        Faceplate a2 = this;
        a2.dsc = a;
    }

    public String getDsc() {
        Faceplate a;
        return a.dsc;
    }

    public Project getProject() {
        Faceplate a;
        return a.project;
    }

    public Faceplate() {
        Faceplate a;
        Faceplate faceplate = a;
        a.faceplateElements = new HashSet();
        faceplate.faceplatePlaceholders = new HashSet();
    }

    public void removeElement(String string) {
        Object a = string;
        Faceplate a2 = this;
        a2.faceplateElements.removeIf(arg_0 -> Faceplate.lambda$removeElement$0((String)a, arg_0));
    }

    public String getName() {
        Faceplate a;
        return a.name;
    }

    public String getProjectId() {
        Faceplate a;
        return a.projectId;
    }

    public void setSvgFileId(String string) {
        Object a = string;
        Faceplate a2 = this;
        a2.svgFileId = a;
    }

    public Set<FaceplatePlaceholder> getFaceplatePlaceholders() {
        Faceplate a;
        return a.faceplatePlaceholders;
    }

    public String getColor() {
        Faceplate a;
        return a.color;
    }
}

