/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datasource.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="custom_query")
@AttributeOverride(name="id", column=@Column(name="custom_query_id", length=36, nullable=false, updatable=false))
@Inheritance(strategy=InheritanceType.JOINED)
@SQLRestriction(value="deleted_dttm IS NULL")
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public abstract class CustomQuery
extends SpaceBaseModel {
    @NotBlank
    @Column(name="query_str")
    private String queryStr;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @Size(max=255)
    private String dsc;
    @NotBlank
    @Size(max=100)
    private String name;

    public void setDsc(String string) {
        Object a = string;
        CustomQuery a2 = this;
        a2.dsc = a;
    }

    public String getDsc() {
        CustomQuery a;
        return a.dsc;
    }

    public CustomQuery() {
        CustomQuery a;
    }

    public String getProjectId() {
        CustomQuery a;
        return a.projectId;
    }

    public void setQueryStr(String string) {
        Object a = string;
        CustomQuery a2 = this;
        a2.queryStr = a;
    }

    public String getQueryStr() {
        CustomQuery a;
        return a.queryStr;
    }

    public Project getProject() {
        CustomQuery a;
        return a.project;
    }

    public void setProject(Project project) {
        CustomQuery a;
        CustomQuery a2 = project;
        CustomQuery customQuery = a = this;
        customQuery.project = a2;
        customQuery.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setProjectId(String string) {
        Object a = string;
        CustomQuery a2 = this;
        a2.projectId = a;
    }

    public void setName(String string) {
        Object a = string;
        CustomQuery a2 = this;
        a2.name = a;
    }

    public String getName() {
        CustomQuery a;
        return a.name;
    }
}

