/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.opcua.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.opcua.model.OpcUaDevice;
import com.inscada.mono.communication.protocols.opcua.r.c_BD;
import com.inscada.mono.communication.protocols.opcua.r.c_Bg;
import com.inscada.mono.communication.protocols.opcua.r.c_uf;
import com.inscada.mono.shared.l.c_nA;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="opc_ua_connection")
public class OpcUaConnection
extends Connection<OpcUaDevice> {
    @Column(name="username")
    private String username;
    @Column(name="is_https_enabled")
    private Boolean isHttpsEnabled;
    @Column(name="password")
    @Convert(converter=c_nA.class)
    private String password;
    @NotNull
    @Column(name="is_username_password_authentication")
    private Boolean isUsernamePasswordAuthentication;
    @NotNull
    @Column(name="is_anonymous_authentication")
    private Boolean isAnonymousAuthentication;
    @Min(value=0L)
    @Max(value=65535L)
    @Column(name="https_port")
    private Integer httpsPort;
    @NotNull
    @Column(name="security_policy")
    private c_uf securityPolicy;
    @Column(name="encoding_type")
    private c_Bg encodingType;
    @Column(name="server_name")
    private String serverName;
    @NotNull
    @Column(name="security_mode")
    private c_BD securityMode;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<OpcUaDevice> devices;
    @Min(value=100L)
    @Column(name="timeout")
    private Integer timeoutInMs;

    public void setIsAnonymousAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isAnonymousAuthentication = a;
    }

    public Boolean getIsUsernamePasswordAuthentication() {
        OpcUaConnection a;
        return a.isUsernamePasswordAuthentication;
    }

    public void setSecurityMode(c_BD c_BD2) {
        OpcUaConnection a = c_BD2;
        OpcUaConnection a2 = this;
        a2.securityMode = a;
    }

    public Integer getHttpsPort() {
        OpcUaConnection a;
        return a.httpsPort;
    }

    public void setEncodingType(c_Bg c_Bg2) {
        OpcUaConnection a = c_Bg2;
        OpcUaConnection a2 = this;
        a2.encodingType = a;
    }

    public String getServerName() {
        OpcUaConnection a;
        return a.serverName;
    }

    public void setHttpsPort(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.httpsPort = a;
    }

    public String getPassword() {
        OpcUaConnection a;
        return a.password;
    }

    public Integer getTimeoutInMs() {
        OpcUaConnection a;
        return a.timeoutInMs;
    }

    public String getUsername() {
        OpcUaConnection a;
        return a.username;
    }

    public OpcUaConnection() {
        OpcUaConnection a;
        OpcUaConnection opcUaConnection = a;
        opcUaConnection.devices = new HashSet();
    }

    public Boolean getIsHttpsEnabled() {
        OpcUaConnection a;
        return a.isHttpsEnabled;
    }

    public void setIsUsernamePasswordAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isUsernamePasswordAuthentication = a;
    }

    public void setDevices(Set<OpcUaDevice> set) {
        Object a = set;
        OpcUaConnection a2 = this;
        a2.devices = a;
    }

    public void setIsHttpsEnabled(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isHttpsEnabled = a;
    }

    public void setSecurityPolicy(c_uf c_uf2) {
        OpcUaConnection a = c_uf2;
        OpcUaConnection a2 = this;
        a2.securityPolicy = a;
    }

    public Set<OpcUaDevice> getDevices() {
        OpcUaConnection a;
        return a.devices;
    }

    public void setPassword(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.password = a;
    }

    public c_BD getSecurityMode() {
        OpcUaConnection a;
        return a.securityMode;
    }

    public c_uf getSecurityPolicy() {
        OpcUaConnection a;
        return a.securityPolicy;
    }

    public void setUsername(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.username = a;
    }

    public Boolean getIsAnonymousAuthentication() {
        OpcUaConnection a;
        return a.isAnonymousAuthentication;
    }

    public void setServerName(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.serverName = a;
    }

    public void setTimeoutInMs(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.timeoutInMs = a;
    }

    public c_Bg getEncodingType() {
        OpcUaConnection a;
        return a.encodingType;
    }
}

