/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_mj;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.manager.LeaderFencedManager;
import com.inscada.mono.cluster.services.c_H;
import com.inscada.mono.communication.base.e.c_Lj;
import com.inscada.mono.communication.base.e.c_MK;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.r.c_Ck;
import com.inscada.mono.communication.base.services.c_J;
import com.inscada.mono.communication.base.services.c_Je;
import com.inscada.mono.communication.base.services.c_dk;
import com.inscada.mono.communication.base.services.c_oI;
import com.inscada.mono.config.c_VB;
import com.inscada.mono.license.e.c_SC;
import com.inscada.mono.log.e.c_eC;
import com.inscada.mono.notification.model.Notification;
import com.inscada.mono.project.e.c_I;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
extends LeaderFencedManager
implements c_I {
    private final c_eC f_et;
    private final JedisPooled f_Ys;
    public static final short f_Is = 207;
    public static final short f_Ss = 210;
    private final c_mj f_sT;
    public static final short f_bs = 209;
    private static final Logger f_td = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short f_jT = 202;
    private final c_oI<C, V> f_Wu;
    private final c_dk f_XS;
    public static final short f_rR = 208;
    public static final short f_YT = 203;
    private final c_SC f_oT;
    public static final short f_ks = 206;
    public static final short f_nt = 204;
    public static final short f_Cs = 205;
    private static final String f_Rs = "activeConnections";
    private final Lock f_Ct;
    public static final short f_Js = 201;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$leader$0(Collection collection, Set set) {
        void a;
        Object a2 = set;
        ConnectionManager a3 = this;
        a.addAll(a3.f_XS.m_sBa((Set)a2));
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, Notification.m_pJ((Object)"2B\u0015q\u0000K\u0014B3B\u0010R\u0004T\u0015\u0007\u0002F\u000fI\u000eSAE\u0004\u0007\u000fR\rK"));
        Objects.requireNonNull(a.getConnectionId(), c_VB.m_zq((Object)"\u0018\n5\u000b>\u0006/\f4\u000b\u0012\u0001{\f5E\b\u0000/3:\t.\u0000\t\u0000*\u0010>\u0016/E8\u00045\u000b4\u0011{\u0007>E5\u00107\t"));
        if (a2.f_XC.m_da()) {
            f_td.debug(Notification.m_pJ((Object)"-b c$u[\u00072B\u0015S\bI\u0006\u0007\u0017F\u0013N\u0000E\rBAQ\u0000K\u0014BAA\u000eUAD\u000eI\u000fB\u0002S\bH\u000f\u0007\u001aZAK\u000eD\u0000K\r^[\u0007\u001aZ"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_td.debug(c_VB.m_zq((Object)"+\u0014+v)\u001e$\u001f \t_{7>\u0014.\u0000(\u00112\u000b<E7\u0000:\u0001>\u0017{\u00114E(\u0000/E-\u0004)\f:\u00077\u0000{\u0013:\t.\u0000{\u00034\u0017{\u00064\u000b5\u00008\u00112\n5E \u0018aE \u0018"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x45FF & 0x3ACC)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_XS.m_tCa((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_Wu.m_Tba((String)a)) != null) {
                void a3;
                a.m_gW((List)a3);
            }
        });
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, Notification.m_pJ((Object)"2B\u0015q\u0000K\u0014B3B\u0010R\u0004T\u0015\u0007\u0002F\u000fI\u000eSAE\u0004\u0007\u000fR\rK")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), c_VB.m_zq((Object)"\u0018\n5\u000b>\u0006/\f4\u000b\u0012\u0001{\f5E\b\u0000/3:\t.\u0000\t\u0000*\u0010>\u0016/E8\u00045\u000b4\u0011{\u0007>E5\u00107\t")));
        if (a3.f_XC.m_da()) {
            f_td.debug(Notification.m_pJ((Object)"k$f%b3\u001dAt\u0004S\u0015N\u000f@A\\\u001c\u0007\u0017F\u0013N\u0000E\rBAQ\u0000K\u0014B\u0012\u0007\rH\u0002F\rK\u0018\t"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_td.debug(c_VB.m_zq((Object)"\u0015*\u0015H\u0017 \u001a!\u001e7aE\t\u0000*\u0010>\u0016/\f5\u0002{\t>\u0004?\u0000)E/\n{\u0016>\u0011{\u001e&E-\u0004)\f:\u00077\u0000{\u0013:\t.\u0000(K"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = new ArrayList(a22);
            a3.f_XC.m_Fa(Short.valueOf((short)(0x21DF & 0x5EED)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(Notification.m_pJ((Object)"a\u0000N\rB\u0005\u0007\u0015HAu1dAT\u0004SAQ\u0000U\bF\u0003K\u0004\u0007\u0017F\rR\u0004T"), (Throwable)a22);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_XC.m_La();
        String[] stringArray = new String[--4];
        stringArray[3 >> 2] = c_VB.m_zq((Object)"\b1\u001a7\u000f:\u0018*\u0015+\u001e&\u000f,\u0014+");
        stringArray[3 & 5] = Notification.m_pJ((Object)"t5h1x\"h/i$d5n.i");
        stringArray[5 >> 1] = c_VB.m_zq((Object)"\r,\u001e2\u0004&\u0014+\u0015 \u00181\u0012*\u0015:\u00121\u001e(");
        stringArray[--3] = Notification.m_pJ((Object)"q(b6x7f3n e-b");
        connectionManager2.f_sT.m_XFa(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_Ck> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(Notification.m_pJ((Object)"k$f%b3\u001dA`\u0004S\u0015N\u000f@AF\rKAD\u000eI\u000fB\u0002S\bH\u000f\u0007\u0012S\u0000S\u0014T\u0004TAA\u000eUAW\u0013H\u000bB\u0002SA\\\u001c\u0007\rH\u0002F\rK\u0018\t"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_td.debug(c_VB.m_zq((Object)"+\u0014+v)\u001e$\u001f \t_{7>\u0014.\u0000(\u00112\u000b<E7\u0000:\u0001>\u0017{\u00034\u0017{\u00047\t{\u00064\u000b5\u00008\u00112\n5E(\u0011:\u0011.\u0016>\u0016{\u00034\u0017{\u0015)\n1\u00008\u0011{\u001e&K"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 & 4] = a;
            return (Map)a2.f_XC.m_Fa(Short.valueOf((short)(0x49DE & 0x36F1)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(Notification.m_pJ((Object)"k$f%b3\u001dAt\u0015F\u0013S\bI\u0006\u0007\u0002H\u000fI\u0004D\u0015N\u000eIA\\\u001c\u0007\rH\u0002F\rK\u0018\t"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_td.debug(c_VB.m_zq((Object)"+\u0014+v)\u001e$\u001f \t_{7>\u0014.\u0000(\u00112\u000b<E7\u0000:\u0001>\u0017{\u00114E(\u0011:\u0017/E8\n5\u000b>\u0006/\f4\u000b{\u001e&K"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x2BDF & 0x54E9)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(Notification.m_pJ((Object)"-b c$u[\u00072S\u000eW\u0011N\u000f@AF\rKAD\u000eI\u000fB\u0002S\bH\u000fTAA\u000eUAW\u0013H\u000bB\u0002SA\\\u001c\u0007\rH\u0002F\rK\u0018\t"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(c_VB.m_zq((Object)"+\u0014+v)\u001e$\u001f \t_{7>\u0014.\u0000(\u00112\u000b<E7\u0000:\u0001>\u0017{\u00114E(\u00114\u0015{\u00047\t{\u00064\u000b5\u00008\u00112\n5\u0016{\u00034\u0017{\u0015)\n1\u00008\u0011{\u001e&K"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 >> 2] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x23FF & 0x5CCF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_sT.m_gEa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_Ct.lock();
            try {
                Runnable runnable = () -> a2.lambda$startConnectionInternal$3((Connection)a);
                a2.fenced("Start connection " + a.getId(), runnable).run();
                return;
            }
            finally {
                a2.f_Ct.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(Notification.m_pJ((Object)"-b c$u[\u00071B\u0013A\u000eU\fN\u000f@AE\u0013H\u0016T\u0004\u0007\u000eW\u0004U\u0000S\bH\u000f\u0007\u0007H\u0013\u0007\u0002H\u000fI\u0004D\u0015N\u000eIA\\\u001c\u0007\rH\u0002F\rK\u0018\t"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_td.debug(c_VB.m_zq((Object)"\u0015*\u0015H\u0017 \u001a!\u001e7aE\t\u0000*\u0010>\u0016/\f5\u0002{\t>\u0004?\u0000)E/\n{\u0015>\u0017=\n)\b{\u0007)\n,\u0016>E4\u0015>\u0017:\u00112\n5E=\n)E8\n5\u000b>\u0006/\f4\u000b{\u001e&K"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            return a2.f_XC.m_Fa(Short.valueOf((short)(0x2ADE & 0x55F3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_Ck> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_XS.m_Yca((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Wu.m_Tba((String)a)) instanceof c_J) {
            return ((c_J)a).m_ca();
        }
        throw new BrowseOperationException(c_VB.m_zq((Object)"\u0019\u00174\u0012(\u0000{\n+\u0000)\u0004/\f4\u000b{\u000b4\u0011{\u0016.\u0015+\n)\u0011>\u0001"));
    }

    protected c_Ck getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Wu.m_Tba((String)a)) != null && a.m_wW()) {
            return c_Ck.f_is;
        }
        return c_Ck.f_cs;
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(Notification.m_pJ((Object)"k$f%b3\u001dAt\u0015H\u0011W\bI\u0006\u0007\u0002H\u000fI\u0004D\u0015N\u000eIA\\\u001c\u0007\rH\u0002F\rK\u0018\t"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_td.debug(c_VB.m_zq((Object)"\u0015*\u0015H\u0017 \u001a!\u001e7aE\t\u0000*\u0010>\u0016/\f5\u0002{\t>\u0004?\u0000)E/\n{\u0016/\n+E8\n5\u000b>\u0006/\f4\u000b{\u001e&K"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x16FA & 0x69CF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_Ck getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_XS.m_QAa((String)a2, (String)a)) == null) {
            return c_Ck.f_cs;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_Ck getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(Notification.m_pJ((Object)"k$f%b3\u001dA`\u0004S\u0015N\u000f@AD\u000eI\u000fB\u0002S\bH\u000f\u0007\u0012S\u0000S\u0014TAA\u000eUA\\\u001c\u0007\rH\u0002F\rK\u0018\t"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_td.debug(c_VB.m_zq((Object)"+\u0014+v)\u001e$\u001f \t_{7>\u0014.\u0000(\u00112\u000b<E7\u0000:\u0001>\u0017{\u00034\u0017{\u00064\u000b5\u00008\u00112\n5E(\u0011:\u0011.\u0016{\u00034\u0017{\u001e&K"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            return (c_Ck)a2.f_XC.m_Fa(Short.valueOf((short)(0x7CEF & 0x3DB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_XS.m_eda((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_Je c_Je2 = a2.f_Wu.m_Tba(a.getConnectionId());
        if (c_Je2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_Je2.m_Rw(a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[3 & 5] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_td.info(Notification.m_pJ((Object)"\"H\u000fI\u0004D\u0015N\u000eI,F\u000fF\u0006B\u0013\u0007Ik\u0004F\u0005B\u0013\u0007\u001aZH\u001dAu\u0004T\u0015H\u0013N\u000f@AD\u000eI\u000fB\u0002S\bH\u000f\u001dA\\\u001c\u0007In%\u001dA\\\u001c\u000e"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a2.getName();
            objectArray[3 >> 1] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_et.m_Tk(a2.getProject()).m_T("Connection Restore (Leader " + (String)a + ")", c_VB.m_zq((Object)"~\u0016{M\u0012!aE~\u0016rE=\u00042\t>\u0001{\u00114E)\u0000(\u00114\u0017>K{&:\u0010(\u0000aE~\u0016").formatted(objectArray));
            try {
                f_td.warn(Notification.m_pJ((Object)"\"H\u000fI\u0004D\u0015N\u000eI,F\u000fF\u0006B\u0013\u0007Ik\u0004F\u0005B\u0013\u0007\u001aZH\u001dAf\u0015S\u0004J\u0011S\bI\u0006\u0007\u0015HAT\u0015H\u0011\u0007\u0002H\u000fI\u0004D\u0015N\u000eIA\\\u001c\u0007\u0000A\u0015B\u0013\u0007\u0013B\u0012S\u000eU\u0000S\bH\u000f\u0007\u0007F\bK\u0014U\u0004\t"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 ^ 3] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_td.error(c_VB.m_zq((Object)"&4\u000b5\u00008\u00112\n5(:\u000b:\u0002>\u0017{M\u0017\u0000:\u0001>\u0017{\u001e&LaE\u001d\u00042\t>\u0001{\u00114E(\u00114\u0015{\u00064\u000b5\u00008\u00112\n5E \u0018{\u0004=\u0011>\u0017{\u0017>\u0016/\n)\u0004/\f4\u000b{\u0003:\f7\u0010)\u0000aE \u0018"), objectArray2);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_MK.class})
    public void handleRestartEvent(c_MK c_MK2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_XC.m_da()) {
            ConnectionManager a2 = a.m_GFa();
            f_td.info(c_VB.m_zq((Object)")\u001e$\u001f \t_{-:\u000b?\t2\u000b<E\t\u0000(\u0011:\u0017/ -\u00005\u0011{\u00034\u0017{\u00064\u000b5\u00008\u00112\n5_{\u001e&Es,\u001f_{\u001e&L"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_Ct.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_Ck.f_is) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_Ct.unlock();
            }
        }
        f_td.debug(Notification.m_pJ((Object)"/h/\n-b c$u[\u0007(@\u000fH\u0013N\u000f@Au\u0004T\u0015F\u0013S$Q\u0004I\u0015\u0007\u0007H\u0013\u0007\u0002H\u000fI\u0004D\u0015N\u000eI[\u0007\u001aZ"), (Object)a.m_GFa().getId());
    }

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_sT.m_gEa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_Ct.lock();
            try {
                c_Je c_Je2 = a2.f_Wu.m_Tba(a.getId());
                if (c_Je2 != null) {
                    c_Je2.m_qW();
                    a2.f_Wu.m_TAa(a.getId(), c_Je2);
                }
                String[] stringArray = new String[2 ^ 3];
                stringArray[5 >> 3] = a.getId();
                a2.f_Ys.srem(f_Rs, stringArray);
                return;
            }
            finally {
                a2.f_Ct.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(Notification.m_pJ((Object)"-b c$u[\u00072S\u0000U\u0015N\u000f@AF\rKAD\u000eI\u000fB\u0002S\bH\u000fTAA\u000eUAW\u0013H\u000bB\u0002SA\\\u001c\u0007\rH\u0002F\rK\u0018\t"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(c_VB.m_zq((Object)"\u0015*\u0015H\u0017 \u001a!\u001e7aE\t\u0000*\u0010>\u0016/\f5\u0002{\t>\u0004?\u0000)E/\n{\u0016/\u0004)\u0011{\u00047\t{\u00064\u000b5\u00008\u00112\n5\u0016{\u00034\u0017{\u0015)\n1\u00008\u0011{\u001e&K"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x5AFE & 0x25CF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader(long l) {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        String a = connectionManager2.f_XC.m_La();
        f_td.info(Notification.m_pJ((Object)"\"H\u000fI\u0004D\u0015N\u000eI,F\u000fF\u0006B\u0013\u001dAs\tN\u0012\u0007\u000fH\u0005BA\u000f\u001aZH\u0007\tF\u0012\u0007\u0003B\u0002H\fBAS\tBAk$f%b3\tAu\u0004T\u0015H\u0013N\u000f@AF\u0002S\bQ\u0004\u0007\u0002H\u000fI\u0004D\u0015N\u000eI\u0012\tO\t"), (Object)a);
        connectionManager2.f_Ct.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_Ys.smembers(f_Rs));
            if (hashSet.isEmpty()) {
                f_td.info(c_VB.m_zq((Object)"&4\u000b5\u00008\u00112\n5(:\u000b:\u0002>\u0017{M\u0017\u0000:\u0001>\u0017{\u001e&LaE\u0015\n{\u00048\u00112\u0013>E8\n5\u000b>\u0006/\f4\u000b(E=\n.\u000b?E2\u000b{7>\u00012\u0016{\u00114E)\u0000(\u00114\u0017>K"), (Object)a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[4 ^ 5] = hashSet.size();
            objectArray[--2] = hashSet;
            f_td.info(Notification.m_pJ((Object)"d\u000eI\u000fB\u0002S\bH\u000fj\u0000I\u0000@\u0004UA\u000f-B\u0000C\u0004UA\\\u001c\u000e[\u0007'H\u0014I\u0005\u0007\u001aZAF\u0002S\bQ\u0004\u0007\u0002H\u000fI\u0004D\u0015N\u000eIAn%TAN\u000f\u00073B\u0005N\u0012\u0007\u0015HAU\u0004T\u0015H\u0013B[\u0007\u001aZ"), objectArray);
            Object a2 = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[3 ^ 3] = c_VB.m_zq((Object)"\r,\u001e2\u0004&\u0014+\u0015 \u00181\u0012*\u0015:\u00121\u001e(");
            connectionManager.f_sT.m_Sea(() -> connectionManager.lambda$leader$0((Collection)a2, hashSet), stringArray);
            f_td.info(Notification.m_pJ((Object)"\"H\u000fI\u0004D\u0015N\u000eI,F\u000fF\u0006B\u0013\u0007Ik\u0004F\u0005B\u0013\u0007\u001aZH\u001dAf\u0015S\u0004J\u0011S\bI\u0006\u0007\u0015HAU\u0004T\u0015H\u0013BA\\\u001c\u0007\u0002H\u000fI\u0004D\u0015N\u000eI\u0012\t"), (Object)a, (Object)a2.size());
            Object object = a2 = a2.iterator();
            while (object.hasNext()) {
                Connection connection = (Connection)a2.next();
                object = a2;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_td.info(c_VB.m_zq((Object)"&4\u000b5\u00008\u00112\n5(:\u000b:\u0002>\u0017{M\u0017\u0000:\u0001>\u0017{\u001e&LaE\u001d\f5\f(\r>\u0001{\u00064\u000b5\u00008\u00112\n5E)\u0000(\u00114\u0017:\u00112\n5E+\u00174\u0006>\u0016(K"), (Object)a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_td.error(Notification.m_pJ((Object)"\"H\u000fI\u0004D\u0015N\u000eI,F\u000fF\u0006B\u0013\u0007Ik\u0004F\u0005B\u0013\u0007\u001aZH\u001dAb\u0013U\u000eUAC\u0014U\bI\u0006\u0007\u0002H\u000fI\u0004D\u0015N\u000eIAU\u0004T\u0015H\u0013F\u0015N\u000eIAW\u0013H\u0002B\u0012T[\u0007\u001aZ"), objectArray);
            return;
        }
        finally {
            connectionManager.f_Ct.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_XS.m_yaa((String)a);
        return connectionManager2.f_sT.m_dFa(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[4 ^ 5];
            classArray[3 & 4] = String.class;
            connectionManager.f_XC.m_Ja((short)(0x4CFB & 0x33CD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_VB.m_zq((Object)"\u0016/\u0004)\u0011\u0018\n5\u000b>\u0006/\f4\u000b\u0012\u000b/\u0000)\u000b:\t"), classArray));
            Class[] classArray2 = new Class[3 >> 1];
            classArray2[2 & 5] = String.class;
            connectionManager.f_XC.m_Ja((short)(0x5CFA & 0x23CF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(Notification.m_pJ((Object)"\u0012S\u000eW\"H\u000fI\u0004D\u0015N\u000eI(I\u0015B\u0013I\u0000K"), classArray2));
            Class[] classArray3 = new Class[2 ^ 3];
            classArray3[5 >> 3] = String.class;
            connectionManager.f_XC.m_Ja((short)(0x3CEF & 0x43DB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_VB.m_zq((Object)"\u0002>\u0011\u0018\n5\u000b>\u0006/\f4\u000b\b\u0011:\u0011.\u0016\u0012\u000b/\u0000)\u000b:\t"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[3 >> 2] = SetValueRequest.class;
            connectionManager.f_XC.m_Ja((short)(0x75DF & 0xAEC), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(Notification.m_pJ((Object)"\u0012B\u0015q\u0000U\bF\u0003K\u0004q\u0000K\u0014B(I\u0015B\u0013I\u0000K"), classArray4));
            Class[] classArray5 = new Class[--1];
            classArray5[2 & 5] = Collection.class;
            connectionManager.f_XC.m_Ja((short)(0x1CCD & 0x63FF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_VB.m_zq((Object)"\u0016>\u0011\r\u0004)\f:\u00077\u0000\r\u00047\u0010>\u0016\u0012\u000b/\u0000)\u000b:\t"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_XC.m_Ja((short)(0x64FF & 0x1BCE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(Notification.m_pJ((Object)"T\u0015F\u0013S\"H\u000fI\u0004D\u0015N\u000eI\u0012e\u0018w\u0013H\u000bB\u0002S(C(I\u0015B\u0013I\u0000K"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_XC.m_Ja((short)(0x7ACF & 0x5FF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_VB.m_zq((Object)"(\u00114\u0015\u0018\n5\u000b>\u0006/\f4\u000b('\"5)\n1\u00008\u0011\u0012\u0001\u0012\u000b/\u0000)\u000b:\t"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_XC.m_Ja((short)(0x69D4 & 0x16FB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(Notification.m_pJ((Object)"\u0006B\u0015d\u000eI\u000fB\u0002S\bH\u000ft\u0015F\u0015R\u0012B\u0012e\u0018w\u0013H\u000bB\u0002S(C(I\u0015B\u0013I\u0000K"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_XC.m_Ja((short)(0x6EF9 & 0x11D7), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_VB.m_zq((Object)"<\u0000/&4\u000b5\u00008\u00112\n56/\u0004/\u0010(\u0000('\",?\u0016\u0012\u000b/\u0000)\u000b:\t"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_XC.m_Ja((short)(0x75FA & 0xAD7), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(Notification.m_pJ((Object)"\u0003U\u000eP\u0012B\"H\u000fI\u0004D\u0015N\u000eI(I\u0015B\u0013I\u0000K"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_VB.m_zq((Object)"\u001d\u00042\t>\u0001{\u00114E)\u0000<\f(\u0011>\u0017{&4\u000b5\u00008\u00112\n5(:\u000b:\u0002>\u0017{7\u000b&{\b>\u00113\n?\u0016"), a);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.info(c_VB.m_zq((Object)"\u0017 \u001a!\u001e7aE\u0013\u00045\u00017\f5\u0002{5)\n1\u00008\u0011\u001f\u0000:\u0006/\f-\u0004/\u0000\u001e\u0013>\u000b/E=\n)E+\u00174\u000f>\u0006/E\u0012!aE \u0018"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(Notification.m_pJ((Object)"/h/\n-b c$u[\u0007(@\u000fH\u0013N\u000f@Aw\u0013H\u000bB\u0002S%B\u0000D\u0015N\u0017F\u0015B$Q\u0004I\u0015\u0007\u0007H\u0013\u0007\u0011U\u000eM\u0004D\u0015\u0007(c[\u0007\u001aZ"), a);
    }

    private /* synthetic */ void lambda$startConnectionInternal$3(Connection connection) {
        ConnectionManager a;
        ConnectionManager a2 = connection;
        ConnectionManager connectionManager = a = this;
        long l = connectionManager.f_XC.m_ea();
        String string = connectionManager.f_XC.m_La();
        connectionManager.stopConnectionInternal((Connection)a2);
        if (!Boolean.TRUE.equals(a2.getProject().getIsActive())) {
            throw new NotActiveException("Project should be active to start connection " + a2.getName());
        }
        ConnectionManager connectionManager2 = a;
        connectionManager2.f_oT.m_yK();
        c_Je c_Je2 = connectionManager2.f_Wu.m_Uca((Connection)a2);
        c_Je2.m_hw();
        long l2 = connectionManager2.f_XC.m_ea();
        if (!connectionManager2.f_XC.m_da() || l2 == -1L || l2 != l) {
            try {
                c_Je2.m_qW();
                a.f_Wu.m_TAa(a2.getId(), c_Je2);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[--4];
                objectArray[5 >> 3] = string;
                objectArray[--1] = a2.getId();
                objectArray[--2] = exception.getMessage();
                objectArray[--3] = exception;
                f_td.warn(c_VB.m_zq((Object)"\u0018\n5\u000b>\u0006/\f4\u000b\u0016\u00045\u0004<\u0000)Es\u001e&LaE\u001d\u00005\u0006>\u0001{\u0016/\n+E=\u00042\t>\u0001{\u00034\u0017{\u00064\u000b5\u00008\u00112\n5E \u0018{\u0004=\u0011>\u0017{\u0011>\u00176E8\r:\u000b<\u0000aE \u0018"), objectArray);
            }
            Object[] objectArray = new Object[--4];
            objectArray[5 >> 3] = a2.getId();
            objectArray[3 >> 1] = string;
            objectArray[1 ^ 3] = l;
            objectArray[--3] = l2;
            f_td.info(Notification.m_pJ((Object)"2L\bW\u0011N\u000f@AF\u0002S\bQ\u0000S\bH\u000f\u0007\u000eAAD\u000eI\u000fB\u0002S\bH\u000f\u0007\u001aZAH\u000f\u0007\u000fH\u0005BA\\\u001c\u001dAK\u0004F\u0005B\u0013T\tN\u0011\u0007\rH\u0012SAH\u0013\u0007\u0015B\u0013JAD\tF\u000f@\u0004CA\u000f\u0012D\tB\u0005R\rB\u0005\u001a\u001aZM\u0007\u0002R\u0013U\u0004I\u0015\u001a\u001aZH\t"), objectArray);
            return;
        }
        String[] stringArray = new String[5 >> 2];
        stringArray[3 ^ 3] = a2.getId();
        a.f_Ys.sadd(f_Rs, stringArray);
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_XS.m_yaa((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_XS.m_Jda((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_Ck> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_XC.m_da()) {
            f_td.debug(Notification.m_pJ((Object)"k$f%b3\u001dA`\u0004S\u0015N\u000f@AD\u000eI\u000fB\u0002S\bH\u000f\u0007\u0012S\u0000S\u0014T\u0004TAA\u000eUA\\\u001c\u0007(c\u0012\u0007\rH\u0002F\rK\u0018\t"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_td.debug(c_VB.m_zq((Object)"+\u0014+v)\u001e$\u001f \t_{7>\u0014.\u0000(\u00112\u000b<E7\u0000:\u0001>\u0017{\u00034\u0017{\u00064\u000b5\u00008\u00112\n5E(\u0011:\u0011.\u0016>\u0016{\u00034\u0017{\u001e&E\u0012!(K"), (Object)a.length);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_XC.m_Fa(Short.valueOf((short)(0x16F9 & 0x69D7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_XS.m_eda((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_XS.m_Gda(a.getId());
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_dk c_dk2, c_SC c_SC2, c_eC c_eC2, c_oI<C, V> c_oI2, JedisPooled jedisPooled, c_H c_H2, c_mj c_mj2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_mj2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        super((c_H)a7);
        ConnectionManager connectionManager6 = a8;
        connectionManager6.f_Ct = new ReentrantLock();
        connectionManager5.f_XS = a6;
        connectionManager5.f_oT = a5;
        connectionManager4.f_et = a4;
        connectionManager4.f_Wu = a3;
        connectionManager3.f_Ys = a2;
        connectionManager3.f_sT = a;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_XS.m_Jda((String)a, (String)a3).getId());
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_XC.m_La();
        f_td.info(c_VB.m_zq((Object)"&4\u000b5\u00008\u00112\n5(:\u000b:\u0002>\u0017aE\u000f\r2\u0016{\u000b4\u0001>Es\u001e&L{\f(E\u0015*{)\u0014+\u001c \tE\u000f-\u001eE\u0017 \u001a!\u001e7uE\b\u00114\u0015+\f5\u0002{\u00047\t{\t4\u0006:\t{\u00064\u000b5\u00008\u00114\u0017(KuK"), a);
        connectionManager2.f_Ct.lock();
        try {
            connectionManager.f_Wu.m_Cda();
            f_td.info(Notification.m_pJ((Object)"\"H\u000fI\u0004D\u0015N\u000eI,F\u000fF\u0006B\u0013\u0007Ii\u000eSAk\u0004F\u0005B\u0013\u0007\u001aZH\u001dAf\rKAK\u000eD\u0000KAD\u000eI\u000fB\u0002S\u000eU\u0012\u0007\tF\u0017BAE\u0004B\u000f\u0007\u0013B\u0010R\u0004T\u0015B\u0005\u0007\u0015HAT\u0015H\u0011\u0007\u0000I\u0005\u0007\u0002K\u0004F\u0013B\u0005\u0007\u0007U\u000eJAK\u000eD\u0000KAS\u0013F\u0002L\bI\u0006\t"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_td.error(c_VB.m_zq((Object)"\u0018\n5\u000b>\u0006/\f4\u000b\u0016\u00045\u0004<\u0000)Es+4\u0011{)>\u0004?\u0000)E \u0018r_{ )\u00174\u0017{\u0001.\u00172\u000b<E+\u00174\u0006>\u0016(E4\u0003{\u0016/\n+\u00152\u000b<E7\n8\u00047E8\n5\u000b>\u0006/\n)\u0016aE \u0018"), objectArray);
            return;
        }
        finally {
            connectionManager.f_Ct.unlock();
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        a.registerRemoteCallsWithClusterNode();
        f_td.info(Notification.m_pJ((Object)"\"H\u000fI\u0004D\u0015N\u000eI,F\u000fF\u0006B\u0013\u0007\bI\bS\bF\rN\u001bB\u0005\u0007\u0000I\u0005\u0007\u0013B\u0006N\u0012S\u0004U\u0004CAF\u0012\u0007\"K\u0014T\u0015B\u0013i\u000eC\u0004k\bT\u0015B\u000fB\u0013\t"));
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Lj.class})
    public void handleDeleteEvent(c_Lj c_Lj2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_XC.m_da()) {
            ConnectionManager a2 = a.m_kfa();
            f_td.info(c_VB.m_zq((Object)"\u0017 \u001a!\u001e7aE\u0013\u00045\u00017\f5\u0002{!>\t>\u0011> -\u00005\u0011{\u00034\u0017{\u00064\u000b5\u00008\u00112\n5_{\u001e&Es,\u001f_{\u001e&L"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_td.debug(Notification.m_pJ((Object)"i.iLk$f%b3\u001dAn\u0006I\u000eU\bI\u0006\u0007%B\rB\u0015B$Q\u0004I\u0015\u0007\u0007H\u0013\u0007\u0002H\u000fI\u0004D\u0015N\u000eI[\u0007\u001aZ"), (Object)a.m_kfa().getId());
    }

    protected Map<String, c_Ck> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }
}

