/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.restcontrollers;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_Qf;
import com.inscada.mono.communication.base.services.c_YD;
import com.inscada.mono.communication.base.services.c_uF;
import com.inscada.mono.communication.base.template.e.c_xD;
import com.inscada.mono.communication.base.template.model.DeviceGenerationRequest;
import com.inscada.mono.communication.base.template.model.DeviceTemplate;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.communication.base.template.model.VariableTemplate;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import jakarta.validation.Valid;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ConnectionController<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TConnectionService extends c_Qf<TConnection, TDevice, TFrame, TVariable>, TDeviceService extends c_uF<TConnection, TDevice, TFrame, TVariable>, TFrameService extends c_YD<TConnection, TDevice, TFrame, TVariable>, TDeviceTemplate extends DeviceTemplate<TFrameTemplate>, TFrameTemplate extends FrameTemplate<TDeviceTemplate, TVariableTemplate>, TVariableTemplate extends VariableTemplate<TFrameTemplate, TDeviceTemplate>, TTemplateService extends c_xD<TDeviceTemplate, TFrameTemplate, TVariableTemplate, TConnection, TDevice, TFrame, TVariable>> {
    protected final TConnectionService f_DJ;
    protected final TFrameService f_xl;
    protected final TTemplateService f_lj;
    protected final TDeviceService f_iL;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public ResponseEntity<TFrame> createFrame(@PathVariable String string, @PathVariable String string2, @Valid @RequestBody TFrame TFrame, UriComponentsBuilder uriComponentsBuilder) {
        void a;
        void deviceId;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = TFrame;
        ConnectionController frame = connectionController;
        object = frame.f_xl.m_su((String)connectionId, (String)deviceId, (Frame)object);
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = connectionId;
        objectArray[4 ^ 5] = deviceId;
        objectArray[--2] = object.getId();
        return ResponseEntity.created((URI)a.path(DataTransferSummary.m_Hq((Object)"0\u0012|\u0006q\u0007z\nk\u0000p\u0007V\rbF{\fi\u0000|\flFd\rz\u001fv\nz {\u00140\u000fm\br\flFd\u000fm\br\fV\rb")).buildAndExpand(objectArray).toUri()).body(object);
    }

    @DeleteMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnection(@PathVariable String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        a.f_DJ.m_C((String)object);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/{connectionId}/devices"})
    public ResponseEntity<TDevice> createDevice(@PathVariable String string, @Valid @RequestBody TDevice TDevice, UriComponentsBuilder uriComponentsBuilder) {
        void a;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = TDevice;
        ConnectionController device = connectionController;
        object = device.f_iL.m_SS((String)connectionId, (Device)object);
        Object[] objectArray = new Object[1 ^ 3];
        objectArray[3 ^ 3] = connectionId;
        objectArray[--1] = object.getId();
        return ResponseEntity.created((URI)a.path(DataTransferSummary.m_Hq((Object)"Fd\np\u0007q\f|\u001dv\u0006q {\u00140\rz\u001fv\nz\u001a0\u0012{\fi\u0000|\fV\rb")).buildAndExpand(objectArray).toUri()).body(object);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{connectionId}/devices/{deviceId}"})
    public TDevice getDevice(@PathVariable String string, @PathVariable String string2) {
        void connectionId;
        ConnectionController connectionController = object;
        Object object = string2;
        ConnectionController a = connectionController;
        return (TDevice)a.f_iL.m_cU((String)connectionId, (String)object);
    }

    @GetMapping(value={"/{connectionId}/devices"})
    public Collection<TDevice> getDevices(@PathVariable String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return a.f_iL.m_dS((String)object);
    }

    @GetMapping(value={"/by-project"})
    public Collection<TConnection> getConnectionsByProject(@RequestParam String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return a.f_DJ.m_jT((String)object);
    }

    @GetMapping(value={"/frames/by-project"})
    public Collection<TFrame> getFramesByProject(@RequestParam String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return a.f_xl.m_is((String)object);
    }

    @GetMapping(value={"/devices"})
    public Collection<TDevice> getDevices() {
        ConnectionController a;
        return a.f_iL.m_a();
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable String string, @PathVariable String string2, @Valid @RequestBody TDevice TDevice) {
        void deviceId;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = TDevice;
        ConnectionController a = connectionController;
        a.f_iL.m_NS((String)connectionId, (String)deviceId, (Device)object);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping
    public ResponseEntity<TConnection> createConnection(@Valid @RequestBody TConnection TConnection, UriComponentsBuilder uriComponentsBuilder) {
        void a;
        ConnectionController connectionController = object;
        Object object = TConnection;
        ConnectionController connection = connectionController;
        object = connection.f_DJ.m_ns((Connection)object);
        Object[] objectArray = new Object[4 ^ 5];
        objectArray[3 & 4] = object.getId();
        return ResponseEntity.created((URI)a.path(DataTransferSummary.m_Hq((Object)"0\u0012|\u0006q\u0007z\nk\u0000p\u0007V\rb")).buildAndExpand(objectArray).toUri()).body(object);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    public TFrame getFrame(@PathVariable String string, @PathVariable String string2, @PathVariable String string3) {
        void deviceId;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = string3;
        ConnectionController a = connectionController;
        return (TFrame)a.f_xl.m_yS((String)connectionId, (String)deviceId, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConnection(@PathVariable String string, @Valid @RequestBody TConnection TConnection) {
        void connectionId;
        ConnectionController connectionController = object;
        Object object = TConnection;
        ConnectionController a = connectionController;
        a.f_DJ.m_Bt((String)connectionId, (Connection)object);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/{connectionId}/devices/generate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void generateFromTemplate(@PathVariable String string, @RequestBody DeviceGenerationRequest deviceGenerationRequest) {
        void connectionId;
        ConnectionController connectionController = connectionController2;
        ConnectionController connectionController2 = deviceGenerationRequest;
        ConnectionController a = connectionController;
        a.f_lj.m_Au((String)connectionId, (DeviceGenerationRequest)connectionController2);
    }

    @GetMapping
    public Collection<TConnection> getConnections() {
        ConnectionController a;
        return a.f_DJ.m_a();
    }

    @GetMapping(value={"/frame/{frameId}"})
    public TFrame getFrameById(@PathVariable String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return (TFrame)a.f_xl.m_Qt((String)object);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public Collection<TFrame> getFrames(@PathVariable String string, @PathVariable String string2) {
        void connectionId;
        ConnectionController connectionController = object;
        Object object = string2;
        ConnectionController a = connectionController;
        return a.f_xl.m_Ct((String)connectionId, (String)object);
    }

    @GetMapping(value={"/device/{deviceId}"})
    public TDevice getDeviceById(@PathVariable String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return (TDevice)a.f_iL.m_Yu((String)object);
    }

    @GetMapping(value={"/frames"})
    public Collection<TFrame> getFrames() {
        ConnectionController a;
        return a.f_xl.m_a();
    }

    @DeleteMapping(value={"/frames/multi/by-ids"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFramesByIds(@RequestParam String[] stringArray) {
        String[] stringArray2 = stringArray3;
        String[] stringArray3 = stringArray;
        String[] a = stringArray2;
        a.f_xl.m_B(List.of(stringArray3));
    }

    /*
     * WARNING - void declaration
     */
    protected ConnectionController(TConnectionService TConnectionService, TDeviceService TDeviceService, TFrameService TFrameService, TTemplateService TTemplateService) {
        Object a;
        void a2;
        void a3;
        void a4;
        ConnectionController a5;
        ConnectionController connectionController = object;
        Object object = TTemplateService;
        ConnectionController connectionController2 = a5 = connectionController;
        ConnectionController connectionController3 = a5;
        connectionController3.f_DJ = a4;
        connectionController3.f_iL = a3;
        connectionController2.f_xl = a2;
        connectionController2.f_lj = a;
    }

    @GetMapping(value={"/devices/by-project"})
    public Collection<TDevice> getDevicesByProject(@RequestParam String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return a.f_iL.m_XT((String)object);
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable String string, @PathVariable String string2, @PathVariable String string3) {
        void deviceId;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = string3;
        ConnectionController a = connectionController;
        a.f_xl.m_Vt((String)connectionId, (String)deviceId, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable String string, @PathVariable String string2, @PathVariable String string3, @Valid @RequestBody TFrame TFrame) {
        void frameId;
        void deviceId;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = TFrame;
        ConnectionController a = connectionController;
        a.f_xl.m_gt((String)connectionId, (String)deviceId, (String)frameId, (Frame)object);
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable String string, @PathVariable String string2) {
        void connectionId;
        ConnectionController connectionController = object;
        Object object = string2;
        ConnectionController a = connectionController;
        a.f_iL.m_ls((String)connectionId, (String)object);
    }

    @DeleteMapping(value={"/devices/multi/by-ids"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevicesByIds(@RequestParam String[] stringArray) {
        String[] stringArray2 = stringArray3;
        String[] stringArray3 = stringArray;
        String[] a = stringArray2;
        a.f_iL.m_B(List.of(stringArray3));
    }

    @GetMapping(value={"/{connectionId}"})
    public TConnection getConnection(@PathVariable String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return (TConnection)a.f_DJ.m_zx((String)object);
    }

    @DeleteMapping(value={"/multi/by-ids"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnectionsByIds(@RequestParam String[] stringArray) {
        String[] stringArray2 = stringArray3;
        String[] stringArray3 = stringArray;
        String[] a = stringArray2;
        a.f_DJ.m_B(List.of(stringArray3));
    }
}

