/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.repositories;

import com.inscada.mono.communication.base.model.FrameView;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.Repository;

@org.springframework.stereotype.Repository
@EnableSpaceFilter
public interface FrameRepositoryFacade
extends Repository<FrameView, String> {
    @Query(value="SELECT f.* FROM inscada.frame f JOIN inscada.device d ON f.device_id = d.device_id JOIN inscada.connection c ON d.conn_id = c.conn_id WHERE c.project_id = ?1 AND f.space_id = :#{T(com.inscada.mono.space.SpaceContext).getActiveSpace().getId()} AND f.deleted_dttm IS NULL AND d.deleted_dttm IS NULL AND c.deleted_dttm IS NULL", nativeQuery=true)
    public Collection<FrameView> findByProjectId(String var1);

    @Query(value="SELECT f.* FROM inscada.frame f JOIN inscada.device d ON f.device_id = d.device_id WHERE d.conn_id = ?1 AND d.device_id = ?2 AND f.frame_id = ?3 AND f.space_id = :#{T(com.inscada.mono.space.SpaceContext).getActiveSpace().getId()} AND f.deleted_dttm IS NULL AND d.deleted_dttm IS NULL", nativeQuery=true)
    public Optional<FrameView> findOneByConnectionIdAndDeviceIdAndId(String var1, String var2, String var3);

    @Query(value="SELECT f FROM FrameView f")
    public List<FrameView> findAll();

    @Query(value="SELECT f.* FROM inscada.frame f JOIN inscada.device d ON f.device_id = d.device_id WHERE d.conn_id = ?1 AND d.device_id = ?2 AND f.space_id = :#{T(com.inscada.mono.space.SpaceContext).getActiveSpace().getId()} AND f.deleted_dttm IS NULL AND d.deleted_dttm IS NULL", nativeQuery=true)
    public Collection<FrameView> findByConnectionIdAndDeviceId(String var1, String var2);

    @Query(value="SELECT f FROM FrameView f WHERE f.frameId = ?1")
    public Optional<FrameView> findOne(String var1);

    @Query(value="SELECT f.* FROM inscada.frame f JOIN inscada.device d ON f.device_id = d.device_id WHERE d.conn_id = ?1 AND d.name = ?2 AND f.name = ?3 AND f.space_id = :#{T(com.inscada.mono.space.SpaceContext).getActiveSpace().getId()} AND f.deleted_dttm IS NULL AND d.deleted_dttm IS NULL", nativeQuery=true)
    public Optional<FrameView> findOneByConnectionIdAndDeviceNameAndName(String var1, String var2, String var3);

    @Query(value="SELECT f FROM FrameView f WHERE f.frameId IN (?1)")
    public List<FrameView> findAll(Iterable<String> var1);
}

