/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.HasFrame;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.r.c_Oj;
import com.inscada.mono.communication.base.r.c_Pj;
import com.inscada.mono.expression.model.Expression;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@AttributeOverride(name="id", column=@Column(name="variable_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"frameId", "frame"})})
public class Variable<TFrame extends Frame<?, ?>, TDevice extends Device<?, ?>, TConnection extends Connection<?>>
extends SpaceBaseModel
implements HasFrame<TFrame> {
    @Column(name="log_type")
    protected c_Oj logType;
    @NotNull
    @Column(name="pulse_off_flag")
    protected Boolean isPulseOff;
    @Column(name="log_min_value")
    protected Double logMinValue;
    @PositiveOrZero
    @Column(name="pulse_on_duration")
    protected Integer pulseOnDuration;
    @Column(name="log_expression_id", insertable=false, updatable=false)
    protected String logExpressionId;
    @Column(name="project_id", insertable=false, updatable=false)
    protected String projectId;
    @NotNull
    @Column(name="active_flag")
    protected Boolean isActive;
    @NotNull
    @Column(name="pulse_on_flag")
    protected Boolean isPulseOn;
    @NotBlank
    @Size(max=100)
    protected String name;
    @Column(name="log_threshold")
    protected Double logThreshold;
    @NotNull
    @Column(name="writable_flag", nullable=false)
    protected Boolean isWritable;
    @Column(name="raw_zero_scale")
    protected Double rawZeroScale;
    @Column(name="frame_id", insertable=false, updatable=false)
    protected String frameId;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="log_expression_id")
    protected Expression logExpression;
    @Min(value=1L)
    @Column(name="log_period")
    protected Integer logPeriod;
    @NotNull
    @Column(name="keep_last_values")
    protected Boolean keepLastValues;
    @Size(max=4000)
    @Column(name="log_expression")
    protected String logExpressionCode;
    @Size(max=255)
    protected String dsc;
    @Column(name="eng_zero_scale")
    protected Double engZeroScale;
    @Column(name="set_min_value")
    protected Double setMinValue;
    @Column(name="log_max_value")
    protected Double logMaxValue;
    @PositiveOrZero
    @Column(name="pulse_off_duration")
    protected Integer pulseOffDuration;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="value_expression_id")
    protected Expression valueExpression;
    @Column(name="eng_full_scale")
    protected Double engFullScale;
    protected String unit;
    @Size(max=20)
    protected String code;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    protected Project project;
    @Column(name="value_expression_id", insertable=false, updatable=false)
    protected String valueExpressionId;
    @JsonIgnore
    @Transient
    protected VariableValue<?> value;
    @Column(name="fractional_digit_count")
    protected Short fractionalDigitCount;
    @Column(name="raw_full_scale")
    protected Double rawFullScale;
    @Size(max=4000)
    @Column(name="value_expression")
    protected String valueExpressionCode;
    @Column(name="value_expression_type")
    protected c_Pj valueExpressionType;
    @Column(name="set_max_value")
    protected Double setMaxValue;

    public Double getLogThreshold() {
        Variable a;
        return a.logThreshold;
    }

    public void setIsWritable(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isWritable = a;
    }

    public c_Oj getLogType() {
        Variable a;
        return a.logType;
    }

    public String getLogExpressionCode() {
        Variable a;
        return a.logExpressionCode;
    }

    public void setSetMinValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.setMinValue = a;
    }

    @JsonIgnore
    public TConnection getConnection() {
        Variable a;
        if (a.getDevice() == null) {
            return null;
        }
        return (TConnection)a.getDevice().getConnection();
    }

    public Double getEngZeroScale() {
        Variable a;
        return a.engZeroScale;
    }

    public Boolean getIsWritable() {
        Variable a;
        return a.isWritable;
    }

    public Double getSetMaxValue() {
        Variable a;
        return a.setMaxValue;
    }

    public void setProject(Project project) {
        Variable a;
        Variable a2 = project;
        Variable variable = a = this;
        variable.project = a2;
        variable.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Double getSetMinValue() {
        Variable a;
        return a.setMinValue;
    }

    public void setValueExpression(Expression expression) {
        Variable a;
        Variable a2 = expression;
        Variable variable = a = this;
        variable.valueExpression = a2;
        variable.valueExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setIsActive(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isActive = a;
    }

    public String getCode() {
        Variable a;
        return a.code;
    }

    public void setName(String string) {
        Object a = string;
        Variable a2 = this;
        a2.name = a;
    }

    public void setLogThreshold(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logThreshold = a;
    }

    public Integer getPulseOnDuration() {
        Variable a;
        return a.pulseOnDuration;
    }

    public void setFractionalDigitCount(Short s) {
        Object a = s;
        Variable a2 = this;
        a2.fractionalDigitCount = a;
    }

    public void setRawFullScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.rawFullScale = a;
    }

    public void setEngFullScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.engFullScale = a;
    }

    public String getLogExpressionId() {
        Variable a;
        return a.logExpressionId;
    }

    public String getProjectId() {
        Variable a;
        return a.projectId;
    }

    public String getConnectionId() {
        Variable a;
        if (a.getDevice() == null) {
            return null;
        }
        return a.getDevice().getConnectionId();
    }

    public void setLogExpression(Expression expression) {
        Variable a;
        Variable a2 = expression;
        Variable variable = a = this;
        variable.logExpression = a2;
        variable.logExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setIsPulseOff(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isPulseOff = a;
    }

    public void setPulseOffDuration(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.pulseOffDuration = a;
    }

    public Double getLogMaxValue() {
        Variable a;
        return a.logMaxValue;
    }

    public void setEngZeroScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.engZeroScale = a;
    }

    public void setDsc(String string) {
        Object a = string;
        Variable a2 = this;
        a2.dsc = a;
    }

    public void setLogMaxValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logMaxValue = a;
    }

    public int hashCode() {
        Variable a;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[--1] = a.getProjectId();
        objectArray[--2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setLogMinValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logMinValue = a;
    }

    public String getFrameId() {
        Variable a;
        return a.frameId;
    }

    public Project getProject() {
        Variable a;
        return a.project;
    }

    public void setLogExpressionId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.logExpressionId = a;
    }

    public String getName() {
        Variable a;
        return a.name;
    }

    public void setRawZeroScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.rawZeroScale = a;
    }

    public Double getEngFullScale() {
        Variable a;
        return a.engFullScale;
    }

    public void setUnit(String string) {
        Object a = string;
        Variable a2 = this;
        a2.unit = a;
    }

    public Double getLogMinValue() {
        Variable a;
        return a.logMinValue;
    }

    public Boolean getIsPulseOn() {
        Variable a;
        return a.isPulseOn;
    }

    public void setLogPeriod(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.logPeriod = a;
    }

    public void setIsPulseOn(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isPulseOn = a;
    }

    public Variable() {
        Variable a;
    }

    public void setValueExpressionId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.valueExpressionId = a;
    }

    public void setFrameId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.frameId = a;
    }

    public void setProjectId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.projectId = a;
    }

    public Double getRawZeroScale() {
        Variable a;
        return a.rawZeroScale;
    }

    public void setLogExpressionCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.logExpressionCode = a;
    }

    public VariableValue<?> getValue() {
        Variable a;
        return a.value;
    }

    public Boolean getKeepLastValues() {
        Variable a;
        return a.keepLastValues;
    }

    public void setValueExpressionType(c_Pj c_Pj2) {
        Variable a = c_Pj2;
        Variable a2 = this;
        a2.valueExpressionType = a;
    }

    public void setLogType(c_Oj c_Oj2) {
        Variable a = c_Oj2;
        Variable a2 = this;
        a2.logType = a;
    }

    public String getDsc() {
        Variable a;
        return a.dsc;
    }

    public Double getRawFullScale() {
        Variable a;
        return a.rawFullScale;
    }

    public boolean equals(Object object) {
        Variable a = this;
        Object a2 = object;
        if (a == a2) {
            return 3 >> 1;
        }
        if (!(a2 instanceof Variable)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return 3 >> 2;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return --1 != 0;
        }
        return false;
    }

    public void setPulseOnDuration(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.pulseOnDuration = a;
    }

    public Integer getPulseOffDuration() {
        Variable a;
        return a.pulseOffDuration;
    }

    public c_Pj getValueExpressionType() {
        Variable a;
        return a.valueExpressionType;
    }

    public String getValueExpressionId() {
        Variable a;
        return a.valueExpressionId;
    }

    public void setCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.code = a;
    }

    public Short getFractionalDigitCount() {
        Variable a;
        return a.fractionalDigitCount;
    }

    public String getValueExpressionCode() {
        Variable a;
        return a.valueExpressionCode;
    }

    @JsonIgnore
    public TDevice getDevice() {
        Variable a;
        if (a.getFrame() == null) {
            return null;
        }
        return (TDevice)a.getFrame().getDevice();
    }

    public String getDeviceId() {
        Variable a;
        if (a.getFrame() == null) {
            return null;
        }
        return a.getFrame().getDeviceId();
    }

    public Integer getLogPeriod() {
        Variable a;
        return a.logPeriod;
    }

    public Expression getLogExpression() {
        Variable a;
        return a.logExpression;
    }

    public void setValue(VariableValue<?> variableValue) {
        VariableValue<?> a = variableValue;
        VariableValue<?> a2 = this;
        a2.value = a;
    }

    public Boolean getIsPulseOff() {
        Variable a;
        return a.isPulseOff;
    }

    public Expression getValueExpression() {
        Variable a;
        return a.valueExpression;
    }

    public void setKeepLastValues(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.keepLastValues = a;
    }

    public void setValueExpressionCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.valueExpressionCode = a;
    }

    public Boolean getIsActive() {
        Variable a;
        return a.isActive;
    }

    public void setSetMaxValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.setMaxValue = a;
    }

    public String getUnit() {
        Variable a;
        return a.unit;
    }
}

