/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.cluster.sync;

import com.inscada.mono.cluster.model.ClusterNodeInfo;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_H;
import com.inscada.mono.communication.protocols.opcua.model.Tree;
import com.inscada.mono.impexp.model.ImportResult;
import jakarta.annotation.PostConstruct;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;

@Service
@ConditionalOnProperty(name={"ins.cluster.enabled"}, havingValue="true")
public class RedisReplicationManager
implements ClusterNodeListener {
    private final c_H f_AU;
    private final JedisPooled f_ss;
    private final Integer f_bt;
    private static final Logger f_BU = LoggerFactory.getLogger(RedisReplicationManager.class);
    private final String f_TS;

    /*
     * WARNING - void declaration
     */
    @Autowired
    public RedisReplicationManager(JedisPooled jedisPooled, c_H c_H2, @Value(value="${spring.data.redis.host:localhost}") String string, @Value(value="${spring.data.redis.port:6379}") Integer n) {
        void selfRedisHost;
        void clusterOperations;
        void jedis;
        RedisReplicationManager a;
        RedisReplicationManager redisReplicationManager = object;
        Object object = n;
        RedisReplicationManager redisReplicationManager2 = a = redisReplicationManager;
        RedisReplicationManager redisReplicationManager3 = a;
        redisReplicationManager3.f_ss = jedis;
        redisReplicationManager3.f_AU = clusterOperations;
        redisReplicationManager2.f_TS = selfRedisHost;
        redisReplicationManager2.f_bt = object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notLeader() {
        RedisReplicationManager redisReplicationManager = this;
        f_BU.info(ImportResult.m_pN((Object)"Y<d'-:b0htd'-5-\u0012B\u0018A\u001bZ\u0011_z-\u0015y h9} d:jty;-2d:ita1l0h&-5c0-'y5\u007f -\u0006h0d'-&h$a=n5y=b:#"));
        try {
            Optional<ClusterNodeInfo> optional = redisReplicationManager.f_AU.m_Ca().stream().filter(ClusterNodeInfo::getIsLeader).findFirst();
            if (optional.isPresent()) {
                ClusterNodeInfo clusterNodeInfo = optional.get();
                String a2 = clusterNodeInfo.getRedisHost();
                Integer n = clusterNodeInfo.getRedisPort();
                if (a2 != null && n != null) {
                    if (Objects.equals(redisReplicationManager.f_TS, a2) && Objects.equals(redisReplicationManager.f_bt, n)) {
                        f_BU.warn(Tree.m_hV((Object)"\f\u001d;\u0017'\u0002-\u0006-\u0010h\u0018-\u0015,\u0011:S;T\u001a\u0011,\u001d;T!\u001a;\u0000)\u001a+\u0011h\u001d;T<\u001c!\u0007h\u001a'\u0010-S;T'\u0003&T!\u001a;\u0000)\u001a+\u0011fT\u001b\u001f!\u00048\u001d&\u0013h\u0006-\u0004$\u001d+\u0015<\u001d'\u001ah\u0017'\u0019%\u0015&\u0010h\u0000'T8\u0006-\u0002-\u001a<T+\u001d:\u0017=\u0018)\u0006h\u0006-\u0004$\u001d+\u0015<\u001d'\u001af"));
                        return;
                    }
                    Object[] objectArray = new Object[--3];
                    objectArray[3 >> 2] = clusterNodeInfo.getNodeId();
                    objectArray[--1] = a2;
                    objectArray[1 ^ 3] = n;
                    f_BU.info(ImportResult.m_pN((Object)"\u0012b!c0-8h5i1\u007ft*/ps-#d et_1i=~tl -/pnv)#t^ l&y=c3-&h$a=n5y=b:#"), objectArray);
                    String[] stringArray = new String[5 >> 1];
                    stringArray[2 & 5] = a2;
                    stringArray[3 & 5] = String.valueOf(n);
                    Object a2 = redisReplicationManager.f_ss.sendCommand((ProtocolCommand)Protocol.Command.REPLICAOF, stringArray);
                    f_BU.info(Tree.m_hV((Object)"'-\u0000h&-\u0010!\u0007h\u0000'T:\u00118\u0018!\u0017)\u0000-T.\u0006'\u0019h\u0018-\u0015,\u0011:Zh&-\u0007=\u0018<Nh\u000f5"), a2);
                    return;
                }
                f_BU.error(ImportResult.m_pN((Object)"A1l0h&-:b0ht*/ps-0b1~tc;yte5{1-\u0006h0d'-<b'y{};\u007f -=c2b&`5y=b:-5{5d8l6a1#tN5c:b -'y5\u007f -&h$a=n5y=b:#"), (Object)clusterNodeInfo.getNodeId());
                return;
            }
            f_BU.warn(Tree.m_hV((Object)"\u000b\u001b=\u0018,T&\u001b<T.\u001d&\u0010h\u0015h\u0018-\u0015,\u0011:T&\u001b,\u0011h\u001d&T<\u001c-T+\u0018=\u0007<\u0011:T>\u001d-\u0003h\u0000'T:\u00118\u0018!\u0017)\u0000-T\u001a\u0011,\u001d;T.\u0006'\u0019fT\u001f\u001d$\u0018h\u0006-\u0000:\rh\u001b&T&\u00110\u0000h\u0017$\u0001;\u0000-\u0006h\u0002!\u0011?T+\u001c)\u001a/\u0011f"));
            return;
        }
        catch (Exception exception) {
            f_BU.error(ImportResult.m_pN((Object)"K5d8h0- bt~1yt_1i=~ty;-&h$a=n5-9b0htb:-2b8a;z1\u007ftc;i1#"), (Throwable)exception);
            return;
        }
    }

    @PostConstruct
    public void registerListener() {
        RedisReplicationManager a;
        a.f_AU.m_aa((ClusterNodeListener)a);
        f_BU.info(Tree.m_hV((Object)"\u001a\u0011,\u001d;&-\u0004$\u001d+\u0015<\u001d'\u001a\u0005\u0015&\u0015/\u0011:T:\u0011/\u001d;\u0000-\u0006-\u0010h\u001d<\u0007-\u0018.T)\u0007h\u0015h7$\u0001;\u0000-\u0006\u0006\u001b,\u0011\u0004\u001d;\u0000-\u001a-\u0006f"));
    }

    public void leader(long a3) {
        try {
            RedisReplicationManager a2;
            String[] stringArray = new String[1 ^ 3];
            stringArray[3 >> 2] = ImportResult.m_pN((Object)"\u001aB");
            stringArray[--1] = Tree.m_hV((Object)"\u0007:\r");
            Object a3 = a2.f_ss.sendCommand((ProtocolCommand)Protocol.Command.REPLICAOF, stringArray);
            f_BU.info(ImportResult.m_pN((Object)"Y<d'-:b0htd'- e1-\u0018H\u0015I\u0011_z-\u0007h y=c3-\u0006h0d'- bt`5~ h&-9b0hz-\u0006h'x8yn-/p"), a3);
            return;
        }
        catch (Exception a3) {
            f_BU.error(Tree.m_hV((Object)"2)\u001d$\u0011,T<\u001bh\u0007-\u0000h&-\u0010!\u0007h\u0000'T%\u0015;\u0000-\u0006h\u0019'\u0010-T'\u001ah\u0018-\u0015,\u0011:T&\u001b,\u0011f"), (Throwable)a3);
            return;
        }
    }
}

