/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.e.c_GK;
import com.inscada.mono.alarm.e.c_HJ;
import com.inscada.mono.alarm.e.c_Sl;
import com.inscada.mono.alarm.e.c_VJ;
import com.inscada.mono.alarm.e.c_xK;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AlarmGroupSummary;
import com.inscada.mono.alarm.r.c_LK;
import com.inscada.mono.alarm.services.c_DK;
import com.inscada.mono.alarm.services.c_Wk;
import com.inscada.mono.alarm.services.c_dJ;
import com.inscada.mono.alarm.services.c_gk;
import com.inscada.mono.animation.model.RunAnimScriptDto;
import com.inscada.mono.auth.c_mj;
import com.inscada.mono.c_nL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.manager.LeaderFencedManager;
import com.inscada.mono.cluster.services.c_H;
import com.inscada.mono.log.e.c_eC;
import com.inscada.mono.project.e.c_I;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
extends LeaderFencedManager
implements c_I {
    private final c_eC f_ZZ;
    private final c_DK f_Wy;
    private final JedisPooled f_AZ;
    public static final short f_Az = 104;
    private final c_mj f_Qaa;
    public static final short f_sY = 105;
    private final c_dJ f_jy;
    private final c_gk f_Lz;
    private final Lock f_PZ;
    public static final short f_Jaa = 109;
    public static final short f_SX = 102;
    private static final Logger f_td = LoggerFactory.getLogger(AlarmManager.class);
    public static final short f_Ny = 103;
    public static final short f_zY = 101;
    private static final String f_kX = "activeAlarmGroups";
    public static final short f_Jy = 107;
    public static final short f_WX = 106;
    public static final short f_aY = 108;

    @TransactionalEventListener(value={c_VJ.class})
    public void handleAlarmDeleteEvent(c_VJ c_VJ2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_XC.m_da()) {
            AlarmManager a = a.m_eKa();
            f_td.info(c_nL.m_ola((Object)"\u001e&\u0013'\u00171hC\u001a\u0002<\u0007>\n<\u0004r\">\u0002 \u000e\u0016\u0006>\u0006&\u0006\u0017\u00157\r&C4\f C3\u000f3\u0011?C\u001b'hC)\u001e~C\u0015\u0011=\u0016\"C\u001b'hC)\u001e"), (Object)a.getId(), (Object)a.getGroupId());
            c_Wk c_Wk2 = alarmManager.f_Wy.m_Dia(a.getGroupId());
            if (c_Wk2 != null && c_Wk2.m_Aha()) {
                c_Wk2.m_Qga((Alarm)a);
                return;
            }
        } else {
            f_td.debug(RunAnimScriptDto.m_fha((Object)"\u0000(\u0000J\u0002\"\u000f#\u000b5tG\u0007\u0000 \b<\u000e \u0000n&\"\u0006<\n\n\u0002\"\u0002:\u0002\u000b\u0011+\t:G(\b<G/\u000b/\u0015#G\u0007#tG5\u001a"), (Object)a.m_eKa().getId());
        }
    }

    protected c_LK getAlarmStatusInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        return alarmManager.getAlarmStatusInternal(alarmManager.f_Lz.m_WIa((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_LK getAlarmGroupStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_jy.m_Ela((String)a2, (String)a)) == null) {
            return c_LK.f_tZ;
        }
        return a3.getAlarmGroupStatus(a2.getId());
    }

    private /* synthetic */ void lambda$deactivateAlarmGroupInternal$4(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_PZ.lock();
        try {
            c_Wk c_Wk2 = a2.f_Wy.m_Dia(a.getId());
            if (c_Wk2 != null) {
                c_Wk2.m_via();
                a2.f_Wy.m_Pia(a.getId(), c_Wk2);
            }
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 >> 2] = a.getId();
            a2.f_AZ.srem(f_kX, stringArray);
            return;
        }
        finally {
            a2.f_PZ.unlock();
        }
    }

    protected c_LK getAlarmGroupStatusInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_Wy.m_Dia((String)a)) != null && a.m_Aha()) {
            return c_LK.f_taa;
        }
        return c_LK.f_tZ;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_LK getAlarmStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(c_nL.m_ola((Object)"\u001e&\u0013'\u00171hC\u0015\u0006&\u0017;\r5C3\u000f3\u0011?C!\u00173\u0017'\u0010r\u0005=\u0011r\u0018/C>\f1\u0002>\u000f+M"), a);
            return a2.getAlarmStatusInternal((String)a);
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)"\u0000(\u0000J\u0002\"\u000f#\u000b5tG\u001c\u0002?\u0012+\u0014:\u000e \u0000n\u000b+\u0006*\u0002<G(\b<G/\u000b/\u0015#G=\u0013/\u0013;\u0014n\u0001!\u0015n\u001c3I"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[5 >> 3] = a;
            return (c_LK)a2.f_XC.m_Fa(Short.valueOf((short)(0x67 & 0x7F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm status for " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_HJ.class})
    public void handleAlarmChangeEvent(c_HJ c_HJ2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_XC.m_da()) {
            AlarmManager a = a.m_zla();
            f_td.info(c_nL.m_ola((Object)"\u001e&\u0013'\u00171hC\u001a\u0002<\u0007>\n<\u0004r\">\u0002 \u000e\u0011\u000b3\r5\u0006\u0017\u00157\r&C4\f C3\u000f3\u0011?C\u001b'hC)\u001e~C\u0015\u0011=\u0016\"C\u001b'hC)\u001e"), (Object)a.getId(), (Object)a.getGroupId());
            c_Wk c_Wk2 = alarmManager.f_Wy.m_Dia(a.getGroupId());
            if (c_Wk2 != null && c_Wk2.m_Aha()) {
                if (Boolean.TRUE.equals(a.getIsActive())) {
                    c_Wk2.m_qGa((Alarm)a);
                    return;
                }
                c_Wk2.m_Qga((Alarm)a);
                return;
            }
        } else {
            f_td.debug(RunAnimScriptDto.m_fha((Object)"\u0000(\u0000J\u0002\"\u000f#\u000b5tG\u0007\u0000 \b<\u000e \u0000n&\"\u0006<\n\r\u000f/\t)\u0002\u000b\u0011+\t:G(\b<G/\u000b/\u0015#G\u0007#tG5\u001a"), (Object)a.m_zla().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_LK getAlarmGroupStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(c_nL.m_ola((Object)"\u001e&\u0013'\u00171hC\u0015\u0006&\u0017;\r5C3\u000f3\u0011?C5\u0011=\u0016\"C!\u00173\u0017'\u0010r\u0005=\u0011r\u0018/C>\f1\u0002>\u000f+M"), a);
            return a2.getAlarmGroupStatusInternal((String)a);
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)"\u0000(\u0000J\u0002\"\u000f#\u000b5tG\u001c\u0002?\u0012+\u0014:\u000e \u0000n\u000b+\u0006*\u0002<G(\b<G/\u000b/\u0015#G)\u0015!\u0012>G=\u0013/\u0013;\u0014n\u0001!\u0015n\u001c3I"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            return (c_LK)a2.f_XC.m_Fa(Short.valueOf((short)(0x7F & 0x68)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group status for " + (String)a, (Throwable)exception);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.info(c_nL.m_ola((Object)"\u001e&\u0013'\u00171hC\u001a\u0002<\u0007>\n<\u0004r3 \f8\u00061\u0017\u0016\u00063\u0000&\n$\u0002&\u0006\u0017\u00157\r&C4\f C\"\u0011=\t7\u0000&C\u001b'hC)\u001e"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)"\u0000(\u0000J\u0002\"\u000f#\u000b5tG\u0007\u0000 \b<\u000e \u0000n7<\b$\u0002-\u0013\n\u0002/\u0004:\u000e8\u0006:\u0002\u000b\u0011+\t:G(\b<G>\u0015!\r+\u0004:G\u0007#tG5\u001a"), a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String string, AlarmGroup alarmGroup) {
        void a;
        AlarmManager a2 = alarmGroup;
        AlarmManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[--1] = a2.getName();
            objectArray[5 >> 1] = a2.getId();
            f_td.info(c_nL.m_ola((Object)"\u0013\u000f3\u0011?.3\r3\u00047\u0011rK\u001e\u00063\u00077\u0011r\u0018/JhC\u0000\u0006!\u0017=\u0011;\r5C3\u000f3\u0011?C5\u0011=\u0016\"Yr\u0018/Cz*\u0016Yr\u0018/J"), objectArray);
            a3.activateAlarmGroupInternal((AlarmGroup)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a2.getName();
            objectArray[4 ^ 5] = a2.getId();
            objectArray[--2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_ZZ.m_Tk(a2.getProject()).m_T("Alarm Group Restore (Leader " + (String)a + ")", RunAnimScriptDto.m_fha((Object)"k\u0014nO\u0007#tGk\u0014gG(\u0006'\u000b+\u0003n\u0013!G<\u0002=\u0013!\u0015+In$/\u0012=\u0002tGk\u0014").formatted(objectArray));
            try {
                f_td.warn(c_nL.m_ola((Object)"\u0013\u000f3\u0011?.3\r3\u00047\u0011rK\u001e\u00063\u00077\u0011r\u0018/JhC\u0013\u0017&\u0006?\u0013&\n<\u0004r\u0017=C6\u00063\u0000&\n$\u0002&\u0006r\u0002>\u0002 \u000er\u0004 \f'\u0013r\u0018/C3\u0005&\u0006 C \u0006!\u0017=\u00113\u0017;\f<C4\u0002;\u000f'\u00117M"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal((AlarmGroup)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[3 & 5] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_td.error(RunAnimScriptDto.m_fha((Object)"&\"\u0006<\n\u0003\u0006 \u0006)\u0002<Gf++\u0006*\u0002<G5\u001ag]n!/\u000e\"\u0002*G:\bn\u0003+\u0006-\u0013'\u0011/\u0013+G/\u000b/\u0015#G)\u0015!\u0012>G5\u001an\u0006(\u0013+\u0015n\u0015+\u0014:\b<\u0006:\u000e!\tn\u0001/\u000e\"\u0012<\u0002tG5\u001a"), objectArray2);
                return;
            }
        }
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$2(AlarmGroup alarmGroup) {
        AlarmManager a;
        AlarmManager a2 = alarmGroup;
        AlarmManager alarmManager = a = this;
        long l = alarmManager.f_XC.m_ea();
        String string = alarmManager.f_XC.m_La();
        c_Wk c_Wk2 = alarmManager.f_Wy.m_yHa((AlarmGroup)a2);
        c_Wk2.m_OGa();
        long l2 = alarmManager.f_XC.m_ea();
        if (!alarmManager.f_XC.m_da() || l2 == -1L || l2 != l) {
            try {
                c_Wk2.m_via();
                a.f_Wy.m_Pia(a2.getId(), c_Wk2);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[--4];
                objectArray[5 >> 3] = string;
                objectArray[3 & 5] = a2.getId();
                objectArray[1 ^ 3] = exception.getMessage();
                objectArray[--3] = exception;
                f_td.warn(c_nL.m_ola((Object)"\u0013\u000f3\u0011?.3\r3\u00047\u0011rK)\u001e{Yr%7\r1\u00066C!\u0017=\u0013r\u00053\n>\u00066C4\f C3\u000f3\u0011?C5\u0011=\u0016\"C)\u001er\u00024\u00177\u0011r\u00177\u0011?C1\u000b3\r5\u0006hC)\u001e"), objectArray);
            }
            Object[] objectArray = new Object[--4];
            objectArray[3 >> 2] = a2.getId();
            objectArray[2 ^ 3] = string;
            objectArray[5 >> 1] = l;
            objectArray[--3] = l2;
            f_td.info(RunAnimScriptDto.m_fha((Object)"4%\u000e>\u0017'\t)G/\u0004:\u000e8\u0006:\u000e!\tn\b(G/\u000b/\u0015#G)\u0015!\u0012>G5\u001an\b G \b*\u0002n\u001c3]n\u000b+\u0006*\u0002<\u0014&\u000e>G\"\b=\u0013n\b<G:\u0002<\nn\u0004&\u0006 \u0000+\u0003nO=\u0004&\u0002*\u0012\"\u0002*Z5\u001abG-\u0012<\u0015+\t:Z5\u001agI"), objectArray);
            return;
        }
        if (c_Wk2.m_Aha()) {
            String[] stringArray = new String[--1];
            stringArray[3 >> 2] = a2.getId();
            a.f_AZ.sadd(f_kX, stringArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected c_LK getAlarmStatusInternal(Alarm alarm) {
        void a;
        AlarmManager alarmManager = this;
        if (a == null) {
            return c_LK.f_tZ;
        }
        AlarmManager a2 = alarmManager.f_Wy.m_Dia(a.getGroup().getId());
        if (a2 != null && a2.m_Aha() && a2.m_Rga(a.getId())) {
            return c_LK.f_taa;
        }
        return c_LK.f_tZ;
    }

    /*
     * WARNING - void declaration
     */
    public AlarmManager(c_gk c_gk2, c_dJ c_dJ2, c_DK c_DK2, c_eC c_eC2, JedisPooled jedisPooled, c_H c_H2, c_mj c_mj2) {
        AlarmManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        AlarmManager a8;
        AlarmManager alarmManager = alarmManager2;
        AlarmManager alarmManager2 = c_mj2;
        AlarmManager alarmManager3 = a8 = alarmManager;
        AlarmManager alarmManager4 = a8;
        AlarmManager alarmManager5 = a8;
        super((c_H)a7);
        AlarmManager alarmManager6 = a8;
        alarmManager6.f_PZ = new ReentrantLock();
        alarmManager5.f_Lz = a6;
        alarmManager5.f_jy = a5;
        alarmManager4.f_Wy = a4;
        alarmManager4.f_ZZ = a3;
        alarmManager3.f_AZ = a2;
        alarmManager3.f_Qaa = a;
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(c_nL.m_ola((Object)"\u001e&\u0013'\u00171hC\u0016\u00063\u0000&\n$\u0002&\n<\u0004r\u0002>\u0002 \u000er\u0004 \f'\u0013r\u0018/C>\f1\u0002>\u000f+M"), a);
            a2.deactivateAlarmGroupInternal((String)a);
            return;
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)")\u0001)c+\u000b&\n\"\u001c]n5+\u0016;\u0002=\u0013'\t)G\"\u0002/\u0003+\u0015n\u0013!G*\u0002/\u0004:\u000e8\u0006:\u0002n\u0006\"\u0006<\nn\u0000<\b;\u0017n\u001c3I"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x7E & 0x67)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm group " + (String)a, (Throwable)exception);
        }
    }

    protected void activateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Qaa.m_gEa(() -> a2.lambda$activateAlarmGroupInternal$3((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    protected void deactivateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.f_jy.m_Pga((String)a2));
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$3(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_PZ.lock();
        try {
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to start alarm group " + a.getName());
            }
            Runnable runnable = () -> a2.lambda$activateAlarmGroupInternal$2((AlarmGroup)a);
            a2.fenced("Activate alarm group " + a.getId(), runnable).run();
            return;
        }
        finally {
            a2.f_PZ.unlock();
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        a.registerRemoteCallsWithClusterNode();
        f_td.info(RunAnimScriptDto.m_fha((Object)"&\"\u0006<\n\u0003\u0006 \u0006)\u0002<G'\t'\u0013'\u0006\"\u000e4\u0002*G/\t*G<\u0002)\u000e=\u0013+\u0015+\u0003n\u0006=G\r\u000b;\u0014:\u0002<)!\u0003++'\u0014:\u0002 \u0002<I"));
    }

    @TransactionalEventListener(value={c_Sl.class})
    public void handleAlarmAddEvent(c_Sl c_Sl2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_XC.m_da()) {
            c_Wk c_Wk2;
            AlarmManager a = a.m_dLa();
            f_td.info(c_nL.m_ola((Object)"/\u0017\"\u0016&\u0000Yr+3\r6\u000f;\r5C\u0013\u000f3\u0011?\"6\u0007\u0017\u00157\r&C4\f C3\u000f3\u0011?C\u001b'hC)\u001e~C\u0015\u0011=\u0016\"C\u001b'hC)\u001e"), (Object)a.getId(), (Object)a.getGroupId());
            if (Boolean.TRUE.equals(a.getIsActive()) && (c_Wk2 = alarmManager.f_Wy.m_Dia(a.getGroupId())) != null && c_Wk2.m_Aha()) {
                c_Wk2.m_qGa((Alarm)a);
                return;
            }
        } else {
            f_td.debug(RunAnimScriptDto.m_fha((Object)")\u0001)c+\u000b&\n\"\u001c]n.)\t!\u0015'\t)G\u000f\u000b/\u0015#&*\u0003\u000b\u0011+\t:G(\b<G/\u000b/\u0015#G\u0007#tG5\u001a"), (Object)a.m_dLa().getId());
        }
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_jy.m_Kga((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_LK> getAlarmGroupStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(c_nL.m_ola((Object)"\u001e&\u0013'\u00171hC\u0015\u0006&\u0017;\r5C3\u000f>C3\u000f3\u0011?C5\u0011=\u0016\"C!\u00173\u0017'\u00107\u0010r\u0005=\u0011r\u0013 \f8\u00061\u0017r\u0018/C>\f1\u0002>\u000f+M"), a);
            return a2.getAlarmGroupStatusesByProjectIdInternal((String)a);
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)"\u0000(\u0000J\u0002\"\u000f#\u000b5tG\u001c\u0002?\u0012+\u0014:\u000e \u0000n\u000b+\u0006*\u0002<G(\b<G/\u000b\"G/\u000b/\u0015#G)\u0015!\u0012>G=\u0013/\u0013;\u0014+\u0014n\u0001!\u0015n\u0017<\b$\u0002-\u0013n\u001c3I"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            return (Map)a2.f_XC.m_Fa(Short.valueOf((short)(0x6E & 0x7B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group statuses for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.deactivateAlarmGroup(alarmManager.f_jy.m_Lia((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_LK> getAlarmStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(c_nL.m_ola((Object)"\u001e&\u0013'\u00171hC\u0015\u0006&\u0017;\r5C3\u000f>C3\u000f3\u0011?C!\u00173\u0017'\u00107\u0010r\u0005=\u0011r\u0013 \f8\u00061\u0017r\u0018/C>\f1\u0002>\u000f+M"), a);
            return a2.getAlarmStatusesByProjectIdInternal((String)a);
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)"\u0000(\u0000J\u0002\"\u000f#\u000b5tG\u001c\u0002?\u0012+\u0014:\u000e \u0000n\u000b+\u0006*\u0002<G(\b<G/\u000b\"G/\u000b/\u0015#G=\u0013/\u0013;\u0014+\u0014n\u0001!\u0015n\u0017<\b$\u0002-\u0013n\u001c3I"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_XC.m_Fa(Short.valueOf((short)(0x7B & 0x6D)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(c_nL.m_ola((Object)"\u001e&\u0013'\u00171hC\u0013\u0000&\n$\u0002&\n<\u0004r\u0002>\u0002 \u000er\u0004 \f'\u0013r\u0018/C>\f1\u0002>\u000f+M"), a);
            a2.activateAlarmGroupInternal((String)a);
            return;
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)")\u0001)c+\u000b&\n\"\u001c]n5+\u0016;\u0002=\u0013'\t)G\"\u0002/\u0003+\u0015n\u0013!G/\u0004:\u000e8\u0006:\u0002n\u0006\"\u0006<\nn\u0000<\b;\u0017n\u001c3I"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x75 & 0x6F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm group " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.activateAlarmGroup(alarmManager.f_jy.m_Lia((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(c_nL.m_ola((Object)"/\u0017\"\u0016&\u0000Yr'7\u00021\u0017;\u00153\u0017;\r5C3\u000f>C3\u000f3\u0011?C5\u0011=\u0016\"\u0010r\u0005=\u0011r\u0013 \f8\u00061\u0017r\u0018/C>\f1\u0002>\u000f+M"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)"\u0000(\u0000J\u0002\"\u000f#\u000b5tG\u001c\u0002?\u0012+\u0014:\u000e \u0000n\u000b+\u0006*\u0002<G:\bn\u0003+\u0006-\u0013'\u0011/\u0013+G/\u000b\"G/\u000b/\u0015#G)\u0015!\u0012>\u0014n\u0001!\u0015n\u0017<\b$\u0002-\u0013n\u001c3I"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 & 4] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x6F & 0x7D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_LK> getAlarmStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_Lz.m_uHa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(BaseModel::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_GK.class})
    public void handleAlarmGroupChangeEvent(c_GK c_GK2) {
        void a;
        AlarmManager alarmManager = this;
        if (alarmManager.f_XC.m_da()) {
            f_td.info(c_nL.m_ola((Object)"/\u0017\"\u0016&\u0000Yr+3\r6\u000f;\r5C\u0013\u000f3\u0011?$ \f'\u0013\u0011\u000b3\r5\u0006\u0017\u00157\r&C4\f C5\u0011=\u0016\"C\u001b'hC)\u001e"), (Object)a.m_FKa().getId());
            alarmManager.f_PZ.lock();
            try {
                Object a2 = a.m_FKa().getId();
                if (alarmManager.getAlarmGroupStatusInternal((String)a2) == c_LK.f_taa) {
                    AlarmManager alarmManager2 = alarmManager;
                    alarmManager2.deactivateAlarmGroupInternal((String)a2);
                    alarmManager2.activateAlarmGroupInternal((String)a2);
                }
                return;
            }
            finally {
                alarmManager.f_PZ.unlock();
            }
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)")\u0001)c+\u000b&\n\"\u001c]n.)\t!\u0015'\t)G\u000f\u000b/\u0015# <\b;\u0017\r\u000f/\t)\u0002\u000b\u0011+\t:G(\b<G)\u0015!\u0012>G\u0007#tG5\u001a"), (Object)a.m_FKa().getId());
    }

    public void notLeader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_XC.m_La();
        f_td.info(RunAnimScriptDto.m_fha((Object)"\u000f\u000b/\u0015#*/\t/\u0000+\u0015tG\u001a\u000f'\u0014n\t!\u0003+Gf\u001c3Nn\u000e=G\u0000(n+\u0001)\t\"\u001cG\u001a/\u000bG\u0002\"\u000f#\u000b5`G\u001d\u0013!\u0017>\u000e \u0000n\u0006\"\u000bn\u000b!\u0004/\u000bn\u0006\"\u0006<\nn\u000e \u0014>\u0002-\u0013!\u0015=I`I"), a);
        alarmManager2.f_PZ.lock();
        try {
            alarmManager.f_Wy.m_BGa();
            f_td.info(c_nL.m_ola((Object)"\">\u0002 \u000e\u001f\u0002<\u00025\u0006 Cz-=\u0017r/7\u00026\u0006 C)\u001e{Yr\">\u000fr\u000f=\u00003\u000fr\u0002>\u0002 \u000er\n<\u0010\"\u00061\u0017;\f<C&\u0002!\b!C:\u0002$\u0006r\u00017\u0006<C \u0006#\u00167\u0010&\u00066C&\fr\u0010&\f\"M"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[--2] = exception;
            f_td.error(RunAnimScriptDto.m_fha((Object)"&\"\u0006<\n\u0003\u0006 \u0006)\u0002<Gf)!\u0013n++\u0006*\u0002<G5\u001ag]n\"<\u0015!\u0015n\u0003;\u0015'\t)G>\u0015!\u0004+\u0014=G!\u0001n\u0014:\b>\u0017'\t)G\"\b-\u0006\"G/\u000b/\u0015#G'\t=\u0017+\u0004:\b<\u0014tG5\u001a"), objectArray);
            return;
        }
        finally {
            alarmManager.f_PZ.unlock();
        }
    }

    protected void activateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_jy.m_Kga((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_LK getAlarmStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_Lz.m_kIa((String)a2, (String)a)) == null) {
            return c_LK.f_tZ;
        }
        return a3.getAlarmStatus(a2.getId());
    }

    protected void activateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.activateAlarmGroupInternal(alarmManager.f_jy.m_Pga((String)a2));
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Qaa.m_gEa(() -> a2.lambda$deactivateAlarmGroupInternal$4((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    protected Map<String, c_LK> getAlarmGroupStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_jy.m_Uka((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroupSummary::getId, alarmGroupSummary -> {
            AlarmManager a = alarmGroupSummary;
            AlarmManager a2 = this;
            return a2.getAlarmGroupStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader(long l) {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        String a = alarmManager2.f_XC.m_La();
        f_td.info(c_nL.m_ola((Object)"\u0013\u000f3\u0011?.3\r3\u00047\u0011hC\u0006\u000b;\u0010r\r=\u00077Cz\u0018/Jr\u000b3\u0010r\u00017\u0000=\u000e7C&\u000b7C\u001e&\u0013'\u00171|C\u0000\u0006!\u0017=\u0011;\r5C3\u0000&\n$\u0006r\u0002>\u0002 \u000e!M|M"), (Object)a);
        alarmManager2.f_PZ.lock();
        try {
            HashSet hashSet = new HashSet(alarmManager.f_AZ.smembers(f_kX));
            if (hashSet.isEmpty()) {
                f_td.info(RunAnimScriptDto.m_fha((Object)"&\"\u0006<\n\u0003\u0006 \u0006)\u0002<Gf++\u0006*\u0002<G5\u001ag]n)!G/\u0004:\u000e8\u0002n\u0006\"\u0006<\nn\u0000<\b;\u0017=G(\b;\t*G'\tn5+\u0003'\u0014n\u0013!G<\u0002=\u0013!\u0015+I"), (Object)a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[--1] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_td.info(c_nL.m_ola((Object)"\">\u0002 \u000e\u001f\u0002<\u00025\u0006 Cz/7\u00026\u0006 C)\u001e{Yr%=\u0016<\u0007r\u0018/C3\u0000&\n$\u0006r\u0002>\u0002 \u000er\u0004 \f'\u0013r*\u0016\u0010r\n<C\u0000\u00066\n!C&\fr\u00117\u0010&\f \u0006hC)\u001e"), objectArray);
            ArrayList a2 = new ArrayList();
            String[] stringArray = new String[2 ^ 3];
            stringArray[2 & 5] = RunAnimScriptDto.m_fha((Object)"\u0018.\u000b0\u0011&\u0002&\u001c*\u0011 \u001c(\u001b7");
            alarmManager.f_Qaa.m_Sea(() -> {
                void a;
                Object a2 = hashSet;
                AlarmManager a3 = this;
                a.addAll(a3.f_jy.m_KIa((Set)a2));
            }, stringArray);
            f_td.info(c_nL.m_ola((Object)"\u0013\u000f3\u0011?.3\r3\u00047\u0011rK\u001e\u00063\u00077\u0011r\u0018/JhC\u0013\u0017&\u0006?\u0013&\n<\u0004r\u0017=C \u0006!\u0017=\u00117C)\u001er\u0002>\u0002 \u000er\u0004 \f'\u0013!M"), (Object)a, (Object)a2.size());
            a2.forEach(alarmGroup -> {
                void a;
                AlarmManager alarmManager;
                AlarmManager alarmManager2 = alarmManager = this;
                Object a2 = alarmManager2.f_XC.m_La();
                String[] stringArray = new String[5 >> 1];
                stringArray[3 ^ 3] = RunAnimScriptDto.m_fha((Object)"\u000f$\u001a.\u0018&\u001a\"\u0011&\u0002&\u001c*");
                stringArray[2 ^ 3] = c_nL.m_ola((Object)"\u0016&\u0013 \u0006*\u0004\"\u0006&\r\"\u001e\"\u0000.");
                alarmManager2.f_Qaa.m_XFa(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1((String)a2, (AlarmGroup)a), a.getSpace(), stringArray);
            });
            f_td.info(RunAnimScriptDto.m_fha((Object)"&\"\u0006<\n\u0003\u0006 \u0006)\u0002<Gf++\u0006*\u0002<G5\u001ag]n!'\t'\u0014&\u0002*G/\u000b/\u0015#G<\u0002=\u0013!\u0015/\u0013'\b G>\u0015!\u0004+\u0014=I"), (Object)a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_td.error(c_nL.m_ola((Object)"\u0013\u000f3\u0011?.3\r3\u00047\u0011rK\u001e\u00063\u00077\u0011r\u0018/JhC\u0017\u0011 \f C6\u0016 \n<\u0004r\u0002>\u0002 \u000er\u00117\u0010&\f \u0002&\n=\rr\u0013 \f1\u0006!\u0010hC)\u001e"), objectArray);
            return;
        }
        finally {
            alarmManager.f_PZ.unlock();
        }
    }

    protected Map<String, c_LK> getAlarmStatusesInternal(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.debug(c_nL.m_ola((Object)"/\u0017\"\u0016&\u0000Yr\"1\u0017;\u00153\u0017;\r5C3\u000f>C3\u000f3\u0011?C5\u0011=\u0016\"\u0010r\u0005=\u0011r\u0013 \f8\u00061\u0017r\u0018/C>\f1\u0002>\u000f+M"), a);
            a2.activateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)"\u0000(\u0000J\u0002\"\u000f#\u000b5tG\u001c\u0002?\u0012+\u0014:\u000e \u0000n\u000b+\u0006*\u0002<G:\bn\u0006-\u0013'\u0011/\u0013+G/\u000b\"G/\u000b/\u0015#G)\u0015!\u0012>\u0014n\u0001!\u0015n\u0017<\b$\u0002-\u0013n\u001c3I"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            a2.f_XC.m_Fa(Short.valueOf((short)(0x6D & 0x7E)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_LK> getAlarmStatuses(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_XC.m_da()) {
            f_td.debug(c_nL.m_ola((Object)"/\u0017\"\u0016&\u0000Yr$7\u0017&\n<\u0004r\u0002>\u0002 \u000er\u0010&\u0002&\u0016!\u0006!C4\f C)\u001er*\u0016\u0010r\u000f=\u00003\u000f>\u001ahC)\u001e"), (Object)a.size(), (Object)a);
            return a2.getAlarmStatusesInternal((List)a);
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)")\u0001)c+\u000b&\n\"\u001c]n5+\u0016;\u0002=\u0013'\t)G\"\u0002/\u0003+\u0015n\u0001!\u0015n\u0006\"\u0006<\nn\u0014:\u0006:\u0012=\u0002=G(\b<G5\u001an.\n\u0014tG5\u001a"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[5 >> 3] = new ArrayList(a);
            return (Map)a2.f_XC.m_Fa(Short.valueOf((short)(0x7B & 0x6F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_xK.class})
    public void handleAlarmGroupDeleteEvent(c_xK c_xK2) {
        AlarmManager a = c_xK2;
        AlarmManager a2 = this;
        if (a2.f_XC.m_da()) {
            f_td.info(c_nL.m_ola((Object)"/\u0017\"\u0016&\u0000Yr+3\r6\u000f;\r5C\u0013\u000f3\u0011?$ \f'\u0013\u0016\u0006>\u0006&\u0006\u0017\u00157\r&C4\f C5\u0011=\u0016\"C\u001b'hC)\u001e"), (Object)a.m_wKa().getId());
            a2.deactivateAlarmGroupInternal(a.m_wKa().getId());
            return;
        }
        f_td.debug(RunAnimScriptDto.m_fha((Object)")\u0001)c+\u000b&\n\"\u001c]n.)\t!\u0015'\t)G\u000f\u000b/\u0015# <\b;\u0017\n\u0002\"\u0002:\u0002\u000b\u0011+\t:G(\b<G)\u0015!\u0012>G\u0007#tG5\u001a"), (Object)a.m_wKa().getId());
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        AlarmManager alarmManager = this;
        try {
            Class[] classArray = new Class[4 ^ 5];
            classArray[3 >> 2] = String.class;
            alarmManager.f_XC.m_Ja((short)(0x65 & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_nL.m_ola((Object)"3\u0000&\n$\u0002&\u0006\u0013\u000f3\u0011?$ \f'\u0013\u001b\r&\u0006 \r3\u000f"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[3 >> 2] = String.class;
            alarmManager.f_XC.m_Ja((short)(0x67 & 0x7E), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(RunAnimScriptDto.m_fha((Object)"*\u0002/\u0004:\u000e8\u0006:\u0002\u000f\u000b/\u0015# <\b;\u0017\u0007\t:\u0002<\t/\u000b"), classArray2));
            Class[] classArray3 = new Class[--1];
            classArray3[2 & 5] = String.class;
            alarmManager.f_XC.m_Ja((short)(0x7F & 0x67), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_nL.m_ola((Object)"5\u0006&\">\u0002 \u000e\u0001\u00173\u0017'\u0010\u001b\r&\u0006 \r3\u000f"), classArray3));
            Class[] classArray4 = new Class[3 & 5];
            classArray4[3 >> 2] = String.class;
            alarmManager.f_XC.m_Ja((short)(0x6F & 0x78), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(RunAnimScriptDto.m_fha((Object)"\u0000+\u0013\u000f\u000b/\u0015# <\b;\u0017\u001d\u0013/\u0013;\u0014\u0007\t:\u0002<\t/\u000b"), classArray4));
            Class[] classArray5 = new Class[3 & 5];
            classArray5[5 >> 3] = String.class;
            alarmManager.f_XC.m_Ja((short)(0x7F & 0x69), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_nL.m_ola((Object)"\u00047\u0017\u0013\u000f3\u0011?0&\u0002&\u0016!\u0006!!+3 \f8\u00061\u0017\u001b\u0007\u001b\r&\u0006 \r3\u000f"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            alarmManager.f_XC.m_Ja((short)(0x7A & 0x6F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(RunAnimScriptDto.m_fha((Object)")\u0002:&\"\u0006<\n\t\u0015!\u0012>4:\u0006:\u0012=\u0002=%77<\b$\u0002-\u0013\u0007\u0003\u0007\t:\u0002<\t/\u000b"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            alarmManager.f_XC.m_Ja((short)(0x6B & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_nL.m_ola((Object)"5\u0006&\">\u0002 \u000e\u0001\u00173\u0017'\u00107\u0010\u001b\r&\u0006 \r3\u000f"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            alarmManager.f_XC.m_Ja((short)(0x6C & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(RunAnimScriptDto.m_fha((Object)"/\u0004:\u000e8\u0006:\u0002\u000f\u000b/\u0015# <\b;\u0017=%77<\b$\u0002-\u0013\u0007\u0003\u0007\t:\u0002<\t/\u000b"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String.class;
            alarmManager.f_XC.m_Ja((short)(0x6F & 0x7D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_nL.m_ola((Object)"6\u00063\u0000&\n$\u0002&\u0006\u0013\u000f3\u0011?$ \f'\u0013!!+3 \f8\u00061\u0017\u001b\u0007\u001b\r&\u0006 \r3\u000f"), classArray9));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(RunAnimScriptDto.m_fha((Object)"!/\u000e\"\u0002*G:\bn\u0015+\u0000'\u0014:\u0002<G\u000f\u000b/\u0015#*/\t/\u0000+\u0015n5\u001e$n\n+\u0013&\b*\u0014"), a);
        }
    }
}

