/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.repositories;

import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;

@EnableSpaceFilter
public interface RepeatableScriptRepository
extends BaseJpaRepository<RepeatableScript> {
    @Query(value="SELECT new com.inscada.mono.script.model.RepeatableScriptSummary(r.id, r.name, r.projectId, r.dsc, r.type, r.log, r.createdBy, r.creationDate, r.lastModifiedBy, r.lastModifiedDate) FROM RepeatableScript r")
    public List<RepeatableScriptSummary> findSummary();

    public List<RepeatableScript> findByProjectId(String var1);

    @DisableSpaceFilter
    @Query(value="SELECT r FROM RepeatableScript r WHERE r.id IN ?1")
    public List<RepeatableScript> findAllInAllSpaces(Set<String> var1);

    @Query(value="SELECT new com.inscada.mono.script.model.RepeatableScriptSummary(r.id, r.name, r.projectId, r.dsc, r.type, r.log, r.createdBy, r.creationDate, r.lastModifiedBy, r.lastModifiedDate) FROM RepeatableScript r WHERE r.id = ?1")
    public Optional<RepeatableScriptSummary> findSummaryById(String var1);

    public List<RepeatableScript> findByProjectIdAndNameIn(String var1, Set<String> var2);

    @Query(value="SELECT new com.inscada.mono.script.model.RepeatableScriptSummary(r.id, r.name, r.projectId, r.dsc, r.type, r.log, r.createdBy, r.creationDate, r.lastModifiedBy, r.lastModifiedDate) FROM RepeatableScript r WHERE r.projectId = ?1")
    public List<RepeatableScriptSummary> findSummaryByProjectId(String var1);

    @Query(value="SELECT new com.inscada.mono.script.model.RepeatableScriptSummary(r.id, r.name, r.projectId, r.dsc, r.type, r.log, r.createdBy, r.creationDate, r.lastModifiedBy, r.lastModifiedDate) FROM RepeatableScript r WHERE r.projectId = ?1 AND r.name = ?2")
    public Optional<RepeatableScriptSummary> findSummaryByProjectIdAndName(String var1, String var2);

    public Optional<RepeatableScript> findOneByProjectIdAndName(String var1, String var2);
}

