/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.filesystem.r;

import com.inscada.mono.filesystem.model.FileDownloadResult;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.filesystem.repositories.FileInfoRepository;
import com.inscada.mono.shared.e.c_Bd;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.ModelUpdater;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.sms.model.SmsRequest;
import com.inscada.mono.space.SpaceContext;
import com.inscada.mono.space.model.Space;
import com.inscada.mono.system.repositories.SystemRequestRepository;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class c_Ic {
    public static final String f_Wi = "animations";
    private final ModelUpdater f_XH;
    public static final String f_Xh = "symbols";
    public static final String f_HI = "faceplates";
    public static final String f_vh = "scl-files";
    public static final String f_fj = "jasper-templates";
    private static final Logger f_Dh = LoggerFactory.getLogger(c_Ic.class);
    private final String f_gj;
    public static final String f_ci = "logo";
    public static final String f_rI = "project-icons";
    private final FileInfoRepository f_oI;
    public static final String f_YG = "login-images";
    public static final String f_Bj = "general-uploads";

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_BN(String string) {
        Object a = string;
        c_Ic a2 = this;
        return (FileInfo)a2.m_MM((String)a).orElseThrow(() -> c_Ic.m_gM((String)a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public Optional<FileInfo> m_MM(String string) {
        Object a = string;
        c_Ic a2 = this;
        return a2.f_oI.findByRelativePath((String)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public List<FileInfo> m_ao() {
        c_Ic a;
        return a.f_oI.findAll();
    }

    private static /* synthetic */ NotFoundException m_OO(String a) {
        return new NotFoundException("File info not found with id: " + a);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_LOGIN_SETTINGS')")
    public String m_Cn(MultipartFile multipartFile) {
        void a22;
        c_Ic c_Ic2 = this;
        void v0 = a22;
        Objects.requireNonNull(v0, SystemRequestRepository.m_gE((Object)"\u0004!%  $(&=\u0012 8,t*5':& i6,t'!%8g"));
        if (v0.isEmpty()) {
            throw new FileStorageException(SmsRequest.m_DD((Object)" 0\r?\f%C\"\u0017>\u00114C0\rq\u0006<\u0013%\u001aq\u00058\u000f4M"));
        }
        Object a = StringUtils.cleanPath((String)Objects.requireNonNull(a22.getOriginalFilename(), SystemRequestRepository.m_gE((Object)"\u0004!%  $(&=\u0012 8,t&& 3 :(8i2 8,:(9,t*5':& i6,t'!%8g")));
        if (a.contains(SmsRequest.m_DD((Object)"\u007fM"))) {
            throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u000f=%1'5$1i7&:=5 ::t :?5%=-t95=<i',%<1'7,tnzgsg"));
        }
        Path path = Path.of(c_Ic2.f_gj, new String[3 & 4]).toAbsolutePath().normalize().resolve(f_YG).normalize();
        Path path2 = path.resolve((String)a).normalize();
        if (!path2.startsWith(path)) {
            throw new FileStorageException(SmsRequest.m_DD((Object)"\u0018\r'\u0002=\n5C=\f6\n?C8\u000e0\u00044C!\u0002%\u000b"));
        }
        try {
            Files.createDirectories(path, new FileAttribute[2 & 5]);
            CopyOption[] copyOptionArray = new CopyOption[5 >> 2];
            copyOptionArray[5 >> 3] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy(a22.getInputStream(), path2, copyOptionArray);
            f_Dh.info(SystemRequestRepository.m_gE((Object)"\u0005;.='t 9(3,tn/4si'<7*1:'/!%80t>&  =1't=;i2 8,'0'=1$t( is2)n"), a, (Object)path2);
            return a;
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not store login image " + (String)a + ". Please try again!", (Throwable)a22);
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public FileInfo m_WN(FileInfo fileInfo) {
        FileInfo fileInfo2;
        c_Ic a = fileInfo;
        c_Ic a2 = this;
        Object object = a.getId() != null ? a2.m_oN(a.getId()) : (fileInfo2 = StringUtils.hasText((String)a.getName()) ? a2.m_Rn(a.getName()) : null);
        if (fileInfo2 != null) {
            a2.f_XH.copyForUpdate((Object)a, (SpaceBaseModel)fileInfo2, new String[2 & 5]);
            return fileInfo2;
        }
        return (FileInfo)a2.f_oI.save((Object)a);
    }

    /*
     * WARNING - void declaration
     */
    public FileDownloadResult m_im(String string) {
        Path path;
        block7: {
            FileInfo fileInfo;
            Object a;
            void a2;
            c_Ic c_Ic2 = this;
            if (!StringUtils.hasText((String)a2)) {
                throw new NotFoundException(SmsRequest.m_DD((Object)"->C=\f6\n?C3\u00022\b6\u0011>\u0016?\u0007q\n<\u00026\u0006q\u00058\u000f4\r0\u000e4C!\u0011>\u00158\u00074\u0007"));
            }
            Path path2 = Path.of(c_Ic2.f_gj, new String[3 ^ 3]);
            path = path2.resolve(f_YG).resolve((String)a2).normalize();
            if (!path.startsWith((Path)(a = path2.resolve(f_YG).normalize()))) {
                throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u001d'\"(8 0i8&3 :i=$5.1i$( !"));
            }
            a = new UrlResource(path.toUri());
            if (!a.exists() || !a.isReadable()) break block7;
            FileInfo fileInfo2 = fileInfo = new FileInfo();
            fileInfo2.setFileName((String)a2);
            fileInfo2.setFileType(Files.probeContentType(path));
            if (fileInfo2.getFileType() == null) {
                fileInfo.setFileType(SmsRequest.m_DD((Object)"0\u0013!\u000f8\u00000\u00178\f?L>\u0000%\u0006%N\"\u0017#\u00060\u000e"));
            }
            return new FileDownloadResult((Resource)a, fileInfo);
        }
        try {
            f_Dh.error(SystemRequestRepository.m_gE((Object)"\u0018&3 :i=$5.1i2 8,t';=t/;<:-t&:i0 '\"ni/4"), (Object)path);
            throw new NotFoundException(SmsRequest.m_DD((Object)"\u001d\f6\n?C8\u000e0\u00044C7\n=\u0006q\r>\u0017q\u0005>\u0016?\u0007"));
        }
        catch (MalformedURLException a) {
            throw new NotFoundException(SystemRequestRepository.m_gE((Object)"\u0005;.='t 9(3,t/=%1i:& i2&!'0i|$5%2&&$1-t\u001c\u0006\u0005}g"));
        }
        catch (IOException a) {
            f_Dh.error(SmsRequest.m_DD((Object)"\u0014\u0011#\f#C0\u00002\u0006\"\u00108\r6C=\f6\n?C8\u000e0\u00044C7\n=\u0006kC*\u001e"), (Object)path, (Object)a);
            throw new NotFoundException(SystemRequestRepository.m_gE((Object)"\u0018&3 :i=$5.1i2 8,t';=t/;<:-"));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_oN(String string) {
        Object a = string;
        c_Ic a2 = this;
        return a2.f_oI.findById(a).orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    public c_Ic(FileInfoRepository fileInfoRepository, ModelUpdater modelUpdater, @Value(value="${ins.files.path}") String string) {
        void modelUpdater2;
        void fileInfoRepository2;
        c_Ic a;
        c_Ic c_Ic2 = object;
        Object object = string;
        c_Ic c_Ic3 = a = c_Ic2;
        a.f_oI = fileInfoRepository2;
        c_Ic3.f_XH = modelUpdater2;
        c_Ic3.f_gj = object;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('VIEW_FILE') and hasAuthority('CREATE_FILE')")
    public FileInfo m_YN(String string) {
        FileInfo a;
        c_Ic c_Ic2 = this;
        Objects.requireNonNull(a, SystemRequestRepository.m_gE((Object)"\u001b;=.='5%t/=%1i\u001d\rt*5':& i6,t'!%8g"));
        a = c_Ic2.m_ro((String)a);
        long l = System.currentTimeMillis();
        String string2 = a.getFileName();
        Object a22 = "";
        String string3 = string2;
        int n = string3.lastIndexOf(0x6F & 0x3E);
        if (n > 0) {
            String string4 = string2;
            string3 = string4.substring(3 ^ 3, n);
            a22 = string4.substring(n);
        }
        if ((string2 = StringUtils.cleanPath((String)(string3 + "_clone_" + l + (String)a22))).contains(SmsRequest.m_DD((Object)"\u007fM"))) {
            throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u000e1'1;5=1-t/=%1'5$1i7&:=5 ::t :?5%=-t95=<i',%<1'7,tnzgsg"));
        }
        a22 = Objects.requireNonNull(SpaceContext.getActiveSpace(), SmsRequest.m_DD((Object)"\"2\u00178\u00154C\"\u00130\u00004C8\u0010q\u00114\u0012$\n#\u00065C%\fq\u0000=\f?\u0006q\u0002q\u00058\u000f4M"));
        String[] stringArray = new String[2 ^ 3];
        stringArray[3 & 4] = a22.getName();
        a22 = Path.of(c_Ic2.f_gj, stringArray).toAbsolutePath().normalize();
        Path path = a22.resolve(string3 = StringUtils.hasText((String)a.getTargetSubdirectory()) ? a.getTargetSubdirectory() : f_Bj).normalize();
        Path path2 = path.resolve(string2).normalize();
        if (!path2.startsWith(path)) {
            throw new FileStorageException("Generated filename results in path traversal: " + string2);
        }
        String string5 = a22.relativize(path2).toString().replace(SystemRequestRepository.m_gE((Object)"\u0015"), SmsRequest.m_DD((Object)"L"));
        if (c_Ic2.f_oI.existsByRelativePath(string5)) {
            throw new FileStorageException("A file already exists at generated path: " + string5);
        }
        a22 = a22.resolve(a.getRelativePath()).normalize();
        try {
            Files.createDirectories(path, new FileAttribute[3 & 4]);
            CopyOption[] copyOptionArray = new CopyOption[3 & 5];
            copyOptionArray[3 ^ 3] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy((Path)a22, path2, copyOptionArray);
            f_Dh.info(SystemRequestRepository.m_gE((Object)"\u000f=%1i7%;'1-t/&&9is2)nt=;is2)n"), a22, (Object)path2);
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not clone file: " + a.getFileName(), (Throwable)a22);
        }
        a22 = a.getName() + "_clone_" + l;
        Path path3 = path = new FileInfo();
        path3.setName((String)a22);
        path3.setDsc("Clone of " + a.getName());
        Path path4 = path;
        FileInfo fileInfo = a;
        Path path5 = path;
        path5.setFileName(string2);
        path5.setRelativePath(string5);
        path.setFileSize(fileInfo.getFileSize());
        path4.setFileType(fileInfo.getFileType());
        path4.setTargetSubdirectory(string3);
        return (FileInfo)c_Ic2.f_oI.save((Object)path);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_FILE')")
    public FileInfo m_fm(String string, MultipartFile multipartFile, FileInfo fileInfo) {
        String string2;
        String string3;
        void a;
        int n;
        Object object;
        c_Ic a2;
        void a3;
        c_Ic c_Ic2;
        block12: {
            int n2;
            void v2;
            void a222;
            c_Ic2 = this;
            Objects.requireNonNull(a3, SystemRequestRepository.m_gE((Object)"\u000190( ,0i9, (0( (ta\u0012 8,\u001d'2&}i;+>,7=t*5':& i6,t'!%8g"));
            a2 = c_Ic2.m_ro((String)a222);
            String[] stringArray = new String[2 ^ 3];
            stringArray[2 & 5] = a2.getSpace().getName();
            object = Path.of(c_Ic2.f_gj, stringArray).toAbsolutePath().normalize();
            Path path = object.resolve(a2.getRelativePath()).normalize();
            int n3 = n = a != null && !a.isEmpty() ? --1 : 0;
            if (n != 0) {
                string3 = StringUtils.cleanPath((String)Objects.requireNonNull(a.getOriginalFilename(), SmsRequest.m_DD((Object)"\u001c\u0016=\u00178\u00130\u0011%%8\u000f4C>\u00118\u00048\r0\u000fq\u00058\u000f4\r0\u000e4C2\u0002?\r>\u0017q\u00014C?\u0016=\u000fq\u00149\u0006?C#\u0006!\u000f0\u00008\r6C2\f?\u00174\r%M")));
                v2 = a3;
            } else {
                string3 = a2.getFileName();
                v2 = a3;
            }
            String string4 = StringUtils.hasText((String)v2.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a3.getTargetSubdirectory()) : (string2 = StringUtils.hasText((String)a2.getTargetSubdirectory()) ? a2.getTargetSubdirectory() : f_Bj);
            if (string3.contains(SystemRequestRepository.m_gE((Object)"zg")) || string2.contains(SmsRequest.m_DD((Object)"\u007fM"))) {
                throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u0000:?5%=-t95=<i'91*=/=,0i='t<$-5=1i&,%<1: g"));
            }
            Path path2 = object.resolve(string2).normalize();
            if (!path2.startsWith((Path)object)) {
                f_Dh.warn(SmsRequest.m_DD((Object)"30\u00179C%\u00110\u00154\u0011\"\u0002=C0\u0017%\u0006<\u0013%Mq-4\u0014q\u00170\u00116\u0006%C\"\u00163\u00078\u00114\u0000%\f#\u001aqD*\u001evC#\u0006\"\f=\u00154\u0010q\f$\u0017\"\n5\u0006q\u0010!\u00022\u0006q\u0011>\f%Cv\u0018,D"), (Object)string2, object);
                throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u0000:?5%=-t-=;1* &&0t95=<i'91*=/=,0g"));
            }
            Path path3 = path2.resolve(string3).normalize();
            if (!path3.startsWith(path2)) {
                f_Dh.warn(SmsRequest.m_DD((Object)"30\u00179C%\u00110\u00154\u0011\"\u0002=C0\u0017%\u0006<\u0013%C'\n0C?\u0006&C7\n=\u0006?\u0002<\u0006\u007fC\u0017\n=\u0006?\u0002<\u0006qD*\u001evC8\rq\u00078\u00114\u0000%\f#\u001aqD*\u001evC#\u0006\"\f=\u00154\u0010q\f$\u0017\"\n5\u0006"), (Object)string3, (Object)path2);
                throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u0000:?5%=-t/=%1'5$1i'91*=/=,0g"));
            }
            int n4 = n2 = !((String)(object = object.relativize(path3).toString().replace(SmsRequest.m_DD((Object)"?"), SystemRequestRepository.m_gE((Object)"f")))).equals(a2.getRelativePath()) ? 3 & 5 : 0;
            if (n2 != 0 && c_Ic2.f_oI.existsByRelativePathAndIdNot((String)object, (String)a222)) {
                throw new FileStorageException(SmsRequest.m_DD((Object)"\u0010C7\n=\u0006q\u00148\u00179C%\u000b8\u0010q\r0\u000e4C0\u000f#\u00060\u0007(C4\u001b8\u0010%\u0010q\u0002%C%\u000b4C%\u0002#\u00044\u0017q\u000f>\u00000\u00178\f?M"));
            }
            try {
                if (n != 0) {
                    if (Files.exists(path, new LinkOption[3 >> 2])) {
                        Files.deleteIfExists(path);
                        f_Dh.info(SystemRequestRepository.m_gE((Object)"\u001b%0i2 8,t*;' ,:=t-1%1=1-t/&&9i2 8,'0'=1$ni/4"), (Object)path);
                    }
                    Files.createDirectories(path2, new FileAttribute[3 & 4]);
                    CopyOption[] copyOptionArray = new CopyOption[2 ^ 3];
                    copyOptionArray[5 >> 3] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy(a.getInputStream(), path3, copyOptionArray);
                    f_Dh.info(SmsRequest.m_DD((Object)"\u001f\u0006&C7\n=\u0006q\u0000>\r%\u0006?\u0017q\u0005>\u0011qD*\u001evC\"\u00162\u00004\u0010\"\u0005$\u000f=\u001aq\u0014#\n%\u00174\rq\u0017>C7\n=\u0006\"\u001a\"\u00174\u000eq\u0002%Cv\u0018,D"), (Object)string3, (Object)path3);
                    break block12;
                }
                if (n2 == 0) break block12;
                if (Files.exists(path, new LinkOption[3 & 4])) {
                    Files.createDirectories(path2, new FileAttribute[0]);
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(path, path3, copyOptionArray);
                    f_Dh.info(SystemRequestRepository.m_gE((Object)"\u0012 8,t$;?1-t/&&9i/4t=;i/4"), (Object)path, (Object)path3);
                    break block12;
                }
                f_Dh.warn(SmsRequest.m_DD((Object)"\u001e\u000f5C7\n=\u0006q\r>\u0017q\u0005>\u0016?\u0007q\u0002%C*\u001eq\u0005>\u0011q\u000e>\u00154C>\u00134\u00110\u00178\f?Oq\u0001$\u0017q\u000e4\u00170\u00070\u00170C4\u001b8\u0010%\u00065M"), (Object)path);
                throw new NotFoundException(SystemRequestRepository.m_gE((Object)"\u0012 8,t';=t/;<:-t/;;t<$-5=1i;91;5==&:g"));
            }
            catch (IOException a222) {
                f_Dh.error(SmsRequest.m_DD((Object)" >\u0016=\u0007q\r>\u0017q\u0016!\u00070\u00174C7\n=\u0006qD*\u001evC5\u00164C%\fq*\u001e&)\u00004\u0013%\n>\r"), (Object)a2.getFileName(), (Object)a222);
                throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u0017&!%0i:& i!90( ,t=<,t/=%1gt\u00198,5:1i ;-i5.5 :g"));
            }
        }
        c_Ic c_Ic3 = a2;
        c_Ic c_Ic4 = a2;
        c_Ic4.setName(a3.getName());
        c_Ic4.setDsc(a3.getDsc());
        c_Ic3.setFileName(string3);
        c_Ic3.setTargetSubdirectory(string2);
        a2.setRelativePath((String)object);
        if (n != 0) {
            c_Ic c_Ic5 = a2;
            c_Ic5.setFileSize(Long.valueOf(a.getSize()));
            c_Ic5.setFileType(StringUtils.hasText((String)a.getContentType()) ? a.getContentType() : SmsRequest.m_DD((Object)"0\u0013!\u000f8\u00000\u00178\f?L>\u0000%\u0006%N\"\u0017#\u00060\u000e"));
        }
        return (FileInfo)c_Ic2.f_oI.save((Object)a2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public void m_Tn(ZipFile zipFile, FileInfo fileInfo) {
        void a3222;
        InputStream a22;
        c_Ic c_Ic2 = this;
        ZipEntry zipEntry = ((ZipFile)((Object)a22)).getEntry(a3222.getFileName());
        if (zipEntry == null) return;
        Objects.requireNonNull(a3222, SystemRequestRepository.m_gE((Object)"\u000f=%1\u0000:/;i;+>,7=t*5':& i6,t'!%8g"));
        Object a = zipEntry.getName();
        if (((String)a).trim().isEmpty()) {
            throw new FileStorageException(SmsRequest.m_DD((Object)"98\u0013q\u0006?\u0017#\u001aq\r0\u000e4C2\u0002?\r>\u0017q\u00014C4\u000e!\u0017(M"));
        }
        if (((String)a).contains(SystemRequestRepository.m_gE((Object)"zg")) || ((String)a).startsWith(SmsRequest.m_DD((Object)"L")) || ((String)a).startsWith(SystemRequestRepository.m_gE((Object)"\u0015")) || ((String)a).contains(SmsRequest.m_DD((Object)"kL")) || ((String)a).contains(SystemRequestRepository.m_gE((Object)"n\u0015"))) {
            f_Dh.warn(SmsRequest.m_DD((Object)"98\u0013q\u0010=\n!C0\u0017%\u0006<\u0013%C5\u0006%\u00062\u00174\u0007q\n?C4\r%\u0011(C?\u0002<\u0006kCv\u0018,D"), a);
            throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u000e $i1' ;-i7&:=5 ::t :?5%=-t95=<i',%<1'7,t=<( i7&!%0i8,5-t=;i0 &,7=;;-i ;5?1;'(8g"));
        }
        Object object = ((String)a).replace((char)(0x5F & 0x7C), (char)(0x3F & 0x6F));
        if (((String)object).contains(SmsRequest.m_DD((Object)"M\u007fL")) || ((String)object).contains(SystemRequestRepository.m_gE((Object)"fzg")) || ((String)object).equals(SmsRequest.m_DD((Object)"\u007fM"))) {
            f_Dh.warn(SystemRequestRepository.m_gE((Object)"\u000e $i'%=9t( =1$$=t-1=1* ,0i='t';;9(8 .,0i1' ;-i:(9,nis2)n"), object);
            throw new FileStorageException(SmsRequest.m_DD((Object)"98\u0013q\u0006?\u0017#\u001aq\u0000>\r%\u00028\r\"C5\n#\u00062\u0017>\u0011(C%\u00110\u00154\u0011\"\u0002=C\"\u0006 \u00164\r2\u0006\"M"));
        }
        Object object2 = object;
        int n = ((String)object2).lastIndexOf(0x2F & 0x7F);
        if (n >= 0) {
            object2 = ((String)object).substring(n + --1);
        }
        if (((String)object2).isEmpty() || ((String)object2).equals(SystemRequestRepository.m_gE((Object)"g")) || ((String)object2).equals(SmsRequest.m_DD((Object)"\u007fM"))) {
            throw new FileStorageException("Invalid filename extracted from zip entry: " + (String)a);
        }
        if (((String)(object2 = StringUtils.cleanPath((String)object2))).contains(SystemRequestRepository.m_gE((Object)"zg"))) {
            throw new FileStorageException(SmsRequest.m_DD((Object)"\u0017\n=\u0006?\u0002<\u0006q\u0000>\r%\u00028\r\"C8\r'\u0002=\n5C!\u0002%\u000bq\u00104\u0012$\u0006?\u00004CvM\u007fDq\u00027\u00174\u0011q\u0000=\u00060\r8\r6M"));
        }
        String string = a = StringUtils.hasText((String)a3222.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a3222.getTargetSubdirectory()) : f_Bj;
        if (((String)a).contains(SystemRequestRepository.m_gE((Object)"zg"))) {
            throw new FileStorageException(SmsRequest.m_DD((Object)"\u0005\u0002#\u00044\u0017q\u0010$\u00015\n#\u00062\u0017>\u0011(C2\f?\u00170\n?\u0010q\n?\u00150\u000f8\u0007q\u00130\u00179C\"\u0006 \u00164\r2\u0006qD\u007fMvM"));
        }
        Space a3222 = Objects.requireNonNull(SpaceContext.getActiveSpace(), SystemRequestRepository.m_gE((Object)"\u0015*  \",t:$(7,t 'i&,%<=;1-t=;i!98&5-t(t/=%1g"));
        String[] stringArray = new String[--1];
        stringArray[5 >> 3] = a3222.getName();
        object = Path.of(c_Ic2.f_gj, stringArray).toAbsolutePath().normalize();
        Path path = object.resolve((String)a).normalize();
        if (!path.startsWith((Path)object)) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[4 ^ 5] = object;
            objectArray[1 ^ 3] = a3222.getName();
            f_Dh.warn(SmsRequest.m_DD((Object)"\u0001\u0002%\u000bq\u0017#\u0002'\u0006#\u00100\u000fq\u0002%\u00174\u000e!\u0017\u007fC\u0004\u0013=\f0\u0007q\u0017>C5\u0006#\n'\u00065C5\n#\u00062\u0017>\u0011(Cv\u0018,Dq\u00114\u0010>\u000f'\u0006\"C>\u0016%\u00108\u00074C\"\u00130\u00004C#\f>\u0017qD*\u001evC7\f#C\"\u00130\u00004Cv\u0018,D"), objectArray);
            throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u0000:?5%=-t-1;=?1-t95=<i'91*=/=,0gt\b =1$$=t=;i5*7,':t&!=' 0,t-1:=.:( ,0i0 &,7=;;-g"));
        }
        a = path.resolve((String)object2).normalize();
        if (!a.startsWith(path)) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = object2;
            objectArray[--1] = path;
            objectArray[1 ^ 3] = a3222.getName();
            f_Dh.warn(SmsRequest.m_DD((Object)"\u0001\u0002%\u000bq\u0017#\u0002'\u0006#\u00100\u000fq\u0002%\u00174\u000e!\u0017q\u00158\u0002q\u00058\u000f4\r0\u000e4Mq%8\u000f4\r0\u000e4Cv\u0018,Dq\n?C5\n#\u00062\u0017>\u0011(Cv\u0018,Dq\u00114\u0010>\u000f'\u0006\"C>\u0016%\u00108\u00074C7\f#C\"\u00130\u00004Cv\u0018,D"), objectArray);
            throw new FileStorageException("Invalid file name results in path traversal: " + (String)object2);
        }
        if (!a.startsWith((Path)object)) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[5 >> 2] = object;
            objectArray[1 ^ 3] = a3222.getName();
            f_Dh.warn(SystemRequestRepository.m_gE((Object)"\u0012 :(8i',7<&  0t*<,7\"t/5 8,0gt\u001d5;3, i2 8,t95=<is2)nt 'i;< :=-1i'95*1i&&;=tn/4si2&&i'95*1is2)n"), objectArray);
            throw new FileStorageException(SmsRequest.m_DD((Object)"70\u00116\u0006%C7\n=\u0006q\u00130\u00179C#\u0006\"\f=\u00154\u0010q\f$\u0017\"\n5\u0006q\u00074\u00108\u0004?\u0002%\u00065C\"\u00130\u00004C5\n#\u00062\u0017>\u0011(M"));
        }
        String a3222 = object.relativize((Path)a).toString().replace(SystemRequestRepository.m_gE((Object)"\u0015"), SmsRequest.m_DD((Object)"L"));
        if (c_Ic2.f_oI.existsByRelativePath(a3222)) {
            f_Dh.info("A file already exists at path: " + a3222);
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            a22 = ((ZipFile)((Object)a22)).getInputStream(zipEntry);
            try {
                CopyOption[] copyOptionArray = new CopyOption[1];
                copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                Files.copy(a22, (Path)a, copyOptionArray);
                f_Dh.info(SystemRequestRepository.m_gE((Object)"\u0012 8,tn/4si'<7*1:'/!%80t>&  =1't=;i2 8,'0'=1$t( is2)n"), object2, a);
                if (a22 == null) return;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a22 != null) {
                    try {
                        a22.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a3222) {
                        throwable.addSuppressed(a3222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
            a22.close();
            return;
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not store file " + (String)object2 + ". Please try again!", (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public Optional<FileInfo> m_XN(String string) {
        Object a = string;
        c_Ic a2 = this;
        return a2.f_oI.findById(a);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE')")
    public FileInfo m_dO(MultipartFile multipartFile, FileInfo fileInfo) {
        String string;
        c_Ic c_Ic2;
        String string2;
        void a22;
        c_Ic a = fileInfo;
        c_Ic a3 = this;
        void v0 = a22;
        Objects.requireNonNull(a, SystemRequestRepository.m_gE((Object)"\u000f=%1\u0000:/;i;+>,7=t*5':& i6,t'!%8g"));
        Objects.requireNonNull(v0, SmsRequest.m_DD((Object)".$\u000f%\n!\u0002#\u0017\u0017\n=\u0006q\u00000\r?\f%C3\u0006q\r$\u000f=M"));
        if (v0.isEmpty()) {
            throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\n5':& i'=;;1i5't,99 0t/=%1g"));
        }
        String string3 = StringUtils.cleanPath((String)Objects.requireNonNull(a22.getOriginalFilename(), SmsRequest.m_DD((Object)".$\u000f%\n!\u0002#\u0017\u0017\n=\u0006q\f#\n6\n?\u0002=C7\n=\u0006?\u0002<\u0006q\u00000\r?\f%C3\u0006q\r$\u000f=M")));
        String string4 = string2 = StringUtils.hasText((String)a.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a.getTargetSubdirectory()) : f_Bj;
        if (string3.contains(SystemRequestRepository.m_gE((Object)"zg")) || string2.contains(SmsRequest.m_DD((Object)"\u007fM"))) {
            throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u001d'\"(8 0i2 8,t95=<i'91*=/=,0g"));
        }
        Space space = Objects.requireNonNull(SpaceContext.getActiveSpace(), SmsRequest.m_DD((Object)"\u0010\u0000%\n'\u0006q\u0010!\u00022\u0006q\n\"C#\u0006 \u00168\u00114\u0007q\u0017>C$\u0013=\f0\u0007q\u0002q\u00058\u000f4M"));
        String[] stringArray = new String[4 ^ 5];
        stringArray[2 & 5] = space.getName();
        Path path = Path.of(a3.f_gj, stringArray).toAbsolutePath().normalize();
        Path path2 = path.resolve(string2).normalize();
        if (!path2.startsWith(path)) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = string2;
            objectArray[2 ^ 3] = path;
            objectArray[5 >> 1] = space.getName();
            f_Dh.warn(SystemRequestRepository.m_gE((Object)"\u0004( !t=&(\",&:5%t( =1$$=zi\u000198&5-t=;i0,& \",0i0 &,7=;;-is2)nt;1:;%\",'i;< :=-1i'95*1i&&;=tn/4si2&&i'95*1is2)n"), objectArray);
            throw new FileStorageException(SmsRequest.m_DD((Object)"*?\u00150\u000f8\u0007q\u00078\u00114\u0000%\f#\u001aq\u00130\u00179C\"\u00134\u00008\u00058\u00065M"));
        }
        Path path3 = path2.resolve(string3).normalize();
        if (!path3.startsWith(path2)) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = string3;
            objectArray[3 >> 1] = path2;
            objectArray[5 >> 1] = space.getName();
            f_Dh.warn(SystemRequestRepository.m_gE((Object)"\u0004( !t=&(\",&:5%t( =1$$=t?=(t/=%1'5$1gt\u000f=%1'5$1is2)nt :i0 &,7=;;-is2)nt;1:;%\",'i;< :=-1i2&&i'95*1is2)n"), objectArray);
            throw new FileStorageException(SmsRequest.m_DD((Object)"*?\u00150\u000f8\u0007q\u00058\u000f4\r0\u000e4C\"\u00134\u00008\u00058\u00065M"));
        }
        String string5 = path.relativize(path3).toString().replace(SystemRequestRepository.m_gE((Object)"\u0015"), SmsRequest.m_DD((Object)"L"));
        if (a3.f_oI.existsByRelativePath(string5)) {
            throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u0015i2 8,t>==<i !=:t'5$1i5%&,5--i11=: :t :i !1i (&.1=t%;*5==&:g"));
        }
        try {
            Files.createDirectories(path2, new FileAttribute[2 & 5]);
            CopyOption[] copyOptionArray = new CopyOption[3 & 5];
            copyOptionArray[3 & 4] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy(a22.getInputStream(), path3, copyOptionArray);
            f_Dh.info(SmsRequest.m_DD((Object)"\u0017\n=\u0006qD*\u001evC\"\u00162\u00004\u0010\"\u0005$\u000f=\u001aq\u0014#\n%\u00174\rq\u0017>C7\n=\u0006\"\u001a\"\u00174\u000eq\u0002%Cv\u0018,D"), (Object)string3, (Object)path3);
            c_Ic c_Ic3 = a;
            a.setFileName(string3);
            c_Ic3.setRelativePath(string5);
            c_Ic3.setFileSize(Long.valueOf(a22.getSize()));
            c_Ic2 = a;
            string = StringUtils.hasText((String)a22.getContentType()) ? a22.getContentType() : SystemRequestRepository.m_gE((Object)"59$%=*5==&:f;* , d'=&,5$");
        }
        catch (IOException a22) {
            f_Dh.error(SmsRequest.m_DD((Object)"\u0012\f$\u000f5C?\f%C\"\u0017>\u00114C7\n=\u0006qD*\u001evC5\u00164C%\fq*\u001e&)\u00004\u0013%\n>\r"), (Object)string3, (Object)a22);
            throw new FileStorageException(SystemRequestRepository.m_gE((Object)"\u0017&!%0i:& i'=;;1i !1i!98&5-1-t/=%1gt\u00198,5:1i ;-i5.5 :g"));
        }
        {
            c_Ic2.setFileType(string);
            a.setTargetSubdirectory(string2);
            return (FileInfo)a3.f_oI.save((Object)a);
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public void m_JO(Collection<FileInfo> collection) {
        Iterator a;
        c_Ic c_Ic2 = this;
        Object object = a.stream().map(BaseModel::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Object object2 = a.stream().map(FileInfo::getName).filter(c_Bd::m_Jf).collect(Collectors.toSet());
        object = c_Ic2.f_oI.findByIdInOrNameIn(object, object2);
        object2 = object.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(FileInfo::getName, Function.identity()));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        a = a.iterator();
        while (a.hasNext()) {
            FileInfo fileInfo;
            c_Ic a2 = (FileInfo)a.next();
            Object object3 = a2.getId() != null ? (FileInfo)object2.get(a2.getId()) : (fileInfo = c_Bd.m_Jf((String)a2.getName()) ? (FileInfo)object.get(a2.getName()) : null);
            if (fileInfo != null) {
                c_Ic2.f_XH.copyForUpdate((Object)a2, (SpaceBaseModel)fileInfo, new String[3 & 4]);
                arrayList.add(fileInfo);
                continue;
            }
            arrayList.add(a2);
        }
        c_Ic2.f_oI.bulkSave(arrayList);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_Rn(String string) {
        Object a = string;
        c_Ic a2 = this;
        return a2.f_oI.findOneByName((String)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileDownloadResult m_Wo(String string) {
        Path path;
        block3: {
            c_Ic a;
            Object a2 = string;
            c_Ic c_Ic2 = a = this;
            a2 = c_Ic2.m_BN((String)a2);
            String[] stringArray = new String[--1];
            stringArray[3 & 4] = a2.getSpace().getName();
            path = Path.of(c_Ic2.f_gj, stringArray).resolve(a2.getRelativePath()).normalize();
            try {
                UrlResource urlResource = new UrlResource(path.toUri());
                if (!urlResource.exists() || !urlResource.isReadable()) break block3;
                return new FileDownloadResult((Resource)urlResource, (FileInfo)a2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new NotFoundException(SmsRequest.m_DD((Object)"%8\u000f4C?\f%C7\f$\r5Cy\u000e0\u000f7\f#\u000e4\u0007q6\u0003/xM"));
            }
        }
        f_Dh.error(SmsRequest.m_DD((Object)"\u0017\n=\u0006q\u000e4\u00170\u00070\u00170C4\u001b8\u0010%\u0010q\u0005>\u0011qD*\u001evC3\u0016%C7\n=\u0006q\n\"C<\n\"\u00108\r6C>\rq\u00078\u0010:M"), (Object)path);
        throw new NotFoundException(SystemRequestRepository.m_gE((Object)"\u0012 8,t';=t/;<:-"));
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_ro(String string) {
        Object a = string;
        c_Ic a2 = this;
        return (FileInfo)a2.m_XN((String)a).orElseThrow(() -> c_Ic.m_OO((String)a));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DELETE_FILE')")
    @Transactional
    public void m_xm(String string) {
        Path path;
        FileInfo fileInfo;
        void a;
        Object object;
        block5: {
            object = this;
            fileInfo = object.m_XN((String)a).orElse(null);
            if (fileInfo == null) {
                return;
            }
            String[] stringArray = new String[2 ^ 3];
            stringArray[5 >> 3] = fileInfo.getSpace().getName();
            Path path2 = Path.of(object.f_gj, stringArray);
            path = path2.resolve(fileInfo.getRelativePath()).normalize();
            if (!Files.exists(path, new LinkOption[5 >> 3])) break block5;
            Object a2 = fileInfo.getFileName();
            String string2 = LocalDateTime.now().format(DateTimeFormatter.ofPattern(SmsRequest.m_DD((Object)"\u001a(\u001a(.\u001c\u00075<\u0019+<\u000e\"\u0010")));
            Object object2 = a2;
            String string3 = "";
            int n = ((String)object2).lastIndexOf(0x2F & 0x7E);
            if (n > 0) {
                Object object3 = a2;
                object2 = ((String)object3).substring(3 ^ 3, n);
                string3 = ((String)object3).substring(n);
            }
            a2 = (String)object2 + "_deleted_" + string2 + string3;
            Path path3 = path;
            a2 = path3.getParent().resolve((String)a2);
            Files.move(path3, (Path)a2, new CopyOption[3 ^ 3]);
            f_Dh.info(SystemRequestRepository.m_gE((Object)"\u000f=%1i&,:(9,0i2;;$tn/4si &tn/4si2&&i0,8, ,"), (Object)path, a2);
        }
        try {
            f_Dh.warn(SmsRequest.m_DD((Object)"\u0001\u000b(\u00108\u00000\u000fq\u00058\u000f4C?\f%C7\f$\r5C7\f#C5\u0006=\u0006%\u0006kC*\u001e"), (Object)path);
        }
        catch (IOException iOException) {
            f_Dh.error(SystemRequestRepository.m_gE((Object)"\u0017&!%0i:& i&,:(9,t/=%1i2&&i0,8, ,ni/4"), (Object)fileInfo.getFileName(), (Object)iOException);
        }
        object.f_oI.delete((Object)fileInfo);
        f_Dh.info(SmsRequest.m_DD((Object)"\u0017\n=\u0006q\u00074\u000f4\u00174\u0007q\u0005>\u0011q*\u0015Yq\u0018,Oq,#\n6\n?\u0002=C\u001f\u0002<\u0006kC*\u001e"), (Object)a, (Object)fileInfo.getFileName());
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_FILE') and hasAuthority('UPDATE_LOGIN_SETTINGS')")
    public void m_sM(String string) {
        void a;
        c_Ic c_Ic2 = this;
        if (!StringUtils.hasText((String)a)) {
            f_Dh.warn(SmsRequest.m_DD((Object)"5\u0006=\u0006%\u0006\u001d\f6\n?*<\u00026\u0006q\u00000\u000f=\u00065C&\n%\u000bq\u0006<\u0013%\u001aq\f#C?\u0016=\u000fq\u00058\u000f4\r0\u000e4M"));
            return;
        }
        try {
            Object a2 = StringUtils.cleanPath((String)a);
            if (a2.contains(SystemRequestRepository.m_gE((Object)"zg"))) {
                throw new FileStorageException(SmsRequest.m_DD((Object)"%8\u000f4\r0\u000e4C2\f?\u00170\n?\u0010q\n?\u00150\u000f8\u0007q\u00130\u00179C\"\u0006 \u00164\r2\u0006qD\u007fMvM"));
            }
            Path path = Path.of(c_Ic2.f_gj, new String[5 >> 3]).toAbsolutePath().normalize().resolve(f_YG).normalize();
            Path path2 = path.resolve((String)a2).normalize();
            if (!path2.startsWith(path)) {
                f_Dh.warn(SystemRequestRepository.m_gE((Object)"\u00195=<i ;5?1;'(8i5= ,99 i2&&i8&3 :i=$5.1i0,8,  ;'ni/4"), a2);
                throw new FileStorageException(SmsRequest.m_DD((Object)"\u0018\r'\u0002=\n5C=\f6\n?C8\u000e0\u00044C!\u0002%\u000bq\u0005>\u0011q\u00074\u000f4\u00178\f?M"));
            }
            Files.deleteIfExists(path2);
            f_Dh.info(SystemRequestRepository.m_gE((Object)"\u0005;.='t 9(3,tn/4si0,8, ,0i2;;$t/=%1:-: ,9i| 2i==t,, '=1-}g"), a2);
            return;
        }
        catch (IOException a2) {
            f_Dh.error(SmsRequest.m_DD((Object)"\u0014\u0011#\f#C>\u00002\u0016#\u00114\u0007q\u00149\n=\u0006q\u00074\u000f4\u00178\r6C=\f6\n?C8\u000e0\u00044C7\n=\u0006kC*\u001e"), (Object)a, (Object)a2);
            return;
        }
    }

    private static /* synthetic */ NotFoundException m_gM(String a) {
        return new NotFoundException("File info not found with relative path: " + a);
    }
}

