/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_OJ;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_L;
import com.inscada.mono.communication.base.m.c_CJ;
import com.inscada.mono.communication.base.m.c_Ij;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_Yi;
import com.inscada.mono.communication.base.services.c_ti;
import com.inscada.mono.communication.base.services.c_vG;
import com.inscada.mono.datatransfer.m.c_BC;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.r.c_TC;
import com.inscada.mono.datatransfer.r.c_cC;
import com.inscada.mono.datatransfer.services.c_EC;
import com.inscada.mono.datatransfer.services.c_uc;
import com.inscada.mono.impexp.restcontrollers.ImportExportController;
import com.inscada.mono.job.m.c_VB;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.log.r.c_bC;
import com.inscada.mono.project.r.c_i;
import com.inscada.mono.search.model.SearchFilter;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener,
c_i {
    private final c_OJ f_Ji;
    private final c_L f_ii;
    private static final Logger f_CH = LoggerFactory.getLogger(DataTransferManager.class);
    private final c_VB f_zi;
    public static final short f_gG = 407;
    public static final short f_gh = 403;
    private final c_bC f_oH;
    public static final short f_kh = 401;
    public static final short f_Ah = 406;
    private static final String f_GH = "scheduledDataTransfers";
    private final Lock f_Ih;
    private final c_vG f_jh;
    private final JedisPooled f_ki;
    private final c_Yi f_zG;
    public static final short f_RH = 404;
    public static final short f_iI = 402;
    private final c_ti f_DH;
    public static final short f_yH = 405;
    private final Map<String, Job> f_Li;
    private final c_uc f_Yi;

    protected Map<String, c_BC> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_Yi.m_pM((String)a2));
    }

    @TransactionalEventListener(value={c_TC.class})
    public void handleRescheduleEvent(c_TC c_TC2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_ii.m_Ga()) {
            DataTransferManager a = a.m_pP();
            f_CH.info(ImportExportController.m_fB((Object)"83521$NV<\u0017\u001a\u0012\u0018\u001f\u001a\u0011T$\u0011\u0005\u0017\u001e\u0011\u0012\u0001\u001a\u00113\u0002\u0013\u001a\u0002T\u0010\u001b\u0004T\u0012\u0015\u0002\u0015V\u0000\u0004\u0015\u0018\u0007\u0010\u0011\u0004NV\u000f\u000bT^=2NV\u000f\u000b]"), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_BC.f_LG) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_CH.debug(SearchFilter.m_lD((Object)"^\u0006^d\\\fQ\rU\u001b*iY.~&b ~.0\u001bu:s!u-e%u\ff,~=0/\u007f;0-q=qid;q'c/u;*ik4"), (Object)a.m_pP().getId());
        }
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = a.getSourceVariableId();
        objectArray[3 >> 1] = a.getRangeType();
        objectArray[1 ^ 3] = a.getCalcType();
        return SearchFilter.m_lD((Object)"t(d(==b(~:v,bs|(c==*q%sdd },*?q;y(r%us5:*lcs5:").formatted(objectArray);
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Ih.lock();
        try {
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a.getName();
            PeriodicJob periodicJob = a2.f_zi.m_lN(a.getProject(), SearchFilter.m_lD((Object)"5:0\rq=qiD;q'c/u;").formatted(objectArray), () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_Li.put(a.getId(), periodicJob);
            String[] stringArray = new String[5 >> 2];
            stringArray[3 ^ 3] = a.getId();
            dataTransferManager.f_ki.sadd(f_GH, stringArray);
            return;
        }
        finally {
            a2.f_Ih.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_Ij c_Ij2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0x2F & 0x5D, 5 >> 3);
        ((Calendar)object).set(0x6E & 0x1F, 3 & 4);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_EC.f_OH[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x6C & 0x1F, 3 ^ 3);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0x7B & 0xF, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0x1F & 0x6B, 0xFFFFFFFF & 0xFFFFFFFE);
                ((Calendar)object3).set(0x6D & 0x1E, 5 >> 3);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0x6B & 0x1F, 5 >> 3);
                ((Calendar)object4).set(0x2F & 0x5C, 2 & 5);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 5 >> 3);
                ((Calendar)object5).set(0x6D & 0x1E, 3 ^ 3);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 3 ^ 3);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(1 ^ 3, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(ImportExportController.m_fB((Object)"!\u0018\u0011\u000e\u0004\u0013\u0017\u0002\u0011\u0012T\u0004\u0015\u0018\u0013\u0013T\u0002\r\u0006\u0011"));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return 3 >> 1;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_CJ c_CJ2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_EC.f_FI[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_ii.m_Ga()) {
            f_CH.debug(ImportExportController.m_fB((Object)"83521$NV7\u0017\u001a\u0015\u0011\u001a\u0018\u001f\u001a\u0011T\u0017\u0018\u001aT\u0012\u0015\u0002\u0015V\u0000\u0004\u0015\u0018\u0007\u0010\u0011\u0004\u0007V\u0012\u0019\u0006V\u0004\u0004\u001b\u001c\u0011\u0015\u0000V\u000f\u000bT\u001a\u001b\u0015\u0015\u001a\u0018\u000fZ"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_CH.debug(SearchFilter.m_lD((Object)"^\u0006^d\\\fQ\rU\u001b*iB,a<u:d ~.0%u(t,bid&0*q's,|iq%|it(d(0=b(~:v,b:0/\u007f;09b&z,s=02mg"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_ii.m_t(Short.valueOf((short)(0x9DF & 0x77B5)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_ii.m_Ga()) {
            f_CH.debug(ImportExportController.m_fB((Object)":1703&LT5\u0015\u0018\u0017\u0013\u0018\u001a\u001d\u0018\u0013V\u0010\u0017\u0000\u0017T\u0002\u0006\u0017\u001a\u0005\u0012\u0013\u0006V\u000f\u000bT\u001a\u001b\u0015\u0015\u001a\u0018\u000fZ"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_CH.debug(SearchFilter.m_lD((Object)"\u0007_\u0007=\u0005U\bT\fBs0\u001bu8e,c=y'wi|,q-u;0=\u007fis(~*u%0-q=qid;q'c/u;02mg"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 & 4] = a;
            a2.f_ii.m_t(Short.valueOf((short)(0x7BF7 & 0x59A)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[5 >> 2] = a2.getName();
            objectArray[--2] = a2.getId();
            f_CH.info(ImportExportController.m_fB((Object)"0\u0017\u0000\u0017 \u0004\u0015\u0018\u0007\u0010\u0011\u00049\u0017\u001a\u0017\u0013\u0013\u0006V\\:\u0011\u0017\u0010\u0013\u0006V\u000f\u000b]LT$\u0011\u0005\u0000\u0019\u0006\u001f\u001a\u0011T\u0012\u0015\u0002\u0015V\u0000\u0004\u0015\u0018\u0007\u0010\u0011\u0004NV\u000f\u000bT^=2NV\u000f\u000b]"), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_oH.m_xL(a2.getProject()).m_v("Data Transfer Restore (Leader " + (String)a + ")", SearchFilter.m_lD((Object)"5:0aY\r*i5:9iv(y%u-0=\u007fib,c=\u007f;ug0\nq<c,*i5:").formatted(objectArray));
            try {
                f_CH.warn(ImportExportController.m_fB((Object)"0\u0017\u0000\u0017 \u0004\u0015\u0018\u0007\u0010\u0011\u00049\u0017\u001a\u0017\u0013\u0013\u0006V\\:\u0011\u0017\u0010\u0013\u0006V\u000f\u000b]LT7\u0000\u0002\u0011\u001b\u0004\u0002\u001d\u0018\u0013V\u0000\u0019T\u0015\u0015\u0018\u0017\u0013\u0018V\u0010\u0017\u0000\u0017T\u0002\u0006\u0017\u001a\u0005\u0012\u0013\u0006V\u000f\u000bT\u0017\u0012\u0002\u0011\u0004T\u0004\u0011\u0005\u0000\u0019\u0006\u0017\u0000\u001f\u001b\u0018T\u0010\u0015\u001f\u0018\u0003\u0006\u0013Z"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[5 >> 3] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_CH.error(SearchFilter.m_lD((Object)"T(d(D;q'c/u;](~(w,bi8\u0005u(t,bik49s0\u000fq |,tid&0*q's,|it(d(0=b(~:v,bik40(v=u;0;u:d&b(d \u007f'0/q |<b,*ik4"), objectArray2);
                return;
            }
        }
    }

    protected Map<String, c_BC> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_Yi.m_Qo((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Ji.m_Zea(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_ii.m_La();
        f_CH.info(ImportExportController.m_fB((Object)"0\u0017\u0000\u0017 \u0004\u0015\u0018\u0007\u0010\u0011\u00049\u0017\u001a\u0017\u0013\u0013\u0006LT\"\u001c\u001f\u0007V\u001a\u0019\u0010\u0013T^\u000f\u000b]V\u001d\u0005T8;V89:11$T\"<3T:1703&XT5\u0015\u0018\u0017\u0013\u0018\u001a\u001d\u0018\u0013V\u0015\u001a\u0018V\u0018\u0019\u0017\u0017\u0018V\u0010\u0017\u0000\u0017T\u0002\u0006\u0017\u001a\u0005\u0012\u0013\u0006V\u001e\u0019\u0016\u0005ZXZ"), a);
        dataTransferManager2.f_Ih.lock();
        try {
            new ArrayList(dataTransferManager.f_Li.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_Li.clear();
            f_CH.info(SearchFilter.m_lD((Object)"T(d(D;q'c/u;](~(w,bi8\u0007\u007f=0\u0005u(t,bik49s0\b|%0%\u007f*q%0-q=qid;q'c/u;0#\u007f+cix(f,0+u,~ib,a<u:d,tid&0*q's,|iq'tis%u(b,tiv;\u007f$0%\u007f*q%0=b(s\"y'wg"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_CH.error(ImportExportController.m_fB((Object)"2\u0015\u0002\u0015\"\u0006\u0017\u001a\u0005\u0012\u0013\u0006;\u0015\u0018\u0015\u0011\u0011\u0004T^:\u0019\u0000V8\u0013\u0015\u0012\u0011\u0004T\r\t_NV1\u0004\u0006\u0019\u0006V\u0010\u0003\u0006\u001f\u001a\u0011T\u0006\u0006\u0019\u0017\u0013\u0007\u0005T\u0019\u0012V\u0017\u0017\u001a\u0015\u0011\u001a\u0018\u001f\u001a\u0011T\u001a\u001b\u0015\u0015\u001aT\u0012\u0015\u0002\u0015V\u0000\u0004\u0015\u0018\u0007\u0010\u0011\u0004T\u001c\u001b\u0014\u0007LT\r\t"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_Ih.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_ii.m_Ga()) {
            f_CH.debug(ImportExportController.m_fB((Object)":1703&LT%\u0017\u001e\u0011\u0012\u0001\u001a\u001d\u0018\u0013V\u0010\u0017\u0000\u0017T\u0002\u0006\u0017\u001a\u0005\u0012\u0013\u0006V\u000f\u000bT\u001a\u001b\u0015\u0015\u001a\u0018\u000fZ"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_CH.debug(SearchFilter.m_lD((Object)"\u0007_\u0007=\u0005U\bT\fBs0\u001bu8e,c=y'wi|,q-u;0=\u007fic*x,t<|,0-q=qid;q'c/u;02mg"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_ii.m_t(Short.valueOf((short)(0x3F9 & 0x7D97)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(SearchFilter.m_lD((Object)"?q%e,"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_BC> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_ii.m_Ga()) {
            f_CH.debug(SearchFilter.m_lD((Object)"\u0005U\bT\fBs0\u000eu=d ~.0-q=qid;q'c/u;0:d(d<c,civ&bik40\u0000T:0%\u007f*q%|0*ik4"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_CH.debug(ImportExportController.m_fB((Object)":9:[83521$NV&\u0013\u0005\u0003\u0011\u0005\u0000\u001f\u001a\u0011T\u001a\u0011\u0017\u0010\u0013\u0006V\u0012\u0019\u0006V\u0010\u0017\u0000\u0017T\u0002\u0006\u0017\u001a\u0005\u0012\u0013\u0006V\u0007\u0002\u0015\u0002\u0001\u0005\u0011\u0005T\u0010\u001b\u0004T\r\tV=2\u0007LT\r\t"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = new ArrayList(a);
            return (Map)a2.f_ii.m_t(Short.valueOf((short)(0x3BFE & 0x4597)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(SearchFilter.m_lD((Object)"e"))), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_CJ[] c_CJArray = (c_CJ[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_CJ[]::new);
        a4 = a7.f_jh.m_Zba(stringArray, (Date)a5, (Date)((Object)a4), c_CJArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_ii.m_La();
        f_CH.info(SearchFilter.m_lD((Object)"T(d(D;q'c/u;](~(w,bs0\u001dx ci~&t,0ak49ix(cir,s&},0=x,0\u0005U\bT\fBg0\u001bu:d&b ~.0:s!u-e%u-0-q=qid;q'c/u;cg>g"), a);
        dataTransferManager2.f_Ih.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_ki.smembers(f_GH));
            if (hashSet.isEmpty()) {
                f_CH.info(ImportExportController.m_fB((Object)"0\u0017\u0000\u0017 \u0004\u0015\u0018\u0007\u0010\u0011\u00049\u0017\u001a\u0017\u0013\u0013\u0006V\\:\u0011\u0017\u0010\u0013\u0006V\u000f\u000b]LT8\u001bV\u0007\u0015\u001c\u0013\u0010\u0003\u0018\u0013\u0010V\u0010\u0017\u0000\u0017T\u0002\u0006\u0017\u001a\u0005\u0012\u0013\u0006\u0005T\u0010\u001b\u0003\u001a\u0012T\u001f\u001aV&\u0013\u0010\u001f\u0007V\u0000\u0019T\u0004\u0011\u0005\u0000\u0019\u0006\u0013Z"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[2 ^ 3] = hashSet.size();
            objectArray[--2] = hashSet;
            f_CH.info(SearchFilter.m_lD((Object)"\rq=q\u001db(~:v,b\u0004q'q.u;0a\\,q-u;02m`*iV&e'tik40:s!u-e%u-0-q=qid;q'c/u;0\u0000T:0 ~iB,t cid&0;u:d&b,*ik4"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[3 >> 1];
            stringArray[3 & 4] = ImportExportController.m_fB((Object)" =3#)07 7+\"&7:%23&");
            dataTransferManager.f_Ji.m_HEa(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_Yi.m_pN((Set)a2));
            }, stringArray);
            f_CH.info(SearchFilter.m_lD((Object)"\rq=q\u001db(~:v,b\u0004q'q.u;0a\\,q-u;02m`*iQ=d,}9d ~.0=\u007fib,c=\u007f;uik40-q=qid;q'c/u;cg"), a, (Object)arrayList.size());
            arrayList.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_ii.m_La();
                String[] stringArray = new String[--2];
                stringArray[2 & 5] = ImportExportController.m_fB((Object)"%7>12!:1)07 7+\"&7:%23&");
                stringArray[--1] = SearchFilter.m_lD((Object)"S\b^\nU\u0005O\rQ\u001dQ\u0016D\u001bQ\u0007C\u000fU\u001b");
                dataTransferManager2.f_Ji.m_OEa(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_CH.info(ImportExportController.m_fB((Object)"2\u0015\u0002\u0015\"\u0006\u0017\u001a\u0005\u0012\u0013\u0006;\u0015\u0018\u0015\u0011\u0011\u0004T^8\u0013\u0015\u0012\u0011\u0004T\r\t_NV2\u001f\u001a\u001f\u0007\u001e\u0011\u0012T\u0012\u0015\u0002\u0015V\u0000\u0004\u0015\u0018\u0007\u0010\u0011\u0004T\u0004\u0011\u0005\u0000\u0019\u0006\u0017\u0000\u001f\u001b\u0018T\u0006\u0006\u0019\u0017\u0013\u0007\u0005Z"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_CH.error(SearchFilter.m_lD((Object)"\rq=q\u001db(~:v,b\u0004q'q.u;0a\\,q-u;02m`*iU;b&bit<b ~.0-q=qid;q'c/u;0;u:d&b(d \u007f'09b&s,c:*ik4"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_Ih.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_Ij c_Ij2) {
        DataTransferManager a = c_Ij2;
        DataTransferManager a2 = this;
        switch (c_EC.f_OH[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_zG.m_NBa(a.getProjectId(), (Map)a2);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[5 >> 2];
            classArray[3 & 4] = String.class;
            dataTransferManager.f_ii.m_Ka((short)(0x9B3 & 0x77DD), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(SearchFilter.m_lD((Object)"c*x,t<|,T(d(D;q'c/u;Y'd,b'q%"), classArray));
            Class[] classArray2 = new Class[5 >> 2];
            classArray2[2 & 5] = String.class;
            dataTransferManager.f_ii.m_Ka((short)(0x35F7 & 0x4B9A), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ImportExportController.m_fB((Object)"\u0015\u0015\u0018\u0017\u0013\u00182\u0015\u0002\u0015\"\u0006\u0017\u001a\u0005\u0012\u0013\u0006?\u001a\u0002\u0011\u0004\u001a\u0017\u0018"), classArray2));
            Class[] classArray3 = new Class[3 & 5];
            classArray3[3 ^ 3] = String.class;
            dataTransferManager.f_ii.m_Ka((short)(0x49F7 & 0x379B), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(SearchFilter.m_lD((Object)".u=T(d(D;q'c/u;C=q=e:Y'd,b'q%"), classArray3));
            Class[] classArray4 = new Class[4 ^ 5];
            classArray4[3 ^ 3] = String.class;
            dataTransferManager.f_ii.m_Ka((short)(0x1D9C & 0x63F7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ImportExportController.m_fB((Object)"\u0005\u0017\u001e\u0011\u0012\u0001\u001a\u00112\u0015\u0002\u0015\"\u0006\u0017\u001a\u0005\u0012\u0013\u0006\u00056\u000f$\u0004\u001b\u001c\u0011\u0015\u0000?\u0010?\u001a\u0002\u0011\u0004\u001a\u0017\u0018"), classArray4));
            Class[] classArray5 = new Class[5 >> 2];
            classArray5[3 >> 2] = String.class;
            dataTransferManager.f_ii.m_Ka((short)(0x3BD7 & 0x45BD), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(SearchFilter.m_lD((Object)"s(~*u%T(d(D;q'c/u;c\u000bi\u0019b&z,s=Y-Y'd,b'q%"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_ii.m_Ka((short)(0x2BBE & 0x55D7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ImportExportController.m_fB((Object)"\u0011\u0011\u00020\u0017\u0000\u0017 \u0004\u0015\u0018\u0007\u0010\u0011\u0004'\u0002\u0015\u0002\u0001\u0005\u0011\u00056\u000f=\u0012\u0007?\u001a\u0002\u0011\u0004\u001a\u0017\u0018"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_ii.m_Ka((short)(0x29BF & 0x57D7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(SearchFilter.m_lD((Object)"w,d\rq=q\u001db(~:v,b\u001ad(d<c,c\u000bi\u0019b&z,s=Y-Y'd,b'q%"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(ImportExportController.m_fB((Object)"0\u0015\u001f\u0018\u0013\u0010V\u0000\u0019T\u0004\u0011\u0011\u001d\u0005\u0000\u0013\u0006V0\u0017\u0000\u0017 \u0004\u0015\u0018\u0007\u0010\u0011\u00049\u0017\u001a\u0017\u0013\u0013\u0006V&&7V\u0019\u0013\u0000\u001e\u001b\u0012\u0007"), a);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_ki.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return (3 & 4) != 0;
        }
        return true;
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_Yi.m_qM((String)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_BC getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_ii.m_Ga()) {
            f_CH.debug(SearchFilter.m_lD((Object)"\\\fQ\rU\u001b*iW,d=y'wit(d(0=b(~:v,bic=q=e:0/\u007f;0\u0000Ts02mi|&s(|%ig"), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_CH.debug(ImportExportController.m_fB((Object)"8;8Y:1703&LT$\u0011\u0007\u0001\u0013\u0007\u0002\u001d\u0018\u0013V\u0018\u0013\u0015\u0012\u0011\u0004T\u0010\u001b\u0004T\u0012\u0015\u0002\u0015V\u0000\u0004\u0015\u0018\u0007\u0010\u0011\u0004T\u0005\u0000\u0017\u0000\u0003\u0007V\u0012\u0019\u0006V=2NV\u000f\u000bZ"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[5 >> 3] = a;
            return (c_BC)a2.f_ii.m_t(Short.valueOf((short)(0x5B9B & 0x25F7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_ii.m_Ga()) {
            f_CH.info(ImportExportController.m_fB((Object)":1703&LT>\u0015\u0018\u0010\u001a\u001d\u0018\u0013V$\u0004\u001b\u001c\u0011\u0015\u00002\u0011\u0017\u0017\u0002\u001d\u0000\u0015\u0002\u00113\u0002\u0013\u001a\u0002T\u0010\u001b\u0004T\u0006\u0006\u0019\u001e\u0013\u0017\u0002T?0LT\r\t"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_CH.debug(SearchFilter.m_lD((Object)"^\u0006^d\\\fQ\rU\u001b*iY.~&b ~.0\u0019b&z,s=T,q*d f(d,U?u'div&bi`;\u007f#u*diY\r*ik4"), a);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_ii.m_Ga()) {
            f_CH.debug(ImportExportController.m_fB((Object)"83521$NV'\u0015\u001c\u0013\u0010\u0003\u0018\u001f\u001a\u0011T\u0017\u0018\u001aT\u0012\u0015\u0002\u0015V\u0000\u0004\u0015\u0018\u0007\u0010\u0011\u0004\u0007V\u0012\u0019\u0006V\u0004\u0004\u001b\u001c\u0011\u0015\u0000V\u000f\u000bT\u001a\u001b\u0015\u0015\u001a\u0018\u000fZ"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_CH.debug(SearchFilter.m_lD((Object)"^\u0006^d\\\fQ\rU\u001b*iB,a<u:d ~.0%u(t,bid&0:s!u-e%uiq%|it(d(0=b(~:v,b:0/\u007f;09b&z,s=02mg"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = a;
            a2.f_ii.m_t(Short.valueOf((short)(0x7195 & 0xFFE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return (4 ^ 5) != 0;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_ki.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return (4 ^ 5) != 0;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_EC.f_OH[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0x3B & 0x4F) != calendar.get(0x4B & 0x3F)) {
                    n2 = 4 ^ 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(0x3F & 0x46) != calendar.get(0x26 & 0x5F)) {
                    n2 = 5 >> 2;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = 2 ^ 3;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(--2) != calendar.get(--2)) {
                    n2 = 3 & 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(3 >> 1) != calendar.get(--1) ? 4 ^ 5 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[5 >> 1];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_ki.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(ImportExportController.m_fB((Object)"7\u0003\u0006\u0004\u0011\u0018\u0000"))) {
            return false;
        }
        int a222 = switch (c_EC.f_OH[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x3C & 0x7F) * (0x53EB & 0x2FFC));
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.f_ii.m_Ea((ClusterNodeListener)a);
        f_CH.info(ImportExportController.m_fB((Object)"2\u0015\u0002\u0015\"\u0006\u0017\u001a\u0005\u0012\u0013\u0006;\u0015\u0018\u0015\u0011\u0011\u0004T\u001f\u001a\u001f\u0000\u001f\u0015\u001a\u001d\f\u0011\u0012T\u0017\u001a\u0012T\u0004\u0011\u0011\u001d\u0005\u0000\u0013\u0006\u0013\u0010V\u0015\u0005T5\u0018\u0003\u0007\u0002\u0011\u0004:\u0019\u0010\u00138\u001f\u0007\u0002\u0011\u0018\u0011\u0004Z"));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_BC> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_ii.m_Ga()) {
            f_CH.debug(ImportExportController.m_fB((Object)":1703&LT1\u0011\u0002\u0000\u001f\u001a\u0011T\u0017\u0018\u001aT\u0012\u0015\u0002\u0015V\u0000\u0004\u0015\u0018\u0007\u0010\u0011\u0004T\u0005\u0000\u0017\u0000\u0003\u0007\u0013\u0007V\u0012\u0019\u0006V\u0004\u0004\u001b\u001c\u0011\u0015\u0000V\u000f\u000bT\u001a\u001b\u0015\u0015\u001a\u0018\u000fZ"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_CH.debug(SearchFilter.m_lD((Object)"^\u0006^d\\\fQ\rU\u001b*iB,a<u:d ~.0%u(t,biv&biq%|it(d(0=b(~:v,bic=q=e:u:0/\u007f;09b&z,s=02mg"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            return (Map)a2.f_ii.m_t(Short.valueOf((short)(0x45DF & 0x3BB7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    protected c_BC getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Li.containsKey(a)) {
            return c_BC.f_LG;
        }
        return c_BC.f_ng;
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_cC.class})
    public void handleCancelEvent(c_cC c_cC2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_ii.m_Ga()) {
            DataTransferManager a2 = a.m_HR();
            f_CH.info(ImportExportController.m_fB((Object)"83521$NV<\u0017\u001a\u0012\u0018\u001f\u001a\u0011T5\u0015\u0018\u0017\u0013\u00183\u0002\u0013\u001a\u0002T\u0010\u001b\u0004T\u0012\u0015\u0002\u0015V\u0000\u0004\u0015\u0018\u0007\u0010\u0011\u0004NV\u000f\u000bT^=2NV\u000f\u000b]"), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_CH.debug(SearchFilter.m_lD((Object)"^\u0006^d\\\fQ\rU\u001b*iY.~&b ~.0\nq's,|\ff,~=0/\u007f;0-q=qid;q'c/u;*ik4"), (Object)a.m_HR().getId());
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_Yi.m_Jm((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_Yi.m_Pm((String)a, (String)a3).getId());
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = a.getSourceVariableId();
        objectArray[3 & 5] = a.getRangeType();
        objectArray[1 ^ 3] = a.getCalcType();
        return ImportExportController.m_fB((Object)"\u0010\u0017\u0000\u0017Y\u0002\u0006\u0017\u001a\u0005\u0012\u0013\u0006L\u0007\u0002\u0015\u0002\u0007L\u0002\u0017\u0006\u001f\u0015\u0014\u0018\u0013NS\u0007LQ\u0005NS\u0007").formatted(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_Yi.m_Pm((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(ImportExportController.m_fB((Object)"\u0002\u0017\u0018\u0003\u0011"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_DH.m_cca((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_zG.m_IAa((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_Li.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_CH.info(ImportExportController.m_fB((Object)"2\u0015\u0002\u0015\"\u0006\u0017\u001a\u0005\u0012\u0013\u0006;\u0015\u0018\u0015\u0011\u0011\u0004T^:\u0019\u0000V8\u0013\u0015\u0012\u0011\u0004T\r\t_NV7\u0017\u001a\u0015\u0011\u001a\u0018\u001f\u001a\u0011T\u001a\u001b\u0015\u0015\u001aT\u001c\u001b\u0014T\u0010\u001b\u0004T\u0012\u0015\u0002\u0015V\u0000\u0004\u0015\u0018\u0007\u0010\u0011\u0004T?0LT\r\t"), (Object)a3, (Object)a);
                dataTransferManager.f_zi.m_zM((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 ^ 3] = a3;
                objectArray[3 >> 1] = a;
                objectArray[--2] = a22.getMessage();
                objectArray[--3] = a22;
                f_CH.error(SearchFilter.m_lD((Object)"\rq=q\u001db(~:v,b\u0004q'q.u;0a^&di\\,q-u;02m`*iU;b&bis(~*u%| ~.0%\u007f*q%0#\u007f+0/\u007f;0-q=qid;q'c/u;0\u0000Tik4*ik4"), objectArray);
            }
        }
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_Yi.m_om((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_BC getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_Yi.m_cn((String)a2, (String)a)) == null) {
            return c_BC.f_ng;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_uc c_uc2, c_ti c_ti2, c_Yi c_Yi2, c_vG c_vG2, c_VB c_VB2, JedisPooled jedisPooled, c_bC c_bC2, c_L c_L2, c_OJ c_OJ2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_OJ2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        DataTransferManager dataTransferManager7 = a10;
        DataTransferManager dataTransferManager8 = a10;
        dataTransferManager7.f_Ih = new ReentrantLock();
        dataTransferManager7.f_Li = new ConcurrentHashMap();
        dataTransferManager7.f_Yi = a9;
        dataTransferManager6.f_DH = a8;
        dataTransferManager6.f_zG = a7;
        dataTransferManager5.f_jh = a6;
        dataTransferManager5.f_zi = a5;
        dataTransferManager4.f_oH = a4;
        dataTransferManager4.f_ki = a3;
        dataTransferManager3.f_ii = a2;
        dataTransferManager3.f_Ji = a;
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Ih.lock();
        try {
            Job job = (Job)a2.f_Li.get(a.getId());
            if (job != null) {
                a2.f_zi.m_zM(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_Li.remove(a.getId());
            String[] stringArray = new String[2 ^ 3];
            stringArray[2 & 5] = a.getId();
            dataTransferManager.f_ki.srem(f_GH, stringArray);
            return;
        }
        finally {
            a2.f_Ih.unlock();
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Ji.m_Zea(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_DH.m_cca((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_zG.m_IAa(object);
        a3 = dataTransferManager2.f_zG.m_IAa((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_ki.setex(a5, (long)n, String.valueOf(d));
            a4.f_ki.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(SearchFilter.m_lD((Object)"?q%e,"), d);
                a6.put(a.getName(), a3);
            }
        }
    }
}

