/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.repositories;

import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

@EnableSpaceFilter
public interface DataTransferDetailRepository
extends BaseJpaRepository<DataTransferDetail> {
    @Query(value="select d from DataTransferDetail d left join fetch d.dataTransfer dt left join fetch d.sourceVariable svar left join fetch d.targetVariable tvar where d.dataTransferId = :dataTransferId and d.id = :detailDataTransferId")
    public Optional<DataTransferDetail> findByDataTransferIdAndId(@Param(value="dataTransferId") String var1, @Param(value="detailDataTransferId") String var2);

    @Query(value="select d from DataTransferDetail d left join fetch d.dataTransfer dt left join fetch d.sourceVariable svar left join fetch d.targetVariable tvar where d.dataTransferId = :dataTransferId and svar.name = :sourceVariableName and tvar.name = :targetVariableName")
    public Optional<DataTransferDetail> findByDataTransferIdAndVariableNames(@Param(value="dataTransferId") String var1, @Param(value="sourceVariableName") String var2, @Param(value="targetVariableName") String var3);

    @Query(value="select distinct d from DataTransferDetail d left join fetch d.dataTransfer dt left join fetch d.sourceVariable svar left join fetch d.targetVariable tvar where d.dataTransferId = :dataTransferId")
    public List<DataTransferDetail> findByDataTransferId(@Param(value="dataTransferId") String var1);

    @Query(value="select distinct d from DataTransferDetail d left join fetch d.dataTransfer dt left join fetch d.sourceVariable svar left join fetch d.targetVariable tvar where d.dataTransferId in :dataTransferIds")
    public List<DataTransferDetail> findByDataTransferIdIn(@Param(value="dataTransferIds") Iterable<String> var1);

    @Query(value="select d from DataTransferDetail d left join fetch d.dataTransfer dt left join fetch d.sourceVariable svar left join fetch d.targetVariable tvar where d.dataTransferId = :dataTransferId and svar.id = :sourceVariableId and tvar.id = :targetVariableId")
    public Optional<DataTransferDetail> findByDataTransferIdAndSourceVariableIdAndTargetVariableId(@Param(value="dataTransferId") String var1, @Param(value="sourceVariableId") String var2, @Param(value="targetVariableId") String var3);
}

