/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.opcua.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.opcua.m.c_HF;
import com.inscada.mono.communication.protocols.opcua.m.c_LE;
import com.inscada.mono.communication.protocols.opcua.m.c_gF;
import com.inscada.mono.communication.protocols.opcua.model.OpcUaDevice;
import com.inscada.mono.shared.converters.c_Gb;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="opc_ua_connection")
public class OpcUaConnection
extends Connection<OpcUaDevice> {
    @Column(name="encoding_type")
    private c_gF encodingType;
    @Column(name="server_name")
    private String serverName;
    @Column(name="is_https_enabled")
    private Boolean isHttpsEnabled;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<OpcUaDevice> devices;
    @Column(name="password")
    @Convert(converter=c_Gb.class)
    private String password;
    @NotNull
    @Column(name="security_policy")
    private c_HF securityPolicy;
    @NotNull
    @Column(name="is_anonymous_authentication")
    private Boolean isAnonymousAuthentication;
    @Min(value=100L)
    @Column(name="timeout")
    private Integer timeoutInMs;
    @Min(value=0L)
    @Max(value=65535L)
    @Column(name="https_port")
    private Integer httpsPort;
    @NotNull
    @Column(name="is_username_password_authentication")
    private Boolean isUsernamePasswordAuthentication;
    @Column(name="username")
    private String username;
    @NotNull
    @Column(name="security_mode")
    private c_LE securityMode;

    public void setUsername(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.username = a;
    }

    public String getUsername() {
        OpcUaConnection a;
        return a.username;
    }

    public String getPassword() {
        OpcUaConnection a;
        return a.password;
    }

    public void setIsUsernamePasswordAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isUsernamePasswordAuthentication = a;
    }

    public void setSecurityMode(c_LE c_LE2) {
        OpcUaConnection a = c_LE2;
        OpcUaConnection a2 = this;
        a2.securityMode = a;
    }

    public OpcUaConnection() {
        OpcUaConnection a;
        OpcUaConnection opcUaConnection = a;
        opcUaConnection.devices = new HashSet();
    }

    public void setIsAnonymousAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isAnonymousAuthentication = a;
    }

    public void setHttpsPort(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.httpsPort = a;
    }

    public c_gF getEncodingType() {
        OpcUaConnection a;
        return a.encodingType;
    }

    public c_LE getSecurityMode() {
        OpcUaConnection a;
        return a.securityMode;
    }

    public Integer getTimeoutInMs() {
        OpcUaConnection a;
        return a.timeoutInMs;
    }

    public c_HF getSecurityPolicy() {
        OpcUaConnection a;
        return a.securityPolicy;
    }

    public Integer getHttpsPort() {
        OpcUaConnection a;
        return a.httpsPort;
    }

    public void setDevices(Set<OpcUaDevice> set) {
        Object a = set;
        OpcUaConnection a2 = this;
        a2.devices = a;
    }

    public void setPassword(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.password = a;
    }

    public void setIsHttpsEnabled(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isHttpsEnabled = a;
    }

    public Set<OpcUaDevice> getDevices() {
        OpcUaConnection a;
        return a.devices;
    }

    public Boolean getIsAnonymousAuthentication() {
        OpcUaConnection a;
        return a.isAnonymousAuthentication;
    }

    public void setSecurityPolicy(c_HF c_HF2) {
        OpcUaConnection a = c_HF2;
        OpcUaConnection a2 = this;
        a2.securityPolicy = a;
    }

    public void setServerName(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.serverName = a;
    }

    public void setEncodingType(c_gF c_gF2) {
        OpcUaConnection a = c_gF2;
        OpcUaConnection a2 = this;
        a2.encodingType = a;
    }

    public void setTimeoutInMs(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.timeoutInMs = a;
    }

    public String getServerName() {
        OpcUaConnection a;
        return a.serverName;
    }

    public Boolean getIsHttpsEnabled() {
        OpcUaConnection a;
        return a.isHttpsEnabled;
    }

    public Boolean getIsUsernamePasswordAuthentication() {
        OpcUaConnection a;
        return a.isUsernamePasswordAuthentication;
    }
}

