/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.mqtt.template.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.m.c_tK;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.communication.protocols.mqtt.template.model.MqttDeviceTemplate;
import com.inscada.mono.communication.protocols.mqtt.template.model.MqttVariableTemplate;
import com.inscada.mono.expression.model.Expression;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="mqtt_frame_template")
public class MqttFrameTemplate
extends FrameTemplate<MqttDeviceTemplate, MqttVariableTemplate> {
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="publish_expression_id")
    private Expression publishExpression;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="device_id")
    protected MqttDeviceTemplate device;
    @JsonIgnore
    @OneToMany(mappedBy="frame")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<MqttVariableTemplate> variables;
    @Column(name="publish_expression_type")
    private c_tK publishExpressionType;
    @NotBlank
    private String topic;
    @Column(name="subscribe_expression_id", insertable=false, updatable=false)
    private String subscribeExpressionId;
    @NotNull
    @Min(value=0L)
    @Max(value=2L)
    private Integer qos;
    @Column(name="subscribe_expression_type")
    private c_tK subscribeExpressionType;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="subscribe_expression_id")
    private Expression subscribeExpression;
    @Size(max=4000)
    @Column(name="publish_expression")
    private String publishExpressionCode;
    @Column(name="publish_expression_id", insertable=false, updatable=false)
    private String publishExpressionId;
    @Size(max=4000)
    @Column(name="subscribe_expression")
    private String subscribeExpressionCode;

    public String getSubscribeExpressionId() {
        MqttFrameTemplate a;
        return a.subscribeExpressionId;
    }

    public MqttFrameTemplate() {
        MqttFrameTemplate a;
        MqttFrameTemplate mqttFrameTemplate = a;
        mqttFrameTemplate.variables = new HashSet();
    }

    public String getSubscribeExpressionCode() {
        MqttFrameTemplate a;
        return a.subscribeExpressionCode;
    }

    public void setPublishExpression(Expression expression) {
        MqttFrameTemplate a;
        MqttFrameTemplate a2 = expression;
        MqttFrameTemplate mqttFrameTemplate = a = this;
        mqttFrameTemplate.publishExpression = a2;
        mqttFrameTemplate.publishExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Expression getPublishExpression() {
        MqttFrameTemplate a;
        return a.publishExpression;
    }

    public void setSubscribeExpression(Expression expression) {
        MqttFrameTemplate a;
        MqttFrameTemplate a2 = expression;
        MqttFrameTemplate mqttFrameTemplate = a = this;
        mqttFrameTemplate.subscribeExpression = a2;
        mqttFrameTemplate.subscribeExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setPublishExpressionType(c_tK c_tK2) {
        MqttFrameTemplate a = c_tK2;
        MqttFrameTemplate a2 = this;
        a2.publishExpressionType = a;
    }

    public String getPublishExpressionCode() {
        MqttFrameTemplate a;
        return a.publishExpressionCode;
    }

    public Expression getSubscribeExpression() {
        MqttFrameTemplate a;
        return a.subscribeExpression;
    }

    public void setSubscribeExpressionType(c_tK c_tK2) {
        MqttFrameTemplate a = c_tK2;
        MqttFrameTemplate a2 = this;
        a2.subscribeExpressionType = a;
    }

    public Integer getQos() {
        MqttFrameTemplate a;
        return a.qos;
    }

    public void setSubscribeExpressionCode(String string) {
        Object a = string;
        MqttFrameTemplate a2 = this;
        a2.subscribeExpressionCode = a;
    }

    public String getPublishExpressionId() {
        MqttFrameTemplate a;
        return a.publishExpressionId;
    }

    public void setDevice(MqttDeviceTemplate mqttDeviceTemplate) {
        MqttFrameTemplate a;
        MqttFrameTemplate a2 = mqttDeviceTemplate;
        MqttFrameTemplate mqttFrameTemplate = a = this;
        mqttFrameTemplate.device = a2;
        mqttFrameTemplate.deviceId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setQos(Integer n) {
        Object a = n;
        MqttFrameTemplate a2 = this;
        a2.qos = a;
    }

    public void setVariables(Set<MqttVariableTemplate> set) {
        Object a = set;
        MqttFrameTemplate a2 = this;
        a2.variables = a;
    }

    public void setSubscribeExpressionId(String string) {
        Object a = string;
        MqttFrameTemplate a2 = this;
        a2.subscribeExpressionId = a;
    }

    public void setPublishExpressionCode(String string) {
        Object a = string;
        MqttFrameTemplate a2 = this;
        a2.publishExpressionCode = a;
    }

    public c_tK getPublishExpressionType() {
        MqttFrameTemplate a;
        return a.publishExpressionType;
    }

    public void setPublishExpressionId(String string) {
        Object a = string;
        MqttFrameTemplate a2 = this;
        a2.publishExpressionId = a;
    }

    public MqttDeviceTemplate getDevice() {
        MqttFrameTemplate a;
        return a.device;
    }

    public void setTopic(String string) {
        Object a = string;
        MqttFrameTemplate a2 = this;
        a2.topic = a;
    }

    public String getTopic() {
        MqttFrameTemplate a;
        return a.topic;
    }

    public Set<MqttVariableTemplate> getVariables() {
        MqttFrameTemplate a;
        return a.variables;
    }

    public c_tK getSubscribeExpressionType() {
        MqttFrameTemplate a;
        return a.subscribeExpressionType;
    }
}

