/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_OJ;
import com.inscada.mono.auth.model.AuthToken;
import com.inscada.mono.auth.services.otp.m.r.c_Tj;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_L;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.m.c_gk;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.r.c_lk;
import com.inscada.mono.communication.base.r.c_vj;
import com.inscada.mono.communication.base.services.c_CI;
import com.inscada.mono.communication.base.services.c_M;
import com.inscada.mono.communication.base.services.c_PF;
import com.inscada.mono.communication.base.services.c_oJ;
import com.inscada.mono.license.r.c_QC;
import com.inscada.mono.log.r.c_bC;
import com.inscada.mono.project.r.c_i;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener,
c_i {
    private static final String f_sR = "activeConnections";
    public static final short f_fu = 203;
    private final c_bC f_Du;
    public static final short f_AT = 206;
    private final c_CI<C, V> f_Tt;
    private final c_QC f_FU;
    public static final short f_dT = 209;
    private final c_L f_PT;
    public static final short f_Pu = 207;
    public static final short f_ws = 205;
    private final JedisPooled f_us;
    private static final Logger f_wu = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short f_yu = 201;
    public static final short f_fU = 202;
    private final c_oJ f_Zu;
    private final Lock f_Ct;
    public static final short f_Rs = 208;
    public static final short f_sT = 204;
    public static final short f_AU = 210;
    private final c_OJ f_au;

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, AuthToken.m_Ofa((Object)"%N\u0002}\u0017G\u0003N$N\u0007^\u0013X\u0002\u000b\u0015J\u0018E\u0019_VI\u0013\u000b\u0018^\u001aG")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), c_Tj.m_rda((Object)"[HvI}DlNwIQC8Nv\u0007KBlqyKmBJBiR}Tl\u0007{FvIwS8E}\u0007vRtK")));
        if (a3.f_PT.m_Ga()) {
            f_wu.debug(AuthToken.m_Ofa((Object)"g3j2n$\u0011Vx\u0013_\u0002B\u0018LVP\u000b\u000b\u0000J\u0004B\u0017I\u001aNV]\u0017G\u0003N\u0005\u000b\u001aD\u0015J\u001aG\u000f\u0005"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_wu.debug(c_Tj.m_rda((Object)"VhV\nTbYc]u\"\u0007JBiR}TlNv@8K}F|Bj\u0007lH8T}S8\\e\u0007nFjNyEtB8QyKmBk\t"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = new ArrayList(a22);
            a3.f_PT.m_t(Short.valueOf((short)(0x7DF & 0x78ED)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(AuthToken.m_Ofa((Object)"m\u0017B\u001aN\u0012\u000b\u0002DVy&hVX\u0013_V]\u0017Y\u001fJ\u0014G\u0013\u000b\u0000J\u001a^\u0013X"), (Throwable)a22);
        }
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_Zu.m_zba(a.getId());
    }

    protected Map<String, c_gk> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[3 >> 1] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_wu.info(AuthToken.m_Ofa((Object)"5D\u0018E\u0013H\u0002B\u0019E;J\u0018J\u0011N\u0004\u000b^g\u0013J\u0012N\u0004\u000b\rV_\u0011Vy\u0013X\u0002D\u0004B\u0018LVH\u0019E\u0018N\u0015_\u001fD\u0018\u0011VP\u000b\u000b^b2\u0011VP\u000b\u0002"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_Du.m_xL(a2.getProject()).m_v("Connection Restore (Leader " + (String)a + ")", c_Tj.m_rda((Object)"=T8\u000fQc\"\u0007=T1\u0007~FqK}C8Sw\u0007jBkSwU}\t8dyRkB\"\u0007=T").formatted(objectArray));
            try {
                f_wu.warn(AuthToken.m_Ofa((Object)"5D\u0018E\u0013H\u0002B\u0019E;J\u0018J\u0011N\u0004\u000b^g\u0013J\u0012N\u0004\u000b\rV_\u0011Vj\u0002_\u0013F\u0006_\u001fE\u0011\u000b\u0002DVX\u0002D\u0006\u000b\u0015D\u0018E\u0013H\u0002B\u0019EVP\u000b\u000b\u0017M\u0002N\u0004\u000b\u0004N\u0005_\u0019Y\u0017_\u001fD\u0018\u000b\u0010J\u001fG\u0003Y\u0013\u0005"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[3 >> 1] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_wu.error(c_Tj.m_rda((Object)"dwIvB{SqHvjyIy@}U8\u000fTByC}U8\\e\u000e\"\u0007^FqK}C8Sw\u0007kSwW8DwIvB{SqHv\u0007cZ8F~S}U8U}TlHjFlNwI8AyNtRjB\"\u0007cZ"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_gk> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_PT.m_Ga()) {
            f_wu.debug(AuthToken.m_Ofa((Object)"g3j2n$\u0011Vl\u0013_\u0002B\u0018LVJ\u001aGVH\u0019E\u0018N\u0015_\u001fD\u0018\u000b\u0005_\u0017_\u0003X\u0013XVM\u0019YV[\u0004D\u001cN\u0015_VP\u000b\u000b\u001aD\u0015J\u001aG\u000f\u0005"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_wu.debug(c_Tj.m_rda((Object)"iWi5k]f\\bJ\u001d8u}VmBkSqI\u007f\u0007tByC}U8AwU8FtK8DwIvB{SqHv\u0007kSySmT}T8AwU8WjHrB{S8\\e\t"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_PT.m_t(Short.valueOf((short)(0x12D2 & 0x6DFD)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Zu.m_Fba((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_PT.m_Ga()) {
            f_wu.debug(AuthToken.m_Ofa((Object)"g3j2n$\u0011Vx\u0002J\u0004_\u001fE\u0011\u000b\u0015D\u0018E\u0013H\u0002B\u0019EVP\u000b\u000b\u001aD\u0015J\u001aG\u000f\u0005"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_wu.debug(c_Tj.m_rda((Object)"iWi5k]f\\bJ\u001d8u}VmBkSqI\u007f\u0007tByC}U8Sw\u0007kSyUl\u0007{HvI}DlNwI8\\e\t"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 >> 2] = a;
            a2.f_PT.m_t(Short.valueOf((short)(0x3DDB & 0x42ED)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_au.m_Zea(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_Ct.lock();
            try {
                a2.stopConnectionInternal((Connection)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.f_FU.m_al();
                connectionManager.f_Tt.m_TAa((Connection)a).m_LW();
                String[] stringArray = new String[3 >> 1];
                stringArray[2 & 5] = a.getId();
                connectionManager.f_us.sadd(f_sR, stringArray);
                return;
            }
            finally {
                a2.f_Ct.unlock();
            }
        }, a);
    }

    protected Map<String, c_gk> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Zu.m_waa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[--1];
            classArray[3 & 4] = String.class;
            connectionManager.f_PT.m_Ka((short)(0x32DB & 0x4DED), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(AuthToken.m_Ofa((Object)"X\u0002J\u0004_5D\u0018E\u0013H\u0002B\u0019E?E\u0002N\u0004E\u0017G"), classArray));
            Class[] classArray2 = new Class[5 >> 2];
            classArray2[3 & 4] = String.class;
            connectionManager.f_PT.m_Ka((short)(0x47EB & 0x38DE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Tj.m_rda((Object)"kSwW[HvI}DlNwIQIlBjIyK"), classArray2));
            Class[] classArray3 = new Class[2 ^ 3];
            classArray3[3 >> 2] = String.class;
            connectionManager.f_PT.m_Ka((short)(0x31FB & 0x4ECF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(AuthToken.m_Ofa((Object)"L\u0013_5D\u0018E\u0013H\u0002B\u0019E%_\u0017_\u0003X?E\u0002N\u0004E\u0017G"), classArray3));
            Class[] classArray4 = new Class[3 >> 1];
            classArray4[3 >> 2] = SetValueRequest.class;
            connectionManager.f_PT.m_Ka((short)(0x72FD & 0xDCE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Tj.m_rda((Object)"kBlqyUqFzK}qyKmBQIlBjIyK"), classArray4));
            Class[] classArray5 = new Class[5 >> 2];
            classArray5[3 ^ 3] = Collection.class;
            connectionManager.f_PT.m_Ka((short)(0x43EF & 0x3CDD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(AuthToken.m_Ofa((Object)"X\u0013_ J\u0004B\u0017I\u001aN J\u001a^\u0013X?E\u0002N\u0004E\u0017G"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_PT.m_Ka((short)(0x76CF & 0x9FE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Tj.m_rda((Object)"TlFjS[HvI}DlNwIkeawjHrB{SQCQIlBjIyK"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_PT.m_Ka((short)(0x5EFF & 0x21CF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(AuthToken.m_Ofa((Object)"\u0005_\u0019[5D\u0018E\u0013H\u0002B\u0019E\u0005i\u000f{\u0004D\u001cN\u0015_?O?E\u0002N\u0004E\u0017G"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_PT.m_Ka((short)(0x3D0 & 0x7CFF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Tj.m_rda((Object)"\u007fBldwIvB{SqHvtlFlRkBkeawjHrB{SQCQIlBjIyK"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_PT.m_Ka((short)(0x26F3 & 0x59DD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(AuthToken.m_Ofa((Object)"\u0011N\u0002h\u0019E\u0018N\u0015_\u001fD\u0018x\u0002J\u0002^\u0005N\u0005i\u000fb\u0012X?E\u0002N\u0004E\u0017G"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_PT.m_Ka((short)(0xFD2 & 0x70FF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Tj.m_rda((Object)"zUwPkB[HvI}DlNwIQIlBjIyK"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(AuthToken.m_Ofa((Object)"0J\u001fG\u0013OV_\u0019\u000b\u0004N\u0011B\u0005_\u0013YVh\u0019E\u0018N\u0015_\u001fD\u0018f\u0017E\u0017L\u0013YVy&hVF\u0013_\u001eD\u0012X"), a);
        }
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Tt.m_MBa((String)a)) instanceof c_M) {
            return ((c_M)a).m_Z();
        }
        throw new BrowseOperationException(c_Tj.m_rda((Object)"ZUwPkB8HhBjFlNwI8IwS8TmWhHjS}C"));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_gk getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_PT.m_Ga()) {
            f_wu.debug(AuthToken.m_Ofa((Object)"g3j2n$\u0011Vl\u0013_\u0002B\u0018LVH\u0019E\u0018N\u0015_\u001fD\u0018\u000b\u0005_\u0017_\u0003XVM\u0019YVP\u000b\u000b\u001aD\u0015J\u001aG\u000f\u0005"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_wu.debug(c_Tj.m_rda((Object)"iWi5k]f\\bJ\u001d8u}VmBkSqI\u007f\u0007tByC}U8AwU8DwIvB{SqHv\u0007kSySmT8AwU8\\e\t"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 >> 2] = a;
            return (c_gk)a2.f_PT.m_t(Short.valueOf((short)(0x3ADF & 0x45EB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_au.m_Zea(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_Ct.lock();
            try {
                c_PF c_PF2 = a2.f_Tt.m_MBa(a.getId());
                if (c_PF2 != null) {
                    c_PF2.m_LS();
                    a2.f_Tt.m_bca(a.getId(), c_PF2);
                }
                String[] stringArray = new String[2 ^ 3];
                stringArray[5 >> 3] = a.getId();
                a2.f_us.srem(f_sR, stringArray);
                return;
            }
            finally {
                a2.f_Ct.unlock();
            }
        }, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_PT.m_La();
        f_wu.info(c_Tj.m_rda((Object)"[HvI}DlNwIUFvF\u007fBj\u001d8spNk\u0007vH|B8\u000fcZ1\u0007pFk\u0007zB{HuB8SpB8k]f\\bJ\t8u}TlHjNv@8F{SqQ}\u0007{HvI}DlNwIk\t6\t"), a);
        connectionManager2.f_Ct.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_us.smembers(f_sR));
            if (hashSet.isEmpty()) {
                f_wu.info(AuthToken.m_Ofa((Object)"h\u0019E\u0018N\u0015_\u001fD\u0018f\u0017E\u0017L\u0013YV\u0003:N\u0017O\u0013YVP\u000b\u0002L\u000b8DVJ\u0015_\u001f]\u0013\u000b\u0015D\u0018E\u0013H\u0002B\u0019E\u0005\u000b\u0010D\u0003E\u0012\u000b\u001fEVy\u0013O\u001fXV_\u0019\u000b\u0004N\u0005_\u0019Y\u0013\u0005"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[2 ^ 3] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_wu.info(c_Tj.m_rda((Object)"dwIvB{SqHvjyIy@}U8\u000fTByC}U8\\e\u000e\"\u0007^HmI|\u0007cZ8F{SqQ}\u0007{HvI}DlNwI8n\\T8Nv\u0007JB|Nk\u0007lH8U}TlHjB\"\u0007cZ"), objectArray);
            Object object = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[5 >> 3] = AuthToken.m_Ofa((Object)" b3|)h9e8n5\u007f?d8t?\u007f3f");
            connectionManager.f_au.m_HEa(() -> {
                void a;
                Object a2 = hashSet;
                ConnectionManager a3 = this;
                a.addAll(a3.f_Zu.m_pca((Set)a2));
            }, stringArray);
            f_wu.info(c_Tj.m_rda((Object)"[HvI}DlNwIUFvF\u007fBj\u00070k}F|Bj\u0007cZ1\u001d8flS}JhSqI\u007f\u0007lH8U}TlHjB8\\e\u0007{HvI}DlNwIk\t"), a, (Object)object.size());
            Object object2 = object = object.iterator();
            while (object2.hasNext()) {
                Connection connection = (Connection)object.next();
                object2 = object;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_wu.info(AuthToken.m_Ofa((Object)"h\u0019E\u0018N\u0015_\u001fD\u0018f\u0017E\u0017L\u0013YV\u0003:N\u0017O\u0013YVP\u000b\u0002L\u000b0B\u0018B\u0005C\u0013OVH\u0019E\u0018N\u0015_\u001fD\u0018\u000b\u0004N\u0005_\u0019Y\u0017_\u001fD\u0018\u000b\u0006Y\u0019H\u0013X\u0005\u0005"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[--2] = exception;
            f_wu.error(c_Tj.m_rda((Object)"[HvI}DlNwIUFvF\u007fBj\u00070k}F|Bj\u0007cZ1\u001d8bjUwU8CmUqI\u007f\u0007{HvI}DlNwI8U}TlHjFlNwI8WjH{BkT\"\u0007cZ"), objectArray);
            return;
        }
        finally {
            connectionManager.f_Ct.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_Zu.m_vca((String)a, (String)a3).getId());
    }

    protected c_gk getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Tt.m_MBa((String)a)) != null && a.m_vs()) {
            return c_gk.f_yT;
        }
        return c_gk.f_It;
    }

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_PF c_PF2 = a2.f_Tt.m_MBa(a.getConnectionId());
        if (c_PF2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_PF2.m_mu(a);
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_PT.m_Ga()) {
            f_wu.info(c_Tj.m_rda((Object)"TbYc]u\"\u0007PFvCtNv@8wjHrB{S\\ByDlNnFlB]Q}Il\u0007~Hj\u0007hUwM}Dl\u0007Qc\"\u0007cZ"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_wu.debug(AuthToken.m_Ofa((Object)"8d8\u0006:n7o3yL\u000b?L\u0018D\u0004B\u0018LV{\u0004D\u001cN\u0015_2N\u0017H\u0002B\u0000J\u0002N3]\u0013E\u0002\u000b\u0010D\u0004\u000b\u0006Y\u0019A\u0013H\u0002\u000b?oL\u000b\rV"), a);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.f_PT.m_Ea((ClusterNodeListener)a);
        f_wu.info(c_Tj.m_rda((Object)"[HvI}DlNwIUFvF\u007fBj\u0007qIqSqFtNbB|\u0007yI|\u0007jB\u007fNkS}U}C8Fk\u0007[KmTlBjiwC}kqTlBvBj\t"));
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_PT.m_La();
        f_wu.info(c_Tj.m_rda((Object)"dwIvB{SqHvjyIy@}U\"\u0007LOqT8IwC}\u00070\\e\u000e8Nk\u0007Vh8kWi_bJ\u0007Lo]\u0007TbYc]u6\u0007KSwWhNv@8FtK8KwDyK8DwIvB{SwUk\t6\t"), a);
        connectionManager2.f_Ct.lock();
        try {
            connectionManager.f_Tt.m_Cca();
            f_wu.info(AuthToken.m_Ofa((Object)"5D\u0018E\u0013H\u0002B\u0019E;J\u0018J\u0011N\u0004\u000b^e\u0019_Vg\u0013J\u0012N\u0004\u000b\rV_\u0011Vj\u001aGVG\u0019H\u0017GVH\u0019E\u0018N\u0015_\u0019Y\u0005\u000b\u001eJ\u0000NVI\u0013N\u0018\u000b\u0004N\u0007^\u0013X\u0002N\u0012\u000b\u0002DVX\u0002D\u0006\u000b\u0017E\u0012\u000b\u0015G\u0013J\u0004N\u0012\u000b\u0010Y\u0019FVG\u0019H\u0017GV_\u0004J\u0015@\u001fE\u0011\u0005"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_wu.error(c_Tj.m_rda((Object)"[HvI}DlNwIUFvF\u007fBj\u00070iwS8k}F|Bj\u0007cZ1\u001d8bjUwU8CmUqI\u007f\u0007hUwD}Tk\u0007wA8TlHhWqI\u007f\u0007tH{Ft\u0007{HvI}DlHjT\"\u0007cZ"), objectArray);
            return;
        }
        finally {
            connectionManager.f_Ct.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_PT.m_Ga()) {
            f_wu.debug(AuthToken.m_Ofa((Object)":n7o3yL\u000b&N\u0004M\u0019Y\u001bB\u0018LVI\u0004D\u0001X\u0013\u000b\u0019[\u0013Y\u0017_\u001fD\u0018\u000b\u0010D\u0004\u000b\u0015D\u0018E\u0013H\u0002B\u0019EVP\u000b\u000b\u001aD\u0015J\u001aG\u000f\u0005"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_wu.debug(c_Tj.m_rda((Object)"VhV\nTbYc]u\"\u0007JBiR}TlNv@8K}F|Bj\u0007lH8W}U~HjJ8EjHoT}\u0007wW}UySqHv\u0007~Hj\u0007{HvI}DlNwI8\\e\t"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            return a2.f_PT.m_t(Short.valueOf((short)(0x77DF & 0x8F2)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_PT.m_Ga()) {
            f_wu.debug(AuthToken.m_Ofa((Object)":n7o3yL\u000b%_\u0019[\u0006B\u0018LVJ\u001aGVH\u0019E\u0018N\u0015_\u001fD\u0018XVM\u0019YV[\u0004D\u001cN\u0015_VP\u000b\u000b\u001aD\u0015J\u001aG\u000f\u0005"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_wu.debug(c_Tj.m_rda((Object)"iWi5k]f\\bJ\u001d8u}VmBkSqI\u007f\u0007tByC}U8Sw\u0007kSwW8FtK8DwIvB{SqHvT8AwU8WjHrB{S8\\e\t"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_PT.m_t(Short.valueOf((short)(0x3DF & 0x7CEF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, AuthToken.m_Ofa((Object)"%N\u0002}\u0017G\u0003N$N\u0007^\u0013X\u0002\u000b\u0015J\u0018E\u0019_VI\u0013\u000b\u0018^\u001aG"));
        Objects.requireNonNull(a.getConnectionId(), c_Tj.m_rda((Object)"[HvI}DlNwIQC8Nv\u0007KBlqyKmBJBiR}Tl\u0007{FvIwS8E}\u0007vRtK"));
        if (a2.f_PT.m_Ga()) {
            f_wu.debug(AuthToken.m_Ofa((Object)":n7o3yL\u000b%N\u0002_\u001fE\u0011\u000b\u0000J\u0004B\u0017I\u001aNV]\u0017G\u0003NVM\u0019YVH\u0019E\u0018N\u0015_\u001fD\u0018\u000b\rVVG\u0019H\u0017G\u001aRL\u000b\rV"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_wu.debug(c_Tj.m_rda((Object)"iWi5k]f\\bJ\u001d8u}VmBkSqI\u007f\u0007tByC}U8Sw\u0007kBl\u0007nFjNyEtB8QyKmB8AwU8DwIvB{SqHv\u0007cZ\"\u0007cZ"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_PT.m_t(Short.valueOf((short)(0x5BEF & 0x24DC)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Zu.m_Fba((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_vj.class})
    public void handleDeleteEvent(c_vj c_vj2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_PT.m_Ga()) {
            ConnectionManager a2 = a.m_gAa();
            f_wu.info(c_Tj.m_rda((Object)"TbYc]u\"\u0007PFvCtNv@8c}K}S}bnBvS8AwU8DwIvB{SqHv\u001d8\\e\u00070n\\\u001d8\\e\u000e"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_wu.debug(AuthToken.m_Ofa((Object)"e9e[g3j2n$\u0011Vb\u0011E\u0019Y\u001fE\u0011\u000b2N\u001aN\u0002N3]\u0013E\u0002\u000b\u0010D\u0004\u000b\u0015D\u0018E\u0013H\u0002B\u0019EL\u000b\rV"), (Object)a.m_gAa().getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_gk getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_Zu.m_yCa((String)a2, (String)a)) == null) {
            return c_gk.f_It;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_lk.class})
    public void handleRestartEvent(c_lk c_lk2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_PT.m_Ga()) {
            ConnectionManager a2 = a.m_Gba();
            f_wu.info(c_Tj.m_rda((Object)"k]f\\bJ\u001d8oyI|KqI\u007f\u0007JBkSyUlbnBvS8AwU8DwIvB{SqHv\u001d8\\e\u00070n\\\u001d8\\e\u000e"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_Ct.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_gk.f_yT) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_Ct.unlock();
            }
        }
        f_wu.debug(AuthToken.m_Ofa((Object)"8d8\u0006:n7o3yL\u000b?L\u0018D\u0004B\u0018LVy\u0013X\u0002J\u0004_3]\u0013E\u0002\u000b\u0010D\u0004\u000b\u0015D\u0018E\u0013H\u0002B\u0019EL\u000b\rV"), (Object)a.m_Gba().getId());
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_PT.m_Ga()) {
            f_wu.debug(AuthToken.m_Ofa((Object)":n7o3yL\u000b%_\u0017Y\u0002B\u0018LVJ\u001aGVH\u0019E\u0018N\u0015_\u001fD\u0018XVM\u0019YV[\u0004D\u001cN\u0015_VP\u000b\u000b\u001aD\u0015J\u001aG\u000f\u0005"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_wu.debug(c_Tj.m_rda((Object)"VhV\nTbYc]u\"\u0007JBiR}TlNv@8K}F|Bj\u0007lH8TlFjS8FtK8DwIvB{SqHvT8AwU8WjHrB{S8\\e\t"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_PT.m_t(Short.valueOf((short)(0x38EE & 0x47DF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_Zu.m_iba((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_PT.m_Ga()) {
            f_wu.debug(AuthToken.m_Ofa((Object)"g3j2n$\u0011Vx\u0002D\u0006[\u001fE\u0011\u000b\u0015D\u0018E\u0013H\u0002B\u0019EVP\u000b\u000b\u001aD\u0015J\u001aG\u000f\u0005"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_wu.debug(c_Tj.m_rda((Object)"VhV\nTbYc]u\"\u0007JBiR}TlNv@8K}F|Bj\u0007lH8TlHh\u0007{HvI}DlNwI8\\e\t"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            a2.f_PT.m_t(Short.valueOf((short)(0x40DB & 0x3FEE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_gk> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_PT.m_Ga()) {
            f_wu.debug(AuthToken.m_Ofa((Object)"g3j2n$\u0011Vl\u0013_\u0002B\u0018LVH\u0019E\u0018N\u0015_\u001fD\u0018\u000b\u0005_\u0017_\u0003X\u0013XVM\u0019YVP\u000b\u000b?o\u0005\u000b\u001aD\u0015J\u001aG\u000f\u0005"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_wu.debug(c_Tj.m_rda((Object)"iWi5k]f\\bJ\u001d8u}VmBkSqI\u007f\u0007tByC}U8AwU8DwIvB{SqHv\u0007kSySmT}T8AwU8\\e\u0007Qck\t"), (Object)a.length);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_PT.m_t(Short.valueOf((short)(0x4ADF & 0x35F1)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_oJ c_oJ2, c_QC c_QC2, c_bC c_bC2, c_CI<C, V> c_CI2, JedisPooled jedisPooled, c_L c_L2, c_OJ c_OJ2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_OJ2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        ConnectionManager connectionManager6 = a8;
        a8.f_Ct = new ReentrantLock();
        a8.f_Zu = a7;
        connectionManager5.f_FU = a6;
        connectionManager5.f_Du = a5;
        connectionManager4.f_Tt = a4;
        connectionManager4.f_us = a3;
        connectionManager3.f_PT = a2;
        connectionManager3.f_au = a;
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_Tt.m_MBa((String)a)) != null) {
                void a3;
                a.m_Fs((List)a3);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_PT.m_La();
        String[] stringArray = new String[--3];
        stringArray[3 >> 2] = AuthToken.m_Ofa((Object)"%\u007f7y\"t5d8e3h\"b9e");
        stringArray[3 & 5] = c_Tj.m_rda((Object)"tLhHx[hVi]dLnWi");
        stringArray[5 >> 1] = AuthToken.m_Ofa((Object)" b3|)h9e8n5\u007f?d8t?\u007f3f");
        connectionManager2.f_au.m_OEa(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_Zu.m_Hba((String)a);
        return connectionManager2.f_au.m_NDa(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_Zu.m_vca((String)a, (String)a3).getId());
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_Zu.m_Hba((String)a2));
    }
}

