/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.HasDevice;
import com.inscada.mono.communication.base.model.HasVariables;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@AttributeOverride(name="id", column=@Column(name="frame_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"deviceId", "device"})
public class Frame<TDevice extends Device<?, ?>, TVariable extends Variable<?, ?, ?>>
extends SpaceBaseModel
implements HasVariables<TVariable>,
HasDevice<TDevice> {
    @Column(name="scan_time_factor")
    protected Integer scanTimeFactor;
    @Column(name="device_id", insertable=false, updatable=false)
    protected String deviceId;
    @NotNull
    @Column(name="writable_flag", nullable=false)
    protected Boolean isWritable;
    @Size(max=255)
    protected String dsc;
    @Column(name="minutes_offset")
    protected Integer minutesOffset;
    @NotNull
    @Column(name="readable_flag", nullable=false)
    protected Boolean isReadable;
    @NotBlank
    @Size(max=100)
    protected String name;

    public String getName() {
        Frame a;
        return a.name;
    }

    public void setDsc(String string) {
        Object a = string;
        Frame a2 = this;
        a2.dsc = a;
    }

    public String getDeviceId() {
        Frame a;
        return a.deviceId;
    }

    public String getDsc() {
        Frame a;
        return a.dsc;
    }

    public Frame() {
        Frame a;
    }

    public void setIsWritable(Boolean bl) {
        Object a = bl;
        Frame a2 = this;
        a2.isWritable = a;
    }

    public void setIsReadable(Boolean bl) {
        Object a = bl;
        Frame a2 = this;
        a2.isReadable = a;
    }

    public boolean equals(Object object) {
        Frame a = this;
        Object a2 = object;
        if (a == a2) {
            return (3 & 5) != 0;
        }
        if (!(a2 instanceof Frame)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return 3 >> 2;
        }
        if (a.getDeviceId().equals(object2.getDeviceId()) && a.getName().equals(object2.getName())) {
            return (4 ^ 5) != 0;
        }
        return false;
    }

    public Boolean getIsWritable() {
        Frame a;
        return a.isWritable;
    }

    public void setName(String string) {
        Object a = string;
        Frame a2 = this;
        a2.name = a;
    }

    public int hashCode() {
        Frame a;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[5 >> 2] = a.getDeviceId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setScanTimeFactor(Integer n) {
        Object a = n;
        Frame a2 = this;
        a2.scanTimeFactor = a;
    }

    public Integer getScanTimeFactor() {
        Frame a;
        return a.scanTimeFactor;
    }

    public Integer getMinutesOffset() {
        Frame a;
        return a.minutesOffset;
    }

    public void setMinutesOffset(Integer n) {
        Object a = n;
        Frame a2 = this;
        a2.minutesOffset = a;
    }

    public Boolean getIsReadable() {
        Frame a;
        return a.isReadable;
    }

    public void setDeviceId(String string) {
        Object a = string;
        Frame a2 = this;
        a2.deviceId = a;
    }
}

