/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.m.c_Yk;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AlarmGroupSummary;
import com.inscada.mono.alarm.model.CheckedAlarm;
import com.inscada.mono.alarm.r.c_Gj;
import com.inscada.mono.alarm.r.c_Mk;
import com.inscada.mono.alarm.r.c_Xl;
import com.inscada.mono.alarm.r.c_kL;
import com.inscada.mono.alarm.r.c_tJ;
import com.inscada.mono.alarm.services.c_EK;
import com.inscada.mono.alarm.services.c_SL;
import com.inscada.mono.alarm.services.c_WL;
import com.inscada.mono.alarm.services.c_qk;
import com.inscada.mono.auth.c_OJ;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_L;
import com.inscada.mono.log.r.c_bC;
import com.inscada.mono.project.r.c_i;
import com.inscada.mono.script.model.ScriptDto;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener,
c_i {
    private final c_SL f_cw;
    private final JedisPooled f_hU;
    private final c_OJ f_Fw;
    private final c_EK f_ew;
    public static final short f_dW = 106;
    private final Lock f_Gx;
    public static final short f_Cw = 102;
    public static final short f_ax = 101;
    private final c_WL f_Fv;
    private final c_L f_Sx;
    public static final short f_qU = 103;
    public static final short f_jU = 105;
    public static final short f_Zx = 109;
    public static final short f_hV = 104;
    public static final short f_JU = 107;
    private final c_bC f_jw;
    public static final short f_wx = 108;
    private static final String f_rx = "activeAlarmGroups";
    private static final Logger f_Zv = LoggerFactory.getLogger(AlarmManager.class);

    @TransactionalEventListener(value={c_kL.class})
    public void handleAlarmDeleteEvent(c_kL c_kL2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_Sx.m_Ga()) {
            AlarmManager a = a.m_LHa();
            f_Zv.info(ScriptDto.m_dI((Object)"\u0015Q\u0018P\u001cFc4\u0011u7p5}7syU5u+y\u001dq5q-q\u001cb<z-4?{+48x8f44\u0010Pc4\"iu4\u001ef6a)4\u0010Pc4\"i"), (Object)a.getId(), (Object)a.getGroupId());
            c_qk c_qk2 = alarmManager.f_cw.m_pIa(a.getGroupId());
            if (c_qk2 != null && c_qk2.m_PIa()) {
                c_qk2.m_mia((Alarm)a);
                return;
            }
        } else {
            f_Zv.debug(CheckedAlarm.m_aia((Object)"9\u00179u;\u001d6\u001c2\nMx>?\u00197\u00051\u0019?W\u0019\u001b9\u000553=\u001b=\u0003=2.\u00126\u0003x\u00117\u0005x\u00164\u0016*\u001ax>\u001cMx\f%"), (Object)a.m_LHa().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_Sx.m_Ga()) {
            f_Zv.debug(ScriptDto.m_dI((Object)"X\u001cU\u001dQ\u000b.yU:`0b8`0z>48x548x8f44>f6a)gyr6fyd+{3q:`yo$45{:u5x :"), a);
            a2.activateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"9\u00179u;\u001d6\u001c2\nMx%=\u0006-\u0012+\u00031\u0019?W4\u00129\u0013=\u0005x\u00037W9\u0014,\u001e.\u0016,\u0012x\u00164\u001bx\u00164\u0016*\u001ax\u0010*\u0018-\u0007+W>\u0018*W(\u00057\u001d=\u0014,W#\nv"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[2 & 5] = a;
            a2.f_Sx.m_t(Short.valueOf((short)(0x6C & 0x7F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_Sx.m_Ga()) {
            f_Zv.debug(ScriptDto.m_dI((Object)"\u0015Q\u0018P\u001cFc4\u0018w-}/u-}7syu5u+yys+{,dyo$45{:u5x :"), a);
            a2.activateAlarmGroupInternal((String)a);
            return;
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"\u00168\u0016Z\u00142\u00193\u001d%bW\n\u0012)\u0002=\u0004,\u001e6\u0010x\u001b=\u0016<\u0012*W,\u0018x\u0016;\u00031\u00019\u0003=W9\u001b9\u00055W?\u00057\u0002(W#\nv"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[5 >> 3] = a;
            a2.f_Sx.m_t(Short.valueOf((short)(0x7D & 0x67)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm group " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_Yk getAlarmStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_Fv.m_EHa((String)a2, (String)a)) == null) {
            return c_Yk.f_BZ;
        }
        return a3.getAlarmStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.deactivateAlarmGroup(alarmManager.f_ew.m_vGa((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_Yk getAlarmGroupStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_ew.m_jHa((String)a2, (String)a)) == null) {
            return c_Yk.f_BZ;
        }
        return a3.getAlarmGroupStatus(a2.getId());
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_Sx.m_Ga()) {
            f_Zv.debug(ScriptDto.m_dI((Object)"\u0015Q\u0018P\u001cFc4\u001dq8w-}/u-}7syu5u+yys+{,dyo$45{:u5x :"), a);
            a2.deactivateAlarmGroupInternal((String)a);
            return;
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"\u00168\u0016Z\u00142\u00193\u001d%bW\n\u0012)\u0002=\u0004,\u001e6\u0010x\u001b=\u0016<\u0012*W,\u0018x\u0013=\u0016;\u00031\u00019\u0003=W9\u001b9\u00055W?\u00057\u0002(W#\nv"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 ^ 3] = a;
            a2.f_Sx.m_t(Short.valueOf((short)(0x67 & 0x7E)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm group " + (String)a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.f_Sx.m_Ea((ClusterNodeListener)a);
        f_Zv.info(CheckedAlarm.m_aia((Object)"\u0019\u001b9\u00055:9\u00199\u0010=\u0005x\u001e6\u001e,\u001e9\u001b1\r=\u0013x\u00166\u0013x\u0005=\u00101\u0004,\u0012*\u0012<W9\u0004x44\u0002+\u0003=\u0005\u0016\u0018<\u0012\u0014\u001e+\u0003=\u0019=\u0005v"));
    }

    @TransactionalEventListener(value={c_tJ.class})
    public void handleAlarmAddEvent(c_tJ c_tJ2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_Sx.m_Ga()) {
            c_qk c_qk2;
            AlarmManager a = a.m_Iia();
            f_Zv.info(ScriptDto.m_dI((Object)"X\u001cU\u001dQ\u000b.y\\8z=x0z>4\u0018x8f4U=p\u001cb<z-4?{+48x8f44\u0010Pc4\"iu4\u001ef6a)4\u0010Pc4\"i"), (Object)a.getId(), (Object)a.getGroupId());
            if (Boolean.TRUE.equals(a.getIsActive()) && (c_qk2 = alarmManager.f_cw.m_pIa(a.getGroupId())) != null && c_qk2.m_PIa()) {
                c_qk2.m_hIa((Alarm)a);
                return;
            }
        } else {
            f_Zv.debug(CheckedAlarm.m_aia((Object)"\u00168\u0016Z\u00142\u00193\u001d%bW\u0011\u00106\u0018*\u001e6\u0010x64\u0016*\u001a\u0019\u0013<2.\u00126\u0003x\u00117\u0005x\u00164\u0016*\u001ax>\u001cMx\f%"), (Object)a.m_Iia().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_Yk> getAlarmStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_Sx.m_Ga()) {
            f_Zv.debug(ScriptDto.m_dI((Object)"\u0015Q\u0018P\u001cFc4\u001eq-`0z>48x548x8f44*`8`,g<gyr6fyd+{3q:`yo$45{:u5x :"), a);
            return a2.getAlarmStatusesByProjectIdInternal((String)a);
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"9\u00179u;\u001d6\u001c2\nMx%=\u0006-\u0012+\u00031\u0019?W4\u00129\u0013=\u0005x\u00117\u0005x\u00164\u001bx\u00164\u0016*\u001ax\u0004,\u0016,\u0002+\u0012+W>\u0018*W(\u00057\u001d=\u0014,W#\nv"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[2 & 5] = a;
            return (Map)a2.f_Sx.m_t(Short.valueOf((short)(0x79 & 0x6F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for project " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        AlarmManager alarmManager = this;
        try {
            Class[] classArray = new Class[3 & 5];
            classArray[3 & 4] = String.class;
            alarmManager.f_Sx.m_Ka((short)(0x6D & 0x77), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ScriptDto.m_dI((Object)"8w-}/u-q\u0018x8f4S+{,d\u0010z-q+z8x"), classArray));
            Class[] classArray2 = new Class[3 >> 1];
            classArray2[5 >> 3] = String.class;
            alarmManager.f_Sx.m_Ka((short)(0x7E & 0x67), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(CheckedAlarm.m_aia((Object)"\u0013=\u0016;\u00031\u00019\u0003=64\u0016*\u001a\u001f\u00057\u0002(>6\u0003=\u00056\u00164"), classArray2));
            Class[] classArray3 = new Class[--1];
            classArray3[3 ^ 3] = String.class;
            alarmManager.f_Sx.m_Ka((short)(0x67 & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ScriptDto.m_dI((Object)">q-U5u+y\n`8`,g\u0010z-q+z8x"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[3 >> 2] = String.class;
            alarmManager.f_Sx.m_Ka((short)(0x69 & 0x7E), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(CheckedAlarm.m_aia((Object)"?\u0012,64\u0016*\u001a\u001f\u00057\u0002($,\u0016,\u0002+>6\u0003=\u00056\u00164"), classArray4));
            Class[] classArray5 = new Class[4 ^ 5];
            classArray5[5 >> 3] = String.class;
            alarmManager.f_Sx.m_Ka((short)(0x6D & 0x7B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ScriptDto.m_dI((Object)"s<`\u0018x8f4G-u-a*q*V D+{3q:`\u0010p\u0010z-q+z8x"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            alarmManager.f_Sx.m_Ka((short)(0x6F & 0x7A), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(CheckedAlarm.m_aia((Object)"\u0010=\u0003\u0019\u001b9\u000550*\u0018-\u0007\u000b\u00039\u0003-\u0004=\u0004\u001a\u000e\b\u00057\u001d=\u0014,><>6\u0003=\u00056\u00164"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            alarmManager.f_Sx.m_Ka((short)(0x7F & 0x6B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ScriptDto.m_dI((Object)">q-U5u+y\n`8`,g<g\u0010z-q+z8x"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            alarmManager.f_Sx.m_Ka((short)(0x7E & 0x6D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(CheckedAlarm.m_aia((Object)"\u0016;\u00031\u00019\u0003=64\u0016*\u001a\u001f\u00057\u0002(\u0004\u001a\u000e\b\u00057\u001d=\u0014,><>6\u0003=\u00056\u00164"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String.class;
            alarmManager.f_Sx.m_Ka((short)(0x6D & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(ScriptDto.m_dI((Object)"=q8w-}/u-q\u0018x8f4S+{,d*V D+{3q:`\u0010p\u0010z-q+z8x"), classArray9));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(CheckedAlarm.m_aia((Object)"\u001e\u00161\u001b=\u0013x\u00037W*\u0012?\u001e+\u0003=\u0005x64\u0016*\u001a\u0015\u00166\u0016?\u0012*W\n'\u001bW5\u0012,\u001f7\u0013+"), a);
        }
    }

    protected void activateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Fw.m_Zea(() -> a2.lambda$activateAlarmGroupInternal$2((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_ew.m_kia((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    protected c_Yk getAlarmStatusInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        return alarmManager.getAlarmStatusInternal(alarmManager.f_Fv.m_via((String)a2));
    }

    protected void deactivateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.f_ew.m_qIa((String)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_Yk> getAlarmStatuses(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_Sx.m_Ga()) {
            f_Zv.debug(ScriptDto.m_dI((Object)"X\u001cU\u001dQ\u000b.yS<`-}7syu5u+yyg-u-a*q*4?{+4\"iy]\u001dgyx6w8x5mc4\"i"), (Object)a.size(), (Object)a);
            return a2.getAlarmStatusesInternal((List)a);
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"\u00168\u0016Z\u00142\u00193\u001d%bW\n\u0012)\u0002=\u0004,\u001e6\u0010x\u001b=\u0016<\u0012*W>\u0018*W9\u001b9\u00055W+\u00039\u0003-\u0004=\u0004x\u00117\u0005x\f%W\u00113+Mx\f%"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[5 >> 3] = new ArrayList(a);
            return (Map)a2.f_Sx.m_t(Short.valueOf((short)(0x6F & 0x7B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_Mk.class})
    public void handleAlarmGroupDeleteEvent(c_Mk c_Mk2) {
        AlarmManager a = c_Mk2;
        AlarmManager a2 = this;
        if (a2.f_Sx.m_Ga()) {
            f_Zv.info(ScriptDto.m_dI((Object)"X\u001cU\u001dQ\u000b.y\\8z=x0z>4\u0018x8f4S+{,d\u001dq5q-q\u001cb<z-4?{+4>f6a)4\u0010Pc4\"i"), (Object)a.m_PHa().getId());
            a2.deactivateAlarmGroupInternal(a.m_PHa().getId());
            return;
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"\u00168\u0016Z\u00142\u00193\u001d%bW\u0011\u00106\u0018*\u001e6\u0010x64\u0016*\u001a\u001f\u00057\u0002(3=\u001b=\u0003=2.\u00126\u0003x\u00117\u0005x\u0010*\u0018-\u0007x>\u001cMx\f%"), (Object)a.m_PHa().getId());
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_Sx.m_Ga()) {
            f_Zv.debug(ScriptDto.m_dI((Object)"X\u001cU\u001dQ\u000b.yP<u:`0b8`0z>48x548x8f44>f6a)gyr6fyd+{3q:`yo$45{:u5x :"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"9\u00179u;\u001d6\u001c2\nMx%=\u0006-\u0012+\u00031\u0019?W4\u00129\u0013=\u0005x\u00037W<\u00129\u0014,\u001e.\u0016,\u0012x\u00164\u001bx\u00164\u0016*\u001ax\u0010*\u0018-\u0007+W>\u0018*W(\u00057\u001d=\u0014,W#\nv"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[5 >> 3] = a;
            a2.f_Sx.m_t(Short.valueOf((short)(0x7D & 0x6F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.activateAlarmGroup(alarmManager.f_ew.m_vGa((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String string, AlarmGroup alarmGroup) {
        void a;
        AlarmManager a2 = alarmGroup;
        AlarmManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[3 >> 1] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_Zv.info(ScriptDto.m_dI((Object)"\u0018x8f4Y8z8s<fy<\u0015q8p<fyo$=c4\u000bq*`6f0z>48x8f44>f6a).yo$4q]\u001d.yo$="), objectArray);
            a3.activateAlarmGroupInternal((AlarmGroup)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_jw.m_xL(a2.getProject()).m_v("Alarm Group Restore (Leader " + (String)a + ")", CheckedAlarm.m_aia((Object)"R+Wp>\u001cMxR+^x\u00119\u001e4\u0012<W,\u0018x\u0005=\u0004,\u0018*\u0012vW\u001b\u0016-\u0004=MxR+").formatted(objectArray));
            try {
                f_Zv.warn(ScriptDto.m_dI((Object)"\u0018x8f4Y8z8s<fy<\u0015q8p<fyo$=c4\u0018`-q4d-}7sy`64=q8w-}/u-qyu5u+yys+{,dyo$48r-q+4+q*`6f8`0{74?u0x,f<:"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal((AlarmGroup)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 & 4] = a;
                objectArray2[2 ^ 3] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_Zv.error(CheckedAlarm.m_aia((Object)"\u0019\u001b9\u00055:9\u00199\u0010=\u0005x_\u0014\u00129\u0013=\u0005x\f%^bW\u001e\u00161\u001b=\u0013x\u00037W<\u00129\u0014,\u001e.\u0016,\u0012x\u00164\u0016*\u001ax\u0010*\u0018-\u0007x\f%W9\u0011,\u0012*W*\u0012+\u00037\u00059\u00031\u00186W>\u00161\u001b-\u0005=Mx\f%"), objectArray2);
                return;
            }
        }
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Fw.m_Zea(() -> a2.lambda$deactivateAlarmGroupInternal$3((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ void lambda$deactivateAlarmGroupInternal$3(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Gx.lock();
        try {
            c_qk c_qk2 = a2.f_cw.m_pIa(a.getId());
            if (c_qk2 != null) {
                c_qk2.m_uga();
                a2.f_cw.m_Yga(a.getId(), c_qk2);
            }
            String[] stringArray = new String[3 >> 1];
            stringArray[3 ^ 3] = a.getId();
            a2.f_hU.srem(f_rx, stringArray);
            return;
        }
        finally {
            a2.f_Gx.unlock();
        }
    }

    protected void activateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.activateAlarmGroupInternal(alarmManager.f_ew.m_qIa((String)a2));
    }

    protected void activateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_ew.m_kia((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$2(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Gx.lock();
        try {
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to start alarm group " + a.getName());
            }
            c_qk c_qk2 = a2.f_cw.m_rGa((AlarmGroup)a);
            c_qk2.m_Rga();
            if (c_qk2.m_PIa()) {
                String[] stringArray = new String[3 >> 1];
                stringArray[3 ^ 3] = a.getId();
                a2.f_hU.sadd(f_rx, stringArray);
            }
            return;
        }
        finally {
            a2.f_Gx.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_Yk getAlarmStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_Sx.m_Ga()) {
            f_Zv.debug(ScriptDto.m_dI((Object)"\u0015Q\u0018P\u001cFc4\u001eq-`0z>48x8f44*`8`,gyr6fyo$45{:u5x :"), a);
            return a2.getAlarmStatusInternal((String)a);
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"9\u00179u;\u001d6\u001c2\nMx%=\u0006-\u0012+\u00031\u0019?W4\u00129\u0013=\u0005x\u00117\u0005x\u00164\u0016*\u001ax\u0004,\u0016,\u0002+W>\u0018*W#\nv"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[2 & 5] = a;
            return (c_Yk)a2.f_Sx.m_t(Short.valueOf((short)(0x67 & 0x7F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm status for " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_Xl.class})
    public void handleAlarmChangeEvent(c_Xl c_Xl2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_Sx.m_Ga()) {
            AlarmManager a = a.m_SHa();
            f_Zv.info(ScriptDto.m_dI((Object)"\u0015Q\u0018P\u001cFc4\u0011u7p5}7syU5u+y\u001a|8z>q\u001cb<z-4?{+48x8f44\u0010Pc4\"iu4\u001ef6a)4\u0010Pc4\"i"), (Object)a.getId(), (Object)a.getGroupId());
            c_qk c_qk2 = alarmManager.f_cw.m_pIa(a.getGroupId());
            if (c_qk2 != null && c_qk2.m_PIa()) {
                if (Boolean.TRUE.equals(a.getIsActive())) {
                    c_qk2.m_hIa((Alarm)a);
                    return;
                }
                c_qk2.m_mia((Alarm)a);
                return;
            }
        } else {
            f_Zv.debug(CheckedAlarm.m_aia((Object)"9\u00179u;\u001d6\u001c2\nMx>?\u00197\u00051\u0019?W\u0019\u001b9\u0005540\u00166\u0010=2.\u00126\u0003x\u00117\u0005x\u00164\u0016*\u001ax>\u001cMx\f%"), (Object)a.m_SHa().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_Sx.m_La();
        f_Zv.info(ScriptDto.m_dI((Object)"\u0018x8f4Y8z8s<fc4\r|0gyz6p<4qo$=y|8gyv<w6y<4-|<4\u0015Q\u0018P\u001cFw4\u000bq*`6f0z>48w-}/qyu5u+y*:w:"), a);
        alarmManager2.f_Gx.lock();
        try {
            HashSet hashSet = new HashSet(alarmManager.f_hU.smembers(f_rx));
            if (hashSet.isEmpty()) {
                f_Zv.info(CheckedAlarm.m_aia((Object)"\u0019\u001b9\u00055:9\u00199\u0010=\u0005x_\u0014\u00129\u0013=\u0005x\f%^bW\u0016\u0018x\u0016;\u00031\u0001=W9\u001b9\u00055W?\u00057\u0002(\u0004x\u00117\u00026\u0013x\u001e6W\n\u0012<\u001e+W,\u0018x\u0005=\u0004,\u0018*\u0012v"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 >> 1] = hashSet.size();
            objectArray[--2] = hashSet;
            f_Zv.info(ScriptDto.m_dI((Object)"U5u+y\u0014u7u>q+4qX<u=q+4\"ip.yR6a7pyo$48w-}/qyu5u+yys+{,dy]\u001dgy}74\u000bq=}*4-{yf<g-{+qc4\"i"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[3 & 4] = CheckedAlarm.m_aia((Object)"!\u00112\u000f(\u0019;\u0019%\u0015(\u001f%\u0017\"\b");
            alarmManager.f_Fw.m_HEa(() -> {
                void a;
                Object a2 = hashSet;
                AlarmManager a3 = this;
                a.addAll(a3.f_ew.m_vIa((Set)a2));
            }, stringArray);
            f_Zv.info(ScriptDto.m_dI((Object)"\u0018x8f4Y8z8s<fy<\u0015q8p<fyo$=c4\u0018`-q4d-}7sy`64+q*`6f<4\"iyu5u+yys+{,d*:"), a, (Object)arrayList.size());
            arrayList.forEach(alarmGroup -> {
                void a;
                AlarmManager alarmManager;
                AlarmManager alarmManager2 = alarmManager = this;
                Object a2 = alarmManager2.f_Sx.m_La();
                String[] stringArray = new String[1 ^ 3];
                stringArray[3 & 4] = CheckedAlarm.m_aia((Object)"6\u001b#\u0011!\u0019#\u001d(\u0019;\u0019%\u0015");
                stringArray[5 >> 2] = ScriptDto.m_dI((Object)"\u001dQ\u0018W\r]\u000fU\rQ\u0006U\u0015U\u000bY");
                alarmManager2.f_Fw.m_OEa(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1((String)a2, (AlarmGroup)a), a.getSpace(), stringArray);
            });
            f_Zv.info(CheckedAlarm.m_aia((Object)"\u0019\u001b9\u00055:9\u00199\u0010=\u0005x_\u0014\u00129\u0013=\u0005x\f%^bW\u001e\u001e6\u001e+\u001f=\u0013x\u00164\u0016*\u001ax\u0005=\u0004,\u0018*\u0016,\u001e7\u0019x\u0007*\u0018;\u0012+\u0004v"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Zv.error(ScriptDto.m_dI((Object)"\u0018x8f4Y8z8s<fy<\u0015q8p<fyo$=c4\u001cf+{+4=a+}7syu5u+yyf<g-{+u-}6zyd+{:q*gc4\"i"), objectArray);
            return;
        }
        finally {
            alarmManager.f_Gx.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_Yk> getAlarmGroupStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_Sx.m_Ga()) {
            f_Zv.debug(ScriptDto.m_dI((Object)"\u0015Q\u0018P\u001cFc4\u001eq-`0z>48x548x8f44>f6a)4*`8`,g<gyr6fyd+{3q:`yo$45{:u5x :"), a);
            return a2.getAlarmGroupStatusesByProjectIdInternal((String)a);
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"9\u00179u;\u001d6\u001c2\nMx%=\u0006-\u0012+\u00031\u0019?W4\u00129\u0013=\u0005x\u00117\u0005x\u00164\u001bx\u00164\u0016*\u001ax\u0010*\u0018-\u0007x\u0004,\u0016,\u0002+\u0012+W>\u0018*W(\u00057\u001d=\u0014,W#\nv"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_Sx.m_t(Short.valueOf((short)(0x7E & 0x6B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group statuses for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Gj.class})
    public void handleAlarmGroupChangeEvent(c_Gj c_Gj2) {
        void a;
        AlarmManager alarmManager = this;
        if (alarmManager.f_Sx.m_Ga()) {
            f_Zv.info(ScriptDto.m_dI((Object)"X\u001cU\u001dQ\u000b.y\\8z=x0z>4\u0018x8f4S+{,d\u001a|8z>q\u001cb<z-4?{+4>f6a)4\u0010Pc4\"i"), (Object)a.m_qia().getId());
            alarmManager.f_Gx.lock();
            try {
                Object a2 = a.m_qia().getId();
                if (alarmManager.getAlarmGroupStatusInternal((String)a2) == c_Yk.f_oaa) {
                    AlarmManager alarmManager2 = alarmManager;
                    alarmManager2.deactivateAlarmGroupInternal((String)a2);
                    alarmManager2.activateAlarmGroupInternal((String)a2);
                }
                return;
            }
            finally {
                alarmManager.f_Gx.unlock();
            }
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"\u00168\u0016Z\u00142\u00193\u001d%bW\u0011\u00106\u0018*\u001e6\u0010x64\u0016*\u001a\u001f\u00057\u0002(40\u00166\u0010=2.\u00126\u0003x\u00117\u0005x\u0010*\u0018-\u0007x>\u001cMx\f%"), (Object)a.m_qia().getId());
    }

    protected Map<String, c_Yk> getAlarmGroupStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_ew.m_Wia((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroupSummary::getId, alarmGroupSummary -> {
            AlarmManager a = alarmGroupSummary;
            AlarmManager a2 = this;
            return a2.getAlarmGroupStatusInternal(a.getId());
        }));
    }

    protected c_Yk getAlarmGroupStatusInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_cw.m_pIa((String)a)) != null && a.m_PIa()) {
            return c_Yk.f_oaa;
        }
        return c_Yk.f_BZ;
    }

    protected Map<String, c_Yk> getAlarmStatusesInternal(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    protected c_Yk getAlarmStatusInternal(Alarm alarm) {
        void a;
        AlarmManager alarmManager = this;
        if (a == null) {
            return c_Yk.f_BZ;
        }
        AlarmManager a2 = alarmManager.f_cw.m_pIa(a.getGroup().getId());
        if (a2 != null && a2.m_PIa() && a2.m_Nha(a.getId())) {
            return c_Yk.f_oaa;
        }
        return c_Yk.f_BZ;
    }

    public void deactivateForProject(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_Sx.m_Ga()) {
            f_Zv.info(ScriptDto.m_dI((Object)"\u0015Q\u0018P\u001cFc4\u0011u7p5}7syD+{3q:`\u001dq8w-}/u-q\u001cb<z-4?{+4)f6~<w-4\u0010Pc4\"i"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"9\u00179u;\u001d6\u001c2\nMx>?\u00197\u00051\u0019?W\b\u00057\u001d=\u0014,3=\u0016;\u00031\u00019\u0003=2.\u00126\u0003x\u00117\u0005x\u0007*\u00182\u0012;\u0003x>\u001cMx\f%"), a);
    }

    protected Map<String, c_Yk> getAlarmStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_Fv.m_uHa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(BaseModel::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    public void notLeader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_Sx.m_La();
        f_Zv.info(CheckedAlarm.m_aia((Object)"64\u0016*\u001a\u0015\u00166\u0016?\u0012*Mx#0\u001e+W6\u0018<\u0012x_#\nqW1\u0004x9\u0017W\u00148\u00160\u001d%x#\u00102x;\u001d6\u001c2\nYx$,\u0018(\u00071\u0019?W9\u001b4W4\u0018;\u00164W9\u001b9\u00055W1\u0019+\u0007=\u0014,\u0018*\u0004vYv"), a);
        alarmManager2.f_Gx.lock();
        try {
            alarmManager.f_cw.m_bha();
            f_Zv.info(ScriptDto.m_dI((Object)"U5u+y\u0014u7u>q+4qZ6`yX<u=q+4\"ip.yU5xyx6w8xyu5u+yy}7g)q:`0{74-u*\u007f*41u/qyv<q74+q(a<g-q=4-{yg-{):"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Zv.error(CheckedAlarm.m_aia((Object)"\u0019\u001b9\u00055:9\u00199\u0010=\u0005x_\u0016\u0018,W\u0014\u00129\u0013=\u0005x\f%^bW\u001d\u0005*\u0018*W<\u0002*\u001e6\u0010x\u0007*\u0018;\u0012+\u0004x\u0018>W+\u00037\u0007(\u001e6\u0010x\u001b7\u00149\u001bx\u00164\u0016*\u001ax\u001e6\u0004(\u0012;\u00037\u0005+Mx\f%"), objectArray);
            return;
        }
        finally {
            alarmManager.f_Gx.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_Yk getAlarmGroupStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_Sx.m_Ga()) {
            f_Zv.debug(ScriptDto.m_dI((Object)"\u0015Q\u0018P\u001cFc4\u001eq-`0z>48x8f44>f6a)4*`8`,gyr6fyo$45{:u5x :"), a);
            return a2.getAlarmGroupStatusInternal((String)a);
        }
        f_Zv.debug(CheckedAlarm.m_aia((Object)"9\u00179u;\u001d6\u001c2\nMx%=\u0006-\u0012+\u00031\u0019?W4\u00129\u0013=\u0005x\u00117\u0005x\u00164\u0016*\u001ax\u0010*\u0018-\u0007x\u0004,\u0016,\u0002+W>\u0018*W#\nv"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 >> 2] = a;
            return (c_Yk)a2.f_Sx.m_t(Short.valueOf((short)(0x7F & 0x68)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AlarmManager(c_WL c_WL2, c_EK c_EK2, c_SL c_SL2, c_bC c_bC2, JedisPooled jedisPooled, c_L c_L2, c_OJ c_OJ2) {
        AlarmManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        AlarmManager a8;
        AlarmManager alarmManager = alarmManager2;
        AlarmManager alarmManager2 = c_OJ2;
        AlarmManager alarmManager3 = a8 = alarmManager;
        AlarmManager alarmManager4 = a8;
        AlarmManager alarmManager5 = a8;
        AlarmManager alarmManager6 = a8;
        a8.f_Gx = new ReentrantLock();
        a8.f_Fv = a7;
        alarmManager5.f_ew = a6;
        alarmManager5.f_cw = a5;
        alarmManager4.f_jw = a4;
        alarmManager4.f_hU = a3;
        alarmManager3.f_Sx = a2;
        alarmManager3.f_Fw = a;
    }
}

