/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.tracking.repositories;

import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import com.inscada.mono.tracking.model.MonitorTable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

@EnableSpaceFilter
public interface MonitorTableRepository
extends BaseJpaRepository<MonitorTable> {
    @Query(value="SELECT DISTINCT mt FROM MonitorTable mt LEFT JOIN FETCH mt.monitorVariables WHERE mt.projectId = :projectId")
    public List<MonitorTable> findByProjectId(@Param(value="projectId") String var1);

    @Query(value="SELECT DISTINCT mt FROM MonitorTable mt LEFT JOIN FETCH mt.monitorVariables")
    public List<MonitorTable> findAll();

    @Query(value="SELECT DISTINCT mt FROM MonitorTable mt LEFT JOIN FETCH mt.monitorVariables WHERE mt.id = :id")
    public Optional<MonitorTable> findById(@Param(value="id") String var1);

    @Query(value="SELECT DISTINCT mt FROM MonitorTable mt LEFT JOIN FETCH mt.monitorVariables WHERE mt.projectId = :projectId AND mt.name IN :names")
    public List<MonitorTable> findByProjectIdAndNameIn(@Param(value="projectId") String var1, @Param(value="names") Set<String> var2);

    @Query(value="SELECT DISTINCT mt FROM MonitorTable mt LEFT JOIN FETCH mt.monitorVariables WHERE mt.projectId = :projectId AND mt.name = :name")
    public Optional<MonitorTable> findByProjectIdAndName(@Param(value="projectId") String var1, @Param(value="name") String var2);
}

